#include	<stdio.h>
#include	<sys/types.h>

/*
**	This program reads in a file of lines of pairs of integers
**	which specify a new mapping of old positions to new
**	ones in the bdf specs. Reads stdin and spits to stdout.
**	Simplicity, simply alter the ENCODING lines.
**	Note that the mapping is only one level, thus
**		a b
**		b c
**	doesn't move a to c, merely a moves to b and what used to
**	be at b moves to c. Hence no loop problem at all.
**	Limitation, only maps fonts up to 256 characters.
*/

u_char		maptab[0x100];

fatal(m)
	char		*m;
{
	(void)fprintf(stderr, "%s\n", m);
	exit(1);
}

readmap(f)
	FILE		*f;
{
	register int	linecount = 1;
	int		old, new;
	char		line[512];

	while (fgets(line, sizeof(line), f) != NULL)
	{
		if (sscanf(line, "%d %d", &old, &new) != 2)
			(void)fprintf(stderr, "Line %d: bad spec %s",
				linecount, line);
		else if (old < 0 || old >= 256 || new < 0 || new >= 256)
			(void)fprintf(stderr, "Line %d: number out of range %s",
				linecount, line);
		else
			maptab[old] = new;
	}
}

/*
**	Copy lines verbatim until pat is found at beginning of line.
**	Return EOF at end of file.
*/
int match(pat, line, max)
	char		*pat, *line;
	int		max;
{
	register int	len = strlen(pat);

	while (fgets(line, max, stdin) != NULL)
	{
		if (strncmp(pat, line, len) == 0)
			return(0);
		(void)fputs(line, stdout);
	}
	return (EOF);
}

main(argc, argv)
	int		argc;
	char		*argv[];
{
	register int	i;
	register FILE	*mfile;
	int		n;
	char		line[512];

	if (argc < 2)
		fatal("Usage: remapbdf mapfile");

	/* install identity transformation */
	for (i = 0; i < 256; ++i)
		maptab[i] = i;

	if ((mfile = fopen(argv[1], "r")) == NULL)
		fatal("Cannot open mapping file");

	readmap(mfile);

	(void)fclose(mfile);

	while (match("ENCODING", line, sizeof(line)) != EOF)
	{
		if (sscanf(line, "ENCODING %d", &n) != 1)
			(void)fprintf(stderr, "Bad line: %s", line);
		if (n < 0 || n >= 256)
			(void)fprintf(stderr, "Encoding %d out of range\n", n);
		else
			n = maptab[n];
		(void)printf("ENCODING %d\n", n);
	}

	exit(0);
}
