#include "qix.h"
/*
 * Code to draw and move the qix.
 */

#define QSIZE	 45	/* Max size for lines in the Qix */
#define DTHRESH	 ((4+level)/3)	/* larger ==> more active */
#define FUDGE	 (Speed)
#define NLINES	 8	/* Max. # lines in the Qix itself */

/* Qix position: */
int
    qix1_x0[NLINES], qix1_x1[NLINES], qix1_y0[NLINES], qix1_y1[NLINES],
    qix1_dx0, qix1_dx1, qix1_dy0, qix1_dy1,	/* velocity */
    qix2_x0[NLINES], qix2_x1[NLINES], qix2_y0[NLINES], qix2_y1[NLINES],
    qix2_dx0, qix2_dx1, qix2_dy0, qix2_dy1;	/* velocity */

init_qix()
{
    int x;
    Speed = 3;

    for (x = 0; x < NLINES; x++) {
	qix1_x0[x] = BOARD_WIDTH / 2 + (rrand() & 3) - 6;
	qix1_x1[x] = qix1_x0[x] + 2;
	qix1_y0[x] = (BOARD_HEIGHT-10) / 2 + (rrand() & 3) - 6;
	qix1_y1[x] = qix1_y0[x] + 2;

	qix2_x0[x] = BOARD_WIDTH / 2 + (rrand() & 3) - 6;
	qix2_x1[x] = qix2_x0[x] + 2;
	qix2_y0[x] = (BOARD_HEIGHT-10) / 2 + (rrand() & 3) - 6;
	qix2_y1[x] = qix2_y0[x] + 2;
    }
}

move_qix()
{
    static index = 0, count;
    int i, j;

    if (level < -1 && count++ & 1)
	return 0;

    if (qix1_x0[index] <= 0)
	qix1_x0[index] = 1;
    if (qix1_x0[index] >= BOARD_WIDTH-1)
	qix1_x0[index] = BOARD_WIDTH-2;
    if (qix1_x1[index] <= 0)
	qix1_x1[index] = 1;
    if (qix1_x1[index] >= BOARD_WIDTH-1)
	qix1_x1[index] = BOARD_WIDTH-2;
    if (qix1_y0[index] <= 0)
	qix1_y0[index] = 1;
    if (qix1_y0[index] >= BOARD_HEIGHT-1)
	qix1_y0[index] = BOARD_HEIGHT-2;
    if (qix1_y1[index] <= 0)
	qix1_y1[index] = 1;
    if (qix1_y1[index] >= BOARD_HEIGHT-1)
	qix1_y1[index] = BOARD_HEIGHT-2;

    if (level > -1) {
	if (qix2_x0[index] <= 0)
	    qix2_x0[index] = 1;
	if (qix2_x0[index] >= BOARD_WIDTH-1)
	    qix2_x0[index] = BOARD_WIDTH-2;
	if (qix2_x1[index] <= 0)
	    qix2_x1[index] = 1;
	if (qix2_x1[index] >= BOARD_WIDTH-1)
	    qix2_x1[index] = BOARD_WIDTH-2;
	if (qix2_y0[index] <= 0)
	    qix2_y0[index] = 1;
	if (qix2_y0[index] >= BOARD_HEIGHT-1)
	    qix2_y0[index] = BOARD_HEIGHT-2;
	if (qix2_y1[index] <= 0)
	    qix2_y1[index] = 1;
	if (qix2_y1[index] >= BOARD_HEIGHT-1)
	    qix2_y1[index] = BOARD_HEIGHT-2;
    }

    j = bounds(qix1_x0[index], qix1_y0[index],
	       qix1_x1[index], qix1_y1[index],
	       &qix1_dx0, &qix1_dy0, &qix1_dx1, &qix1_dy1);
    if (j != -1 && level > -1)
	j = bounds(qix2_x0[index],qix2_y0[index],qix2_x1[index],qix2_y1[index],
	    &qix2_dx0, &qix2_dy0, &qix2_dx1, &qix2_dy1);

    i = (index + 1) % NLINES;

    /* erase old line */
    pw_putattributes(draw_win, &qix_mask);
    draw(convert_x(qix1_x0[i]), convert_y(qix1_y0[i]),
	 convert_x(qix1_x1[i]), convert_y(qix1_y1[i]), 
		PIX_CLR|PIX_COLOR((index % CMS_RAINBOWSIZE) + 
		QIX_COLOR_BASE));
    if (level > -1)
	draw(convert_x(qix2_x0[i]), convert_y(qix2_y0[i]),
	     convert_x(qix2_x1[i]), convert_y(qix2_y1[i]), 
		PIX_CLR|PIX_COLOR((index % CMS_RAINBOWSIZE) + 
		QIX_COLOR_BASE));

    qix1_x0[i] = qix1_x0[index] + qix1_dx0;
    qix1_y0[i] = qix1_y0[index] + qix1_dy0;
    qix1_x1[i] = qix1_x1[index] + qix1_dx1;
    qix1_y1[i] = qix1_y1[index] + qix1_dy1;

    if (level > -1) {
	qix2_x0[i] = qix2_x0[index] + qix2_dx0;
	qix2_y0[i] = qix2_y0[index] + qix2_dy0;
	qix2_x1[i] = qix2_x1[index] + qix2_dx1;
	qix2_y1[i] = qix2_y1[index] + qix2_dy1;
    }
    index = i;

    draw(convert_x(qix1_x0[i]), convert_y(qix1_y0[i]),
	 convert_x(qix1_x1[i]), convert_y(qix1_y1[i]), 
	 PIX_SRC|PIX_COLOR((index % CMS_RAINBOWSIZE) + 
	 QIX_COLOR_BASE));
    if (level > -1)
	draw(convert_x(qix2_x0[i]), convert_y(qix2_y0[i]),
	     convert_x(qix2_x1[i]), convert_y(qix2_y1[i]), 
	     PIX_SRC|PIX_COLOR((index % CMS_RAINBOWSIZE) + 
	     QIX_COLOR_BASE));
    return j;
}

bounds(x0, y0, x1, y1, dx0, dy0, dx1, dy1)
register int x0, y0, x1, y1;
register int *dx0, *dy0, *dx1, *dy1;
{
    register int i, new_x0, new_y0, new_x1, new_y1;
    int count, loop_count = 0;

    /* randomly change direction */
    if (!(rrand() % 10)) {
	register int r;
	/* move at least one space, but not greater than "Speed" */
	r = rrand();
	*dx0 = (1 + r%(Speed-1)) * ((r&1) ? -1 : 1);
	r = rrand();
	*dy0 = (1 + r%(Speed-1)) * ((r&1) ? -1 : 1);
	r = rrand();
	*dx1 = (1 + r%(Speed-1)) * ((r&1) ? -1 : 1);
	r = rrand();
	*dy1 = (1 + r%(Speed-1)) * ((r&1) ? -1 : 1);
	/* check that qix is moving towards player */
	if (level > -2 && !(rrand() % (6 - level))) {
	    if (pen_x - x0 > 0 && *dx0 < 0)
		*dx0 = -*dx0;
	    if (pen_x - x1 > 0 && *dx1 < 0)
		*dx1 = -*dx1;
	    if (pen_y - y0 > 0 && *dy0 < 0)
		*dy0 = -*dy0;
	    if (pen_y - y1 > 0 && *dy1 < 0)
		*dy1 = -*dy1;
	}
    }

    do  {
	if (x0 + *dx0 <= 1 || x0 + *dx0 >= BOARD_WIDTH-2)
	    *dx0 = -*dx0;
	if (x1 + *dx1 <= 1 || x1 + *dx1 >= BOARD_WIDTH-2)
	    *dx1 = -*dx1;
	if (y0 + *dy0 <= 1 || y0 + *dy0 >= BOARD_HEIGHT-2)
	    *dy0 = -*dy0;
	if (y1 + *dy1 <= 1 || y1 + *dy1 >= BOARD_HEIGHT-2)
	    *dy1 = -*dy1;

	new_x0 = x0 + *dx0;
	new_x1 = x1 + *dx1;
	new_y0 = y0 + *dy0;
	new_y1 = y1 + *dy1;

	/* Prevent Qix from growing too large: */
	if ((abs(new_x1 - new_x0) > QSIZE) || (abs((*dx0)-(*dx1)) < DTHRESH))
	    if (rrand()&1)
		*dx1 += (x1<x0 ? FUDGE : -FUDGE), new_x1 = x1 + *dx1;
	    else
		*dx0 += (x0<x1 ? FUDGE : -FUDGE), new_x0 = x0 + *dx0;
	if ((abs(new_y1 - new_y0) > QSIZE) || (abs((*dy0)-(*dy1)) < DTHRESH)) 
	    if (rrand()&1)
		(*dy1) += (y1<y0 ? FUDGE : -FUDGE), new_y1 = y1 + *dy1;
	    else
		(*dy0) += (y0<y1 ? FUDGE : -FUDGE), new_y0 = y0 + *dy0;

	/* if we hit a wall, try again */
	if ((count = check_line(new_x0, new_y0, new_x1, new_y1)) == 1) {
	    register int r;
	    *dx0 = (1 + (r = rrand())%Speed) * ((r&1) ? -1 : 1);
	    *dy0 = (1 + (r = rrand())%Speed) * ((r&1) ? -1 : 1);
	    *dx1 = (1 + (r = rrand())%Speed) * ((r&1) ? -1 : 1);
	    *dy1 = (1 + (r = rrand())%Speed) * ((r&1) ? -1 : 1);
	}
	if (!(++loop_count % 100)) {
#ifdef DEBUG
	    msg("bad news... loop count hit %d", loop_count);
	    Sleep(2);
	    remove_msgs(0);
#endif DEBUG
	    break;
	}
    } while(count == 1);
    return count;
}

check_line(x1, y1, x2, y2)
{
    register double dx_step, dy_step, x, y;
    int dx, dy, steps;

    x = x1 + 0.5, y = y1 + 0.5;
    dx = x2 - x1;
    dy = y2 - y1;

    steps = max(abs(dx), abs(dy)) + 1;
    dx_step = (double)((double)dx / (double)steps);
    dy_step = (double)((double)dy / (double)steps);

    while (steps--) {
	if (board[(int)x][(int)y]) {
	    if (
#ifdef DEBUG
		!no_qix_kill &&
#endif DEBUG
		(board[(int)x][(int)y] & NEW_LINE))
		return -1;
	    return 1;  /* just an intersect, return */
	}
	x += dx_step;
	y += dy_step;
    }
    return 0;
}

get_qix_pos(which, x, y)
register int *x, *y;
{
    register int i;
    int *x0, *y0, *x1, *y1;

    if (which == 0)
	x0 = qix1_x0, y0 = qix1_y0, x1 = qix1_x1, y1 = qix1_y1;
    else
	x0 = qix2_x0, y0 = qix2_y0, x1 = qix2_x1, y1 = qix2_y1;

    for (i = 0; i < NLINES; i++)
	if (!board[x0[i]][y0[i]]) {
	    *x = x0[i], *y = y0[i];
	    return 0;
	}
    msg("The qix is trapped in a place it shouldn't have gotten to!");
    Sleep(2);
    remove_msgs(0);
    return -1;
}
