#include "puzzletool.h"

void canvas_proc() ;

Canvas canvas, rcanvas ;
Cursor main_cursor ;
Event event ;
Frame frame ;
Icon puzzletool_icon ;
Panel panel ;
Panel_item display_item ;
struct Pixfont *nfont ;
Pixwin *cpw ;

short piece0_image[] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7BBB,0xBBBA,0x0000,0x0000,0x6EEE,0xEEEE,0x0000,0x0000,
	0x7777,0x7776,0x0000,0x0000,0x5DDD,0xDDDE,0x0000,0x0000,
	0x7FFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
} ;
mpr_static(piece0_pr,64,64,1,piece0_image) ;

short piece1_image[] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFE,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x6AAA,0xAAAA,0x0000,0x0000,0x5555,0x5556,0x0000,0x0000,
	0x7FFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
} ;
mpr_static(piece1_pr,64,64,1,piece1_image) ;

short piece2_image[] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFFF,0xFFFE,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x6AAA,0xAAAA,0xAAAA,0xAAAA,0x5555,0x5555,0x5555,0x5556,
	0x7FFF,0xFFFF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
} ;
mpr_static(piece2_pr,64,64,1,piece2_image) ;

short piece3_image[] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFFF,0xFFFE,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x4444,0x4444,0x4444,0x4446,0x5111,0x1111,0x1111,0x1112,
	0x4888,0x8888,0x8888,0x888A,0x6222,0x2222,0x2222,0x2222,
	0x7FFF,0xFFFF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000
} ;
mpr_static(piece3_pr,64,64,1,piece3_image) ;

short icon_image[] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0xFF00,0x0007,0xC003,0xC003,0xFF80,0x000F,0xE003,
	0xC007,0x83C0,0x001F,0xF003,0xC00E,0x00E0,0x003F,0xF803,
	0xC018,0x0070,0x003F,0xF803,0xC038,0x0038,0x003F,0xF803,
	0xC030,0x0018,0x003F,0xF803,0xC070,0x001C,0x003F,0xF803,
	0xC060,0x000C,0x001F,0xF003,0xC000,0x000C,0x001F,0xF003,
	0xC000,0x000C,0x001F,0xF003,0xC000,0x000C,0x001F,0xE003,
	0xC000,0x000C,0x001F,0xE003,0xC000,0x001C,0x000F,0xE003,
	0xC000,0x0018,0x000F,0xE003,0xC000,0x0038,0x000F,0xE003,
	0xC000,0x0070,0x000F,0xC003,0xC000,0x00E0,0x000F,0xC003,
	0xC000,0x03C0,0x000F,0xC003,0xC000,0x3F80,0x000F,0xC003,
	0xC000,0x3E00,0x000F,0xC003,0xC000,0x3000,0x0007,0x8003,
	0xC000,0x3000,0x0007,0x8003,0xC000,0x3000,0x0007,0x8003,
	0xC000,0x3000,0x0007,0x8003,0xC000,0x3000,0x0007,0x8003,
	0xC000,0x3000,0x0007,0x0003,0xC000,0x3000,0x0007,0x0003,
	0xC000,0x3000,0x0007,0x0003,0xC000,0x3000,0x0003,0x0003,
	0xC000,0x3000,0x0003,0x0003,0xC000,0x3000,0x0002,0x0003,
	0xC000,0x3000,0x0002,0x0003,0xC000,0x3000,0x0002,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x3800,0x0007,0x0003,
	0xC000,0x7C00,0x001F,0xC003,0xC000,0xFE00,0x001F,0xC003,
	0xC000,0xFE00,0x003F,0xE003,0xC000,0xFE00,0x003F,0xE003,
	0xC000,0x7C00,0x003F,0xE003,0xC000,0x3800,0x001F,0xC003,
	0xC000,0x0000,0x001F,0xC003,0xC000,0x0000,0x0007,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xC000,0x0000,0x0000,0x0003,0xC000,0x0000,0x0000,0x0003,
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF
} ;
mpr_static(icon_pixrect,64,64,1,icon_image) ;

int ncolumn,column ;            /* Column number of key pressed. */
int m,n ;               /* mouse and index */
int nrow,row ;               /* Row number of key pressed. */
int step=0;


int board[7][6]= {
        {-2,-2,-2,-2,-2,-2}, {-2,4,9,9,5,-2}, {-2,4,9,9,5,-2}, 
        {-2,6,8,8,7,-2}, {-2,6,0,1,7,-2},
        {-2,-1,2,3,-1,-2}, {-2,-2,-2,-2,-2,-2}
};
int pieces[10][5] = {      
	{0,2,4,1,1}, {0,3,4,1,1}, {0,2,5,1,1}, {0,3,5,1,1},
        {1,1,1,1,2}, {1,4,1,1,2}, {1,1,3,1,2}, {1,4,3,1,2},
        {2,2,3,2,1},{3,2,1,2,2}
} ;

char display[MAXLINE] ;             /* Current calculator display. */


main(argc,argv)
int argc ;
char *argv[] ;

{
  nfont = pf_open(NORMALFONT) ;     /* Open normal sized font. */
  puzzletool_icon = icon_create(ICON_WIDTH,64,
                              ICON_IMAGE,&icon_pixrect,
                              0) ;

  frame = window_create((Window) 0, FRAME,
                        FRAME_ICON, puzzletool_icon,
                        FRAME_SHOW_LABEL, FALSE,
                        FRAME_SUBWINDOWS_ADJUSTABLE, FALSE,
                        FRAME_NO_CONFIRM, FALSE,
                        WIN_TOP_MARGIN, DISPLAY,
                        WIN_ROW_HEIGHT, PIECE_H,
                        WIN_COLUMN_WIDTH, PIECE_W,
                        WIN_ROWS, PIECE_ROWS,
                        WIN_COLUMNS, PIECE_COLS,
                        FRAME_ARGS, argc,argv,
                        0) ;

  panel = window_create(frame, PANEL,
                        WIN_CONSUME_KBD_EVENTS, WIN_ASCII_EVENTS, 0,
                        WIN_HEIGHT, DISPLAY,
                        0) ;

  canvas = window_create(frame,CANVAS,
                         WIN_BELOW,panel,
                         WIN_WIDTH,TOTAL_WIDTH,
                         WIN_HEIGHT,TOTAL_HEIGHT,
                         WIN_FONT,nfont,
                         WIN_EVENT_PROC,canvas_proc,
                         0) ;
  WINDOW_SET(canvas,WIN_CONSUME_KBD_EVENT,WIN_ASCII_EVENTS,0) ;

  display_item = panel_create_item(panel,PANEL_MESSAGE,
                                PANEL_LABEL_X,10,
                                PANEL_LABEL_Y,DISPLAY-15,
                                PANEL_LABEL_FONT,nfont,
                                PANEL_LABEL_STRING,"",
                                0) ;
  cpw = canvas_pixwin(canvas) ;
  main_cursor = window_get(canvas,WIN_CURSOR) ;

  make_canvas() ;            /* Draw the calculators pieces. */
  window_fit(frame) ;
  window_main_loop(frame) ;
  exit(0) ;
}

/*ARGSUSED*/
static void
canvas_proc(win,event,arg)
Canvas  win ;
Event *event ;
caddr_t arg ;

{
  if (event_is_button(event) && event_is_down(event))
    {
      switch (event_id(event))
        {
          case MS_LEFT   : column = event_x(event) / PIECE_W ;
                           row = event_y(event) / PIECE_H ;
                           n = board[row+1][column+1] ;  m=0;
                           return;
          case MS_MIDDLE : WINDOW_SET(frame,FRAME_CLOSED,TRUE,0);
                           return;
          case MS_RIGHT  : WINDOW_DESTROY(frame);
          default:         return ;
        }
   }
  if (event_is_button(event) && event_is_up(event) && n>=0)
    {
      switch (event_id(event))
        {
          case MS_LEFT   : ncolumn = event_x(event) / PIECE_W;
                           nrow = event_y(event) / PIECE_H ;
                           if(board[nrow+1][ncolumn+1]!=-1)return ;
                           if(ncolumn>column) m=0;
                           if(nrow<row)m=1;
                           if(ncolumn<column) m=2;
                           if(nrow>row)m=3;
                           do_move();
          case MS_MIDDLE : 
          case MS_RIGHT  : 
          default:         return ;
        }
   }
  return ;

}

display_test(display)       /* Output result to calculator display. */
char display[MAXLINE];
{
  PANEL_SET(display_item,PANEL_LABEL_STRING,display,0) ;
}

make_canvas()
{
  int n,x ;
  char pstr[10] ;

  pw_writebackground(cpw,0,0,TOTAL_WIDTH,TOTAL_HEIGHT,PIX_CLR) ;
  for(n=0;n<4;++n)
  pw_write(cpw,(pieces[n][PX]-1)*PIECE_W, (pieces[n][PY]-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece0_pr,0,0) ;
  for(n=4;n<8;++n)
  pw_write(cpw,(pieces[n][PX]-1)*PIECE_W, (pieces[n][PY]-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece1_pr,0,0) ;
  n=8;
  pw_write(cpw,(pieces[n][PX]-1)*PIECE_W, (pieces[n][PY]-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece2_pr,0,0) ;
  n=9;
  pw_write(cpw,(pieces[n][PX]-1)*PIECE_W, (pieces[n][PY]-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece3_pr,0,0) ;
}

do_move()
{
   int ox,oy,nx,ny;

   ox=pieces[n][PX];
   oy=pieces[n][PY];
   switch(n){
      case 0:
      case 1:
      case 2:
      case 3: switch(m){
               case 0: if(board[ny=oy][nx=ox+1]==-1)break;
                       return;
               case 1: if(board[ny=oy-1][nx=ox]==-1)break;
                       return;
               case 2: if(board[ny=oy][nx=ox-1]==-1)break;
                       return;
               case 3: if(board[ny=oy+1][nx=ox]==-1)break;
                       return;
              }
              break;
      case 4:
      case 5:
      case 6:
      case 7: switch(m){
               case 0: if(board[oy][ox+1]==-1&&board[oy+1][ox+1]==-1){nx=ox+1;ny=oy;break;}
                       return;
               case 1: if(board[oy-1][ox]==-1){nx=ox;ny=oy-1;break;}
                       return;
               case 2: if(board[oy][ox-1]==-1&&board[oy+1][ox-1]==-1){nx=ox-1;ny=oy;break;}
                       return;
               case 3: if(board[oy+2][ox]==-1){nx=ox;ny=oy+1;break;}
                       return;
              }
              break;
      case 8: switch(m){
               case 0: if(board[oy][ox+2]==-1){nx=ox+1;ny=oy;break;}
                       return;
               case 1: if(board[oy-1][ox]==-1&&board[oy-1][ox+1]==-1){nx=ox;ny=oy-1;break;}
                       return;
               case 2: if(board[oy][ox-1]==-1){nx=ox-1;ny=oy;break;}
                       return;
               case 3: if(board[oy+1][ox]==-1&&board[oy+1][ox+1]==-1){nx=ox;ny=oy+1;break;}
                       return;
              }
              break;
      case 9: switch(m){
               case 0: if(board[oy][ox+2]==-1&&board[oy+1][ox+2]==-1){nx=ox+1;ny=oy;break;}
                       return;
               case 1: if(board[oy-1][ox]==-1&&board[oy-1][ox+1]==-1){nx=ox;ny=oy-1;break;}
                       return;
               case 2: if(board[oy][ox-1]==-1&&board[oy+1][ox-1]==-1){nx=ox-1;ny=oy;break;}
                       return;
               case 3: if(board[oy+2][ox]==-1&&board[oy+2][ox+1]==-1){nx=ox;ny=oy+1;break;}
                       return;
              }
              break;
                         
         }
   itos(++step,display);
   display_test(display);
      pieces[n][PX]=nx;pieces[n][PY]=ny;
      switch(n){
         case 0:
         case 1:
         case 2:
         case 3: board[oy][ox]= -1;
                 board[ny][nx]=n;
                 pw_writebackground(cpw,(ox-1)*PIECE_W,(oy-1)*PIECE_H,pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_CLR);
  pw_write(cpw,(nx-1)*PIECE_W, (ny-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece0_pr,0,0) ;
                 break;
         case 4:
         case 5:
         case 6:
         case 7: board[oy][ox]=board[oy+1][ox]= -1;
                 board[ny][nx]=board[ny+1][nx]=n;
                 pw_writebackground(cpw,(ox-1)*PIECE_W,(oy-1)*PIECE_H,pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_CLR);
  pw_write(cpw,(nx-1)*PIECE_W, (ny-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece1_pr,0,0) ;
                 break;
         case 8: board[oy][ox]=board[oy][ox+1]= -1;
                 board[ny][nx]=board[ny][nx+1]=n;
                 pw_writebackground(cpw,(ox-1)*PIECE_W,(oy-1)*PIECE_H,pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_CLR);
  pw_write(cpw,(nx-1)*PIECE_W, (ny-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece2_pr,0,0) ;
                 break;
         case 9: board[oy][ox]=board[oy][ox+1]=board[oy+1][ox]=board[oy+1][ox+1]= -1;
                 board[ny][nx]=board[ny][nx+1]=board[ny+1][nx]=board[ny+1][nx+1]=n;
                 pw_writebackground(cpw,(ox-1)*PIECE_W,(oy-1)*PIECE_H,pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_CLR);
  pw_write(cpw,(nx-1)*PIECE_W, (ny-1)*PIECE_H, pieces[n][PDX]*PIECE_W,pieces[n][PDY]*PIECE_H,PIX_SRC,&piece3_pr,0,0) ;
                       break;
      }
}

itos(i,c)
int i;
char *c;

{  int j;
   char t;

   c[0]='\0';
   for(j=1;i>0;j++){
      c[j]=i%10+'0';
      i/=10;
   }
   for(i=0;i<j/2;++i){
      t=c[i];
      c[i]=c[j-1-i];
      c[j-1-i]=t;
   }
}
