
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/getship.c,v 3.1 88/09/20 00:44:05 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include "defs.h"
#include "struct.h"
#include "data.h"

/* fill in ship characteristics */

getship(shipp,customship)
struct ship *shipp;
char *customship;
{
    int feature[128];
    char *savecs = customship;
    double ppower, tpower;

    bzero(feature,128 * sizeof(int));

    if (customship)
	for (; *customship > 0; customship++) {
	    if (islower(*customship)) {
		    (feature[*customship])--;
	    } else if (isupper(*customship)) {
		    (feature[tolower(*customship)])++;
	    }
	}

    /*
     * The following are the configurable options:
     * a/A  Army Transport
     * c/C  Cloaking Cost
     * d/D  Heat Dissipation (weapons & engines)
     * e/E  Engine Efficiency
     * f/F  Fuel Capacity
     * g/G  Fuel Generation
     * i/I  Invisibility While Cloaked
     * m/M  Maneuverablity
     * p/P  Phaser Power (affects damage & range)
     * r/R  Repair Rate
     * s/S  Shield Strength
     * t/T  Torpedo Damage
     * v/V  Torpedo Speed
     * w/W  Warp Engines (affects acceleration & top speed)
     * x/X  Ship Size
     */

    /* check sanity of options */
    if ((feature['a'] + feature['c'] + feature['d'] + feature['e'] + 
	 feature['f'] + feature['g'] + feature['i'] + feature['m'] +
	 feature['p'] + feature['r'] + feature['s'] + feature['t'] +
	 feature['v'] + feature['w'] + feature['x']) > 0)
    {
	fprintf(stderr,"ship has too many additions:\n\t%s\n", savecs);
	exit(1);
    }
#define rangecheck(min,value,max) \
	if (feature[(value)] < (min)) \
	{ \
	    fprintf(stderr,"ship out of range:%c < %d\n",(value),(min)); \
	    exit(1); \
	} \
	if (feature[(value)] > (max)) \
	{ \
	    fprintf(stderr,"ship out of range:%c > %d\n",(value),(max)); \
	    exit(1); \
	}

    rangecheck(-2,'a',1000);
    shipp->s_maxarmies = 10 + 4 * feature['a'];

    rangecheck(0,'c',3);
    shipp->s_cloakcost = 30 - 10 * feature['c'];

    rangecheck(-5,'d',1000);
    shipp->s_ecool = 5 + feature['d'];
    shipp->s_wcool = shipp->s_ecool / 2;

    rangecheck(-4,'e',16);
    shipp->s_warpcost = 20 / (5 + feature['e']);

    /*
     * this limit is artificial, an artifact of the status
     * display code, which requires fuel to be a short. YUK!!
     * I should fix it some time.
     */
    rangecheck(-3,'f',9);
    shipp->s_maxfuel = 10000 + 2500 * feature['f'];

    rangecheck(-5,'g',1000);
    shipp->s_recharge = 10 + 2 * feature['g'];

    rangecheck(-2,'i',1000);
    shipp->s_accs = 21 + feature['i'] * 10;

    rangecheck(-5,'m',1000);
    shipp->s_turns = 128000;
    if (feature['m'] > 0) {
	shipp->s_turns <<= feature['m'];
    } else {
	shipp->s_turns >>= -(feature['m']);
    }

    rangecheck(-4,'p',1000);
    ppower=(4 + feature['p']) * 2500.0;
    shipp->s_phaserdamage = (int) sqrt(ppower);

    rangecheck(-2,'r',1000);
    shipp->s_repair = 100 + 50 * feature['r'];

    rangecheck(-4,'s',1000);
    shipp->s_maxshields = 100 + 25 * feature['s'];

    rangecheck(-2,'t',1000);
    tpower=(2 + feature['t']) * 450.0;
    shipp->s_torpdamage = (int) sqrt(tpower);

    rangecheck(-2,'v',1000);
    shipp->s_torpspeed = 12 + 6 * feature['v'];

    rangecheck(-4,'w',1000);
    shipp->s_maxspeed = 9 + 2 * feature['w'];
    shipp->s_accint = 10 * (1 + shipp->s_maxspeed);

    rangecheck(-5,'x',1000);
    shipp->s_maxdamage = 100 + 15 * feature['x'];
	
    shipp->s_decint = 200;
    shipp->s_detcost = 100;
    shipp->s_torpcost = (shipp->s_torpspeed/2 + 4) * shipp->s_torpdamage;
    shipp->s_phasercost = 10 * shipp->s_phaserdamage;
}
