/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

/*
** Functions for drawing and removing the cursor
**
*/

#include	"X.h"
#include	"screenint.h"
#include	"cursorstr.h"
#include	"miscstruct.h"
#include	"sgifb.h"
#include	"sgigl.h"

/*
************************************************************************
** sgiRecolorCursor --
**	The colors for this cursor have changed, we don't do anything
**	unless this is the cursor being displayed, in which case we
**	set the colors from the cursor structure into the cursor.
**
************************************************************************
*/

void
sgiRecolorCursor(pScr, pCurs, onscreen)
    ScreenPtr	pScr;
    CursorPtr	pCurs;
{
    if (onscreen) {
	/*
	** Change the cursor colors to match the new cursor, then
	** change to that cursor.  Since X claims that a "1" image on
	** top of a "0" mask is undefined, we won't define a color
	** for it either.  I am assuming here that the image is the
	** "2" bit and the mask is the "1" bit.
	*/
	GLcursorcolors(
	    pCurs->backRed&0xff, pCurs->backGreen&0xff, pCurs->backBlue&0xff,
	    pCurs->foreRed&0xff, pCurs->foreGreen&0xff, pCurs->foreBlue&0xff
	);
    }
}

/*
************************************************************************
** sgiDisplayCursor --
**	Really draw the passed cursor on the screen.
**
************************************************************************
*/

sgiDisplayCursor(pScr, pCurs)
    ScreenPtr	pScr;
    CursorPtr	pCurs;
{
    register int i;

    /*
    ** Now combine the mask and image to form a 3 color cursor.  We
    ** will be one of the few people to support 32 bit cursors!
    **
    ** Since cursors are defined from the bottom up, we have to invert them
    ** from the server ordering.
    */
    if (pCurs->width == 16) {
	short	cursordata[32],
		*pimage,
		*pmask;

	memset(cursordata, 0, sizeof cursordata);
	pimage = (short *) pCurs->source;
	pmask = (short *) pCurs->mask;
	for (i = 0; i < pCurs->height; i++, pimage += 2, pmask += 2) {
	    cursordata[15 - i] = *pimage;
	    cursordata[31 - i] = *pmask;
	}
	GLcurstype(16);
	defcursor(SGI_CURSOR, cursordata);
	curorigin(SGI_CURSOR, pCurs->xhot, 15 - pCurs->yhot);
    } else
	return FALSE;
    GLsetcursor(SGI_CURSOR, 0, 0);
    sgiRecolorCursor(pScr, pCurs, TRUE);
    return TRUE;
}

/*
************************************************************************
** sgiCursorLimits --
**	Return a box within which the given cursor may move on the given
**	screen. We assume that the HotBox is actually on the given screen,
**	since dix knows that size.
**
** Results:
**	A box for the hot spot corner of the cursor.
**
** Side Effects:
**	None.
**
************************************************************************
*/
void
sgiCursorLimits (pScreen, pCursor, pHotBox, pResultBox)
    ScreenPtr	  pScreen;  	/* Screen on which limits are desired */
    CursorPtr	  pCursor;  	/* Cursor whose limits are desired */
    BoxPtr  	  pHotBox;  	/* Limits for pCursor's hot point */
    BoxPtr  	  pResultBox;	/* RETURN: limits for hot spot */
{
    pResultBox->x1 = pResultBox->y1 = 0;
    pResultBox->x2 = SGI_WIDTH;
    pResultBox->y2 = SGI_HEIGHT;
}
