/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include	"X.h"
#include	"Xproto.h"
#include	"input.h"
#include	"Xmd.h"
#include	"scrnintstr.h"
#include    	"dixstruct.h"
#include    	"opaque.h"
#include	"servermd.h"
#include	<signal.h>
#include    	"sgifb.h"

extern int sgiScreenInit(), sgiKeybdProc(), sgiMouseProc();

#define MOTION_BUFFER_SIZE 0

static PixmapFormatRec	formats[] = {
    8, 8, BITMAP_SCANLINE_PAD,		/* 8-bit deep */
};
#define NUMFORMATS	N_ELEMENTS(formats)

extern int ForceDrawToLoad, ForceBltToLoad;

/*
 * Initialize screenInfo and add our screen to the system.
 */
InitOutput(pScreenInfo, argc, argv)
    ScreenInfo 	  *pScreenInfo;
    int     	  argc;
    char    	  **argv;
{
    register int     	  i;
    i = ForceDrawToLoad + ForceBltToLoad;

    pScreenInfo->imageByteOrder = IMAGE_BYTE_ORDER;
    pScreenInfo->bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
    pScreenInfo->bitmapScanlinePad = BITMAP_SCANLINE_PAD;
    pScreenInfo->bitmapBitOrder = BITMAP_BIT_ORDER;

    pScreenInfo->numPixmapFormats = NUMFORMATS;
    for (i=0; i< NUMFORMATS; i++)
    {
        pScreenInfo->formats[i] = formats[i];
    }

    i = AddScreen(sgiScreenInit, argc, argv);
}

/*
 * Initialize all supported input devices...what else is there
 * besides pointer and keyboard?
 *
 * Two DeviceRec's are allocated and registered as the system pointer
 * and keyboard devices.
 */
/*ARGSUSED*/
InitInput(argc, argv)
    int     	  argc;
    char    	  **argv;
{
    DevicePtr p, k;
    static int  zero = 0;
    
    p = AddInputDevice(sgiMouseProc, TRUE);
    k = AddInputDevice(sgiKeybdProc, TRUE);

    RegisterPointerDevice(p, MOTION_BUFFER_SIZE);
    RegisterKeyboardDevice(k);
}
