/*****************************************************************************/
/* msmouse.h - mICROsOFT mouse INTERFACE FOR THE IBMPC */
/*****************************************************************************/
/*****************************************************************************/
#ifndef	_msmouse_h
#define	_msmouse_h
/*****************************************************************************/
/*****************************************************************************/
#define	MSMOUSE_INSTALLEDANDRESET	(0)
#define	MSMOUSE_SHOWCURSOR		(1)
#define	MSMOUSE_HIDECURSOR		(2)
#define	MSMOUSE_GETPOSANDBUTTONS	(3)
#define	MSMOUSE_SETPOS			(4)
#define	MSMOUSE_GETBUTTONPRESS		(5)
#define	MSMOUSE_GETBUTTONRELEASE	(6)
#define	MSMOUSE_SETMINANDMAXHORZ	(7)
#define	MSMOUSE_SETMINANDMAXVERT	(8)
#define	MSMOUSE_SETGRAPHICSCURSOR	(9)
#define	MSMOUSE_SETTEXTCURSOR		(10)
#define	MSMOUSE_READMOTIONCOUNTERS	(11)
#define	MSMOUSE_SETINT			(12)
#define	MSMOUSE_LIGHTPENEMULATIONON	(13)
#define	MSMOUSE_LIGHTPENENUMLATIONOFF	(14)
#define	MSMOUSE_SETMICKEYPIXELRATIO	(15)
#define	MSMOUSE_CONDITIONALOFF		(16)
#define	MSMOUSE_SETDBLSPEEDTHRESHOLD	(19)

#define	MSMOUSE_SETINT_MASK_ALL			(0xFFFF)
#define	MSMOUSE_SETINT_MASK_MOVEMENT		(0x0001)
#define	MSMOUSE_SETINT_MASK_LBUTTONPRESS	(0x0002)
#define	MSMOUSE_SETINT_MASK_LBUTTONRELEASE	(0x0004)
#define	MSMOUSE_SETINT_MASK_RBUTTONPRESS	(0x0008)
#define	MSMOUSE_SETINT_MASK_RBUTTONRELEASE	(0x0010)

typedef struct {
	short	func;
	short	arg2, arg3, arg4;
} MSMOUSE;

typedef short	MSMMASK[16];	/* A 16 X 16 BIT MOUSE MASK */
				/* EACH short IS A HORIZONTAL STRIP */
typedef	struct {
	MSMMASK	screen;	/* SCREEN MASK -- FIRST AND'ED TO THE SCREEN */
	MSMMASK	cursor; /* CURSOR MASK -- SECOND XOR'ED TO THE SCREEN */
}	MSMCURSOR;


void	msmouse(MSMOUSE *msm);
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#endif
