/* $Header: access.c,v 1.14 87/06/11 12:21:33 sue Exp $ */
/* Bellcore 7/22/87 modified and compiled OK by David K. Chan */

#include "X.h"
#include "Xproto.h"
#include "misc.h" 
#include <stdio.h>
#include <errno.h>
#include <sys\types.h>
#include <sys\socket.h>
#include <net\if.h> 
#include <net1.h>
#include <netinet\in.h>
#include "ndixstruct.h"
#undef    NULL
#include "osdep.h"

#define DONT_CHECK -1

extern char *strchr();

struct map {
       int af, xf;
};

struct map familyMap[] = {
#ifdef AF_INET
       {AF_INET, FamilyInternet}
#endif
}; 

#define FAMILIES ((sizeof (familyMap)) / (sizeof (familyMap[0])))

struct HOST {
	short		family;
	short		len;
	unsigned char	addr[4];  /* will need to be bigger eventually */
	struct HOST *next;
};

static struct HOST *selfhosts  = NULL;
static struct HOST *validhosts = NULL;
static int AccessEnabled       = TRUE;

/* Define this host for access control. Find all the hosts the OS knows about 
   this fd and add them to the selfhosts list */
DefineSelf (fd)
int fd;
{
    char		buf[2048];
    struct ifconf	ifc;
    register int	n;
    int 		len;
    pointer 		addr;
    short 		family;
    register struct HOST  *host;
    register struct ifreq *ifr;
    
    ifc.ifc_len = sizeof (buf);
    ifc.ifc_buf = buf;
/*  if (ioctl(fd, (int)SIOCGIFCONF, (pointer)&ifc) < 0)
        printf ("\nError--Getting interface configuration\n");
*/    
    for (ifr=ifc.ifc_req,n=ifc.ifc_len/sizeof(struct ifreq); --n >= 0; ifr++)
    {
        if ((family = ConvertAddr (&ifr->ifr_addr, &len, &addr)) <= 0)
	    continue;
        for (host = selfhosts; host && (family != host->family ||
	  bcmp (addr, host->addr, len)); host = host->next)
	    ;
        if (host)
	    continue;
        host = (struct HOST *) Xalloc (sizeof (struct HOST));
        host->family = family;
        host->len = len;
        bcopy(addr, host->addr, len);
        host->next = selfhosts;
        selfhosts = host;
    }
}  /* DefineSelf */

/* Reset access control list to initial hosts */
ResetHosts (display)
    char *display;
{
    struct HOST *host,  *self;
    char 		hostname[99];
    char		fname[32];
    FILE		*fd;
    char		*ptr;
    union {
        struct sockaddr	sa;
        struct sockaddr_in in;
    } 			saddr;

    short		family;
    int			len;
    pointer		addr;
    register struct hostent *hp;
    struct hostent *gethostbyname();

    while (host = validhosts)
    {
        validhosts = host->next;
        Xfree ((pointer) host);
    }
    for (self = selfhosts; self; self = self->next)
    {
        host = (struct HOST *) Xalloc (sizeof (struct HOST));
        *host = *self;
        host->next = validhosts;
        validhosts = host;
    }
    strcpy (fname, "\etc\X");
    strcat (fname, display);
    strcat (fname, ".hosts");
    if (fd = fopen (fname, "r")) 
    {
        while (fgets (hostname, sizeof (hostname), fd))
	{
            if (ptr = strchr(hostname, '\n'))
     	       *ptr = 0;
/*          if (hp =  gethostbyname (hostname))
*/	
               {
    		saddr.sa.sa_family = hp->h_addrtype;
    		if ((family = ConvertAddr (&saddr.sa, &len, &addr)) > 0)
#ifdef NEW_HEADER_WITH_OLD_LIBRARY
    		    NewHost (family, hp->h_addr_list);
#else
    		    NewHost (family, hp->h_addr);
#endif

    	    }
        }
        fclose (fd);
    }
}

/* Add a host to the access control list.  This is the external interface
 * called from the dispatcher */
int
AddHost (client, family, length, pAddr)
    int			client;
    int                 family;
    int                 length;        /* of bytes in pAddr */
    pointer             pAddr;
{
    int			len;
    struct  HOST	*host;
    int                 unixFamily;

    unixFamily = UnixFamily(family);
    if ((len = CheckFamily (DONT_CHECK, unixFamily)) < 0)
        return BadMatch;

    if (len != length)
        return BadMatch;
    for (host = validhosts; host; host = host->next)
        if (unixFamily == host->family && !bcmp (pAddr, host->addr, len))
    	    return Success;
    host = (struct HOST *) Xalloc (sizeof (struct HOST));
    host->family = unixFamily;
    host->len = len;
    bcopy(pAddr, host->addr, len);
    host->next = validhosts;
    validhosts = host;
    return Success;
}

/* Add a host to the access control list. This is the internal interface 
 * called when starting or resetting the server */
NewHost (family, addr)
    short	family;
    pointer	addr;
{
    int		len;
    struct HOST *host;

    if ((len = CheckFamily (DONT_CHECK, family)) < 0)
        return;
    for (host = validhosts; host; host = host->next)
    {
        if (family == host->family && !bcmp (addr, host->addr, len))
    	return;
    }
    host = (struct HOST *) Xalloc (sizeof (struct HOST));
    host->family = family;
    host->len = len;
    bcopy(addr, host->addr, len);
    host->next = validhosts;
    validhosts = host;
}

/* Remove a host from the access control list */
int
RemoveHost (client, family, length, pAddr)
    int			client;
    int                 family;
    int                 length;        /* of bytes in pAddr */
    pointer             pAddr;
{
    int			len,
                        unixFamily;
    struct HOST	*host,  **prev;

    unixFamily = UnixFamily(family);
    if ((len = CheckFamily (DONT_CHECK, unixFamily)) < 0)
        return BadMatch;
    if (len != length)
        return BadMatch;
    for (prev = &validhosts;
         (host = *prev) && (unixFamily != host->family ||
		            bcmp (pAddr, host->addr, len));
         prev = &host->next)
        ;
    if (host)
    {
        *prev = host->next;
        Xfree ((pointer) host);
    }
    return Success;
}

/* Get all hosts in the access control list */
int
GetHosts (data, pnHosts, pEnabled)
    pointer		*data;
    int			*pnHosts, *pEnabled;
{
    int			len;
    register int 	n = 0;
    register pointer	ptr;
    struct HOST	        *host;
    int			nHosts = 0;
    int			*lengths = (int *) NULL;

    *pEnabled = AccessEnabled ? EnableAccess : DisableAccess;
    for (host = validhosts; host; host = host->next)
    {
        if ((len = CheckFamily (DONT_CHECK, host->family)) < 0)
            return (-1);
	lengths = (int *) Xrealloc(lengths, (nHosts + 1) * sizeof(int));
	lengths[nHosts++] = len;
	n += (((len + 3) >> 2) << 2) + sizeof(xHostEntry);
    }
    if (n)
    {
        *data = ptr = (pointer) Xalloc (n);
	nHosts = 0;
        for (host = validhosts; host; host = host->next)
	{

	    len = lengths[nHosts++];
	    ((xHostEntry *)ptr)->family = XFamily(host->family);
	    ((xHostEntry *)ptr)->length = len;
	    ptr += sizeof(xHostEntry);
	    bcopy (host->addr, ptr, len);
	    ptr += ((len + 3) >> 2) << 2;
        }
    }
    *pnHosts = nHosts;
    Xfree(lengths);
    return (n);
}

/* Check for valid address family, and for local host if client modification.
 * Return address length.
 */

CheckFamily (connection, family)
    int			connection;
    short		family;
{
    struct sockaddr	from;
    int	 		alen;
    pointer		addr;
    struct HOST	        *host;
    int 		len;

    switch (family)
    {
#ifdef TCPCONN
      case AF_INET:
        len = sizeof (struct in_addr);
        break;
#endif 

      default:
        /* BadValue */
        return (-1);
    }
    if (connection == DONT_CHECK)
        return (len);
    alen = sizeof (from);
/*  if (!getpeername (connection, &from, &alen))
*/   
    {
        if ((family = ConvertAddr (&from, &alen, &addr)) >= 0)
	{
	    if (family == 0)
		return (len);
	    for (host = selfhosts; host; host = host->next)
	    {
		if (family == host->family &&
		    !bcmp (addr, host->addr, alen))
		    return (len);
	    }
	}
    }
    /* Bad Access */
    return (-1);
}

/* Check if a host is not in the access control list. 
 * Returns 1 if host is invalid, 0 if we've found it. */
InvalidHost (saddr, len)
    register struct sockaddr	*saddr;
    int				len;
{
    short 			family;
    pointer			addr;
    struct HOST 		*host;
    if ((family = ConvertAddr (saddr, len ? &len : 0, &addr)) < 0)
        return (1);
    if (family == 0)
        return (0);
    for (host = validhosts; host; host = host->next)
    {
        if (family == host->family && !bcmp (addr, host->addr, len))
    	    return (0);
    }
    return (1);
}

ConvertAddr (saddr, len, addr)
    register struct sockaddr	*saddr;
    int				*len;
    pointer			*addr;
{
    if (len == 0)
        return (0);
    switch (saddr->sa_family)
    {
      case AF_UNSPEC:
      case AF_UNIX:
        return (0);
      case AF_INET:

#ifdef TCPCONN
        *len = sizeof (struct in_addr);
        *addr = (pointer) &(((struct sockaddr_in *) saddr)->sin_addr);
        return (AF_INET);
#endif TCPCONN
        break;

        default:
        break;
    }
    return (-1);
}

ChangeAccessControl(client, fEnabled)
    int                 fEnabled;
    struct _Client      *client;
{
    int    		alen, family;
    struct sockaddr	from;
    pointer		addr;
    struct HOST 	*host;

    alen = sizeof (from);
/*  if (!getpeername ((int *)(client->osPrivate), &from, &alen))
*/  
       {
        if ((family = ConvertAddr (&from, &alen, &addr)) >= 0)
	{
	    if (family == 0)
    		AccessEnabled = fEnabled;
	    for (host = selfhosts; host; host = host->next)
	    {
		if (family == host->family &&
		    !bcmp (addr, host->addr, alen))
    		    AccessEnabled = fEnabled;
	    }
	}
    }
}

static int XFamily(af)
    int af;
{
    int i;
    for (i = 0; i < FAMILIES; i++)
        if (familyMap[i].af == af)
            return familyMap[i].xf;
    return -1;
}

static int UnixFamily(xf)
    int xf;
{
    int i;
    for (i = 0; i < FAMILIES; i++)
        if (familyMap[i].xf == xf)
            return familyMap[i].af;
    return -1;
}
