/*
 * Dclock.c -- a digital clock widget.
 * Author: Dan Heller <island!argv@sun.com>
 */
#ifndef _XtDclockP_h
#define _XtDclockP_h

#include <X11/CoreP.h>
#include "Dclock.h"

typedef struct {
    Pixel      		foreground;
    Boolean    		reverse;
    Boolean		scroll;
    Boolean		seconds;
    Boolean		bell;
    String		date_fmt;
    XFontStruct		*font;

    /* non-resources (e.g. user can't set) */
    XtIntervalId	interval_id;
    GC			foreGC, backGC;
    int			digit_w, digit_h;
    Pixmap		digits[10];
    Pixmap		tiny_digits[10];
    Pixmap		colon[2];
} DclockPart;

typedef struct _DclockRec {
    CorePart	core;
    DclockPart	dclock;
} DclockRec;

typedef struct {int dummy;} DclockClassPart;

typedef struct _DclockClassRec {
    CoreClassPart	core_class;
    DclockClassPart	dclock_class;
} DclockClassRec;

extern DclockClassRec dclockClassRec;

#endif _XtDclockP_h
