/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        CreateTile.c
 **
 **   Project:     X Widgets
 **
 **   Description: This file contains source for the tile creation
 **                routine used for patterned area fills, tiled
 **                text writes, etc...
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/


#include <stdio.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xw/XwP.h>
#include <Xw/Xw.h>
#include <X11/StringDefs.h>


/*  Tile types that can be created  */

static unsigned short bitmaps [9][16] =
{
   {  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 		/*  Solid Foreground  */
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF  },

   {  0x0000, 0x0000, 0x0000, 0x0000, 		/*  Solid Background  */
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000  },

   {  0x8888, 0x2222, 0x8888, 0x2222,		/*  25 percent  */
      0x8888, 0x2222, 0x8888, 0x2222,
      0x8888, 0x2222, 0x8888, 0x2222,
      0x8888, 0x2222, 0x8888, 0x2222  },

   {  0x5555, 0xAAAA, 0x5555, 0xAAAA,		/*  50 percent  */
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA  },

   {  0x5555, 0xFFFF, 0xAAAA, 0xFFFF,		/*  75 percent  */
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF  },

   {  0x5555, 0x5555, 0x5555, 0x5555,		/*  Vertical  */
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555  },

   {  0xffff, 0x0000, 0xffff, 0x0000,		/*  Horizontal  */ 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000  },

   {  0xeeee, 0xdddd, 0xbbbb, 0x7777,		/*  Slant Left  */
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777  },

   {  0x7777, 0xbbbb, 0xdddd, 0xeeee, 		/*  Slant Right  */
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee  }
};


/*  Tile caching structure  */

typedef struct _PixmapCache
{
   Screen * screen;
   Pixel    foreground;
   Pixel    background;
   int      tileType;
   Pixmap   pixmap;
   struct _PixmapCache * next;
} CacheEntry;

static CacheEntry * pixmapCache = NULL;



/************************************************************************
 *
 *  XwCreateTile
 *	Create a tile of screen depth, using the foreground and 
 *      background colors specified.  Use the type parameter to
 *      select the particular tile to create.  Ensure that multiple
 *      tiles of the same attributes are not created by caching the
 *      tiles.
 *
 ************************************************************************/

Pixmap XwCreateTile (screen, foreground, background, tileType)
Screen * screen;
Pixel    foreground;
Pixel    background;
int      tileType;

{
   register Display * display = DisplayOfScreen(screen);
   XImage       image;
   CacheEntry * cachePtr;
   Pixmap       tile;
   GC gc;
   XGCValues gcValues;


    /*  Check for a matching pixmap  */

    for (cachePtr = pixmapCache; cachePtr; cachePtr = cachePtr -> next)
	if (cachePtr -> screen == screen         && 
            cachePtr -> foreground == foreground &&
            cachePtr -> background == background &&
            cachePtr -> tileType == tileType)
          return (cachePtr -> pixmap);


    /*  Fill out the image structure for the new tile and create the pixmap */

    image.height = 16;
    image.width = 16;
    image.xoffset = 0;
    image.format = XYBitmap;
    image.data = (char*) bitmaps[tileType];
    image.byte_order = ImageByteOrder(display);
    image.bitmap_pad = BitmapPad(display);
    image.bitmap_bit_order = BitmapBitOrder(display);
    image.bitmap_unit = BitmapUnit(display);
    image.depth = 1;
    image.bytes_per_line = 2;
    image.obdata = NULL;

    tile = XCreatePixmap (display, RootWindowOfScreen(screen), 
		          16, 16, DefaultDepthOfScreen (screen));


    /*  Insert it at the head of the cache  */

    cachePtr = XtNew (CacheEntry);
    cachePtr -> screen = screen;
    cachePtr -> foreground = foreground;
    cachePtr -> background = background;
    cachePtr -> tileType = tileType;
    cachePtr -> pixmap = tile;
    cachePtr -> next = pixmapCache;
    pixmapCache = cachePtr;


    /*  Store the image into the tile  */

    gcValues.foreground = foreground;
    gcValues.background = background;
    gc = XCreateGC (display, RootWindowOfScreen(screen),
		    GCForeground | GCBackground, &gcValues);

    XPutImage (display, tile, gc, &image, 0, 0, 0, 0, 16, 16);

    XFreeGC (display, gc);
    return (tile);
}






