/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:    WClassing.c
 **
 **   Project:     X Widgets
 **
 **   Description: Code/Definitions for widget classing mechanism.
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/


/*****************************************************************************
 *
 * Include files and external variables accessed.
 *
 *****************************************************************************/
#include <string.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xw/WClassingP.h>

#undef XtCreateWidget

extern XrmDatabase	XtDefaultDB;
extern XwWCViewLoadProc	XwWCViewLoadProcs[];
extern int	XwNumWCViewLoadProcs;
extern XwTaskTableEntry	XwTasks[];
extern int	XwNumTasks;


/*************************************<->*************************************
 *
 *	void XwLoadViewTable(table,index,name,class)
 *		XwViewTableEntry	table[];
 *		int	index;
 *		char	*name;
 *		WidgetClass	class;
 *
 *   Description:
 *   -----------
 *		Because widget class addresses are not known at compile time,
 *		this procedure must be used to load the view tables for each task.
 *
 *   Inputs:
 *   ------
 * 
 *************************************<->***********************************/
void XwLoadViewTable(table,index,name,class)
	XwViewTableEntry	table[];
	int	index;
	char	*name;
	WidgetClass	class;
{
	table[index].name = name;
	table[index].wClass = class;
}

/*************************************<->*************************************
 *
 *	static void XwInitWClassing()
 *
 *   Description:
 *   -----------
 *		Goes through the table of view table load procedures and calls
 *		at run time.
 *
 *   Inputs:
 *   ------
 * 
 *************************************<->***********************************/
static void XwInitWClassing()
{
	int i;

	for (i=0; i<XwNumWCViewLoadProcs; i++)
		(XwWCViewLoadProcs[i])();
}

/*************************************<->*************************************
 *
 *	Widget XwCreateWidget(name,class,parent,args,num)
 *		char	*name;
 *		WidgetClass	class;
 *		Widget	parent;
 *		ArgList	args;
 *		Cardinal	num;
 *
 *   Description:
 *   -----------
 *		Replaces calls to XtCreateWidget.  Checks to see if the class 
 *		pointer value is really a task pointer.  If it is not a task
 *		pointer, vanilla XtCreateWidget is called.  If it is a task 
 *		pointer, the resource database is queried for the desired view.
 *
 *   Inputs:
 *   ------
 * 
 *************************************<->***********************************/
Widget XwCreateWidget(name,class,parent,args,num)
	char	*name;
	WidgetClass	class;
	Widget	parent;
	ArgList	args;
	Cardinal	num;
{
	static Boolean first_time = TRUE;
	Widget	return_widget;
	Widget	w;
	int	i,length;
	XwTaskTableEntry	*task;
	register XrmName	names[100];
	register XrmClass	classes[100];
	XrmQuark	t;
	XrmValue	res_ret;

	/*
	 * This may not be correct.  It might need to be a
	 * pointer instead of a value.  For now we just 
	 * don't ever access it, so we don't care.
	 */
	XrmRepresentation	typeQ;

	/*
	 * Make sure the table is initialized.
	 */
	if (first_time)
	{
		XwInitWClassing();
		first_time = FALSE;
	}

	/*
	 * See if the class is really a task.
	 */
	for (i=0; i<XwNumTasks; i++)
		if (class == (WidgetClass) XwTasks[i].task)
			break;
	if (i == XwNumTasks)
		/*
		 * It wasn't.  Just call XwCreatWidget and return.
		 */
		return(XtCreateWidget(name,class,parent,args,num));

	task = &(XwTasks[i]);
	w = parent;

	/*
	 * Set up the resource lists.  First, traverse the widget 
	 * heirarchy and get names and classes.
	 */
	for(length = 0; w != NULL; w = w->core.parent, length++)
	{
		names[length] = (XrmQuark) w->core.xrm_name;
		classes[length] = 
			(XrmQuark) w->core.widget_class->core_class.xrm_class;
	}

	/*
	 * Because the heirarchy was traversed bottom-up, the
	 * lists are backwards from what we need.  Invert them.
	 */
	for (i = 0; i < length/2; i++)
	{
		t = names[i];
		names[i] = names[length-i-1];
		names[length-i-1] = t;
		t = classes[i];
		classes[i] = classes[length-i-1];
		classes[length-i-1] = t;
	}

	/*
	 * Attach the tail end.
	 */
	names[length] = (XrmQuark) XrmStringToQuark(name);
	classes[length] = (XrmQuark) XrmStringToQuark(task->task_class);
	length++;

	names[length] = (XrmQuark) XrmStringToQuark("view");
	classes[length] = (XrmQuark) XrmStringToQuark("View");
	length++;

	/*
	 * Terminate the lists.
	 */
	names[length] = classes[length] = NULLQUARK;

	/*
	 * Get the resource.
	 */
	if (XrmQGetResource(XtDefaultDB,names,classes,&typeQ,&res_ret))
	{
		/*
		 * See if we can get a match with an entry in the
		 * view table.
		 */
		for(i = 0; i < task->num_views; i++)
		{
			if (!strcmp(res_ret.addr,task->views[i].name))
			{
				return(XtCreateWidget(name,task->views[i].wClass,
					parent, args,num));
			}
		}
	}

	/*
	 * Use the default, the first table entry, otherwise.
	 */
	return(XtCreateWidget(name,task->views[0].wClass,parent,args,num));
}

/*************************************<->*************************************
 *
 *	Widget XwCreateManagedWidget(name,class,parent,args,num)
 *		char	*name;
 *		WidgetClass	class;
 *		Widget	parent;
 *		ArgList	args;
 *		Cardinal	num;
 *
 *   Description:
 *   -----------
 *		Replaces calls to XtCreateManagedWidget.  Calls XwCreateWidget
 *		and then XtManageChild.
 * 
 *   Inputs:
 *   ------
 * 
 *************************************<->***********************************/
Widget XwCreateManagedWidget(name,class,parent,args,num)
	char	*name;
	WidgetClass	class;
	Widget	parent;
	ArgList	args;
	Cardinal	num;
{
	Widget	ret_widget;

	ret_widget = XwCreateWidget(name,class,parent,args,num);
	XtManageChild(ret_widget);
	return(ret_widget);
}
