#ifndef lint
static char rcsid[] = "$Header: SBitmap.c,v 1.1 88/08/20 09:06:19 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SBitmap.c,v $
 * Revision 1.1  88/08/20  09:06:19  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/********************************************************
*							*
*	Sony bitmap Widget				*
*							*
*	Written by M.Abe				*
*							*
*	Version 1.00	 7/27/88			*
*		First release				*
*							*
********************************************************/

#define XtStrlen(s)             ((s) ? strlen(s) : 0)

/********************************************************
*							*
*	Include definition				*
*							*
********************************************************/

#include <stdio.h>
#ifdef KANJI
#include <ctype.h>
#endif KANJI

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>
#include <X11/Misc.h>

#include <X11/SBitmap.h>
#include <X11/SBitmapP.h>

/********************************************************
*							*
*	Private procedure definitions			*
*							*
********************************************************/

static	void		ClassInitialize();
static	void		Initialize();
static	void		Realize();
static	void		Resize();
static	void		Exposure();
static	Boolean		SetValues();
static	void		Destroy();
static	void		Redisplay();

static	void		CvtStringToOrientation();
static	XtTextExtent	*SetupText();
static	void		GetnormalGC();
static	void		GethighlightGC();
static	void		GetgrayGC();
static	void		GetinvertGC();
static			ReadBitmapFiles();
static	char		*SaveLabel();
static	void		RedisplayBitmap();
static	void		RedisplayLabels();
static	unsigned short	sft2jis();
static	void		JustWidth();
static	void		JustHeight();

/********************************************************
*							*
*	Full class record constant			*
*							*
********************************************************/

static Cursor  defaultCursor = None;
static int defIWidth = 4;
static int defIHeight = 2;

static XtResource resources[] = { 
    /* resources for label */
    {XtNleftLabel,  XtCLabel, XtRString, sizeof(String),
	XtOffset(SBitmapWidget, sbitmap.left_label), XtRString, NULL},
    {XtNlabel,  XtCLabel, XtRString, sizeof(String),
	XtOffset(SBitmapWidget, sbitmap.label), XtRString, NULL},
    {XtNrightLabel,  XtCLabel, XtRString, sizeof(String),
	XtOffset(SBitmapWidget, sbitmap.right_label), XtRString, NULL},

    /* resources for font */
    {XtNleftFont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.left_font), XtRString,
	"8x16kana"},
    {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.font), XtRString, "8x16kana"},
    {XtNrightFont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.right_font), XtRString,
	"8x16kana"},

#ifdef KANJI
    /* resources for kanji font */
    {XtNleftKanjiFont, XtCKanjiFont, XtRFontStruct,
	sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.left_kanji_font), XtRString,
#ifdef sony_news
	"16x16kanji"},
#else sony_news
	"k14"},
#endif sony_news
    {XtNkanjiFont,  XtCKanjiFont, XtRFontStruct,
	sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.kanji_font), XtRString,
#ifdef sony_news
	"16x16kanji"},
#else sony_news
	"k14"},
#endif sony_news
    {XtNrightKanjiFont, XtCKanjiFont, XtRFontStruct,
	sizeof(XFontStruct *),
	XtOffset(SBitmapWidget, sbitmap.right_kanji_font), XtRString,
#ifdef sony_news
	"16x16kanji"},
#else sony_news
	"k14"},
#endif sony_news
#endif KANJI

    /* resources for text extent */
    {XtNleftTextExt, XtCTextExt, XtRPointer, sizeof(XtTextExtent *),
	XtOffset(SBitmapWidget ,sbitmap.left_text), XtRPointer,
	(caddr_t)NULL},
    {XtNtextExt, XtCTextExt, XtRPointer, sizeof(XtTextExtent *),
	XtOffset(SBitmapWidget ,sbitmap.text), XtRPointer,
	(caddr_t)NULL},
    {XtNrightTextExt, XtCTextExt, XtRPointer, sizeof(XtTextExtent *),
	XtOffset(SBitmapWidget ,sbitmap.right_text), XtRPointer,
	(caddr_t)NULL},

    /* resources for bitmap files */
    {XtNbitmapPath, XtCBitmapPath, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.bitmap_path), XtRString,
	DefaultBitmapPath},
    {XtNbitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.bitmap_file), XtRString,
	(caddr_t)NULL},
    {XtNhighlightBitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.highlight_bitmap_file),
	XtRString, (caddr_t)NULL},
    {XtNselectedBitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.selected_bitmap_file),
	XtRString, (caddr_t)NULL},
    {XtNselhighBitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.selhigh_bitmap_file),
	XtRString, (caddr_t)NULL},
    {XtNinsensitiveBitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.insensitive_bitmap_file),
	XtRString, (caddr_t)NULL},
    {XtNbackgroundFile, XtCBitmapFile, XtRString, sizeof(char *),
	XtOffset(SBitmapWidget ,sbitmap.background_file), XtRString,
	(caddr_t)NULL},

    /* resources for colors */
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	XtOffset(SBitmapWidget, sbitmap.foreground), XtRString,
	"Black"},
    {XtNtransparent, XtCTransparent, XtRBoolean, sizeof(Boolean),
	XtOffset(SBitmapWidget, sbitmap.transp), XtRString,
	"true"},
    {XtNhighlightBorder, XtCBorderColor, XtRPixel, sizeof(Pixel),
	XtOffset(SBitmapWidget, sbitmap.highlight_border_pixel),
	XtRString, "Black"},
    {XtNselectedBorder, XtCBorderColor, XtRPixel, sizeof(Pixel),
	XtOffset(SBitmapWidget, sbitmap.selected_border_pixel),
	XtRString, "Black"},

    /* resources for flags and modes */
    {XtNautoAdjust, XtCAutoAdjust, XtRBoolean, sizeof(Boolean),
	XtOffset(SBitmapWidget ,sbitmap.auto_adjust), XtRString,
	"FALSE"},
    {XtNselected, XtCSelected, XtRBoolean, sizeof(Boolean),
	XtOffset(SBitmapWidget ,sbitmap.selected), XtRString,
	"FALSE"},
    {XtNhighlightMode, XtCHighlightMode, XtRInt, sizeof(int),
	XtOffset(SBitmapWidget ,sbitmap.highlight_mode), XtRString,
	"0"},
    {XtNselectMode, XtCHighlightMode, XtRInt, sizeof(int),
	XtOffset(SBitmapWidget ,sbitmap.select_mode), XtRString, "0"},
    {XtNorientation, XtCOrientation, XtROrientation,
	sizeof(XtOrientation),
	XtOffset(SBitmapWidget ,sbitmap.orientation), XtRString,
	(char *)"horizontal"},

    /* resources for geometry */
    {XtNinternalWidth, XtCWidth, XtRInt,  sizeof(Dimension),
	XtOffset(SBitmapWidget, sbitmap.internal_width), XtRInt,
	(caddr_t)&defIWidth},
    {XtNinternalHeight, XtCHeight, XtRInt, sizeof(Dimension),
	XtOffset(SBitmapWidget, sbitmap.internal_height), XtRInt,
	(caddr_t)&defIHeight},

    /* resources for cursor */
    {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
	XtOffset(SBitmapWidget ,sbitmap.cursor), XtRCursor,
	(caddr_t)&defaultCursor},
};  

SBitmapClassRec sBitmapClassRec = {
  {
    (WidgetClass) &widgetClassRec,	/* superclass		*/
    "SBitmap",                          /* class_name		*/
    sizeof(SBitmapRec),                 /* size			*/
    ClassInitialize,                    /* class initialize  	*/
    NULL,				/* class_part_init	*/
    FALSE,                              /* class_inited      	*/
    Initialize,                         /* initialize		*/
    NULL,				/* initialize_hook	*/
    Realize,                            /* realize		*/
    NULL,                               /* actions		*/
    0,					/* num_actions		*/
    resources,                          /* resources	        */
    XtNumber(resources),                /* resource_count	*/
    NULLQUARK,                          /* xrm_class	        */
    TRUE,
    TRUE,
    TRUE,				/* compress enterleave	*/
    FALSE,                              /* visible_interest	*/
    Destroy,                            /* destroy		*/
    Resize,				/* resize		*/
    Exposure,				/* expose		*/
    SetValues,                          /* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_value_hook	*/
    NULL,                               /* accept_focus		*/
    XtVersion,				/* version              */
    NULL,				/* callback_private     */
    NULL,				/* tm_table             */
    NULL,				/* query_geometry       */
  },
  {	/* sbitmap field */
    Redisplay,				/* redisplay		*/
  }
};

/* for public consumption */
WidgetClass sBitmapWidgetClass = (WidgetClass) &sBitmapClassRec;

/********************************************************
*							*
*	Private Procedures				*
*							*
********************************************************/

/********************************************************
*							*
*	Class Initialize				*
*							*
********************************************************/

static  XrmQuark  XtQEhorizontal;
static  XrmQuark  XtQEvertical;

static void ClassInitialize(class)
WidgetClass class;
{
	XtQEhorizontal = XrmStringToQuark(XtEhorizontal);
	XtQEvertical   = XrmStringToQuark(XtEvertical);
	XtAddConverter( XtRString, XtROrientation,
			CvtStringToOrientation, NULL, (Cardinal)0 );
} /* ClassInitialize */

/********************************************************
*							*
*	Initialize					*
*							*
********************************************************/

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal num_args;
{
    SBitmapWidget bmw = (SBitmapWidget)new;
    SBitmapWidget req = (SBitmapWidget)request;
    XtTextExtent *text;

    /* save labels */
    bmw->sbitmap.left_label = SaveLabel(bmw->sbitmap.left_label);
    bmw->sbitmap.label = SaveLabel(bmw->sbitmap.label);
    bmw->sbitmap.right_label = SaveLabel(bmw->sbitmap.right_label);

    /* setup text */
    bmw->sbitmap.left_text = SetupText(bmw, 0);
    bmw->sbitmap.text = SetupText(bmw, 1);
    bmw->sbitmap.right_text = SetupText(bmw, 2);

    /* read bitmap files */
    bmw->sbitmap.bitmap_data = (Pixmap)UnspecifiedPixmap;
    bmw->sbitmap.highlight_bitmap_data = (Pixmap)UnspecifiedPixmap;
    bmw->sbitmap.selected_bitmap_data = (Pixmap)UnspecifiedPixmap;
    bmw->sbitmap.selhigh_bitmap_data = (Pixmap)UnspecifiedPixmap;
    bmw->sbitmap.insensitive_bitmap_data = (Pixmap)UnspecifiedPixmap;
    ReadBitmapFiles(bmw);

    if (bmw->sbitmap.auto_adjust || req->core.width == 0)
	JustWidth(bmw);
    else bmw->core.width = req->core.width;

    if (bmw->sbitmap.auto_adjust || req->core.height == 0)
	JustHeight(bmw);
    else bmw->core.height = req->core.height;

#ifdef KANJI
    GetnormalGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
    GethighlightGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
    GetgrayGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
#else KANJI
    GetnormalGC(bmw, bmw->sbitmap.font);
    GethighlightGC(bmw, bmw->sbitmap.font);
    GetgrayGC(bmw, bmw->sbitmap.font);
#endif KANJI
    GetinvertGC(bmw);

    bmw->sbitmap.highlighted = FALSE;
    (*XtClass(new)->core_class.resize) ((Widget)bmw);
} 

/********************************************************
*							*
*	Realize						*
*							*
********************************************************/

static void Realize(w, valueMask, attributes) 
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	Pixmap border_pixmap;

	*valueMask |= CWBitGravity;
	attributes->bit_gravity = WestGravity;
/*	attributes->bit_gravity = CenterGravity;	*/
/*	attributes->bit_gravity = EastGravity;		*/

	if ((attributes->cursor =
			((SBitmapWidget)w)->sbitmap.cursor) != None)
		*valueMask |= CWCursor;

	XtCreateWindow( w, (unsigned int)InputOutput,
		(Visual *)CopyFromParent, *valueMask, attributes );

} /* Realize */

/********************************************************
*							*
*	Destroy						*
*							*
********************************************************/

static void Destroy(w)
Widget w;
{
	SBitmapWidget bmw = (SBitmapWidget)w;

	/* must free GCs and pixmaps */

	bmw->core.background_pixmap = UnspecifiedPixmap;
	bmw->core.border_pixmap = UnspecifiedPixmap;

	if (bmw->sbitmap.left_label) free(bmw->sbitmap.left_label);
	if (bmw->sbitmap.label) free(bmw->sbitmap.label);
	if (bmw->sbitmap.right_label) free(bmw->sbitmap.right_label);

	XtDestroyGC(bmw->sbitmap.normal_GC);
	XtDestroyGC(bmw->sbitmap.normal_KGC);
	XtDestroyGC(bmw->sbitmap.highlight_GC);
	XtDestroyGC(bmw->sbitmap.highlight_KGC);
	XtDestroyGC(bmw->sbitmap.gray_GC);
	XtDestroyGC(bmw->sbitmap.gray_KGC);
	XtDestroyGC(bmw->sbitmap.invert_GC);
}

/********************************************************
*							*
*	Resize						*
*							*
********************************************************/

static void Resize(w)
Widget	w;
{
    SBitmapWidget bmw = (SBitmapWidget)w;
    int x, y;
    int interval;

    if (bmw->sbitmap.orientation == XtorientHorizontal) {
	/* set bitmap position */
	bmw->sbitmap.bitmap_x = bmw->sbitmap.internal_width;
	bmw->sbitmap.bitmap_y = ((Position)bmw->core.height -
			(Position)bmw->sbitmap.bitmap_height) / 2;

	/* set left label position */
	if (bmw->sbitmap.bitmap_width == 0) 
	    bmw->sbitmap.left_text->x = bmw->sbitmap.bitmap_x;
	else
	    bmw->sbitmap.left_text->x = bmw->sbitmap.bitmap_x +
		bmw->sbitmap.bitmap_width +
		bmw->sbitmap.internal_width;
	bmw->sbitmap.left_text->y = ((Position)bmw->core.height -
	    (Position)bmw->sbitmap.left_text->height) / 2 +
#ifdef KANII
	    Max(bmw->sbitmap.left_font->max_bounds.ascent,
		bmw->sbitmap.left_kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.left_font->max_bounds.ascent;
#endif KANJI

	/* set center label position */
	interval = (Position)bmw->core.width -
	    ((Position)bmw->sbitmap.left_text->width +
	     (Position)bmw->sbitmap.text->width +
	     (Position)bmw->sbitmap.right_text->width +
	     (Position)(bmw->sbitmap.bitmap_width ?
		bmw->sbitmap.bitmap_width +
		bmw->sbitmap.internal_width : 0) +
	     (Position)bmw->sbitmap.internal_width * 2);
	bmw->sbitmap.text->x = bmw->sbitmap.left_text->x +
		bmw->sbitmap.left_text->width + interval/2;
/*
	((Position)bmw->core.width -
				(Position)bmw->sbitmap.text->width)/2;
	if (bmw->sbitmap.bitmap_width) {
		bmw->sbitmap.text->x +=
		    (bmw->sbitmap.bitmap_x +
		     bmw->sbitmap.bitmap_width) / 2;
	}
*/
	x = bmw->sbitmap.left_text->x + bmw->sbitmap.left_text->width;
	if (bmw->sbitmap.left_text->width)
	    x += bmw->sbitmap.internal_width;
	bmw->sbitmap.text->x = Max(x, bmw->sbitmap.text->x);

	bmw->sbitmap.text->y =
	    ((Position)bmw->core.height -
		(Position)bmw->sbitmap.text->height) / 2 +
#ifdef KANJI
	    Max(bmw->sbitmap.font->max_bounds.ascent,
		bmw->sbitmap.kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.font->max_bounds.ascent;
#endif KANJI

	/* set right label position */
	bmw->sbitmap.right_text->x =
	    (Position)bmw->core.width -
	    (Position)bmw->sbitmap.internal_width -
	    (Position)bmw->sbitmap.right_text->width;
	
	if (bmw->sbitmap.text->width) {
	    x = bmw->sbitmap.text->x +
		bmw->sbitmap.text->width +
		bmw->sbitmap.internal_width;
	} else {
	    x = bmw->sbitmap.left_text->x +
		bmw->sbitmap.left_text->width;
	    if (bmw->sbitmap.left_text->width)
		x += bmw->sbitmap.internal_width;
	}

	bmw->sbitmap.right_text->x = Max(x, bmw->sbitmap.right_text->x);

	bmw->sbitmap.right_text->y =
	    ((Position)bmw->core.height -
		(Position)bmw->sbitmap.right_text->height) / 2 +
#ifdef KANJI
	    Max(bmw->sbitmap.right_font->max_bounds.ascent,
		bmw->sbitmap.right_kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.right_font->max_bounds.ascent;
#endif KANJI
    } else {	/* XtorientVertical */
	/* set bitmap position */
	bmw->sbitmap.bitmap_y = bmw->sbitmap.internal_height;
	bmw->sbitmap.bitmap_x = ((Position)bmw->core.width -
			(Position)bmw->sbitmap.bitmap_width) / 2;

	/* set center label position */
	bmw->sbitmap.text->x = ((Position)bmw->core.width -
				(Position)bmw->sbitmap.text->width)/2;
	bmw->sbitmap.text->y = ((Position)(bmw->core.height +
	    bmw->sbitmap.internal_height + bmw->sbitmap.bitmap_height) -
	    (Position)bmw->sbitmap.text->height) / 2;

	y = bmw->sbitmap.bitmap_y + bmw->sbitmap.bitmap_height;
	if (bmw->sbitmap.bitmap_height)
	    y += bmw->sbitmap.internal_height;
	bmw->sbitmap.text->y = Max(y, bmw->sbitmap.text->y) +
#ifdef KANJI
	    Max(bmw->sbitmap.font->max_bounds.ascent,
		bmw->sbitmap.kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.font->max_bounds.ascent;
#endif KANJI

	/* set left label position */
	bmw->sbitmap.left_text->x = Min(
	    (Position)bmw->sbitmap.internal_width,
	    (Position)bmw->sbitmap.text->x -
		(Position)bmw->sbitmap.internal_width -
		(Position)bmw->sbitmap.left_text->width);

	bmw->sbitmap.left_text->y = ((Position)(bmw->core.height +
	    bmw->sbitmap.internal_height + bmw->sbitmap.bitmap_height) -
	    (Position)bmw->sbitmap.left_text->height) / 2;
	y = bmw->sbitmap.bitmap_y + bmw->sbitmap.bitmap_height;
	if (bmw->sbitmap.bitmap_height)
	    y += bmw->sbitmap.internal_height;
	bmw->sbitmap.left_text->y = Max(y, bmw->sbitmap.left_text->y) +
#ifdef KANJI
	    Max(bmw->sbitmap.left_font->max_bounds.ascent,
		bmw->sbitmap.left_kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.left_font->max_bounds.ascent;
#endif KANJI

	/* set right label position */
	bmw->sbitmap.right_text->x = Max(
		(Position)(bmw->sbitmap.text->x +
		    bmw->sbitmap.text->width +
		    bmw->sbitmap.internal_width),
		(Position)bmw->core.width -
		    (Position)bmw->sbitmap.right_text->width -
		    (Position)bmw->sbitmap.internal_width);

	bmw->sbitmap.right_text->y = ((Position)(bmw->core.height +
	    bmw->sbitmap.internal_height + bmw->sbitmap.bitmap_height) -
	    (Position)bmw->sbitmap.right_text->height) / 2;
	y = bmw->sbitmap.bitmap_y + bmw->sbitmap.bitmap_height;
	if (bmw->sbitmap.bitmap_height)
	    y += bmw->sbitmap.internal_height;
	bmw->sbitmap.right_text->y =
	    Max(y, bmw->sbitmap.right_text->y) +
#ifdef KANJI
	    Max(bmw->sbitmap.right_font->max_bounds.ascent,
		bmw->sbitmap.right_kanji_font->max_bounds.ascent);
#else KANJI
	    bmw->sbitmap.right_font->max_bounds.ascent;
#endif KANJI
    }
}

/********************************************************
*							*
*	Redisplay					*
*							*
*********************************************************/

static void Exposure(w, event)
Widget w;
XEvent *event;
{
    SBitmapWidget bmw = (SBitmapWidget) w;
    XSetWindowAttributes window_attributes;
    GC gc, kgc;
    Pixmap bitmap_data;

    if (!bmw->core.sensitive) {
	XClearWindow(XtDisplay(w), XtWindow(w));
	window_attributes.border_pixel = bmw->core.border_pixel;
	XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
	RedisplayBitmap(bmw,
		bmw->sbitmap.insensitive_bitmap_data,
		bmw->sbitmap.normal_GC);
	RedisplayLabels(bmw,
		bmw->sbitmap.gray_GC, bmw->sbitmap.gray_KGC);
	return;
    }

    switch (bmw->sbitmap.highlight_mode * 3 + bmw->sbitmap.select_mode){
	case 0: /* highlight by inverse, select by inverse */

		if (bmw->sbitmap.highlighted ^ bmw->sbitmap.selected) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 1: /* highlight by inverse, select by border color */
		if (bmw->sbitmap.highlighted) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		if (bmw->sbitmap.selected)
		    window_attributes.border_pixel =
				bmw->sbitmap.selected_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 2: /* highlight by inverse, select by bitmap */
		if (bmw->sbitmap.highlighted) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		if (bmw->sbitmap.selected) {
			bitmap_data = bmw->sbitmap.selected_bitmap_data;
		} else {
			bitmap_data = bmw->sbitmap.bitmap_data;
		}
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 3: /* highlight by border color, select by inverse */
		if (bmw->sbitmap.selected) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		if (bmw->sbitmap.highlighted)
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 4: /* highlight by border color, select by border color */

		XClearWindow(XtDisplay(w), XtWindow(w));
		if (bmw->sbitmap.highlighted)
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		else if (bmw->sbitmap.selected)
		    window_attributes.border_pixel =
				bmw->sbitmap.selected_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);

		/*
		 *	Setup GC
		 */
		gc = bmw->sbitmap.normal_GC;
		kgc = bmw->sbitmap.normal_KGC;
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 5: /* highlight by border color, select by bitmap */
		XClearWindow(XtDisplay(w), XtWindow(w));
		if (bmw->sbitmap.highlighted)
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		gc = bmw->sbitmap.normal_GC;
		kgc = bmw->sbitmap.normal_KGC;
		if (bmw->sbitmap.selected) {
			bitmap_data = bmw->sbitmap.selected_bitmap_data;
		} else {
			bitmap_data = bmw->sbitmap.bitmap_data;
		}
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 6: /* highlight by bitmap, select by inverse */
		if (bmw->sbitmap.selected) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		if (bmw->sbitmap.highlighted)
		     bitmap_data = bmw->sbitmap.highlight_bitmap_data;
		else
		     bitmap_data = bmw->sbitmap.bitmap_data;
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 7: /* highlight by bitmap, select by border */
		XClearWindow(XtDisplay(w), XtWindow(w));
		if (bmw->sbitmap.selected)
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		gc = bmw->sbitmap.normal_GC;
		kgc = bmw->sbitmap.normal_KGC;

		if (bmw->sbitmap.highlighted)
		     bitmap_data = bmw->sbitmap.highlight_bitmap_data;
		else
		     bitmap_data = bmw->sbitmap.bitmap_data;
		RedisplayBitmap(bmw, bmw->sbitmap.bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 8: /* highlight by bitmap, select by bitmap */
		XClearWindow(XtDisplay(w), XtWindow(w));
		gc = bmw->sbitmap.normal_GC;
		kgc = bmw->sbitmap.normal_KGC;
		if (bmw->sbitmap.selected) {
		    if (bmw->sbitmap.highlighted) {
			bitmap_data=bmw->sbitmap.selhigh_bitmap_data;
		    } else {
			bitmap_data=bmw->sbitmap.selected_bitmap_data;
		    }
		} else {
		    if (bmw->sbitmap.highlighted) {
			bitmap_data=bmw->sbitmap.highlight_bitmap_data;
		    } else {
			bitmap_data=bmw->sbitmap.bitmap_data;
		    }
		}
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;
	}
}

static void Redisplay(w, event)
Widget w;
XEvent *event;
{
    SBitmapWidget bmw = (SBitmapWidget) w;
    XSetWindowAttributes window_attributes;
    GC gc, kgc;
    Pixmap bitmap_data;

    if (!bmw->core.sensitive) return;

    switch (bmw->sbitmap.highlight_mode * 3 + bmw->sbitmap.select_mode){
	case 0: /* highlight by inverse, select by inverse */
		if (DefaultDepthOfScreen(XtScreen(w)) == 1) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			bmw->sbitmap.invert_GC, 0, 0,
			bmw->core.width, bmw->core.height);
		    break;
		}
		if (bmw->sbitmap.highlighted ^ bmw->sbitmap.selected) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		bitmap_data = bmw->sbitmap.bitmap_data;
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 1:	/* highlight by invrese, select by border color */
		if (DefaultDepthOfScreen(XtScreen(w)) == 1) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			bmw->sbitmap.invert_GC, 0, 0,
			bmw->core.width, bmw->core.height);
		    break;
		}
		if (bmw->sbitmap.highlighted) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		bitmap_data = bmw->sbitmap.bitmap_data;
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 2: /* select by bitmap, highlight by inverse */
		if (DefaultDepthOfScreen(XtScreen(w)) == 1) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			bmw->sbitmap.invert_GC, 0, 0,
			bmw->core.width, bmw->core.height);
		    break;
		}
		if (bmw->sbitmap.highlighted) {
		    XFillRectangle(XtDisplay(w), XtWindow(w),
			    bmw->sbitmap.normal_GC, 0, 0,
			    bmw->core.width, bmw->core.height);
		    gc = bmw->sbitmap.highlight_GC;
		    kgc = bmw->sbitmap.highlight_KGC;
		} else {
		    XClearWindow(XtDisplay(w), XtWindow(w));
		    gc = bmw->sbitmap.normal_GC;
		    kgc = bmw->sbitmap.normal_KGC;
		}
		if (bmw->sbitmap.selected) {
		    bitmap_data = bmw->sbitmap.selected_bitmap_data;
		} else {
		    bitmap_data = bmw->sbitmap.bitmap_data;
		}
		RedisplayBitmap(bmw, bitmap_data, gc);
		RedisplayLabels(bmw, gc, kgc);
		break;

	case 3: /* select inverse, highlight by border color */
	case 5: /* select by bitmap, highlight by border color */
		if (bmw->sbitmap.highlighted)
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		else
		    window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		break;

	case 4: /* select by border color, highlight by border color */
		if (bmw->sbitmap.highlighted) {
		    window_attributes.border_pixel =
				bmw->sbitmap.highlight_border_pixel;
		} else if (bmw->sbitmap.selected)
		    window_attributes.border_pixel =
				bmw->sbitmap.selected_border_pixel;
		else window_attributes.border_pixel =
				bmw->core.border_pixel;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                               	CWBorderPixel, &window_attributes);
		break;

	case 6: /* select by inverse, highlight by changing bitmap */

		if (bmw->sbitmap.selected)
		    gc = bmw->sbitmap.highlight_GC;
		else
		    gc = bmw->sbitmap.normal_GC;
		if (bmw->sbitmap.highlighted)
		    bitmap_data = bmw->sbitmap.highlight_bitmap_data;
		else
		    bitmap_data = bmw->sbitmap.bitmap_data;

		RedisplayBitmap(bmw, bitmap_data, gc);
		break;

	case 7: /* select by border color, highlight by bitmap */

		gc = bmw->sbitmap.normal_GC;
		if (bmw->sbitmap.highlighted)
		    bitmap_data = bmw->sbitmap.highlight_bitmap_data;
		else
		    bitmap_data = bmw->sbitmap.bitmap_data;

		RedisplayBitmap(bmw, bitmap_data, gc);
		break;

	case 8: /* select by bitmap, highlight by bitmap */
		gc = bmw->sbitmap.normal_GC;
		if (bmw->sbitmap.highlighted) {
		    if (bmw->sbitmap.selected) {
	    		bitmap_data = bmw->sbitmap.selhigh_bitmap_data;
		    } else {
	    		bitmap_data = bmw->sbitmap.highlight_bitmap_data;
		    }
		}else {
		    if (bmw->sbitmap.selected) {
	    		bitmap_data = bmw->sbitmap.selected_bitmap_data;
		    } else {
	    		bitmap_data = bmw->sbitmap.bitmap_data;
		    }
		}
		RedisplayBitmap(bmw, bitmap_data, gc);
    }
}

/********************************************************
*							*
*	Set Value					*
*							*
*********************************************************/

/*
	if (new != req) {	for supreclass resource only
		if (new != cur) {
			superclass set created value internally
		} else {
			superclass just ignore the req
		}
	} else {
		if (new != cur) {
			requested value is set
		} else {
			no request or
			requested value is the same as current value
		}
	}
*/


static Boolean SetValues (current, request, new, last)
Widget current, request, new;
Boolean last;
{
    SBitmapWidget cur = (SBitmapWidget) current;
    SBitmapWidget req = (SBitmapWidget) request;
    SBitmapWidget bmw = (SBitmapWidget) new;
    Boolean was_resized = FALSE;
    Boolean redisplay = FALSE;
    char file_name[128];
    int width, height;
    int x_hot, y_hot;
    XSetWindowAttributes window_attributes;

    if (cur->sbitmap.left_font != bmw->sbitmap.left_font ||
#ifdef KANJI
	cur->sbitmap.left_kanji_font != bmw->sbitmap.left_kanji_font ||
#endif KANJI
	(cur->sbitmap.left_label != bmw->sbitmap.left_label &&
	 (cur->sbitmap.left_label && bmw->sbitmap.left_label &&
	  strcmp(cur->sbitmap.left_label, bmw->sbitmap.left_label)))) {
	    if (cur->sbitmap.left_label != bmw->sbitmap.left_label ||
		(cur->sbitmap.left_label && bmw->sbitmap.left_label &&
		 strcmp(cur->sbitmap.left_label, bmw->sbitmap.left_label))) {
		    if (cur->sbitmap.left_label)
			free(cur->sbitmap.left_label);
		    bmw->sbitmap.left_label =
			SaveLabel(bmw->sbitmap.left_label);
	    }
	    bmw->sbitmap.left_text = SetupText(bmw, 0);
	    was_resized = True;
	    redisplay = True;
    }

    if (cur->sbitmap.font != bmw->sbitmap.font ||
#ifdef KANJI
	cur->sbitmap.kanji_font != bmw->sbitmap.kanji_font ||
#endif KANJI
	(cur->sbitmap.label != bmw->sbitmap.label &&
	 (cur->sbitmap.left_label && bmw->sbitmap.left_label &&
	  strcmp(cur->sbitmap.label, bmw->sbitmap.label)))) {
	    if (cur->sbitmap.label != bmw->sbitmap.label ||
		(cur->sbitmap.left_label && bmw->sbitmap.left_label &&
		 strcmp(cur->sbitmap.label, bmw->sbitmap.label))) {
		    if (cur->sbitmap.label) free(cur->sbitmap.label);
		    bmw->sbitmap.label = SaveLabel(bmw->sbitmap.label);
	    }
	    bmw->sbitmap.text = SetupText(bmw, 1);
	    was_resized = True;
	    redisplay = True;
    }

    if (cur->sbitmap.right_font != bmw->sbitmap.right_font ||
#ifdef KANJI
	cur->sbitmap.right_kanji_font != bmw->sbitmap.right_kanji_font ||
#endif KANJI
	(cur->sbitmap.right_label != bmw->sbitmap.right_label ||
	 (cur->sbitmap.left_label && bmw->sbitmap.left_label &&
	  strcmp(cur->sbitmap.right_label, bmw->sbitmap.right_label)))) {
	    if (cur->sbitmap.right_label != bmw->sbitmap.right_label ||
		(cur->sbitmap.left_label && bmw->sbitmap.left_label &&
		 strcmp(cur->sbitmap.right_label, bmw->sbitmap.right_label))) {
		    if (cur->sbitmap.right_label)
			free(cur->sbitmap.right_label);
		    bmw->sbitmap.right_label =
			SaveLabel(bmw->sbitmap.right_label);
	    }
	    bmw->sbitmap.right_text = SetupText(bmw, 2);
	    was_resized = True;
	    redisplay = True;
    }

    if (cur->sbitmap.bitmap_file != bmw->sbitmap.bitmap_file) {
	_ReadBitmapFile(0, bmw, bmw->sbitmap.bitmap_file,
			&width, &height, &bmw->sbitmap.bitmap_data);
	bmw->sbitmap.bitmap_width =
			Max(bmw->sbitmap.bitmap_width, width);

	bmw->sbitmap.bitmap_height =
			Max(bmw->sbitmap.bitmap_height, height);
	was_resized = TRUE;
	redisplay |= !bmw->sbitmap.highlighted &&
		    !bmw->sbitmap.selected;
    }

    if (cur->sbitmap.highlight_bitmap_file !=
				bmw->sbitmap.highlight_bitmap_file) {
	_ReadBitmapFile(0, bmw, bmw->sbitmap.highlight_bitmap_file,
			&width, &height,
			&bmw->sbitmap.highlight_bitmap_data);
	bmw->sbitmap.bitmap_width =
			Max(bmw->sbitmap.bitmap_width, width);
	bmw->sbitmap.bitmap_height =
			Max(bmw->sbitmap.bitmap_height, height);
	was_resized = TRUE;
	redisplay |= (bmw->sbitmap.highlight_mode == 2) &&
		    bmw->sbitmap.highlighted &&
		    !bmw->sbitmap.selected;
    }

    if (cur->sbitmap.selected_bitmap_file !=
				bmw->sbitmap.selected_bitmap_file) {
	_ReadBitmapFile(0, bmw, bmw->sbitmap.selected_bitmap_file,
			&width, &height,
			&bmw->sbitmap.selected_bitmap_data);
	bmw->sbitmap.bitmap_width =
				Max(bmw->sbitmap.bitmap_width, width);
	bmw->sbitmap.bitmap_height =
				Max(bmw->sbitmap.bitmap_height, height);
	was_resized = TRUE;
	redisplay |= (bmw->sbitmap.select_mode == 2) &&
		    !bmw->sbitmap.highlighted &&
		    bmw->sbitmap.selected;
    }

    if (cur->sbitmap.selhigh_bitmap_file !=
				bmw->sbitmap.selhigh_bitmap_file) {
	_ReadBitmapFile(0, bmw, bmw->sbitmap.selhigh_bitmap_file,
			&width, &height,
			&bmw->sbitmap.selhigh_bitmap_data);
	bmw->sbitmap.bitmap_width =
				Max(bmw->sbitmap.bitmap_width, width);
	bmw->sbitmap.bitmap_height =
				Max(bmw->sbitmap.bitmap_height, height);
	was_resized = TRUE;
	redisplay |= (bmw->sbitmap.highlight_mode == 2) &&
		    (bmw->sbitmap.select_mode == 2) &&
		    bmw->sbitmap.highlighted &&
		    bmw->sbitmap.selected;
    }

    if (cur->sbitmap.insensitive_bitmap_file !=
				bmw->sbitmap.insensitive_bitmap_file) {
	_ReadBitmapFile(0, bmw, bmw->sbitmap.insensitive_bitmap_file,
			&width, &height,
			&bmw->sbitmap.insensitive_bitmap_data);
	bmw->sbitmap.bitmap_width =
				Max(bmw->sbitmap.bitmap_width, width);
	bmw->sbitmap.bitmap_height =
				Max(bmw->sbitmap.bitmap_height, height);
	was_resized = TRUE;
	redisplay |= ~bmw->core.sensitive;
    }

    if (cur->sbitmap.background_file !=
				bmw->sbitmap.background_file) {
	_ReadBitmapFile(1, bmw, bmw->sbitmap.background_file,
			&width, &height,
			&bmw->core.background_pixmap);
	window_attributes.background_pixmap =
			bmw->core.background_pixmap;
	XChangeWindowAttributes(XtDisplay(bmw), XtWindow(bmw),
                               	CWBackPixmap, &window_attributes);
    }

    if (cur->sbitmap.selected_border_pixel !=
				bmw->sbitmap.selected_border_pixel) {
	if (bmw->sbitmap.selected && bmw->sbitmap.select_mode == 1) {
	    window_attributes.border_pixel =
			bmw->sbitmap.selected_border_pixel;
	    XChangeWindowAttributes(XtDisplay(bmw), XtWindow(bmw),
                               	CWBorderPixel, &window_attributes);
	}
    }

    if (cur->sbitmap.highlight_border_pixel !=
				bmw->sbitmap.highlight_border_pixel) {
	if (bmw->sbitmap.highlighted &&
				bmw->sbitmap.highlight_mode == 1) {
	    window_attributes.border_pixel =
			bmw->sbitmap.highlight_border_pixel,
	    XChangeWindowAttributes(XtDisplay(bmw), XtWindow(bmw),
                               	CWBorderPixel, &window_attributes);
	}
    }

    if (cur->sbitmap.internal_width != bmw->sbitmap.internal_width ||
	cur->sbitmap.internal_height != bmw->sbitmap.internal_height) {
	    was_resized = TRUE;
	    redisplay = TRUE;
    }

    if (bmw->sbitmap.auto_adjust || req->core.width == 0) {
	JustWidth(bmw);
	was_resized = TRUE;
	redisplay = TRUE;
    }
    if (bmw->sbitmap.auto_adjust || req->core.height == 0) {
	JustHeight(bmw);
	was_resized = TRUE;
	redisplay = TRUE;
    }

    if (cur->core.width != bmw->core.width ||
	cur->core.height != bmw->core.height) {
	    if ((XtMakeResizeRequest(bmw,
		bmw->core.width, bmw->core.height,
		&bmw->core.width, &bmw->core.height)==XtGeometryNo)) {
		    bmw->core.width = cur->core.width;
		    bmw->core.height = cur->core.height;
	    } else {
		was_resized = TRUE;
		redisplay = TRUE;
	    }
    }

    if (cur->sbitmap.foreground != bmw->sbitmap.foreground ||
	cur->sbitmap.font->fid != bmw->sbitmap.font->fid) {
	    XtDestroyGC(cur->sbitmap.normal_GC);
	    XtDestroyGC(cur->sbitmap.normal_KGC);
	    XtDestroyGC(cur->sbitmap.highlight_GC);
	    XtDestroyGC(cur->sbitmap.highlight_KGC);
	    XtDestroyGC(cur->sbitmap.gray_GC);
	    XtDestroyGC(cur->sbitmap.gray_KGC);
#ifdef KANJI
	    GetnormalGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
	    GethighlightGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
	    GetgrayGC(bmw, bmw->sbitmap.font, bmw->sbitmap.kanji_font);
#else KANJI
	    GetnormalGC(bmw, bmw->sbitmap.font);
	    GethighlightGC(bmw, bmw->sbitmap.font);
	    GetgrayGC(bmw, bmw->sbitmap.font);
#endif KANJI
	    redisplay = TRUE;
    }

    if (cur->sbitmap.selected != bmw->sbitmap.selected ||
	cur->sbitmap.highlight_mode != bmw->sbitmap.highlight_mode ||
	cur->sbitmap.select_mode != bmw->sbitmap.select_mode)
	    redisplay = TRUE;

    if (was_resized) Resize((Widget)bmw);
    return (redisplay);
}

/********************************************************
*							*
*	Define and add resource converter		*
*							*
********************************************************/

 /* Orientation enumeration constants */

extern void LowerCase();

#define done(address, type) \
    { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }

/* ARGSUSED */
static void CvtStringToOrientation(args, num_args, fromVal, toVal)
XrmValuePtr *args;              /* unused */
Cardinal        *num_args;      /* unused */
XrmValuePtr     fromVal;
XrmValuePtr     toVal;
{
	static XtOrientation orient;
	XrmQuark       q;
	char        lowerName[1000];

	LowerCase((char *) fromVal->addr, lowerName);
	q = XrmStringToQuark(lowerName);
	if (q == XtQEhorizontal) orient = XtorientHorizontal;
	else if (q == XtQEvertical) orient = XtorientVertical;
	else return;
	done(&orient, XtOrientation);
};

/********************************************************
*							*
*	Setup text					*
*							*
********************************************************/

#ifdef KANJI
static int GetTextWidth(bmw, label, font, kfont)
SBitmapWidget bmw;
char *label;
XFontStruct *font, *kfont;
{
    char *p = label;
    unsigned short kanji;
    int width = 0;

    while (*p) {
	if (iskanji(*p)) {
	    kanji = *(p++);
	    kanji = sft2jis((kanji << 8) + *(p++));
	    width += (Dimension)XTextWidth16(kfont, &kanji, 1);
	} else
	    width += (Dimension)XTextWidth(font, p++, 1);
    }
    return(width);
}
#endif KANJI

static XtTextExtent *SetupText(bmw, justify)
SBitmapWidget bmw;
int justify;
{
    char *label;
    XFontStruct *font;
#ifdef KANJI
    XFontStruct *kfont;
#endif KANJI
    XtTextExtent *text;

    switch (justify) {
	case 0:	/* left */
		label = bmw->sbitmap.left_label;
		font = bmw->sbitmap.left_font;
#ifdef KANJI
		kfont = bmw->sbitmap.left_kanji_font;
#endif KANJI
		text = bmw->sbitmap.left_text;
		break;

	case 1: /* center */
		label = bmw->sbitmap.label;
		font = bmw->sbitmap.font;
#ifdef KANJI
		kfont = bmw->sbitmap.kanji_font;
#endif KANJI
		text = bmw->sbitmap.text;
		break;

	case 2: /* right */
		label = bmw->sbitmap.right_label;
		font = bmw->sbitmap.right_font;
#ifdef KANJI
		kfont = bmw->sbitmap.right_kanji_font;
#endif KANJI
		text = bmw->sbitmap.right_text;
		break;
    }
    if (text == NULL)
	text = (XtTextExtent *)malloc(sizeof(XtTextExtent));
    if (label == NULL || *label == NULL) {
	text->width = 0;
	text->height = 0;
    } else {
#ifdef KANJI
	text->width =
	    (Dimension)GetTextWidth(bmw, label, font, kfont);
	text->height =
	    Max(font->max_bounds.ascent + font->max_bounds.descent,
		kfont->max_bounds.ascent + kfont->max_bounds.descent);
#else KANJI
	text->width =
	    (Dimension)XTextWidth(font, label, strlen(label));
	text->height =
	    font->max_bounds.ascent + font->max_bounds.descent;
#endif KANJI
    }
    return(text);
}

/********************************************************
*							*
*	Get GC						*
*							*
********************************************************/

#ifdef KANJI
static void GetnormalGC(bmw, font, kfont)
SBitmapWidget bmw;
XFontStruct *font, *kfont;
{
    XGCValues	values;

    values.foreground = bmw->sbitmap.foreground;
    values.background = bmw->core.background_pixel;

    values.font = font->fid;
    bmw->sbitmap.normal_GC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
    values.font = kfont->fid;
    bmw->sbitmap.normal_KGC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
}

static void GethighlightGC(bmw, font, kfont)
SBitmapWidget bmw;
XFontStruct *font, *kfont;
{
    XGCValues	values;

    values.foreground = bmw->core.background_pixel;
    values.background = bmw->sbitmap.foreground;

    values.font = font->fid;
    bmw->sbitmap.highlight_GC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
    values.font = kfont->fid;
    bmw->sbitmap.highlight_KGC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
}

static void GetgrayGC(bmw, font, kfont)
SBitmapWidget bmw;
XFontStruct *font, *kfont;
{
    XGCValues	values;

    values.foreground = 0xff/*bmw->sbitmap.foreground*/;
    values.background = 0;
    values.tile       = XtGrayPixmap(XtScreen((Widget)bmw));
    values.fill_style = FillTiled;

    values.font = font->fid;
    bmw->sbitmap.gray_GC = XtGetGC((Widget)bmw, 
       (unsigned)GCForeground|GCBackground|GCTile|GCFillStyle|GCFont,
       &values);
    values.font = kfont->fid;
    bmw->sbitmap.gray_KGC = XtGetGC((Widget)bmw, 
       (unsigned)GCForeground|GCBackground|GCTile|GCFillStyle|GCFont,
       &values);
}
#else KANJI
static void GetnormalGC(bmw, font)
SBitmapWidget bmw;
XFontStruct *font;
{
    XGCValues	values;

    values.foreground = bmw->sbitmap.foreground;
    values.background = bmw->core.background_pixel;

    values.font = font->fid;
    bmw->sbitmap.normal_GC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
}

static void GethighlightGC(bmw, font)
SBitmapWidget bmw;
XFontStruct *font;
{
    XGCValues	values;

    values.foreground = bmw->core.background_pixel;
    values.background = bmw->sbitmap.foreground;

    values.font = font->fid;
    bmw->sbitmap.highlight_GC = XtGetGC((Widget)bmw,
	(unsigned) GCForeground | GCBackground | GCFont, &values);
}

static void GetgrayGC(bmw, font)
SBitmapWidget bmw;
XFontStruct *font;
{
    XGCValues	values;

    values.foreground = 0xff/*bmw->sbitmap.foreground*/;
    values.background = 0;
    values.tile       = XtGrayPixmap(XtScreen((Widget)bmw));
    values.fill_style = FillTiled;

    values.font = font->fid;
    bmw->sbitmap.gray_GC = XtGetGC((Widget)bmw, 
       (unsigned)GCForeground|GCBackground|GCTile|GCFillStyle|GCFont,
       &values);
}
#endif KANJI

static void GetinvertGC(bmw)
    SBitmapWidget bmw;
{
    XGCValues	values;

    values.function	= GXinvert;;

    bmw->sbitmap.invert_GC =
	XtGetGC((Widget)bmw, (unsigned) GCFunction, &values);
}

/********************************************************
*							*
*	Read bitmap file				*
*							*
********************************************************/

static int _ReadBitmapFile(flag, bmw, file, width, height, bitmap_data)
int flag;
SBitmapWidget bmw;
char *file;
int *width, *height;
Pixmap *bitmap_data;
{
    char file_name[128];
    int x_hot, y_hot, status;

    if (file == NULL) {
	*bitmap_data = (Pixmap)UnspecifiedPixmap;
	*width = 0;
	*height = 0;
	return(BitmapFileInvalid);
    }

    strcpy(file_name, bmw->sbitmap.bitmap_path);
    strcat(file_name, "/");
    strcat(file_name, file);
    if (!flag) {
	status = XtSCreatePixmap(XtDisplay(bmw),
		RootWindowOfScreen(XtScreen(bmw)), file_name,
		1, 0, 1, width, height, bitmap_data, &x_hot, &y_hot);
    } else
	status = XtSCreatePixmap(XtDisplay(bmw),
		RootWindowOfScreen(XtScreen(bmw)), file_name,
		bmw->sbitmap.foreground, bmw->core.background_pixel,
		DefaultDepthOfScreen(XtScreen(bmw)),
	    	width, height, bitmap_data, &x_hot, &y_hot);

    if (status != BitmapSuccess) {
	*bitmap_data = (Pixmap)UnspecifiedPixmap;
	*width = 0;
	*height = 0;
    }
    return(status);
}

static ReadBitmapFiles(bmw)
SBitmapWidget bmw;
{
    int width[6], height[6];
    int i;

    if (bmw->sbitmap.bitmap_path ==  NULL) {
		bmw->sbitmap.bitmap_data = (Pixmap)UnspecifiedPixmap;
		bmw->sbitmap.bitmap_width = 0;
		bmw->sbitmap.bitmap_height = 0;
		return;
    };

    _ReadBitmapFile(0, bmw, bmw->sbitmap.bitmap_file,
	&width[0], &height[0], &bmw->sbitmap.bitmap_data);
    _ReadBitmapFile(0, bmw, bmw->sbitmap.highlight_bitmap_file,
	&width[1], &height[1], &bmw->sbitmap.highlight_bitmap_data);
    _ReadBitmapFile(0, bmw, bmw->sbitmap.selected_bitmap_file,
	&width[2], &height[2], &bmw->sbitmap.selected_bitmap_data);
    _ReadBitmapFile(0, bmw, bmw->sbitmap.selhigh_bitmap_file,
	&width[3], &height[3], &bmw->sbitmap.selhigh_bitmap_data);
    _ReadBitmapFile(0, bmw, bmw->sbitmap.insensitive_bitmap_file,
	&width[4], &height[4], &bmw->sbitmap.insensitive_bitmap_data);
    _ReadBitmapFile(1, bmw, bmw->sbitmap.background_file,
	&width[5], &height[5], &bmw->core.background_pixmap);

    bmw->sbitmap.bitmap_width = 0;
    bmw->sbitmap.bitmap_height = 0;
    for (i = 0; i < 5; i++) {
	bmw->sbitmap.bitmap_width =
		Max(bmw->sbitmap.bitmap_width, width[i]);
	bmw->sbitmap.bitmap_height =
		Max(bmw->sbitmap.bitmap_height, height[i]);
    }
}

/********************************************************
*							*
*	Save label					*
*							*
********************************************************/

static char *SaveLabel(label)
char *label;
{
    int len;
    char *p = (char *)NULL;

    if (label) {
	len = strlen(label) + 1;
	p = (char *)malloc(len);
	if (p == NULL) fprintf(stderr, "cant alloc memory\n");
	strcpy(p, label);
    }
    return(p);
}

/********************************************************
*							*
*	Redisplay Bitmap				*
*							*
********************************************************/

static void RedisplayBitmap(bmw, bitmap_data, gc)
SBitmapWidget bmw;
Pixmap bitmap_data;
GC gc;
{
	/*
	 *	Bitmap
	 */
	if (bitmap_data != (Pixmap)UnspecifiedPixmap) {
	    XCopyPlane(XtDisplay(bmw), bitmap_data,
		XtWindow(bmw), gc, 0, 0,
		bmw->sbitmap.bitmap_width, bmw->sbitmap.bitmap_height,
		bmw->sbitmap.bitmap_x, bmw->sbitmap.bitmap_y, 1);
	}
}

/********************************************************
*							*
*	Redisplay label					*
*							*
********************************************************/

#ifdef KANJI
static void RedisplayLabel(bmw, gc, kgc, font, kfont, label, text)
SBitmapWidget bmw;
GC gc, kgc;
XFontStruct *font;
XFontStruct *kfont;
char *label;
XtTextExtent *text;
{
    unsigned char *p = (unsigned char *)label;
    unsigned char *q;
    unsigned short kanji;
    int offset;
    unsigned char *buf;
    Boolean kanji_flag = FALSE;
    int count = 0;

    if (p == NULL) return;

    XSetFont(XtDisplay(bmw), gc, font->fid);
    XSetFont(XtDisplay(bmw), kgc, kfont->fid);

    offset = 0;
    q = buf = (unsigned char *)malloc(strlen(label) + 1);

    while (*p) {
	if (kanji_flag) {
	    if (iskanji(*p)) {
		kanji = sft2jis((*p << 8) + *(p+1));
		p += 2;
		*q++ = kanji >> 8;
		*q++ = kanji & 0xff;
		count++;
	    } else {
		if (count) {
		    if (bmw->sbitmap.transp)
			XDrawString16(XtDisplay(bmw),
				XtWindow(bmw), kgc, text->x + offset,
				text->y, buf, count);
		    else
			XDrawImageString16(XtDisplay(bmw),
				XtWindow(bmw), kgc, text->x + offset,
				text->y, buf, count);
		    offset += XTextWidth16(kfont, buf, count);
		}
		kanji_flag = FALSE;
		count = 0;
		q = buf;
	    }
	} else {
	    if (iskanji(*p)) {
		if (count) {
		    if (bmw->sbitmap.transp)
			XDrawString(XtDisplay(bmw), XtWindow(bmw),
			    gc, text->x + offset, text->y, buf, count);
		    else
			XDrawImageString(XtDisplay(bmw), XtWindow(bmw),
			    gc, text->x + offset, text->y, buf, count);
		    offset += XTextWidth(font, buf, count);
		}
		kanji_flag = TRUE;
		count = 0;
		q = buf;
	    } else {
		*q++ = *p++;
		count++;
	    }
	}
    }
    if (count) {
	if (kanji_flag) {
	    if (bmw->sbitmap.transp)
		XDrawString16(XtDisplay(bmw), XtWindow(bmw), kgc,
			text->x + offset, text->y, buf, count);
	    else
		XDrawImageString16(XtDisplay(bmw), XtWindow(bmw), kgc,
			text->x + offset, text->y, buf, count);
	} else {
	    if (bmw->sbitmap.transp)
		XDrawString(XtDisplay(bmw), XtWindow(bmw), gc,
			text->x + offset, text->y, buf, count);
	    else
		XDrawImageString(XtDisplay(bmw), XtWindow(bmw), gc,
			text->x + offset, text->y, buf, count);
	}
    }
    free(buf);
}
#endif KANJI

static void RedisplayLabels(bmw, gc, kgc)
SBitmapWidget bmw;
GC gc, kgc;
{
#ifdef KANJI
    RedisplayLabel(bmw, gc, kgc,
	bmw->sbitmap.left_font,
	bmw->sbitmap.left_kanji_font,
	bmw->sbitmap.left_label,
	bmw->sbitmap.left_text);
    RedisplayLabel(bmw, gc, kgc,
	bmw->sbitmap.font,
	bmw->sbitmap.kanji_font,
	bmw->sbitmap.label,
	bmw->sbitmap.text);
    RedisplayLabel(bmw, gc, kgc,
	bmw->sbitmap.right_font,
	bmw->sbitmap.right_kanji_font,
	bmw->sbitmap.right_label,
	bmw->sbitmap.right_text);
#else KANJI
    if (bmw->sbitmap.transp) {
	if (bmw->sbitmap.left_label)
	    XDrawString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.left_text->x, bmw->sbitmap.left_text->y,
		bmw->sbitmap.left_label, strlen(bmw->sbitmap.left_label));
	if (bmw->sbitmap.label)
	    XDrawString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.text->x, bmw->sbitmap.text->y,
		bmw->sbitmap.label, strlen(bmw->sbitmap.label));
	if (bmw->sbitmap.right_label)
	    XDrawString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.right_text->x, bmw->sbitmap.right_text->y,
		bmw->sbitmap.right_label, strlen(bmw->sbitmap.right_label));
    } else {
	if (bmw->sbitmap.left_label)
	    XDrawImageString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.left_text->x, bmw->sbitmap.left_text->y,
		bmw->sbitmap.left_label, strlen(bmw->sbitmap.left_label));
	if (bmw->sbitmap.label)
	    XDrawImageString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.text->x, bmw->sbitmap.text->y,
		bmw->sbitmap.label, strlen(bmw->sbitmap.label));
	if (bmw->sbitmap.right_label)
	    XDrawImageString(XtDisplay(bmw), XtWindow(bmw), gc,
		bmw->sbitmap.right_text->x, bmw->sbitmap.right_text->y,
		bmw->sbitmap.right_label, strlen(bmw->sbitmap.right_label));
    }
#endif KANJI
}

/********************************************************
*							*
*	convert shift jis to jis			*
*							*
********************************************************/

static unsigned short sft2jis(sft)
unsigned short sft;
{
	int     high, low;

	if((high = sft >> 8) > 0x9f) high -= 0x40;
	high = (high - 0x81) << 1;
	if((low = sft & 0xff) > 0x7e) low--;
	if(low > 0x9d) {
		high++;
		low -= 0x5e;
	}
	return((high << 8) + low + 0x20E1);
}

static void JustWidth(bmw)
SBitmapWidget bmw;
{
	bmw->core.width = 0;
	if (bmw->sbitmap.left_text->width)
	    bmw->core.width += bmw->sbitmap.left_text->width +
					bmw->sbitmap.internal_width;
	if (bmw->sbitmap.text->width)
	    bmw->core.width += bmw->sbitmap.text->width +
					bmw->sbitmap.internal_width;
	if (bmw->sbitmap.right_text->width)
	    bmw->core.width += bmw->sbitmap.right_text->width +
					bmw->sbitmap.internal_width;
	if (bmw->sbitmap.orientation == XtorientHorizontal) {
	    if (bmw->sbitmap.bitmap_width) {
		bmw->core.width += bmw->sbitmap.bitmap_width +
					bmw->sbitmap.internal_width;
	    }
	} else {
	    bmw->core.width =
		Max(bmw->core.width, bmw->sbitmap.bitmap_width);
	}
	if (bmw->core.width == 0)
	    bmw->core.width = bmw->sbitmap.internal_width;
	bmw->core.width += bmw->sbitmap.internal_width;
	bmw->core.width = Max(bmw->core.width, 1);
}

static void JustHeight(bmw)
SBitmapWidget bmw;
{
	if (bmw->sbitmap.orientation == XtorientHorizontal) {
	    bmw->core.height =
		Max(Max(bmw->sbitmap.bitmap_height,
			bmw->sbitmap.text->height),
		    Max(bmw->sbitmap.left_text->height,
			bmw->sbitmap.right_text->height)) +
		2 * bmw->sbitmap.internal_height;
	    bmw->core.height = Max(bmw->core.height, 1);
	} else {	/* XtorientVertical */
	    bmw->core.height = 0;
	    if (bmw->sbitmap.bitmap_height)
		bmw->core.height += bmw->sbitmap.bitmap_height +
				    bmw->sbitmap.internal_height;
	    bmw->core.height +=
		Max(Max(bmw->sbitmap.text->height,
			bmw->sbitmap.left_text->height),
		    bmw->sbitmap.right_text->height) +
		bmw->sbitmap.internal_height;
	    if (bmw->core.height == 0)
		bmw->core.height = bmw->sbitmap.internal_height;
	    bmw->core.height += bmw->sbitmap.internal_height;
	    bmw->core.height = Max(bmw->core.height, 1);
	}
}
