#ifndef lint
static char rcsid[] = "$Header: SKanjiText.c,v 1.1 88/08/20 09:06:28 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SKanjiText.c,v $
 * Revision 1.1  88/08/20  09:06:28  michael
 * Initial revision
 * 
 */

/***********************************************************
 *                                                         *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 *    Original: AsciiText.c by DEC, M.I.T.                 *
 *    Modified: KanjiSink support is added by Sony Corp.   *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#include <X11/copyright.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/SKanjiTextP.h>

/* from SText.c */

extern void SForceBuildLineTable(); /* in SText.c */

static XtResource string_resources[] = {
  {XtNstring, XtCString, XtRString, sizeof(String),
     XtOffset(SKanjiStringWidget, kanji_string.string), XtRString, NULL},
#ifdef KANJI
  {XtNkanji, XtCKanji, XtRBoolean, sizeof(Boolean),
     XtOffset(SKanjiStringWidget, kanji_string.kanji), XtRString, "TRUE"}
#endif KANJI
};

static XtResource disk_resources[] = {
  {XtNfile, XtCFile, XtRString, sizeof(String),
     XtOffset(SKanjiDiskWidget, kanji_disk.file_name), XtRString, NULL},
#ifdef KANJI
  {XtNkanji, XtCKanji, XtRBoolean, sizeof(Boolean),
     XtOffset(SKanjiDiskWidget, kanji_disk.kanji), XtRString, "TRUE"}
#endif KANJI
};

static void StringClassInitialize(), StringInitialize(),
    StringCreateSourceSink(), StringDestroy();
static Boolean StringSetValues();

static void DiskClassInitialize(), DiskInitialize(),
    DiskCreateSourceSink(), DiskDestroy();
static Boolean DiskSetValues();

SKanjiStringClassRec sKanjiStringClassRec = {
  { /* core fields */
    /* superclass       */      (WidgetClass) &sTextClassRec,
    /* class_name       */      "SText",
    /* widget_size      */      sizeof(SKanjiStringRec),
    /* class_initialize */      StringClassInitialize,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      StringInitialize,
    /* initialize_hook  */	StringCreateSourceSink,
    /* realize          */      XtInheritRealize,
    /* actions          */      sTextActionsTable,
    /* num_actions      */      0,
    /* resources        */      string_resources,
    /* num_ resource    */      XtNumber(string_resources),
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      FALSE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      StringDestroy,
    /* resize           */      XtInheritResize,
    /* expose           */      XtInheritExpose,
    /* set_values       */      StringSetValues,
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      XtInheritTranslations
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* kanji_string fields */
    /* empty            */      0
  }
};

SKanjiDiskClassRec sKanjiDiskClassRec = {
  { /* core fields */
    /* superclass       */      (WidgetClass) &sTextClassRec,
    /* class_name       */      "SText",
    /* widget_size      */      sizeof(SKanjiDiskRec),
    /* class_initialize */      DiskClassInitialize,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      DiskInitialize,
    /* initialize_hook  */	DiskCreateSourceSink,
    /* realize          */      XtInheritRealize,
    /* actions          */      sTextActionsTable,
    /* num_actions      */      0,
    /* resources        */      disk_resources,
    /* num_ resource    */      XtNumber(disk_resources),
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      FALSE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      DiskDestroy,
    /* resize           */      XtInheritResize,
    /* expose           */      XtInheritExpose,
    /* set_values       */      DiskSetValues,
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      XtInheritTranslations
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* kanji_disk fields */
    /* empty            */      0
  }
};


WidgetClass sKanjiStringWidgetClass = (WidgetClass)&sKanjiStringClassRec;
WidgetClass sKanjiDiskWidgetClass = (WidgetClass)&sKanjiDiskClassRec;


static void StringClassInitialize()
{
    sKanjiStringClassRec.core_class.num_actions = sTextActionsTableCount;
}


/* ARGSUSED */
static void StringInitialize(request, new)
    Widget request, new;
{
    /* superclass Initialize can't set the following,
     * as it didn't know the source or sink when it was called */
    if (request->core.height == DEFAULT_TEXT_HEIGHT)
	new->core.height = DEFAULT_TEXT_HEIGHT;
}

static void StringCreateSourceSink(widget, args, num_args)
    Widget widget;
    ArgList args;
    Cardinal *num_args;
{
    SKanjiStringWidget w = (SKanjiStringWidget)widget;

    w->text.source = XtSStringSourceCreate( w, args, *num_args );
#ifdef KANJI
    w->text.sink = w->kanji_string.kanji ? 
			XtSKanjiSinkCreate( w, args, *num_args ):
			XtSAsciiSinkCreate( w, args, *num_args );
#else KANJI
    w->text.sink = XtSAsciiSinkCreate( w, args, *num_args );
#endif KANJI


    if (w->core.height == DEFAULT_TEXT_HEIGHT)
        w->core.height = (2*yMargin) + 2 + (*w->text.sink->MaxHeight)(w, 1);

    w->text.lastPos = /* GETLASTPOS */
      (*w->text.source->Scan) ( w->text.source, 0, XtstAll,
			        XtsdRight, 1, TRUE );

    w->text.lastLine = 
      (*w->text.source->GetLinePos)(w->text.source, w->text.lastPos);

    SForceBuildLineTable( (STextWidget)w );
}


/* ARGSUSED */
static Boolean StringSetValues(current, request, new)
    Widget current, request, new;
{
    SKanjiStringWidget old = (SKanjiStringWidget)current;
    SKanjiStringWidget w = (SKanjiStringWidget)new;

    if (w->kanji_string.string != old->kanji_string.string)
        XtError( "SetValues on SKanjiStringWidget string not supported." );

    return False;
}


static void StringDestroy(w)
    Widget w;
{
    XtSStringSourceDestroy( ((SKanjiStringWidget)w)->text.source );
#ifdef KANJI
    if (((SKanjiStringWidget)w)->kanji_string.kanji)
	XtSKanjiSinkDestroy( ((SKanjiStringWidget)w)->text.sink );
    else
	XtSAsciiSinkDestroy( ((SKanjiStringWidget)w)->text.sink );
#else KANJI
    XtSAsciiSinkDestroy( ((SKanjiStringWidget)w)->text.sink );
#endif KANJI
}


static void DiskClassInitialize()
{
    sKanjiDiskClassRec.core_class.num_actions = sTextActionsTableCount;
}


/* ARGSUSED */
static void DiskInitialize(request, new)
    Widget request, new;
{
    /* superclass Initialize can't set the following,
     * as it didn't know the source or sink when it was called */
    if (request->core.height == DEFAULT_TEXT_HEIGHT)
	new->core.height = DEFAULT_TEXT_HEIGHT;
}

static void DiskCreateSourceSink(widget, args, num_args)
    Widget widget;
    ArgList args;
    Cardinal *num_args;
{
    SKanjiDiskWidget w = (SKanjiDiskWidget)widget;

    w->text.source = XtSDiskSourceCreate( w, args, *num_args );
#ifdef KANJI
    w->text.sink = w->kanji_disk.kanji ? 
			XtSKanjiSinkCreate( w, args, *num_args ):
			XtSAsciiSinkCreate( w, args, *num_args );
#else KANJI
    w->text.sink = XtSAsciiSinkCreate( w, args, *num_args );
#endif KANJI

    w->text.lastPos = /* GETLASTPOS */
      (*w->text.source->Scan) ( w->text.source, 0, XtstAll,
			        XtsdRight, 1, TRUE );

    w->text.lastLine = 
      (*w->text.source->GetLinePos)(w->text.source, w->text.lastPos);

    if (w->core.height == DEFAULT_TEXT_HEIGHT)
        w->core.height = (2*yMargin) + 2 + (*w->text.sink->MaxHeight)(w, 1);

    SForceBuildLineTable( (STextWidget)w );
}


/* ARGSUSED */
static Boolean DiskSetValues(current, request, new)
    Widget current, request, new;
{
    SKanjiDiskWidget old = (SKanjiDiskWidget)current;
    SKanjiDiskWidget w = (SKanjiDiskWidget)new;

    if (w->kanji_disk.file_name != old->kanji_disk.file_name)
        XtError( "SetValues on SKanjiDiskWidget file not supported." );

    return False;
}


static void DiskDestroy(w)
    Widget w;
{
    XtSDiskSourceDestroy( ((SKanjiDiskWidget)w)->text.source );
#ifdef KANJI
    if (((SKanjiDiskWidget)w)->kanji_disk.kanji)
	XtSKanjiSinkDestroy( ((SKanjiDiskWidget)w)->text.sink );
    else
	XtSAsciiSinkDestroy( ((SKanjiDiskWidget)w)->text.sink );
#else KANJI
    XtSAsciiSinkDestroy( ((SKanjiDiskWidget)w)->text.sink );
#endif KANJI
}
