/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SPDMenuP.h,v 1.1 88/08/20 09:06:52 michael Exp $ Sony Corporation
 *
 * $Log:	SPDMenuP.h,v $
 * Revision 1.1  88/08/20  09:06:52  michael
 * Initial revision
 * 
 */
/********************************************************
*							*
*	Private header for Sony PullDown Menu Widget	*
*							*
*	Written by M.Abe				*
*							*
********************************************************/

#ifndef _XtSPDMenuPrivate_h
#define _XtSPDMenuPrivate_h

#include "X11/SBitmapP.h"
#include "X11/SPDMenu.h"

/********************************************************
*							*
*	Class structure					*
*							*
********************************************************/

/* New fields for the SPDMenu widget class record */
typedef struct _SPDMenuClass 
  {
    int makes_compiler_happy;  /* not used */
  } SPDMenuClassPart;

/* Full class record declaration */
typedef struct _SPDMenuClassRec {
    CoreClassPart	core_class;
    SBitmapClassPart     sbitmap_class;
    SPDMenuClassPart     spdmenu_class;
} SPDMenuClassRec;

extern SPDMenuClassRec sPDMenuClassRec;

/********************************************************
*							*
*	Instance (widget) structure 			*
*							*
********************************************************/

/* New fields for the SPDMenu widget record */
typedef struct {
	/* resources */
	XtCallbackList	callbacks;
	XtMenuItemList	items;
	int		num_items;
	Widget		shell;
	Widget		menu;
	/* private state */

} SPDMenuPart;

/* Full widget declaration */
typedef struct _SPDMenuRec {
    CorePart         core;
    SBitmapPart      sbitmap;
    SPDMenuPart       spdmenu;
} SPDMenuRec;

#endif _XtSPDMenuPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
