#ifndef lint
static char rcsid[] = "$Header: SScroll.c,v 1.1 88/08/20 09:06:32 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SScroll.c,v $
 * Revision 1.1  88/08/20  09:06:32  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/****************************************************************
 *
 * The Source File for SScroll Widget by SONY
 *
 ****************************************************************/
/* SScroll.c */
/* created in 88/07/25 00:00:00 1988 Version 0.1 by SONY */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Misc.h>
#include <X11/Xresource.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/SStringDefs.h>
#include <X11/SBitmap.h>
#include <X11/SButton.h>
#include <X11/SScroll.h>
#include <X11/SScrollP.h>

static void ClassInitialize();
static void Initialize();
static void Resize();
static Boolean SetValues();
static XtGeometryResult Geometry();

static void Notify();
static void Release();
static void Repeat();

static void Btn_callback();
static void Thumb_callback();
static void Bar_callback();

static char defaultTranslations[] =
	"<Btn1Down>:		notify()			\n\
	<Btn1Up>:		release()";

static char scrollBtnTranslations[] =
	"<Btn1Down>:	 	set() notify() timeron()	\n\
	<Btn1Up>:	 	timeroff() unset()";

static char scrollThumbTranslations[] =
	"<Btn1Down>:		set() notify() timeron()	\n\
	<MouseMoved>:		notify()			\n\
	<Btn1Up>:		notify() timeroff() unset()";

static char scrollThumbshadeTranslations[] =
	"";

static char scrollBarTranslations[] =
	"<Btn1Down>:		set() notify() timeron()	\n\
	<MouseMoved>:		notify()			\n\
	<Btn1Up>:		timeroff() unset()";

static XtResource resources[] = {
  {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
     XtOffset(SScrollWidget, sscroll.callbacks), XtRCallback, NULL},
  {XtNscrollOrientation, XtCScrollOrientation, XtRScrollOrientation, sizeof(XtScrollOrientation),
     XtOffset(SScrollWidget, sscroll.orientation), XtRString, "2-dimension"},
  {XtNscrollPointMode, XtCScrollMode, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.point_mode), XtRString, "false"},
  {XtNscrollThumbFix, XtCScrollThumb, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.thumb_fix), XtRString, "false"},
  {XtNinactive, XtCInactive, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.inactive), XtRString, "false"},
  {XtNscrollButtonRaw, XtCScrollRaw, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.button_raw), XtRString, "false"},
  {XtNscrollBarRaw, XtCScrollRaw, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.bar_raw), XtRString, "false"},
  {XtNscrollThumbRaw, XtCScrollRaw, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.thumb_raw), XtRString, "false"},
  {XtNscrollBtnSide, XtCScrollBtnSide, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.button_side), XtRString, "false"},
  {XtNscrollHideResThm, XtCScrollHideResThm, XtRBoolean, sizeof(Boolean),
     XtOffset(SScrollWidget, sscroll.hide_resthumb), XtRString, "true"},
  {XtNintervalTime, XtCIntervalTime, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.interval_time), XtRString, "0"},
  {XtNscrollPositionH, XtCScrollPosition, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.position[0]), XtRString, "0"},
  {XtNscrollMinH, XtCScrollMin, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.min[0]), XtRString, "0"},
  {XtNscrollMaxH, XtCScrollMax, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.max[0]), XtRString, "0"},
  {XtNscrollShownH, XtCScrollShown, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.shown[0]), XtRString, "1"},
  {XtNscrollSmoothH, XtCScrollSmooth, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.smooth[0]), XtRString, "0"},
  {XtNscrollThumbLenH, XtCScrollThumbLen, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.thumb_len[0]), XtRString, "0"},
  {XtNscrollButtonLenH, XtCScrollButtonLen, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.button_len[0]), XtRString, "0"},
  {XtNscrollPositionV, XtCScrollPosition, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.position[1]), XtRString, "0"},
  {XtNscrollMinV, XtCScrollMin, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.min[1]), XtRString, "0"},
  {XtNscrollMaxV, XtCScrollMax, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.max[1]), XtRString, "0"},
  {XtNscrollShownV, XtCScrollShown, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.shown[1]), XtRString, "1"},
  {XtNscrollSmoothV, XtCScrollSmooth, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.smooth[1]), XtRString, "0"},
  {XtNscrollThumbLenV, XtCScrollThumbLen, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.thumb_len[1]), XtRString, "0"},
  {XtNscrollButtonLenV, XtCScrollButtonLen, XtRInt, sizeof(int),
     XtOffset(SScrollWidget, sscroll.button_len[1]), XtRString, "0"},
  {XtNhotSpot, XtCHotSpot, XtRHotSpot, sizeof(XtHotSpot),
     XtOffset(SScrollWidget, sscroll.hot_spot), XtRString, "middle"},
};


static XtActionsRec actionList[] = {
	{"notify",	Notify},
	{"release",	Release},
};

static SScrollClassRec sScrollClassRec = {
    {
/* core fields */
    /* superclass            */	(WidgetClass) &compositeClassRec,
    /* class_name            */	"SScroll",
    /* size                  */	sizeof(SScrollRec),
    /* class_initialize	     */	ClassInitialize,
    /* class_part_initialize */	NULL,
    /* class_inited          */	FALSE,
    /* initialize            */	Initialize,
    /* initialize_hook       */	NULL,
    /* realize               */	XtInheritRealize,
    /* actions               */	actionList,
    /* num_actions	     */	XtNumber(actionList),
    /* resources             */	resources,
    /* num_resources         */	XtNumber(resources),
    /* xrm_class             */	NULLQUARK,
    /* compress_motion       */	TRUE,
    /* compress_exposure     */	TRUE,
    /* compress_enterleave   */	TRUE,
    /* visible_interest      */	FALSE,
    /* destroy               */	NULL,
    /* resize                */	Resize,
    /* expose                */	NULL,
    /* set_values            */	SetValues,
    /* set_values_hook       */	NULL,
    /* set_values_almost     */	XtInheritSetValuesAlmost,
    /* get_values_hook       */	NULL,
    /* accept_focus          */	NULL,
    /* version               */	XtVersion,
    /* callback_private      */	NULL,
    /* tm_table              */	defaultTranslations,
    /* query_geometry        */	NULL,
    },
    {
/* composite fields */
    /* geometry_manager      */	Geometry,
    /* change_managed        */	NULL,
    /* insert_child          */	XtInheritInsertChild,
    /* delete_child          */	XtInheritDeleteChild,
    /* move_focus_to_next    */	NULL,
    /* move_focus_to_prev    */	NULL,
    },
    {
/* sscroll fields */
    /* dummy            */      NULL,
    }
};

WidgetClass sScrollWidgetClass = (WidgetClass)&sScrollClassRec;

/* private constants value */

#define BorderW	(w->core.border_width)	
#define Thm_BorderW	((W->sscroll.widget_thumb)->core.border_width)	
#define ThmS_BorderW	((W->sscroll.widget_thumbshade)->core.border_width)	

/* macros convenient for programming */

#define	fast			register
#define	W			((SScrollWidget)w)
#define	ScrOffset(field)	(XtOffset(SScrollWidget,sscroll.field))

#define	Frame_Mode(W)		(!W->sscroll.point_mode)
#define	Point_Mode(W)		(W->sscroll.point_mode)
#define	Thumb_Var(W)		(!W->sscroll.thumb_fix)
#define	Thumb_Fix(W)		(W->sscroll.thumb_fix)
#define	ActiveSW(W)		(!W->sscroll.inactive)
#define	InactiveSW(W)		(W->sscroll.inactive)
#define	EDGE_BUTTON(W)		(!W->sscroll.button_side)
#define	SIDE_BUTTON(W)		(W->sscroll.button_side)
#define	RESTHUMB(W)		(!W->sscroll.hide_resthumb)
#define	HIDE_RESTHUMB(W)	(W->sscroll.hide_resthumb)
#define	VERTICAL(W)		(W->sscroll.orientation == Xtscroll_Vertical)
#define	HORIZONTAL(W)		(W->sscroll.orientation == Xtscroll_Horizontal)

#define	Rate(x,from,to)		(((from) == 0) ? 0:((x)*(to))/(from))
#define	for_each_dir		for (i=VERTICAL(W)?1:0,j=HORIZONTAL(W)?1:2;i<j;i++)
#define	for_all_dir		for (i=0;i<2;i++)

#define	GetLog_Thumb_Var(W,X,i)	Rate(X,W->sscroll.bar_len[i], \
				W->sscroll.whole[i])
#define	GetLog_Thumb_Fix(W,X,i)	(Point_Mode(W) ? \
				Rate(X,W->sscroll.bar_len[i], \
				W->sscroll.whole[i]) : \
				Rate(X,W->sscroll.bar_len[i]- \
				W->sscroll.thumb_len[i]+1, \
				W->sscroll.whole[i]-W->sscroll.shown[i]+1))
#define	GetDim_Thumb_Var(W,X,i)	Rate(X,W->sscroll.whole[i], \
				W->sscroll.bar_len[i])
#define	GetDim_Thumb_Fix(W,X,i)	(Point_Mode(W) ? \
				Rate(X,W->sscroll.whole[i], \
				W->sscroll.bar_len[i]) : \
				Rate(X,W->sscroll.whole[i]- \
				W->sscroll.shown[i]+1, \
				W->sscroll.bar_len[i]- \
				W->sscroll.thumb_len[i]+1))

#define	done(address, type) \
	{ (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }
#define InRange(num, small, big) \
	((num < small) ? small : ((num > big) ? big : num))
#define ChRange(num, small, big) \
	((num < small) ? FALSE : ((num > big) ? FALSE : TRUE))
#define	MinusToZero(X) \
	{ if ((X) < 0) (X) = 0; }
#define IfZeroToOne(X)		((X) ? X : 1)
#define IfZeroToThis(X,x)	((X) ? X : x)

#define	setarg(a,n,v) \
	{ (a)->name = (n); (a++)->value = (XtArgVal)(v); }

/* callback list for each child widget */

static XtCallbackRec scrollBtn_callbackList[] =
	{ {Btn_callback, NULL}, {NULL, NULL} };
static XtCallbackRec scrollBar_callbackList[] =
	{ {Bar_callback, NULL}, {NULL, NULL} };
static XtCallbackRec scrollThumb_callbackList[] =
	{ {Thumb_callback, NULL}, {NULL, NULL} };

extern void LowerCase();

/* HotSpot enumeration constants */

static	XrmQuark  XtQEtop;
static	XrmQuark  XtQEmiddle;
static	XrmQuark  XtQElast;

/* ARGSUSED */
static void
CvtStringToHotSpot(args, num_args, fromVal, toVal)
XrmValuePtr *args;		/* unused */
Cardinal	*num_args;	/* unused */
XrmValuePtr	fromVal;
XrmValuePtr	toVal;
{
    static XtHotSpot hotSpot;
    fast XrmQuark	q;
    char	lowerName[1000];

    LowerCase((char *) fromVal->addr, lowerName);
    q = XrmStringToQuark(lowerName);
    if (q == XtQEtop)
    	hotSpot = XthotSpotTop;
    else if (q == XtQEmiddle)
    	hotSpot = XthotSpotMiddle;
    else if (q == XtQElast)
    	hotSpot = XthotSpotLast;
    else
    	hotSpot = XthotSpotTop;
    done(&hotSpot, XtHotSpot);
};

/* ScrollOrientation enumeration constants */

static	XrmQuark  XtQEs_2dim;
static	XrmQuark  XtQEs_horizontal;
static	XrmQuark  XtQEs_vertical;

/* ARGSUSED */
static void
CvtStringToScrollOrientation(args, num_args, fromVal, toVal)
XrmValuePtr *args;		/* unused */
Cardinal	*num_args;	/* unused */
XrmValuePtr	fromVal;
XrmValuePtr	toVal;
{
    static XtScrollOrientation orientation;
    fast XrmQuark	q;
    char	lowerName[1000];

    LowerCase((char *) fromVal->addr, lowerName);
    q = XrmStringToQuark(lowerName);
    if (q == XtQEs_2dim)
    	orientation = Xtscroll_2dimension;
    else if (q == XtQEs_horizontal)
    	orientation = Xtscroll_Horizontal;
    else if (q == XtQEs_vertical)
    	orientation = Xtscroll_Vertical;
    else
    	orientation = Xtscroll_2dimension;
    done(&orientation, XtScrollOrientation);
}

static void
recalculate_pos(w)
fast Widget w;
{
    fast Position max;
    int i;

    for_all_dir {
/**/
    W->sscroll.whole[i] = W->sscroll.max[i] - W->sscroll.min[i];
    if (W->sscroll.whole[i] < 0) {
	W->sscroll.max[i] = W->sscroll.min[i];
	W->sscroll.whole[i] = 0;
    }

    if (!W->sscroll.shown[i] && Thumb_Var(W))
	W->sscroll.shown[i] = W->sscroll.whole[i] + 1;
    W->sscroll.shown[i] = Min(W->sscroll.shown[i], W->sscroll.whole[i] + 1);

    W->sscroll.offset[i] = W->sscroll.position[i] - W->sscroll.min[i];
    max = Frame_Mode(W) ? W->sscroll.whole[i] - W->sscroll.shown[i] :
	W->sscroll.whole[i];
    W->sscroll.offset[i] = InRange(W->sscroll.offset[i], 0,max);
    W->sscroll.position[i] = W->sscroll.min[i] + W->sscroll.offset[i];
/**/
    }
}

static void
recalculate_cloc(w,offset,i)
fast Widget w;
fast Log_Position offset;
int i;
{
    W->sscroll.cur_loc[i] = Thumb_Var(W) ?
	GetDim_Thumb_Var(W, offset,i) : GetDim_Thumb_Fix(W, offset,i);
    if Point_Mode(W)
	W->sscroll.cur_loc[i] -= (W->sscroll.hot_spot == XthotSpotMiddle) ?
		W->sscroll.thumb_len[i]/2 - 1 :
		(W->sscroll.hot_spot == XthotSpotLast) ?
		W->sscroll.thumb_len[i] - 1 : 0;
    else if (offset == 0)
	W->sscroll.cur_loc[i] = 0;
    else if (offset >= W->sscroll.whole[i] - W->sscroll.shown[i]) {
	W->sscroll.cur_loc[i] = W->sscroll.bar_len[i] -
	    W->sscroll.thumb_len[i] + 1;
	MinusToZero(W->sscroll.cur_loc[i]);
    }
}

static void
recalculate_loc(w)
fast Widget w;
{
    fast Dimension len;
    int i;

    for_all_dir {
/**/
    len = i ? w->core.height : w->core.width;
    MinusToZero((int)W->sscroll.button_len[i]);
/* calculate bar length */
    if EDGE_BUTTON(W) {
	W->sscroll.bar_len[i] = len - 1;
	if (W->sscroll.button_len[i])
	    W->sscroll.bar_len[i] -= (W->sscroll.button_len[i] + BorderW)*2;
    }
    else {
	W->sscroll.bar_len[i] = len;
	if (W->sscroll.button_len[!i])
	    W->sscroll.bar_len[i] -= W->sscroll.button_len[!i] + BorderW;
	else
	    W->sscroll.bar_len[i] -= BorderW;
    }
    MinusToZero((int)W->sscroll.bar_len[i]);
/* calculate bar position */
    if EDGE_BUTTON(W) {
	W->sscroll.bar_pos[i] = W->sscroll.button_len[i];
	if (W->sscroll.button_len[i])
	    W->sscroll.bar_pos[i] += BorderW;
    }
    else
	W->sscroll.bar_pos[i] = 0;

    if Thumb_Var(W) {
	if (!W->sscroll.whole[i])
	    W->sscroll.thumb_len[i] = W->sscroll.bar_len[i] + 1;
	else
	    W->sscroll.thumb_len[i] =
		GetDim_Thumb_Var(W, W->sscroll.shown[i],i) + 1;
    }
    else if (i == 0 && W->sscroll.orientation == Xtscroll_Horizontal)
	W->sscroll.thumb_len[!i] = W->core.height;
    else if (i == 1 && W->sscroll.orientation == Xtscroll_Vertical)
	W->sscroll.thumb_len[!i] = W->core.width;
    W->sscroll.thumb_len[i] = Max(BorderW*2 + 1, W->sscroll.thumb_len[i]);

    recalculate_cloc(w,W->sscroll.offset[i],i);
/**/
    }
}

static void
movethumb(w)
fast Widget w;
{
    XtMoveWidget(W->sscroll.widget_thumb,
	W->sscroll.bar_pos[0] + W->sscroll.cur_loc[0],
	W->sscroll.bar_pos[1] + W->sscroll.cur_loc[1]);
}

static void
make_scroll_widgets(w)
fast Widget w;
{
    Arg args[32];
    fast Arg *a;
    int i,j;

    for_each_dir {
/**/
    a = args;
    if EDGE_BUTTON(W) {
    setarg(a,XtNx,i ?
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW) : -BorderW);
    setarg(a,XtNy,i ? -BorderW :
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW));
    setarg(a,XtNwidth, i ? W->sscroll.bar_len[!i] + 1 :
	IfZeroToOne(W->sscroll.button_len[i]));
    setarg(a,XtNheight, i ? IfZeroToOne(W->sscroll.button_len[i]) :
	W->sscroll.bar_len[!i] + 1);
    }
    else {
    setarg(a,XtNx,i ? W->sscroll.bar_len[!i] + 1 : -BorderW);
    setarg(a,XtNy,i ? -BorderW : W->sscroll.bar_len[!i] + 1);
    setarg(a,XtNwidth, i ? IfZeroToOne(W->sscroll.button_len[i]) :
	IfZeroToOne((W->sscroll.bar_len[i] + 1)/2));
    setarg(a,XtNheight, i ? IfZeroToOne((W->sscroll.bar_len[i] + 1)/2) :
	IfZeroToOne(W->sscroll.button_len[i]));
    }
    setarg(a,XtNborderWidth, BorderW);
    setarg(a,XtNtranslations,XtParseTranslationTable(scrollBtnTranslations));
    scrollBtn_callbackList[0].closure = (caddr_t)ScrollObj_Btn;
    if (i)
    (int)scrollBtn_callbackList[0].closure |= ScrollBtnOri;
    setarg(a,XtNcallback,scrollBtn_callbackList);
    if InactiveSW(W)
	setarg(a,XtNsensitive, 0);

    W->sscroll.widget_btn_minus[i] =
	XtCreateWidget(i? "scrollButtonMV" : "scrollButtonMH",
	    sButtonWidgetClass,w, (ArgList)args,a-args);
    if (W->sscroll.button_len[i])
	XtManageChild(W->sscroll.widget_btn_minus[i]);

    a = args;
    if EDGE_BUTTON(W) {
    setarg(a,XtNx, i ?
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW) :
	w->core.width - W->sscroll.button_len[i] - BorderW);
    setarg(a,XtNy, i ?
	w->core.height - W->sscroll.button_len[i] - BorderW :
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW));
    setarg(a,XtNwidth, i ? W->sscroll.bar_len[!i] + 1 :
	IfZeroToOne(W->sscroll.button_len[i]));
    setarg(a,XtNheight, i ? IfZeroToOne(W->sscroll.button_len[i]) :
	W->sscroll.bar_len[!i] + 1);
    }
    else {
    setarg(a,XtNx, i ?
	W->sscroll.bar_len[!i] + 1 : IfZeroToOne((W->sscroll.bar_len[i] + 1)/2));
    setarg(a,XtNy, i ?
	IfZeroToOne((W->sscroll.bar_len[i] + 1)/2) : W->sscroll.bar_len[!i] + 1);
    setarg(a,XtNwidth, i ? W->sscroll.button_len[i] :
	W->sscroll.bar_len[i] - IfZeroToOne((W->sscroll.bar_len[i] + 1)/2));
    setarg(a,XtNheight, i ?
	W->sscroll.bar_len[i] - IfZeroToOne((W->sscroll.bar_len[i] + 1)/2) :
	W->sscroll.button_len[i]);
    }
    setarg(a,XtNborderWidth, BorderW);
    setarg(a,XtNtranslations,XtParseTranslationTable(scrollBtnTranslations));
    scrollBtn_callbackList[0].closure = (caddr_t)(ScrollObj_Btn | ScrollBtnDir);
    if (i)
    (unsigned)scrollBtn_callbackList[0].closure |= ScrollBtnOri;
    setarg(a,XtNcallback,scrollBtn_callbackList);
    if InactiveSW(W)
	setarg(a,XtNsensitive, 0);

    W->sscroll.widget_btn_plus[i] =
	XtCreateWidget(i ? "scrollButtonPV" : "scrollButtonPH",
	    sButtonWidgetClass,w, (ArgList)args,a-args);
    if (W->sscroll.button_len[i])
	XtManageChild(W->sscroll.widget_btn_plus[i]);
/**/
    }

    a = args;
    setarg(a,XtNx,0);
    setarg(a,XtNy,0);
    setarg(a,XtNwidth,W->sscroll.thumb_len[0] - BorderW*2);
    setarg(a,XtNheight,W->sscroll.thumb_len[1] - BorderW*2);
/*
    setarg(a,XtNborderWidth, BorderW);
*/
    scrollThumb_callbackList[0].closure = (caddr_t)ScrollObj_Thumb;
    setarg(a,XtNcallback, scrollThumb_callbackList);
    setarg(a,XtNtranslations, XtParseTranslationTable(scrollThumbshadeTranslations));

    W->sscroll.widget_thumbshade =
	XtCreateWidget("scrollThumbShade",sButtonWidgetClass,w, (ArgList)args,a-args);

    a = args;
    setarg(a,XtNx, W->sscroll.bar_pos[0] + W->sscroll.cur_loc[0]);
    setarg(a,XtNy, W->sscroll.bar_pos[1] + W->sscroll.cur_loc[1]);
    setarg(a,XtNwidth,W->sscroll.thumb_len[0] - BorderW*2);
    setarg(a,XtNheight,W->sscroll.thumb_len[1] - BorderW*2);
/*
    setarg(a,XtNborderWidth, BorderW);
*/
    scrollThumb_callbackList[0].closure = (caddr_t)ScrollObj_Thumb;
    setarg(a,XtNcallback, scrollThumb_callbackList);
    setarg(a,XtNtranslations, XtParseTranslationTable(scrollThumbTranslations));

    W->sscroll.widget_thumb =
	XtCreateWidget("scrollThumb",sButtonWidgetClass,w, (ArgList)args,a-args);
    if ActiveSW(W)
	XtManageChild(W->sscroll.widget_thumb);

    a = args;
    setarg(a,XtNx, W->sscroll.bar_pos[0]);
    setarg(a,XtNy, W->sscroll.bar_pos[1]);
    setarg(a,XtNwidth, W->sscroll.bar_len[0] + 1);
    setarg(a,XtNheight, W->sscroll.bar_len[1] + 1);
    setarg(a,XtNborderWidth, 0);
    scrollBar_callbackList[0].closure = (caddr_t)ScrollObj_Bar;
    setarg(a,XtNcallback, scrollBar_callbackList);
    setarg(a,XtNtranslations, XtParseTranslationTable(scrollBarTranslations));
    if InactiveSW(W)
	setarg(a,XtNsensitive, 0);

    W->sscroll.widget_bar =
	XtCreateWidget("scrollBar",sButtonWidgetClass,w, (ArgList)args,a-args);
    if (W->sscroll.bar_len)
	XtManageChild(W->sscroll.widget_bar);
}

static void
modifythumb(w)
fast Widget w;
{
    fast Dimension width,height;

    width = W->sscroll.thumb_len[0] - Thm_BorderW*2;
    height = W->sscroll.thumb_len[1] - Thm_BorderW*2;
    if ActiveSW(W) {
	XtResizeWidget(W->sscroll.widget_thumb, width, height, Thm_BorderW);
	movethumb(w);
    }
    width = W->sscroll.thumb_len[0] - ThmS_BorderW*2;
    height = W->sscroll.thumb_len[1] - ThmS_BorderW*2;
    XtResizeWidget(W->sscroll.widget_thumbshade, width, height, ThmS_BorderW);
}

static void
Bar_callback(bw,closure,event)
Widget bw;
caddr_t closure;
fast XEvent *event;
{
    fast Widget w = bw->core.parent;
    SscrollEvent e;
    Position p;
    Position cur;
    Log_Position off[2];
    int i,j;
    unsigned o;

    e.scrollEv_obj = ScrollObj_Bar;

    for_each_dir {
/**/
    cur = W->sscroll.cur_loc[i];
    if (!event) {
	e.scrollEv_obj = W->sscroll.barevent;
	p = W->sscroll.barpossav[i];
    }
    else {
	p = i ? event->xmotion.y : event->xmotion.x;
	W->sscroll.barpossav[i] = p;
	if (event->type == ButtonPress) {
	    o = (int)e.scrollEv_obj;
	    if (p > cur + W->sscroll.thumb_len[i]/2)
		o |= i ? ScrollBarDir_V:ScrollBarDir_H;
	    e.scrollEv_obj = o;
	    W->sscroll.barevent = e.scrollEv_obj;
	}
	else
	    e.scrollEv_obj = W->sscroll.barevent;
    }

    off[i] = Thumb_Var(W) ? GetLog_Thumb_Var(W, p,i) : GetLog_Thumb_Fix(W, p,i);
    MinusToZero(off[i]);
/**/
    }

    if (W->sscroll.bar_raw) {
	e.scrollEv_type = ScrollEv_Notify;
	e.scrollEv_posH = W->sscroll.min[0] + off[0];
	e.scrollEv_posV = W->sscroll.min[1] + off[1];
	XtCallCallbacks(w,XtNcallback, &e);
	return;
    }
    e.scrollEv_type = ScrollEv_Scroll;

    for_each_dir {
/**/
    if Frame_Mode(W) {
	if Thumb_Var(W) {
	    off[i] -= W->sscroll.shown[i]/2;
	}
	else {
	    int j;
	    j = GetLog_Thumb_Fix(W, W->sscroll.thumb_len[i],i)/2;
	    MinusToZero(j);
	    off[i] -= j;
	}
	off[i] = InRange(off[i], 0, W->sscroll.whole[i] - W->sscroll.shown[i]);
    }
    else {
	off[i] = InRange(off[i], 0, W->sscroll.whole[i]);
    }
    W->sscroll.offset[i] = off[i];
    W->sscroll.position[i] = W->sscroll.min[i] + off[i];
    recalculate_cloc(w, W->sscroll.offset[i],i);
/**/
    }
    movethumb(w);
    e.scrollEv_posH = W->sscroll.position[0];
    e.scrollEv_posV = W->sscroll.position[1];
    XtCallCallbacks(w,XtNcallback, &e);
}

static void
Thumb_callback(bw,closure,event)
Widget bw;
caddr_t closure;
fast XEvent *event;
{
    SscrollEvent e;
    fast Widget w = bw->core.parent;
    fast Position p;
    fast Log_Position off;
    fast int min,max;
    int i,j;

    e.scrollEv_obj = (unsigned)closure;
    e.scrollEv_posH = e.scrollEv_posV = 0;
    if (!event && W->sscroll.thumb_raw)
	goto Thumb_raw;
    switch(event->type) {
	case ButtonPress:
	    if (W->sscroll.thumb_raw)
		goto Thumb_raw;
	    W->sscroll.status[0] |= SCR_THUMBPULL;
	    W->sscroll.status[1] |= SCR_THUMBPULL;
	    W->sscroll.off_pull[0] = event->xmotion.x;
	    W->sscroll.off_pull[1] = event->xmotion.y;
	    W->sscroll.cur_pull[0] = W->sscroll.cur_loc[0];
	    W->sscroll.cur_pull[1] = W->sscroll.cur_loc[1];
	    XtMoveWidget(W->sscroll.widget_thumbshade,
		W->sscroll.cur_loc[0] + W->sscroll.bar_pos[0],
		W->sscroll.cur_loc[1] + W->sscroll.bar_pos[1]);
	    XtManageChild(W->sscroll.widget_thumbshade);
	    if HIDE_RESTHUMB(W)
		XLowerWindow(XtDisplay(w),XtWindow(W->sscroll.widget_thumb));
	    return;
	case ButtonRelease:
	    if (!W->sscroll.status[0])
		return;
	    e.scrollEv_type = ScrollEv_Scroll;
	    for_each_dir {
/**/
	    if (W->sscroll.cur_pull[i])
		W->sscroll.cur_pull[i] += 1;
	    W->sscroll.cur_loc[i] = p = W->sscroll.cur_pull[i];
	    if Point_Mode(W) {
		if (W->sscroll.hot_spot == XthotSpotMiddle)
		    p += W->sscroll.thumb_len[i]/2;
		else if (W->sscroll.hot_spot == XthotSpotLast)
		    p += W->sscroll.thumb_len[i];
	    }
	    W->sscroll.status[i] &= ~SCR_THUMBPULL;
	    off = Thumb_Var(W) ?
		GetLog_Thumb_Var(W, p,i) :
		GetLog_Thumb_Fix(W, p,i);
	    max = Frame_Mode(W) ? W->sscroll.whole[i] - W->sscroll.shown[i] :
		W->sscroll.whole[i];
	    off = InRange(off,0,max);
	    MinusToZero(off);
	    W->sscroll.offset[i] = off;
	    if (W->sscroll.status[i] & SCR_THUMBPULLDE) {
		e.scrollEv_type |= i ? ScrollEv_DeadendV : ScrollEv_DeadendH;
		W->sscroll.status[i] &= ~SCR_THUMBPULLDE;
	    }
	    W->sscroll.position[i] = W->sscroll.min[i] + off;
	    recalculate_cloc(w, W->sscroll.offset[i],i);
/**/
	    }
	    movethumb(w);
	    XtUnmanageChild(W->sscroll.widget_thumbshade);
	    if HIDE_RESTHUMB(W)
		XRaiseWindow(XtDisplay(w),XtWindow(W->sscroll.widget_thumb));
	    e.scrollEv_posH = W->sscroll.position[0];
	    e.scrollEv_posV = W->sscroll.position[1];
	    XtCallCallbacks(w,XtNcallback, &e);
	    return;
	case MotionNotify:
	    if (!W->sscroll.status[0])
		break;

	    for_each_dir {
/**/
	    p = i ? event->xmotion.y : event->xmotion.x;
	    p += W->sscroll.cur_loc[i];
	    p -= (W->sscroll.off_pull[i] + BorderW);

	    if Frame_Mode(W) {
		min = 0;
		max = W->sscroll.bar_len[i] - W->sscroll.thumb_len[i] + 1;
	    }
	    else if (W->sscroll.hot_spot == XthotSpotMiddle) {
		min = -(W->sscroll.thumb_len[i]/2-1);
		max = W->sscroll.bar_len[i] - W->sscroll.thumb_len[i]/2 + 1;
	    }
	    else if (W->sscroll.hot_spot == XthotSpotLast) {
		min = -(W->sscroll.thumb_len[i]-1);
		max = W->sscroll.bar_len[i] - W->sscroll.thumb_len[i] + 1;
	    }
	    else  {
		min = 0;
		max = W->sscroll.bar_len[i];
	    }

	    if (ChRange(p, min, max))
		W->sscroll.status[i] &= ~SCR_THUMBPULLDE;
	    else
		W->sscroll.status[i] |= SCR_THUMBPULLDE;
	    p = InRange(p, min, max);

	    W->sscroll.cur_pull[i] = p;
/**/
	    }
	    XtMoveWidget(
		W->sscroll.widget_thumbshade,
		W->sscroll.bar_pos[0] + W->sscroll.cur_pull[0],
		W->sscroll.bar_pos[1] + W->sscroll.cur_pull[1]);
	    return;
	default:
	    return;
    }
Thumb_raw:
    e.scrollEv_type = ScrollEv_Notify;
    XtCallCallbacks(w,XtNcallback, &e);
}

static void
Btn_callback(bw,closure)
Widget bw;
caddr_t closure;
{
    SscrollEvent e;
    fast Widget w = bw->core.parent;
    fast Log_Position o,p;
    fast Log_Position max;
    int i;

    e.scrollEv_obj = (unsigned)closure;
    e.scrollEv_posH = e.scrollEv_posV = 0;
    if InactiveSW(W) {
	e.scrollEv_type = ScrollEv_Notify | ScrollEv_Inactive;
 	XtCallCallbacks(w,XtNcallback, &e);
	return;
    }

    if (W->sscroll.button_raw) {
	e.scrollEv_type = ScrollEv_Notify;
 	XtCallCallbacks(w,XtNcallback, &e);
	return;
    }
    e.scrollEv_type = ScrollEv_Scroll;
    i = ((int)closure & ScrollBtnOri) ? 1:0;
    o = p = W->sscroll.offset[i];
    max = Frame_Mode(W) ? W->sscroll.whole[i] - W->sscroll.shown[i] :
	W->sscroll.whole[i];
    if ((int)closure & ScrollBtnDir)
	p += W->sscroll.smooth[i];
    else
	p -= W->sscroll.smooth[i];
    p = InRange(p,0,max);

    recalculate_cloc(w,p,i);

    W->sscroll.offset[i] = p;
    W->sscroll.position[i] = W->sscroll.min[i] + p;
    e.scrollEv_posH = W->sscroll.position[0];
    e.scrollEv_posV = W->sscroll.position[1];
    if (o != p)
	movethumb(w);
    else
	e.scrollEv_type |= i ? ScrollEv_DeadendV : ScrollEv_DeadendH;
    XtCallCallbacks(w,XtNcallback, &e);
}

static void
ClassInitialize()
{
    XtQEtop	= XrmStringToQuark(XtEtop);
    XtQEmiddle	= XrmStringToQuark(XtEmiddle);
    XtQElast	= XrmStringToQuark(XtElast);
    XtAddConverter( XtRString, XtRHotSpot, CvtStringToHotSpot,
		    NULL, (Cardinal)0 );

    XtQEs_2dim		= XrmStringToQuark(XtEs_2dim);
    XtQEs_horizontal	= XrmStringToQuark(XtEs_horizontal);
    XtQEs_vertical	= XrmStringToQuark(XtEs_vertical);
    XtAddConverter( XtRString, XtRScrollOrientation, CvtStringToScrollOrientation,
		    NULL, (Cardinal)0 );
}

static void
Initialize( request, w , args, num_args )
Widget request;		/* what the client asked for */
fast Widget w;		/* what we're going to give him */
ArgList args;
Cardinal *num_args;
{
    if (!w->core.width)
	w->core.width = 16;
    if (!w->core.height)
	w->core.height = 16;

    if VERTICAL(W) {
	W->sscroll.min[0] = 0;
	W->sscroll.max[0] = 1;
	W->sscroll.shown[0] = 1;
	W->sscroll.position[0] = W->sscroll.offset[0] = 0;
	W->sscroll.button_len[0] = 0;
    }
    else if HORIZONTAL(W) {
	W->sscroll.min[1] = 0;
	W->sscroll.max[1] = 1;
	W->sscroll.shown[1] = 1;
	W->sscroll.position[1] = W->sscroll.offset[1] = 0;
	W->sscroll.button_len[1] = 0;
    }
	
    recalculate_pos(w);
    recalculate_loc(w);

    W->sscroll.interval_id = 0;
    W->sscroll.status[0] = W->sscroll.status[1] = SCR_IDLE;

    make_scroll_widgets(w);
    modifythumb(w);
}

static Boolean
SetValues( w, request, desired )
fast Widget w;		/* what I am */
Widget request;		/* what he wants me to be */
Widget desired;		/* what I will become */
{
    fast SScrollWidget dw = (SScrollWidget) desired;
    Boolean redraw = FALSE;
    int i,j;

    recalculate_pos(desired);
    recalculate_loc(desired);

    for_each_dir {
/**/
    if (W->sscroll.button_len[i] && !dw->sscroll.button_len[i]) {
	XtUnmanageChild(dw->sscroll.widget_btn_minus[i]);
	XtUnmanageChild(dw->sscroll.widget_btn_plus[i]);
    }
    else if (!W->sscroll.button_len[i] && dw->sscroll.button_len[i]) {
	XtManageChild(dw->sscroll.widget_btn_minus[i]);
	XtManageChild(dw->sscroll.widget_btn_plus[i]);
    }

    if (W->sscroll.bar_len[i] && !dw->sscroll.bar_len[i])
	XtUnmanageChild(dw->sscroll.widget_bar);
    else if (!W->sscroll.bar_len[i] && dw->sscroll.bar_len[i])
	XtManageChild(dw->sscroll.widget_bar);

    if (W->sscroll.button_len[i] != dw->sscroll.button_len[i])
	Resize(desired);
    else
	modifythumb(desired);
/**/
    }

    if (ActiveSW(W) != ActiveSW(dw)) {
	if (ActiveSW(dw)) {
	    for_each_dir {
		XtSetSensitive(dw->sscroll.widget_btn_minus[i], TRUE);
		XtSetSensitive(dw->sscroll.widget_btn_plus[i], TRUE);
	    }
	    XtSetSensitive(dw->sscroll.widget_bar, TRUE);
	    XtManageChild(dw->sscroll.widget_thumb);
	}
	else {
	    for_each_dir {
		XtSetSensitive(dw->sscroll.widget_btn_minus[i], FALSE);
		XtSetSensitive(dw->sscroll.widget_btn_plus[i], FALSE);
	    }
	    XtSetSensitive(dw->sscroll.widget_bar, FALSE);
	    XtUnmanageChild(dw->sscroll.widget_thumb);
	}
    }

    return redraw;
}

static void
Resize( w )
fast Widget w;
{
    fast Dimension width,height;
    fast Position x,y;
    int i,j;

    recalculate_loc(w);

    for_each_dir {
/**/
    if (W->sscroll.button_len[i]) {
    if EDGE_BUTTON(W) {
	width = i ?
	    W->sscroll.bar_len[!i] + 1 : W->sscroll.button_len[i];
	height = i ? 
	    W->sscroll.button_len[i] : W->sscroll.bar_len[!i] + 1;
    }
    else {
	width = i ? IfZeroToOne(W->sscroll.button_len[i]) :
	    IfZeroToOne((W->sscroll.bar_len[i] + 1)/2);
	height = i ? IfZeroToOne((W->sscroll.bar_len[i] + 1)/2) :
	    IfZeroToOne(W->sscroll.button_len[i]);
    }
    XtResizeWidget(W->sscroll.widget_btn_minus[i], width, height, BorderW);
    if SIDE_BUTTON(W) {
	width = i ? IfZeroToOne(W->sscroll.button_len[i]) :
	    W->sscroll.bar_len[i] - IfZeroToOne((W->sscroll.bar_len[i] + 1)/2);
	height = i ?
	    W->sscroll.bar_len[i] - IfZeroToOne((W->sscroll.bar_len[i] + 1)/2):
	    IfZeroToOne(W->sscroll.button_len[i]);
    }
    XtResizeWidget(W->sscroll.widget_btn_plus[i], width, height, BorderW);
    if EDGE_BUTTON(W) {
    x = i ? IfZeroToThis(W->sscroll.button_len[!i],-BorderW) : -BorderW;
    y = i ? -BorderW : IfZeroToThis(W->sscroll.button_len[!i],-BorderW);
    }
    else {
    x = i ? W->sscroll.bar_len[!i] + 1 : -BorderW;
    y = i ? -BorderW : W->sscroll.bar_len[!i] + 1;
    }
    XtMoveWidget(W->sscroll.widget_btn_minus[i],x,y);
    if EDGE_BUTTON(W) {
    x = i ?
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW) :
	w->core.width - W->sscroll.button_len[i] - BorderW;
    y = i ?
	w->core.height - W->sscroll.button_len[i] - BorderW :
	IfZeroToThis(W->sscroll.button_len[!i],-BorderW);
    }
    else {
    x = i ?
	W->sscroll.bar_len[!i] + 1 : IfZeroToOne((W->sscroll.bar_len[i] + 1)/2);
    y = i ?
	IfZeroToOne((W->sscroll.bar_len[i] + 1)/2) : W->sscroll.bar_len[!i] + 1;
    }
    XtMoveWidget(W->sscroll.widget_btn_plus[i],x,y);
    }

    if (W->sscroll.bar_len) {
    x = W->sscroll.bar_pos[0];
    y = W->sscroll.bar_pos[1];
    width =  W->sscroll.bar_len[0] + 1;
    height =  W->sscroll.bar_len[1] + 1;
    XtResizeWidget(W->sscroll.widget_bar, width, height, 0);
    XtMoveWidget(W->sscroll.widget_bar,x,y);
    }
/**/
    }
    modifythumb(w);
}

static XtGeometryResult
Geometry()
{
    return XtGeometryNo;
}

static void
Notify(w, event)
fast Widget w;
XEvent *event;
{
    SscrollEvent e;

    e.scrollEv_type = ScrollEv_Notify |
	(InactiveSW(W) ? ScrollEv_Inactive : 0);
    e.scrollEv_obj = ScrollObj_Scroll;
    e.scrollEv_posH = e.scrollEv_posV = 0;

    if (!W->sscroll.interval_id && W->sscroll.interval_time)
	W->sscroll.interval_id =
	    XtAddTimeOut(W->sscroll.interval_time, Repeat, w);
    XtCallCallbacks(w, XtNcallback, &e);
}

static void
Release(w, event)
fast Widget w;
XEvent *event;
{
    if (W->sscroll.interval_id && W->sscroll.interval_time) {
	XtRemoveTimeOut(W->sscroll.interval_id);
	W->sscroll.interval_id = 0;
    }
}

static void
Repeat(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    fast Widget w = (Widget)client_data;
    SscrollEvent e;

    e.scrollEv_type = ScrollEv_Notify |
	(InactiveSW(W) ? ScrollEv_Inactive : 0);
    e.scrollEv_obj = ScrollObj_Scroll;
    e.scrollEv_posH = e.scrollEv_posV = 0;
    XtCallCallbacks(w, XtNcallback, &e);
    W->sscroll.interval_id =
	XtAddTimeOut(W->sscroll.interval_time, Repeat, w);
}
