/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SScroll.h,v 1.1 88/08/20 09:06:55 michael Exp $ Sony Corporation
 *
 * $Log:	SScroll.h,v $
 * Revision 1.1  88/08/20  09:06:55  michael
 * Initial revision
 * 
 */

#ifndef _XtSScroll_h
#define _XtSScroll_h

/****************************************************************
 *
 * The Public Header File for SScroll Widget by SONY
 *
 ****************************************************************/

#ifndef	_XtHotSpot_e
#define	_XtHotSpot_e

typedef enum {XthotSpotTop, XthotSpotMiddle, XthotSpotLast} XtHotSpot;
#endif	_XtHotSpot_e

#ifndef _XtSScroll_P
#define	_XtSScroll_P

typedef	int		Log_Volume;
typedef	int		Log_Position;


/* scroll orientation */

typedef enum {Xtscroll_2dimension, Xtscroll_Horizontal,
	Xtscroll_Vertical } XtScrollOrientation;

/* callback event type mask */

#define	ScrollEv_Scroll	(1L<<0)
#define	ScrollEv_Notify	(1L<<1)

#define	ScrollEv_DeadendH	(1L<<8)
#define	ScrollEv_DeadendV	(1L<<9)
#define	ScrollEv_Inactive	(1L<<10)

/* callback event object */

#define ScrollObj_Scroll	(1L<<0)
#define ScrollObj_Btn		(1L<<1)
#define ScrollObj_Bar		(1L<<2)
#define ScrollObj_Thumb		(1L<<3)

#define	ScrollBarDir_H	(1L<<8)		/* 0:minus 1:plus */
#define	ScrollBarDir_V	(1L<<9)
#define	ScrollBtnOri	(1L<<10)	/* 0:horizontal 1:vertical */
#define	ScrollBtnDir	(1L<<11)	/* 0:minus 1:plus */

/* scroll event data structure */

typedef struct _SscrollEvent {
    unsigned long	scrollEv_type;		/* scroll event type */
    unsigned		scrollEv_obj;		/* scroll event object */
    Log_Position	scrollEv_posH;		/* scroll logical position */
    Log_Position	scrollEv_posV;		/* scroll logical position */
} SscrollEvent;

#endif	_XtSScroll_P

typedef struct _SScrollRec	 *SScrollWidget;
typedef struct _SScrollClassRec *SScrollWidgetClass;

extern WidgetClass sScrollWidgetClass;

#endif _XtSScroll_h
/* DON'T ADD STUFF AFTER THIS #endif */
