#ifndef lint
static char rcsid[] = "$Header: SWindow.c,v 1.1 88/08/20 09:06:38 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SWindow.c,v $
 * Revision 1.1  88/08/20  09:06:38  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/****************************************************************
 *								*
 *	<< SWindow.c - Window composite widget >>		*
 *								*
 *								*
 *					Sony Corporation	*
 *					Wed Aug 10 1988		*
 *								*
 ****************************************************************/

#include	<stdio.h>
#include	<ctype.h>
#include	<X11/Xlib.h>
#include	<X11/Xatom.h>
#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Shell.h>

#include	<X11/SStringDefs.h>
#include	<X11/SBitmap.h>
#include	<X11/SButton.h>
#include	<X11/SScreen.h>
#include	<X11/SScroll.h>
#include	<X11/SWindow.h>
#include	<X11/SWindowP.h>

static void		ClassInitialize();
static void		Initialize();
static void		Realize();
static void		Resize();
static void		Redisplay();
static void		Destroy();
static Boolean		SetValues();
static void		ChangeManaged();
static XtGeometryResult GeometryManager();
static void		CvtStringToType();

/* Callback routine */
static void		ResizeWindow();
static void		MoveWindow();
static void		OpenWindow();
static void		CloseWindow();

static void		RaiseWindow();
static void		ConfigureWindow();
static void		ChangeWindowAddr();
static Dimension	CalculateHeaderSize();
static void		Selclr();
static void		Chgprop();

void	XtSDeIconifyWindow();
void	XtSIconifyWindow();
int	XtSGetWindowStatus();

#define	SHADOW		2
#define	RESIZE_AREA	16

/*==============================================================
	Translation Table
================================================================*/
static char defaultTranslations[] =
	"<Btn1Down>:	resize()\n\
	 <MouseMoved>:	resize()\n\
	 <Btn1Up>:	resize() raise()\n\
	 <SelectionClear>: selclr()\n\
	 <PropertyNotify>: chgprop()";

static  char buttonTranslations[] =
	"<Btn1Down>:	set() notify()\n\
	 <MouseMoved>:	notify()\n\
	 <Btn1Up>:	unset() notify(always)";


/*==============================================================
	Window Resources
================================================================*/
static XtResource resources[] = {
    {XtNwindowType, XtCWindowType, XtRWindowType, sizeof(XtWindowType),
	 XtOffset(SWindowWidget, window.window_type), XtRString, "wStandard"},
    {XtNinactive, XtCInactive, XtRBoolean, sizeof(Boolean),
         XtOffset(SWindowWidget, window.inactive), XtRString, "off"},
    {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
         XtOffset(SWindowWidget, window.cursor), XtRString, "opendot"},
    {XtNraiseCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.raise_callback), XtRCallback,
	 (caddr_t)NULL},
    {XtNselclrCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.selclr_callback), XtRCallback,
	 (caddr_t)NULL},
    {XtNpropertyCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.prop_callback), XtRCallback,
	 (caddr_t)NULL},

    /* Resize box */
    {XtNresizeareaFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.resize_flag),XtRString, "on"},
    {XtNresizeHspace, XtCHSpace, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.hspace), XtRString, "12"},
    {XtNresizeVspace, XtCVSpace, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.vspace), XtRString, "12"},
    {XtNresizeCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.resize_callback), XtRCallback,
	 NULL},

    /* Close box */
    {XtNcloseboxFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.close_flag),XtRString, "on"},
    {XtNcloseCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.close_callback), XtRCallback,
	 (caddr_t)NULL},

    {XtNiconify, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.iconify),XtRString, "off"},
    {XtNiconFont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	 XtOffset(SWindowWidget, window.font),XtRString, "8x16kana"},
#ifdef KANJI
    {XtNiconKanjiFont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	 XtOffset(SWindowWidget, window.kanji_font),XtRString,
#ifdef sony_news
	 "16x16kanji"},
#else sony_news
	 "k14"},
#endif sony_news
#endif KANJI
    {XtNiconLabel,  XtCLabel, XtRString, sizeof(String),
	 XtOffset(SWindowWidget, window.icon_label), XtRString, NULL},
    {XtNiconBitmapPath, XtCBitmapPath, XtRString, sizeof(char *),
	 XtOffset(SWindowWidget ,window.bitmap_path), XtRString,
	 DefaultBitmapPath},
    {XtNiconBitmapFile, XtCBitmapFile, XtRString, sizeof(char *),
	 XtOffset(SWindowWidget ,window.icon_file), XtRString, (caddr_t)NULL},
    {XtNdeIconifyCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.deiconify_callback), XtRCallback,
	 (caddr_t)NULL},

    /* Title bar */
    {XtNtitlebarFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.title_flag),XtRString, "on"},
    {XtNmoveCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	 XtOffset(SWindowWidget, window.move_callback), XtRCallback, 
	 (caddr_t)NULL},

    /* Menu bar */
    {XtNmenuClass, XtCWidgetClass, XtRWidgetClass, sizeof(WidgetClass),
	 XtOffset(SWindowWidget, window.menu_class), XtRWidgetClass,
	 NULL},
    {XtNmenuArgs, XtCArgs, XtRArgs, sizeof(ArgList),
	 XtOffset(SWindowWidget, window.menu_args), XtRArgs, NULL},
    {XtNnumMenuArgs, XtCNumArgs, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.num_menu_args), XtRString, "0"},

    /* Scroll box */
    {XtNscrollboxFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.scroll_flag),XtRString, "off"},

    /* Screen */
    {XtNscreenWidth, XtCWidth, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.screen_width), XtRString, "140"},
    {XtNscreenHeight, XtCHeight, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.screen_height), XtRString, "140"},
    {XtNminScreenWidth, XtCWidth, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.min_screen_width), XtRString, "140"},
    {XtNminScreenHeight, XtCHeight, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.min_screen_height), XtRString, "140"},
    {XtNmaxScreenWidth, XtCWidth, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.max_screen_width), XtRString, "140"},
    {XtNmaxScreenHeight, XtCHeight, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.max_screen_height), XtRString, "140"},
    {XtNscreenClass, XtCWidgetClass, XtRWidgetClass, sizeof(WidgetClass),
	 XtOffset(SWindowWidget, window.screen_class), XtRWidgetClass,
	 NULL},
    {XtNscreenArgs, XtCArgs, XtRArgs, sizeof(ArgList),
	 XtOffset(SWindowWidget, window.screen_args), XtRArgs, NULL},
    {XtNnumScreenArgs, XtCNumArgs, XtRInt, sizeof(int),
	 XtOffset(SWindowWidget, window.num_screen_args), XtRString, "0"},

    /* Horizontal scroll bar */
    {XtNhscrollbarFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.hscroll_flag),XtRString, "on"},

    /* Vertical scroll bar */
    {XtNvscrollbarFlag, XtCBoxFlag, XtRBoolean,  sizeof(Boolean),
         XtOffset(SWindowWidget, window.vscroll_flag),XtRString, "on"},
};


/*==============================================================
	Action Table
================================================================*/
static XtActionsRec actionList[] = {
	{"raise",	RaiseWindow},
	{"resize",	ResizeWindow},
	{"selclr",	Selclr},
	{"chgprop",	Chgprop},
};

/*==============================================================
	Full class record constant
================================================================*/
SWindowClassRec sWindowClassRec = {
  /* core_class fields      */
  {
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "SWindow",
    /* widget_size        */    sizeof(SWindowRec),
    /* class_initialize   */    ClassInitialize,
    /* class_part_init	  */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook	  */	NULL,
    /* realize            */    Realize,
    /* actions            */    actionList,
    /* num_actions	  */	XtNumber(actionList),
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    Resize,
    /* expose             */    Redisplay,
    /* set_values         */    SetValues,
    /* set_values_hook	  */	NULL,
    /* set_values_almost  */	XtInheritSetValuesAlmost,
    /* get_values_hook	  */	NULL,
    /* accept_focus       */    NULL,
    /* version		  */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    defaultTranslations,
    /* query_geometry     */    NULL,
  },
  /* composite_class fields */
  {
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,	/* Inherit from superclass */
    /* delete_child	  */	XtInheritDeleteChild,	/* Inherit from superclass */
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },
  {
    /* mumble		  */	0	/* Make C compiler happy   */
  }
};
WidgetClass sWindowWidgetClass = (WidgetClass)&sWindowClassRec;


/*==============================================================
	Callback list
================================================================*/
static XtCallbackRec move_callbacks[] = {
	{ MoveWindow,	NULL },
	{ NULL,		NULL },
};

static XtCallbackRec close_callbacks[] = {
	{ CloseWindow,	NULL },
	{ NULL,		NULL },
};

static XtCallbackRec resize_callbacks[] = {
	{ ResizeWindow,	NULL },
	{ NULL,		NULL },
};

/*==============================================================
	Default Arguments
================================================================*/
/* Resize box */
#define	RmTransration	1

/* Close box */
static Arg close_box_arg[] = {
	{ XtNcallback,		  (XtArgVal)close_callbacks },
};

/* Title bar */
static Arg title_bar_arg[] = {
	{ XtNcallback,		  (XtArgVal)move_callbacks },
	{ XtNtranslations,	  (XtArgVal)NULL },
};

/* Scroll box */
static Arg scroll_box_arg[] = {
	{ XtNscrollOrientation,	(XtArgVal)Xtscroll_2dimension },
	{ XtNscrollBtnSide,	(XtArgVal)1 },
	{ XtNscrollHideResThm,	(XtArgVal)1 },
};

/* Vertical Scroll bar */
static Arg vscroll_bar_arg[] = {
	{ XtNscrollOrientation,	(XtArgVal)Xtscroll_Vertical },
};

/* Horizontal Scroll bar */
static Arg hscroll_bar_arg[] = {
	{ XtNscrollOrientation,	(XtArgVal)Xtscroll_Horizontal },
};

/* Icon */
#define	RmBitmapPath	2
#define	RmBitmapFile	3
#define	RmInactiveFile	4
#define	RmFont		5
#ifdef KANJI
#define	RmKanjiFont	6
#define	RmLabel		7
#else
#define	RmLabel		6
#endif KANJI

static Arg icon_arg[] = {
	{ XtNcallback,		  (XtArgVal)move_callbacks },
	{ XtNtranslations,	  (XtArgVal)NULL },
	{ XtNbitmapPath,	  (XtArgVal)NULL },
	{ XtNbitmapFile,	  (XtArgVal)NULL },
	{ XtNinsensitiveBitmapFile, (XtArgVal)NULL },
	{ XtNfont,		  (XtArgVal)NULL },
#ifdef KANJI
	{ XtNkanjiFont,		  (XtArgVal)NULL },
#endif KANJI
	{ XtNlabel,		  (XtArgVal)NULL },
	{ XtNorientation,	  (XtArgVal)XtorientVertical },
	{ XtNborderWidth,	  (XtArgVal)0 },
};

#define	max(a,b) ( (a) > (b) ? (a) : (b) )
#define	min(a,b) ( (a) > (b) ? (b) : (a) )

/************************************************************************
 *									*
 *	Private Routines						*
 *									*
 ************************************************************************/
static	XrmQuark	XrmQEwStandard;
static	XrmQuark	XrmQEwPlainBox;
static	XrmQuark	XrmQEwShadowBox;


/*==============================================================
	Inactive Window
================================================================*/
static void Inactive(w)
Widget	w;
{
    Cardinal	i;

    if (XtIsComposite(w)) {
	for (i = 0; i < ((CompositeWidget)w)->composite.num_children; i++)
	    Inactive(((CompositeWidget)w)->composite.children[i]);
    }
    XSelectInput(XtDisplay(w), XtWindow(w), ExposureMask);
}

/*==============================================================
	Active Window
================================================================*/
static void Active(w)
Widget	w;
{
    Cardinal	i;
    EventMask mask, _XtBuildEventMask();

    if (XtIsComposite(w)) {
	for (i = 0; i < ((CompositeWidget)w)->composite.num_children; i++)
	    Active(((CompositeWidget)w)->composite.children[i]);
    }
    mask = _XtBuildEventMask(w);
    XSelectInput(XtDisplay(w), XtWindow(w), mask);
}

/*==============================================================
	Draw Rectangle
================================================================*/
static void DrawRectangle(w, event)
SWindowWidget	w;
XEvent		*event;
{
    XPoint	box[5];

    box[0].x = box[3].x = box[4].x = 
	min(w->window.flame_x1, w->window.flame_x2);
    box[1].x = box[2].x =
	max(w->window.flame_x1, w->window.flame_x2);
    box[0].y = box[1].y = box[4].y =
	min(w->window.flame_y1, w->window.flame_y2);
    box[2].y = box[3].y =
	max(w->window.flame_y1, w->window.flame_y2);

    if (XtIsSubclass(w->core.parent, wmShellWidgetClass))
	XDrawLines(event->xmotion.display, event->xmotion.root,
		   w->window.frame_gc, box, 5, CoordModeOrigin);
    else
	XDrawLines(event->xmotion.display, XtWindow(w->core.parent),
		   w->window.frame_gc, box, 5, CoordModeOrigin);
}



/*==============================================================
	Class Initialize
================================================================*/
static void ClassInitialize()
{
    XrmQEwStandard  = XrmStringToQuark(XtEwStandard);
    XrmQEwPlainBox  = XrmStringToQuark(XtEwPlainbox);
    XrmQEwShadowBox = XrmStringToQuark(XtEwShadowbox);

    XtAddConverter(XtRString, XtRWindowType, CvtStringToType, NULL, 0);
}


static void CvtStringToType(args, num_args, fromVal, toVal)
XrmValuePtr	*args;
Cardinal	*num_args;
XrmValuePtr	fromVal;
XrmValuePtr	toVal;
{
    static XtWindowType	type;
    XrmQuark	q;
    char	*s = (char *)fromVal->addr;
    char	lowerName[1000];
    int		i;

    if (s == NULL) return;

    for (i = 0; i <= strlen(s); i++) {
	char c = s[i];
	lowerName[i] = isupper(c) ? (char) tolower(c) : c;
    }
    q = XrmStringToQuark(lowerName);

    toVal->size = sizeof(XtWindowType);
    toVal->addr = (caddr_t)&type;

    if (q == XrmQEwStandard )  { type = XtwStandard;  return; }
    if (q == XrmQEwPlainBox )  { type = XtwPlainBox;  return; }
    if (q == XrmQEwShadowBox ) { type = XtwShadowBox; return; }

    toVal->size = 0;
    toVal->addr = NULL;
}


static void Get_frameGC(w)
SWindowWidget	w;
{
    XGCValues	values;

    values.function   = GXxor;
    values.foreground = 0xfd;
    values.line_width = 0;
    values.subwindow_mode = IncludeInferiors;

    w->window.frame_gc
	= XtGetGC( w, (unsigned)( GCFunction
				| GCForeground
				| GCLineWidth
				| GCSubwindowMode), &values);
}


static void Get_resizeGC(w)
SWindowWidget	w;
{
    XGCValues	values;

    values.foreground = w->core.border_pixel;
    values.line_width = 0;
    values.subwindow_mode = IncludeInferiors;

    w->window.resize_gc
	= XtGetGC( w, (unsigned)( GCForeground
				| GCLineWidth
				| GCSubwindowMode), &values);
}


/*==============================================================
	Resize
================================================================*/
static void Resize(widget)
Widget	widget;
{
    SWindowWidget	w;
    Dimension	x = 0;
    Dimension	y = 0;
    Dimension	x1 = 0;
    Dimension	y1 = 0;
    Dimension	width = 0;
    Dimension	height = 0;
    Dimension	screenx = 0;
    Dimension	screeny = 0;
    Dimension	screenw, screenh;
    Boolean	hflag = 0;


    w = (SWindowWidget)widget;
    if (w->window.icon_flag) {
	return;
    }

    width  = screenw = w->core.width;
    height = screenh = w->core.height;

    if (w->window.window_type == XtwStandard)
    {
	CalculateHeaderSize(w);
	screenx += w->window.hspace;
	screeny += w->window.vspace;
	if (w->window.vscroll_bar)
	    screenw -= ((w->window.hspace) * 2
		      + w->window.vscroll_width
		      + w->window.vscroll_border);
	else
	    screenw -= w->window.hspace * 2;
	if (w->window.hscroll_bar)
	    screenh -= ((w->window.vspace) * 2
		      + w->window.hscroll_height
		      + w->window.hscroll_border);
	else
	    screenh -= w->window.hspace * 2;
	x = screenx;
	y = screeny;
	width  = screenw;
	height = screenh;

	/* Move close box */
	if (w->window.close_box) {
	    XtConfigureWidget(w->window.close_box, x, y,
				w->window.close_width,
				w->window.close_height,
				w->window.close_border/2);
	    width -= (w->window.close_border + w->window.close_width
			+ (w->window.hspace) / 2);
	    x += (w->window.close_border + w->window.close_width
			+ (w->window.hspace) / 2);
	    screeny = y + w->window.close_border + w->window.close_height;
	    screenh = height - (w->window.close_border + w->window.close_height);
	    hflag = 1;
	}

	/* move scroll box */
	if (w->window.scroll_flag && w->window.scroll_box) {
	    x1 = screenx + screenw - w->window.scroll_width - w->window.scroll_border;
	    XtConfigureWidget(w->window.scroll_box, (int)x1, y,
				w->window.scroll_width,
				w->window.scroll_height,
				w->window.scroll_border/2);
	    width -= (w->window.scroll_border + w->window.scroll_width
			+ (w->window.hspace) / 2);
	    screenh = height - (w->window.scroll_border + w->window.scroll_height);
	    screeny = y + w->window.scroll_border + w->window.scroll_height;
	    hflag = 1;
	}

	/* resize title bar */
	if (w->window.title_flag && w->window.title_bar) {
	    XtConfigureWidget(w->window.title_bar, x, y,
				width - w->window.title_border,
				w->window.title_height, 
				w->window.title_border/2);
	    if (XtIsRealized(w->window.title_bar))
    	    	XClearArea(XtDisplay(w->window.title_bar),
				XtWindow(w->window.title_bar),
				0, 0, width - w->window.title_border,
				w->window.title_height, TRUE );
	    height -= (w->window.title_border + w->window.title_height);
	    if (screenh > height)
		screenh = height;
	    y  += (w->window.title_border + w->window.title_height);
	    if (screeny < y)
	    	screeny = y;
	    hflag = 1;
	}

	/* resize menu bar */
	if (w->window.menu_bar) {
	    XtConfigureWidget(w->window.menu_bar, x, y,
			   width - w->window.menu_border,
			   w->window.menu_height, 
			   w->window.menu_border/2);
	    height -= (w->window.menu_border + w->window.menu_height);
	    if (screenh > height)
		screenh = height;
	    y += (w->window.menu_border + w->window.menu_height);
	    if (screeny < y)
	    	screeny = y;
	    hflag = 1;
	}

	/* move vertical scroll bar */
	if (w->window.vscroll_flag && w->window.vscroll_bar) {
	    x = w->core.width - w->window.vscroll_width
		- w->window.vscroll_border - (w->window.vspace) / 2;
	    if (hflag) {
		height = screenh - (w->window.vspace) / 2;
	    	y = screeny + (w->window.vspace) / 2;
	    }
	    XtConfigureWidget(w->window.vscroll_bar, x, y,
		           w->window.vscroll_width, height,
			   w->window.vscroll_border/2);
	}

	/* move horizontal scroll bar */
	if (w->window.hscroll_flag && w->window.hscroll_bar) {
	    y = w->core.height - w->window.hscroll_height
		- w->window.hscroll_border - (w->window.vspace) / 2;
	    XtConfigureWidget(w->window.hscroll_bar, screenx, y,
			      screenw - w->window.hscroll_border,
			      w->window.hscroll_height,
			      w->window.hscroll_border/2);
	}
    }

    /* resize screen */
    if (w->window.screen) {
	w->window.screen_width  = screenw - w->window.screen_border;
	w->window.screen_height = screenh - w->window.screen_border;
	if (hflag) {
	    w->window.screen_height -= (w->window.vspace) / 2;
	    screeny += (w->window.vspace) / 2;
	}
	if (w->window.window_type == XtwShadowBox) {
	    w->window.screen_width  -= SHADOW;
	    w->window.screen_height -= SHADOW;
	}
	XtConfigureWidget(w->window.screen, screenx, screeny,
			w->window.screen_width, w->window.screen_height,
			(w->window.screen)->core.border_width);
    }
    w->window.redisp = 1;
}


/*==============================================================
	Redisplay
================================================================*/
static void Redisplay(widget, event, region)
Widget	widget;
XEvent	*event;
Region	region;
{
    SWindowWidget w = (SWindowWidget)widget;

    if (!XtIsRealized(widget))
	return;
    if (!w->window.resize_flag)
	return;
    if (w->window.icon_flag)
	return;
    if (w->window.redisp)
    	XClearWindow(XtDisplay(w), XtWindow(w));

    XDrawLine(XtDisplay(w), XtWindow(w), w->window.resize_gc,
		  0, RESIZE_AREA, RESIZE_AREA, 0);
    XDrawLine(XtDisplay(w), XtWindow(w), w->window.resize_gc,
		w->core.width - RESIZE_AREA, 0, w->core.width, RESIZE_AREA);
    XDrawLine(XtDisplay(w), XtWindow(w), w->window.resize_gc,
		0, w->core.height - RESIZE_AREA, RESIZE_AREA, w->core.height);
    XDrawLine(XtDisplay(w), XtWindow(w), w->window.resize_gc,
		w->core.width, w->core.height - RESIZE_AREA, 
		w->core.width - RESIZE_AREA, w->core.height);
    w->window.redisp = 0;
}

static XtGeometryResult ResizeReq(w, width, height)
SWindowWidget	w;
Dimension	width;
Dimension	height;
{
    XtWidgetGeometry  reqGeo;
    XtGeometryResult  result = XtGeometryNo;

    reqGeo.request_mode = NULL;
    if (width != w->core.width) {
	reqGeo.request_mode |= CWWidth;
	reqGeo.width = width;
    }
    if (height != w->core.height) {
	reqGeo.request_mode |= CWHeight;
	reqGeo.height = height;
    }
    if (reqGeo.request_mode != NULL) {
	result = XtMakeGeometryRequest((Widget)w, &reqGeo, &reqGeo);
	if (result == XtGeometryAlmost)
	    result = XtMakeGeometryRequest((Widget)w, &reqGeo, NULL);
	if (result == XtGeometryYes) {
	    w->core.width  = width;
	    w->core.height = height;
        }
    }
    return(result);
}


static XtGeometryResult MoveReq(w, x, y)
SWindowWidget	w;
Position	x;
Position	y;
{
    XtWidgetGeometry  reqGeo;
    XtGeometryResult  result = XtGeometryYes;

    reqGeo.request_mode = NULL;
    if (x != w->core.x) {
	reqGeo.request_mode |= CWX;
	reqGeo.x = x;
    }
    if (y != w->core.y) {
	reqGeo.request_mode |= CWY;
	reqGeo.y = y;
    }
    if (reqGeo.request_mode != NULL) {
	result = XtMakeGeometryRequest((Widget)w, &reqGeo, &reqGeo);
	if (result == XtGeometryAlmost)
	    result = XtMakeGeometryRequest((Widget)w, &reqGeo, NULL);
	if (result == XtGeometryYes) {
	    w->core.x = x;
	    w->core.y = y;
        }
    }
    return(result);
}


static Dimension CalculateHeaderSize(w)
SWindowWidget	w;
{
    Dimension  maxh;

    if (w->window.close_box) {
	w->window.close_border = (w->window.close_box)->core.border_width * 2;
	w->window.close_width  = (w->window.close_box)->core.width;
	w->window.close_height = (w->window.close_box)->core.height;
     }else
	w->window.close_border = w->window.close_width = w->window.close_height = 0;
    if (w->window.title_bar) {
	w->window.title_border = (w->window.title_bar)->core.border_width * 2;
	w->window.title_height = (w->window.title_bar)->core.height;
    } else
	w->window.title_border = w->window.title_height = 0;
    if (w->window.menu_bar) {
	w->window.menu_border = (w->window.menu_bar)->core.border_width * 2;
	w->window.menu_height = (w->window.menu_bar)->core.height;
    } else
	w->window.menu_border = w->window.menu_height = 0;
    if (w->window.scroll_box) {
	w->window.scroll_border = (w->window.scroll_box)->core.border_width * 2;
	w->window.scroll_width  = (w->window.scroll_box)->core.width;
	w->window.scroll_height = (w->window.scroll_box)->core.height;
    } else
	w->window.scroll_border = w->window.scroll_width = w->window.scroll_height = 0;
    if (w->window.vscroll_bar) {
	w->window.vscroll_border = (w->window.vscroll_bar)->core.border_width * 2;
	w->window.vscroll_width  = (w->window.vscroll_bar)->core.width;
    } else
	w->window.vscroll_border = w->window.vscroll_width = 0;
    if (w->window.hscroll_bar) {
	w->window.hscroll_border = (w->window.hscroll_bar)->core.border_width * 2;
	w->window.hscroll_height = (w->window.hscroll_bar)->core.height;
    } else
	w->window.hscroll_border = w->window.hscroll_height = 0;
    if (w->window.screen)
	w->window.screen_border = (w->window.screen)->core.border_width * 2;
    else
	w->window.screen_border = 0;

    maxh = max(w->window.close_height + w->window.close_border,
	       w->window.scroll_height + w->window.scroll_border);
    if (maxh < (w->window.title_height + w->window.title_border +
		w->window.menu_height  + w->window.menu_border))
    {
	w->window.close_height
	    = w->window.title_height + w->window.title_border
	    + w->window.menu_height + w->window.menu_border
	    - w->window.close_border;
	w->window.scroll_height
	    = w->window.title_height + w->window.title_border
	    + w->window.menu_height + w->window.menu_border
	    - w->window.scroll_border;
	return(w->window.title_height + w->window.title_border +
	       w->window.menu_height  + w->window.menu_border);
    }
    return(maxh);
}


static void CalculateWindowSize(w, window_width, window_height)
SWindowWidget	w;
Dimension	*window_width;
Dimension	*window_height;
{
    Arg			arg[2];
    XtWidgetGeometry	reqGeo;
    Dimension	header;
    Dimension	hb = 0;
    Dimension	vb = 0;


    if (w->window.icon_flag) {
	*window_width  = (w->window.icon)->core.width;
	*window_height = (w->window.icon)->core.height;
	return;
    }

    header =CalculateHeaderSize(w);
    if (w->window.window_type == XtwStandard) {
	hb += (w->window.vscroll_bar) ?
		(w->window.hspace * 2) : (w->window.hspace + w->window.hspace);
	vb += (w->window.hscroll_bar) ?
		(w->window.vspace * 2) : (w->window.vspace + w->window.vspace);
	if ((w->window.close_box) ||
	    (w->window.title_bar) ||
	    (w->window.menu_bar)  ||
	    (w->window.scroll_box)) {
	    vb += (w->window.vspace) / 2;
	}
    } else if (w->window.window_type == XtwShadowBox) {
	hb += SHADOW;
	vb += SHADOW;
    }

    w->window.screen_width
	= ((w->window.screen_width >= w->window.min_screen_width) ?
	    w->window.screen_width : w->window.min_screen_width);
    *window_width = w->window.screen_width  + w->window.screen_border
		  + w->window.vscroll_width + w->window.vscroll_border
		  + hb;

    w->window.screen_height
	= ((w->window.screen_height >= w->window.min_screen_height) ?
	    w->window.screen_height : w->window.min_screen_height);
    *window_height = w->window.screen_height + w->window.screen_border
		   + w->window.hscroll_height+ w->window.hscroll_border
		   + header + vb;
}


static void CalculateMaxSize( w )
SWindowWidget	w;
{
    Dimension	header;
    Dimension	hb = 0;
    Dimension	vb = 0;


    header = CalculateHeaderSize(w);

    if (w->window.window_type == XtwStandard) {
	hb += (w->window.vscroll_bar) ?
		(w->window.hspace * 2) : (w->window.hspace + w->window.vspace);
	vb += (w->window.hscroll_bar) ?
		(w->window.vspace * 2) : (w->window.vspace + w->window.vspace);
	if ((w->window.close_box) ||
	    (w->window.title_bar) ||
	    (w->window.menu_bar)  ||
	    (w->window.scroll_box)) {
	    vb += (w->window.vspace) / 2;
	}
    } else if (w->window.window_type == XtwShadowBox) {
	hb += 4;
	vb += 4;
    }

    w->window.min_window_width 
	= w->window.min_screen_width + w->window.screen_border
	+ w->window.vscroll_width + w->window.vscroll_border
	+ hb;
    w->window.min_window_height
	= w->window.min_screen_height + w->window.screen_border
	+ w->window.hscroll_height+ w->window.hscroll_border
	+ header + vb;
    w->window.max_screen_width
	= ((w->window.max_screen_width >= w->window.screen_width) ?
	  w->window.max_screen_width : w->window.screen_width);
    w->window.max_screen_height
	= ((w->window.max_screen_height >= w->window.screen_height) ?
	  w->window.max_screen_height : w->window.screen_height);
    w->window.max_window_width
	= w->window.max_screen_width + w->window.screen_border
	+ w->window.vscroll_width + w->window.vscroll_border
	+ hb;
    w->window.max_window_height
	= w->window.max_screen_height + w->window.screen_border
	+ w->window.hscroll_height+ w->window.hscroll_border
	+ header + vb;
}


/*==============================================================
	Geometry Manager
================================================================*/
static XtGeometryResult GeometryManager(child, request, reply)
Widget			child;
XtWidgetGeometry	*request;
XtWidgetGeometry	*reply;	/* RETURN */

{
    Dimension   width, height;


    if (request->request_mode & (CWWidth | CWHeight | CWBorderWidth)) {

	/* Make all three fields in the request valid */
	if (request->request_mode & CWWidth)
	    child->core.width = request->width;
	if (request->request_mode & CWHeight)
	    child->core.height = request->height;
        if (request->request_mode & CWBorderWidth)
	    child->core.border_width = request->border_width;
	CalculateWindowSize(child->core.parent, &width, &height);
	return (ResizeReq(child->core.parent, width, height));
    }
    return (XtGeometryNo);
}


/*==============================================================
	Change Managed
================================================================*/
static void ChangeManaged(widget)
Widget	widget;
{
    SWindowWidget  w;
    Dimension	window_width, window_height;

    w = (SWindowWidget)widget;

    if (w->window.close_flag && w->window.close_box) {
	w->window.close_width  = (w->window.close_box)->core.width;
	w->window.close_height = (w->window.close_box)->core.height;
    }
    if (w->window.title_bar)
	w->window.title_height = (w->window.title_bar)->core.height;
    if (w->window.menu_bar)
	w->window.menu_height = (w->window.menu_bar)->core.height;
    if (w->window.scroll_box) {
	w->window.scroll_width  = (w->window.scroll_box)->core.width;
	w->window.scroll_height = (w->window.scroll_box)->core.height;
    }
    if (w->window.vscroll_bar) {
	w->window.vscroll_width  = (w->window.vscroll_bar)->core.width;
    }
    if (w->window.hscroll_bar) {
	w->window.hscroll_height = (w->window.hscroll_bar)->core.height;
    }
    if (w->window.screen) {
	w->window.screen_width  = (w->window.screen)->core.width;
	w->window.screen_height = (w->window.screen)->core.height;
    }
    CalculateWindowSize(w, &window_width, &window_height);
    CalculateMaxSize(w);
    if (ResizeReq(w, window_width, window_height) == XtGeometryYes)
    	Resize(w);
}


/*==============================================================
	Initialize
================================================================*/
static void Initialize(request, new, args, num_args)
Widget	 request, new;
ArgList	 args;
Cardinal num_args;
{
    SWindowWidget w;
    Arg		arg[100];
    ArgList	list;
    Cardinal	i, j;
    Widget	child;

    w = (SWindowWidget)new;
    w->window.close_box   = NULL;
    w->window.title_bar   = NULL;
    w->window.menu_bar    = NULL;
    w->window.screen      = NULL;
    w->window.scroll_box  = NULL;
    w->window.vscroll_bar = NULL;
    w->window.hscroll_bar = NULL;
    w->window.redisp = 0;
    w->window.icon_flag = 0;
    w->window.open_flag = 0;
    w->window.time = 0;
    w->window.flame = 0;

    switch(w->window.window_type) {
    case XtwStandard:
	break;
    case XtwPlainBox:
    case XtwShadowBox:
	w->window.resize_flag  = 0;
	w->window.close_flag   = 0;
	w->window.title_flag   = 0;
	w->window.scroll_flag  = 0;
	w->window.vscroll_flag = 0;
	w->window.hscroll_flag = 0;
	w->window.hspace  = 0;
	w->window.vspace  = 0;
	break;
    }

    if (w->window.window_type == XtwStandard)
    {
	/* Close box */
	if (w->window.close_flag) {
	    w->window.close_box
		= XtCreateManagedWidget("closebox", sButtonWidgetClass, w,
				(ArgList)close_box_arg, XtNumber(close_box_arg));
	}

	/* Title bar */
	if (w->window.title_flag) {
	    title_bar_arg[RmTransration].value
		= (XtArgVal)XtParseTranslationTable(buttonTranslations);
	    w->window.title_bar
		= XtCreateManagedWidget("titlebar", sButtonWidgetClass, w,
			     (ArgList)title_bar_arg, XtNumber(title_bar_arg));
	}

	/* Menu bar */
	if (w->window.menu_class) {
	    w->window.menu_bar
		= XtCreateManagedWidget("menubar", w->window.menu_class, w,
				 (ArgList)w->window.menu_args,
				 w->window.num_menu_args);
	}

	/* Scroll box */
	if (w->window.scroll_flag) {
	    w->window.scroll_box
		= XtCreateManagedWidget("scrollbox", sScrollWidgetClass, w,
				(ArgList)scroll_box_arg, XtNumber(scroll_box_arg));
	}

	/* Vertical scroll bar */
	if (w->window.vscroll_flag) {
	    w->window.vscroll_bar
		= XtCreateManagedWidget("vscrollbar", sScrollWidgetClass, w,
				(ArgList)vscroll_bar_arg, XtNumber(vscroll_bar_arg));
	}

	/* Horizontal scroll bar */
	if (w->window.hscroll_flag) {
	    w->window.hscroll_bar
		= XtCreateManagedWidget("hscrollbar", sScrollWidgetClass, w,
		             (ArgList)hscroll_bar_arg, XtNumber(hscroll_bar_arg));
	}
    }

    /* Screen Widget */
    if (w->window.screen_class == NULL)
	w->window.screen_class = sScreenWidgetClass;
    i = 0;
    XtSetArg(arg[0], XtNwidth, w->window.screen_width); i++;
    XtSetArg(arg[1], XtNheight,w->window.screen_height); i++;
    for (j = 0, list = w->window.screen_args;
		j < w->window.num_screen_args; j++, list++) {
	if (list->name == XtNwidth) continue;
	if (list->name == XtNheight) continue;
	XtSetArg(arg[i], list->name, list->value);
	i++;
    }

    w->window.screen
	= XtCreateManagedWidget("screen", w->window.screen_class,
				w, (ArgList)arg, i);

    /* Icon Widget */
    if (w->window.iconify) {
	icon_arg[RmTransration].value
	    = (XtArgVal)XtParseTranslationTable(buttonTranslations);
	icon_arg[RmBitmapPath].value = (XtArgVal)w->window.bitmap_path;
	icon_arg[RmBitmapFile].value = (XtArgVal)w->window.icon_file;
	icon_arg[RmInactiveFile].value = (XtArgVal)w->window.icon_file;
	icon_arg[RmFont].value       = (XtArgVal)w->window.font;
#ifdef KANJI
	icon_arg[RmKanjiFont].value  = (XtArgVal)w->window.kanji_font;
#endif KANJI
	icon_arg[RmLabel].value      = (XtArgVal)w->window.icon_label;
	w->window.icon
	    = XtCreateWidget("icon", sButtonWidgetClass, w,
			     (ArgList)icon_arg, XtNumber(icon_arg));
    }

    Get_frameGC(w);
    Get_resizeGC(w);

} /* Initialize */


/*==============================================================
	Realize
================================================================*/
static void Realize(w, valueMask, attributes)
register	Widget w;
Mask		*valueMask;
XSetWindowAttributes *attributes;
{

    attributes->bit_gravity = NorthWestGravity;
    *valueMask |= CWBitGravity;
    attributes->cursor = ((SWindowWidget)w)->window.cursor;
    *valueMask |= CWCursor;
     if (((SWindowWidget)w)->window.window_type == XtwShadowBox) {
         attributes->background_pixel = w->core.border_pixel;
         *valueMask |= CWBackPixel;
    }
    if (((SWindowWidget)w)->window.window_type == XtwShadowBox) {
	attributes->background_pixel
	    = XBlackPixel(XtDisplay(w), XDefaultScreen(XtDisplay(w)));
	*valueMask |= CWBackPixel;
    }
    
    XtCreateWindow(w, (unsigned)InputOutput, (Visual *)CopyFromParent,
		   *valueMask, attributes);
    
} /* Realize */



/*==============================================================
	Set Value
================================================================*/
static Boolean SetValues(current, request, new, last)
Widget  current, request, new;
Boolean last;
{
    Cardinal	i;
    Arg		arg[3];
    Dimension	width, height;
    Pixel	foreground, background;

    SWindowWidget curw = (SWindowWidget) current;
    SWindowWidget neww = (SWindowWidget) new;


    /*---------------------------------------------------
	Screen
    ---------------------------------------------------*/
    /* Screen height or width */
    if ((curw->window.screen_height != neww->window.screen_height) ||
	(curw->window.screen_width  != neww->window.screen_width)) {
	CalculateWindowSize(neww, &width, &height);
	ConfigureWindow(neww, neww->core.x, neww->core.y, width, height);
    }

	
    /* Max. screen size or Min. screen size */
    if ((curw->window.max_screen_height != neww->window.max_screen_height) ||
	(curw->window.max_screen_width  != neww->window.max_screen_width)  ||
	(curw->window.min_screen_height != neww->window.min_screen_height) ||
	(curw->window.min_screen_width  != neww->window.min_screen_width))
	CalculateMaxSize(neww);

    /*---------------------------------------------------
	Icon
    ---------------------------------------------------*/
    if (curw->window.icon) {
	/* Bitmap */
	if (strcmp(curw->window.icon_file, neww->window.icon_file)) {
	    XtSetArg(arg[0], XtNbitmapFile, (XtArgVal)neww->window.icon_file);
	    XtSetValues( curw->window.icon, arg, 1);
	}

	/* Font type */
	if (curw->window.font->fid != neww->window.font->fid) {
	    XtSetArg(arg[0], XtNfont, (XtArgVal)neww->window.font);
	    XtSetValues(curw->window.icon, arg, 1);
	}

#ifdef KANJI
	/* Kanji font type */
	if (curw->window.kanji_font->fid != neww->window.kanji_font->fid) {
	    XtSetArg(arg[0], XtNkanjiFont, (XtArgVal)neww->window.kanji_font);
	    XtSetValues(curw->window.icon, arg, 1);
	}
#endif KANJI

	/* Label */
	if (strcmp(curw->window.icon_label, neww->window.icon_label)) {
	    XtSetArg(arg[0], XtNlabel, (XtArgVal)neww->window.icon_label);
	    XtSetArg(arg[1], XtNwidth,  (XtArgVal)0);
	    XtSetArg(arg[2], XtNheight, (XtArgVal)0);
	    XtSetValues( curw->window.icon, arg, 3);
	    CalculateWindowSize(neww, &width, &height);
	    if ((width != neww->core.width) ||
		(height != neww->core.height))
	    {
		XWindowAttributes	attributes;
		Window		root_win, parent_win;
		int			num_children;
		Window		*child_list;

		if (XtIsSubclass(neww->core.parent, wmShellWidgetClass)) {
		    XQueryTree(XtDisplay(neww->core.parent), XtWindow(neww->core.parent),
				&root_win, &parent_win, &child_list, &num_children);
		    if (root_win == parent_win)
			XGetWindowAttributes(XtDisplay(neww->core.parent),
				     XtWindow(neww->core.parent), &attributes);
		    else
			XGetWindowAttributes(XtDisplay(neww->core.parent),
				     parent_win, &attributes);
		} else {
		    XGetWindowAttributes(XtDisplay(neww),
			         XtWindow(neww), &attributes);
		}
		ConfigureWindow(neww, attributes.x, attributes.y, width, height);
	    }
	}
    }

    /*---------------------------------------------------
	Window
    ---------------------------------------------------*/
    /* Cursor */
    if (curw->window.cursor != neww->window.cursor) {
	XFreeCursor(XtDisplay(curw), curw->window.cursor);
	neww->window.cursor = XCreateFontCursor(XtDisplay(curw), neww->window.cursor);
	XDefineCursor(XtDisplay(curw), XtWindow(curw), neww->window.cursor);
    }

    /* Inactive Flag */
    if (curw->window.inactive != neww->window.inactive) {
	for (i = 0; i < neww->composite.num_children; i++) {
	    if (neww->composite.children[i] == neww->window.title_bar) {
		XtSetArg(arg[0], XtNforeground, (XtArgVal)&background);
		XtSetArg(arg[1], XtNbackground, (XtArgVal)&foreground);
		XtGetValues(neww->composite.children[i], arg, 2);
		XtSetArg(arg[0], XtNforeground, (XtArgVal)foreground);
		XtSetArg(arg[1], XtNbackground, (XtArgVal)background);
		XtSetValues(neww->composite.children[i], arg, 2);
		continue;
	    }
	    if (neww->window.inactive == TRUE)
		Inactive(neww->composite.children[i]);
	    else
		Active(neww->composite.children[i]);
	    if (XtIsSubclass(neww->composite.children[i],sScrollWidgetClass)) {
		XtSetArg(arg[0], XtNinactive, neww->window.inactive);
		XtSetValues(neww->composite.children[i], arg, 1);
	    } else if (XtIsSubclass(neww->composite.children[i],sButtonWidgetClass)) {
		XtSetArg(arg[0], XtNsensitive, neww->window.inactive ? FALSE : TRUE);
		XtSetValues(neww->composite.children[i], arg, 1);
	    }
	}
    }
    return (FALSE);
}


/*===============================================================
	Destroy
=================================================================*/
static void Destroy(w)
SWindowWidget w;
{
    w->core.background_pixmap =  UnspecifiedPixmap;
    w->core.border_pixmap     =  UnspecifiedPixmap;
}


/************************************************************************/
/*									*/
/*	Callback routines						*/
/*									*/
/************************************************************************/
/*==============================================================
	Move Window
================================================================*/
static void MoveWindow(widget, closure, callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    SWindowWidget	w;
    XEvent		*event;
    XWindowAttributes	attributes;
    XWindowAttributes	parent_attr;
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;
    Arg			arg;

    w = (SWindowWidget)widget->core.parent;
    event = (XEvent *)callData;

    switch (event->type) {
    case ButtonPress:
	XGrabServer(XtDisplay(w->core.parent));
	if (w->window.icon_flag) {
	    if (((event->xbutton.time) - (w->window.time)) < 500) {
		w->window.open_flag = 1;
		return;
	    }
	    w->window.time = event->xbutton.time;

	}
	if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	    XQueryTree(XtDisplay(w->core.parent), XtWindow(w->core.parent), &root_win,
			&parent_win, &child_list, &num_children);
	    if (root_win == parent_win)
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     XtWindow(w->core.parent), &attributes);
	    else
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     parent_win, &attributes);
	    XGetWindowAttributes(XtDisplay(w),
			         root_win, &parent_attr);
	} else {
	    XGetWindowAttributes(XtDisplay(w),
			         XtWindow(w), &attributes);
	    XGetWindowAttributes(XtDisplay(w),
			         XtWindow(w->core.parent), &parent_attr);
	}
	w->window.flame_x1 = attributes.x;
	w->window.flame_y1 = attributes.y;
	w->window.flame_x2 = attributes.x + attributes.width;
	w->window.flame_y2 = attributes.y + attributes.height;
	DrawRectangle(w, event);
	w->window.current_x = event->xmotion.x_root;
	w->window.current_y = event->xmotion.y_root;
	w->window.cursor_x  = w->window.flame_x1 + event->xmotion.x;
	w->window.cursor_y  = w->window.flame_y1 + event->xmotion.y;
	w->window.max_width  = parent_attr.width;
	w->window.max_height = parent_attr.height;
	w->window.flame = TRUE;
	return;

    case ButtonRelease:
	if (w->window.flame == FALSE) {
	    if (w->window.open_flag) {
	    	XUngrabServer(XtDisplay(w->core.parent));
		OpenWindow(w);
		w->window.open_flag = 0;
	    }
	    return;
	}
	DrawRectangle(w, event);
	if (w->window.icon_flag)
    	    XClearArea(XtDisplay(w), XtWindow(w->window.icon), 0, 0,
			w->core.width, w->core.height, TRUE);
	ChangeWindowAddr(w, w->window.flame_x1, w->window.flame_y1);
	XtCallCallbacks(w, XtNmoveCallback, callData);
	w->window.flame = FALSE;
	XUngrabServer(XtDisplay(w->core.parent));
	return;

    case MotionNotify:
	if (w->window.flame == FALSE)
	    return;
	DrawRectangle(w, event);
	w->window.flame_x1 += (event->xmotion.x_root - w->window.current_x);
	w->window.flame_x2 += (event->xmotion.x_root - w->window.current_x);
	w->window.flame_y1 += (event->xmotion.y_root - w->window.current_y);
	w->window.flame_y2 += (event->xmotion.y_root - w->window.current_y);
	w->window.cursor_x += (event->xmotion.x_root - w->window.current_x);
	w->window.cursor_y += (event->xmotion.y_root - w->window.current_y);
	if ((w->window.cursor_x >= 0) &&
	    (w->window.cursor_y >= 0) &&
	    (w->window.cursor_x <= w->window.max_width) &&
	    (w->window.cursor_y <= w->window.max_height)) {
	    DrawRectangle(w, event);
	    w->window.flame = TRUE;
	} else
	    w->window.flame = FALSE;
	w->window.current_x = event->xmotion.x_root;
	w->window.current_y = event->xmotion.y_root;
	return;

    default:
	return;
    }
}

/*==============================================================
	Resize Window
================================================================*/
static void ResizeWindow(w, event)
SWindowWidget	w;
XEvent		*event;
{
    XWindowAttributes	attributes;
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;
    Position		ox, oy;
    Dimension		width, height;
    SresizeEvent	resize;


    if (w->window.inactive)
	return;
    if (!(w->window.resize_flag))
	return;

    switch (event->type) {
    case ButtonPress:
	if (((event->xmotion.x > RESIZE_AREA) &&
	     (event->xmotion.x < w->core.width - RESIZE_AREA))
	  ||((event->xmotion.y > RESIZE_AREA) &&
	     (event->xmotion.y < w->core.height - RESIZE_AREA)))
	    return;

	w->window.flame = TRUE;
	XGrabServer(XtDisplay(w->core.parent));
	if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	    XQueryTree(XtDisplay(w->core.parent), XtWindow(w->core.parent), &root_win,
			&parent_win, &child_list, &num_children);
	    if (root_win == parent_win)
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     XtWindow(w->core.parent), &attributes);
	    else
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     parent_win, &attributes);
	} else
	    XGetWindowAttributes(XtDisplay(w), XtWindow(w), &attributes);

	if (event->xmotion.x > RESIZE_AREA) {
	    w->window.flame_x1 = attributes.x;
	    w->window.flame_x2 = attributes.x + attributes.width;
	    w->window.resize_event = ResizeEv_PlusX;
	} else {
	    w->window.flame_x1 = attributes.x + attributes.width;
	    w->window.flame_x2 = attributes.x;
	    w->window.resize_event = ResizeEv_MinusX;
	}
	if (event->xmotion.y > RESIZE_AREA) {
	    w->window.flame_y1 = attributes.y;
	    w->window.flame_y2 = attributes.y + attributes.height;
	    w->window.resize_event |= ResizeEv_PlusY;
	} else {
	    w->window.flame_y1 = attributes.y + attributes.height;
	    w->window.flame_y2 = attributes.y;
	    w->window.resize_event |= ResizeEv_MinusY;
	}
	w->window.current_x = event->xmotion.x_root;
	w->window.current_y = event->xmotion.y_root;
	w->window.cursor_x = w->window.flame_x2;
	w->window.cursor_y = w->window.flame_y2;

	DrawRectangle(w, event);
	return;

    case ButtonRelease:
	if (w->window.flame == FALSE)
	    return;
	DrawRectangle(w, event);
	ox = min(w->window.flame_x1, w->window.flame_x2);
	oy = min(w->window.flame_y1, w->window.flame_y2);
	width = (w->window.flame_x2 > w->window.flame_x1 ?
		 w->window.flame_x2 - w->window.flame_x1 :
		 w->window.flame_x1 - w->window.flame_x2);
	height = (w->window.flame_y2 > w->window.flame_y1 ?
		  w->window.flame_y2 - w->window.flame_y1 :
		  w->window.flame_y1 - w->window.flame_y2);
	resize.type = w->window.resize_event;
	resize.x = (int)width - (int)(w->core.width);
	resize.y = (int)height - (int)(w->core.height);
	ConfigureWindow(w, ox, oy, width, height);
	XtCallCallbacks(w, XtNresizeCallback, &resize);
	XUngrabServer(XtDisplay(w->core.parent));
	w->window.flame = FALSE;
	return;

    case MotionNotify:
	if (w->window.flame == FALSE)
	    return;
	DrawRectangle(w, event);
	w->window.cursor_x += (event->xmotion.x_root - w->window.current_x);
	w->window.cursor_y += (event->xmotion.y_root - w->window.current_y);
	w->window.flame_x2 += (event->xmotion.x_root - w->window.current_x);
	w->window.flame_y2 += (event->xmotion.y_root - w->window.current_y);
	width = (w->window.cursor_x > w->window.flame_x1 ?
		 w->window.cursor_x - w->window.flame_x1 :
		 w->window.flame_x1 - w->window.cursor_x);
	height = (w->window.cursor_y > w->window.flame_y1 ?
		  w->window.cursor_y - w->window.flame_y1 :
		  w->window.flame_y1 - w->window.cursor_y);
	if (width < (int)w->window.min_window_width) {
	    if (w->window.flame_x2 > w->window.flame_x1)
	    	w->window.flame_x2 = w->window.flame_x1 + w->window.min_window_width;
	    else
	    	w->window.flame_x2 = w->window.flame_x1 - w->window.min_window_width;
	}
	if (width > (int)w->window.max_window_width) {
	    if (w->window.flame_x2 > w->window.flame_x1)
	    	w->window.flame_x2 = w->window.flame_x1 + w->window.max_window_width;
	    else
	    	w->window.flame_x2 = w->window.flame_x1 - w->window.max_window_width;
	}
	if (height < (int)w->window.min_window_height) {
	    if (w->window.flame_y2 > w->window.flame_y1)
		w->window.flame_y2 = w->window.flame_y1 + w->window.min_window_height;
	    else
		w->window.flame_y2 = w->window.flame_y1 - w->window.min_window_height;
	}
	if (height > (int)w->window.max_window_height) {
	    if (w->window.flame_y2 > w->window.flame_y1)
		w->window.flame_y2 = w->window.flame_y1 + w->window.max_window_height;
	    else
		w->window.flame_y2 = w->window.flame_y1 - w->window.max_window_height;
	}

	DrawRectangle(w, event);
	w->window.current_x = event->xmotion.x_root;
	w->window.current_y = event->xmotion.y_root;
	return;

    default:
	return;
    }
}


static void MapChildren(w)
SWindowWidget	w;
{
    int	i;

    for (i = 0; i < w->composite.num_children; i++) {
	if (w->composite.children[i] == w->window.icon)
	    continue;
	XtMapWidget(w->composite.children[i]);
    }
}


static void UnmapChildren(w)
SWindowWidget	w;
{
    int	i;

    for (i = 0; i < w->composite.num_children; i++) {
	if (w->composite.children[i] == w->window.icon)
	    continue;
	XtUnmapWidget(w->composite.children[i]);
    }
}


/*==============================================================
	Open Window
================================================================*/
static void OpenWindow(w)
SWindowWidget	w;
{

    XtSDeIconifyWindow(w);
    XtCallCallbacks(w, XtNdeIconifyCallback, NULL);
}
/*==============================================================
	Close Window
================================================================*/
static void CloseWindow(widget, closure, callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    SWindowWidget	w;
    Arg			arg[2];
    XWindowAttributes	attributes;
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;
    Dimension		width, height;

    w = (SWindowWidget)widget->core.parent;
    XtSIconifyWindow(w);
    XtCallCallbacks(w, XtNcloseCallback, callData);
}


/*==============================================================
	Raise window
================================================================*/
static void RaiseWindow(w, event)
SWindowWidget	w;
XEvent		*event;
{
    if (XtIsSubclass(w->core.parent, wmShellWidgetClass))
	XRaiseWindow(XtDisplay(w->core.parent), XtWindow(w->core.parent));
    else
	XRaiseWindow(XtDisplay(w), XtWindow(w));
    XtCallCallbacks(w, XtNraiseCallback, event);
}


/*==============================================================
	Selection clear
================================================================*/
static void Selclr(w, event)
SWindowWidget	w;
XEvent		*event;
{
    XtCallCallbacks(w, XtNselclrCallback, event);
}


/*==============================================================
	Change property
================================================================*/
static void Chgprop(w, event)
SWindowWidget	w;
XEvent		*event;
{
    XtCallCallbacks(w, XtNpropertyCallback, event);
}


static void ConfigureWindow(w, x, y, width, height)
SWindowWidget		w;
Position	x, y;
Dimension	width, height;
{
    Window	root_win, parent_win;
    int		num_children;
    Window	*child_list;


    if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	XQueryTree(XtDisplay(w->core.parent),
		   XtWindow(w->core.parent), &root_win,
		   &parent_win, &child_list, &num_children);
	if (root_win == parent_win) {
	    XtConfigureWidget(w->core.parent, x, y, width, height,
				(w->window.icon_flag ? 0 : 1));
	} else {
	    XResizeWindow(XtDisplay(w->core.parent), parent_win,
			  width, height);
	}
    } else {
	MoveReq(w, x, y);
	if (ResizeReq(w, width, height) == XtGeometryYes) {
	    (*(w->core.widget_class->core_class.resize))(w);
	}
    }
}


static void ChangeWindowAddr(w, x, y)
Widget		w;
Position	x, y;
{ 
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;

    if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	XQueryTree(XtDisplay(w), XtWindow(w->core.parent), &root_win,
			&parent_win, &child_list, &num_children);
	if (root_win == parent_win) {
	    XtMoveWidget(w->core.parent, x, y);
	    XRaiseWindow(XtDisplay(w->core.parent), XtWindow(w->core.parent));
	} else {
	    Window	pwin;
	    for (;;) {
		pwin = parent_win;
	    	XQueryTree(XtDisplay(w), pwin, &root_win,
			   &parent_win, &child_list, &num_children);
	    	if (root_win == parent_win)
		    break;
	    }
	    XMoveWindow(XtDisplay(w), pwin, x, y);
	    XRaiseWindow(XtDisplay(w->core.parent), pwin);
	}
	XFlush(XtDisplay(w->core.parent));
    } else {
	if (MoveReq(w, x, y)
		== XtGeometryYes) {
	    XRaiseWindow(XtDisplay(w), XtWindow(w));
	}
    }
}


/************************************************************************
 *									*
 *	Public Routines							*
 *									*
 ************************************************************************/

/*==============================================================
	Deiconify Window
================================================================*/
void XtSDeIconifyWindow(w)
SWindowWidget	w;
{
    XWindowAttributes	attributes;
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;
    Dimension		width, height;
    Arg			arg[1];

    if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	XQueryTree(XtDisplay(w->core.parent), XtWindow(w->core.parent), &root_win,
			&parent_win, &child_list, &num_children);
	if (root_win == parent_win)
	    XGetWindowAttributes(XtDisplay(w->core.parent),
				 XtWindow(w->core.parent), &attributes);
	else
	    XGetWindowAttributes(XtDisplay(w->core.parent),
				 parent_win, &attributes);
    } else {
	XGetWindowAttributes(XtDisplay(w),
			     XtWindow(w), &attributes);
    }
    w->window.icon_flag = 0;
    w->window.time = 0;
    XtUnmanageChild(w->window.icon);
    MapChildren(w);
    CalculateWindowSize(w, &width, &height);
    XtSetArg(arg[0], XtNborderWidth, 1);
    XtSetValues(w, arg, 1);
    ConfigureWindow(w, attributes.x, attributes.y, width, height);
}
/*==============================================================
	Iconify Window
================================================================*/
void XtSIconifyWindow(w)
SWindowWidget	w;
{
    Arg			arg[2];
    XWindowAttributes	attributes;
    Window		root_win, parent_win;
    int			num_children;
    Window		*child_list;
    Dimension		width, height;

    if (w->window.icon) {
	if (XtIsSubclass(w->core.parent, wmShellWidgetClass)) {
	    XQueryTree(XtDisplay(w->core.parent), XtWindow(w->core.parent), &root_win,
			&parent_win, &child_list, &num_children);
	    if (root_win == parent_win)
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     XtWindow(w->core.parent), &attributes);
	    else
		XGetWindowAttributes(XtDisplay(w->core.parent),
				     parent_win, &attributes);
	} else {
	    XGetWindowAttributes(XtDisplay(w),
			         XtWindow(w), &attributes);
	}
	w->window.icon_flag = 1;
	UnmapChildren(w);
	XtManageChild(w->window.icon);
	XtSetArg(arg[0], XtNwidth, &width);
	XtSetArg(arg[1], XtNheight, &height);
	XtGetValues(w->window.icon, arg, 2);
	ConfigureWindow(w, attributes.x, attributes.y, width, height);
	XtSetArg(arg[0], XtNborderWidth, 0);
	XtSetValues(w, arg, 1);
    }
}


/*==============================================================
	Get Window Status
================================================================*/
XtSGetWindowStatus(w)
SWindowWidget	w;
{
    return(w->window.icon_flag);
}
