/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * Cpick.c - Color picker widget for X11 Toolkit
 * 
 * Author:	Mike Yang
 * 		Western Research Laboratory
 *	 	Digital Equipment Corporation
 * Date:	Mon Aug 9 1988
 *
 */

#include <stdio.h>
#include <math.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <X11/CompositeP.h>
#include <X11/StringDefs.h>
#include <X11/Composite.h>
#include <X11/Form.h>
#include <X11/Label.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Dialog.h>
#include "Slide.h"
#include "CpickP.h"
#include "color.h"

#define NULLSTR ""
#define VDIST 5
#define HDIST 5
#define LDIST 20
#define LWIDTH 50
#define BHDIST 15
#define BVDIST 5
#define BWIDTH 120
#define BHEIGHT 50
#define SHEIGHT 10
#define SWIDTH 100
#define SBACKGD "white"
#define HORIGIN 35
#define CDIST 10
#define HHDIST 15
#define HVDIST (BVDIST+3)
#define NHDIST 0
#define NVDIST 15
#define PVDIST 10
#define NFACTOR 1.8
#define CCURSOR XC_star

#define DEFAULTWIDTH 600
#define DEFAULTHEIGHT 300

#define INCREMENT 4000
#define WIDENEAR 8192
#define NARROWNEAR 768
#define MAXIMUM 65536
#define MINIMUM 0

#define FONT "variable"

#define Offset(field) XtOffset(CpickWidget, field)

static int defNearpixels = NEARPIXELS;

static XtResource resources[] = {
  {XtNokProc, XtCCallback, XtRCallback, sizeof(caddr_t),
     Offset(cpick.okProc), XtRCallback, NULL},
  {XtNselectProc, XtCCallback, XtRCallback, sizeof(caddr_t),
     Offset(cpick.selectProc), XtRCallback, NULL},
  {XtNchangeProc, XtCCallback, XtRCallback, sizeof(caddr_t),
     Offset(cpick.changeProc), XtRCallback, NULL},
  {XtNrestoreProc, XtCCallback, XtRCallback, sizeof(caddr_t),
     Offset(cpick.restoreProc), XtRCallback, NULL},
  {XtNallocated, XtCAllocated, XtRXColor, sizeof(caddr_t),
     Offset(cpick.allocated), XtRXColor, NULL},
  {XtNcmap, XtCCmap, XtRColormap, sizeof(Colormap),
     Offset(cpick.cmap), XtRColormap, NULL},
  {XtNselectLabel, XtCLabel, XtRString, sizeof(String),
     Offset(cpick.selectlabel), XtRString, "select"},
  {XtNcancelLabel, XtCLabel, XtRString, sizeof(String),
     Offset(cpick.cancellabel), XtRString, "cancel"},
  {XtNrestoreLabel, XtCLabel, XtRString, sizeof(String),
     Offset(cpick.restorelabel), XtRString, "restore"},
  {XtNokLabel, XtCLabel, XtRString, sizeof(String),
     Offset(cpick.oklabel), XtRString, "ok"},
  {XtNnearPixels, XtCDimension, XtRInt, sizeof(int),
     Offset(cpick.nearpixels), XtRInt, (caddr_t) &defNearpixels},
  {XtNuseColors, XtCUsecolors, XtRBoolean, sizeof(Boolean),
     Offset(cpick.usecolors), XtRBoolean, (caddr_t) TRUE},
};

static void ClassInitialize();
static void Initialize();
static void Realize();
static void Resize();
static void Redisplay();
static Boolean SetValues();

static void Notify(), Destroy();

CpickClassRec cpickClassRec = {
  {
    (WidgetClass) &compositeClassRec,	/* superclass		  */	
    "Cpick",				/* class_name		  */
    sizeof(CpickRec),			/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    Resize,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },{
/* Cpick class fields */
    /* empty		  */	0,
  }
};

static void Destroy(w)
     Widget w;
{

}

WidgetClass cpickWidgetClass = (WidgetClass)&cpickClassRec;

static String argv0 = "CPick";

typedef unsigned long (*PixProc)();

struct vals {
  int ih, iw, x0, y0, rownum;
  PixProc pix;
} gval, nval;

String colors[] = {"red", "green", "blue",
		     "gold", "khaki", "wheat",
		     "cyan", "magenta", "yellow"};

Arg sargs[] = {
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNfillColor, NULL},
  {XtNbackground, (XtArgVal) NULL},
  {XtNheight, (XtArgVal) SHEIGHT},
  {XtNwidth, (XtArgVal) SWIDTH},
  {XtNhorizDistance, HORIGIN},
  {XtNvertDistance, VDIST},
  {XtNorientation, (XtArgVal) XtorientHorizontal},
};

Arg largs[] = {
  {XtNlabel, (XtArgVal) NULLSTR},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNfont, NULL},
  {XtNhorizDistance, HDIST},
  {XtNvertDistance, VDIST},
  {XtNborderWidth, 0},
  {XtNwidth, LWIDTH},
  {XtNjustify, (XtArgVal) XtJustifyLeft},
};

Arg targs[] = {
  {XtNlabel, (XtArgVal) "?"},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNfont, NULL},
  {XtNhorizDistance, LDIST},
  {XtNvertDistance, VDIST},
  {XtNborderWidth, 0},
};

Arg bargs[] = {
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNhorizDistance, BHDIST},
  {XtNvertDistance, BVDIST},
  {XtNwidth, BWIDTH},
  {XtNheight, BHEIGHT},
  {XtNborderWidth, 2},
};

Arg hargs[] = {
  {XtNlabel, (XtArgVal) NULLSTR},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNfont, NULL},
  {XtNhorizDistance, HHDIST},
  {XtNvertDistance, HVDIST},
  {XtNborderWidth, 2},
  {XtNjustify, (XtArgVal) XtJustifyCenter},
};

Arg cargs[] = {
  {XtNlabel, (XtArgVal) NULLSTR},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNhorizDistance, BHDIST},
  {XtNvertDistance, BVDIST},
  {XtNfont, NULL},
  {XtNborderWidth, 2},
};

Arg nargs[] = {
  {XtNborderColor, NULL},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNhorizDistance, NHDIST},
  {XtNvertDistance, NVDIST},
  {XtNheight, 1},
  {XtNwidth, 1},
};

Arg dargs[] = {
  {XtNvalue, (XtArgVal) NULLSTR},
  {XtNlabel, (XtArgVal) "Hex string:"},
};

Arg pargs[] = {
  {XtNlabel, (XtArgVal) NULLSTR},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNfont, NULL},
  {XtNlabel, (XtArgVal) "narrow"},
  {XtNhorizDistance, HHDIST},
  {XtNvertDistance, PVDIST},
  {XtNborderWidth, 2},
};

Arg plabelargs[] = {
  {XtNlabel, NULL},
};

Arg labelargs1[] = {
  {XtNlabel, NULL},
  {XtNwidth, LWIDTH},
};

Arg labelargs2[] = {
  {XtNlabel, NULL},
};

char STRING[] = "rgbhsvcmy";

static void Realize( gw, valueMask, attributes )
   Widget gw;
   Mask *valueMask;
   XSetWindowAttributes *attributes;
{
  CpickWidget cw = (CpickWidget) gw;

  XtCreateWindow( gw, InputOutput, (Visual *)CopyFromParent,
		 *valueMask, attributes );
  XtRealizeWidget(cw->cpick.tlevel);

  XtMakeResizeRequest(gw, get(cw->cpick.tlevel, XtNwidth),
		      get(cw->cpick.tlevel, XtNheight),
		      NULL, NULL);
}

static void Resize( gw )
   Widget gw;
{
  CpickWidget cw = (CpickWidget) gw;

  XClearWindow( XtDisplay(gw), XtWindow(gw) );
  XtResizeWidget(cw->cpick.tlevel, cw->core.width,
		 cw->core.height, 1);
}


static Boolean SetValues( current, request, desired )
   Widget current,		/* what I am */
          request,		/* what he wants me to be */
          desired;		/* what I will become */
{
    CpickWidget w = (CpickWidget) current;
    CpickWidget rw = (CpickWidget) request;
    CpickWidget dw = (CpickWidget) desired;
    Boolean redraw = TRUE; /* be stupid for now */

    dw->cpick.oldvalue = *(dw->cpick.allocated);
    doNew(dw);
    return(redraw);
}


static int get(w, s)
Widget w;
String s;
{
  int result;
  Arg args[1];

  XtSetArg(args[0],s,(XtArgVal) &result);
  XtGetValues(w, args, XtNumber(args));

  return(result);
}

static updateBox(cw)
CpickWidget cw;
{
  XStoreColor(XtDisplay(cw),
	      cw->cpick.cmap,
	      cw->cpick.allocated);
}

static char hexDigit(v)
int v;
{
  if (v < 10)
    return '0'+v;
  else
    return 'a'+(v-10);
}

static createHex(r, g, b, s, max)
int r, g, b, max;
char s[];
{
  if (max == 16) {
    sprintf(s, "#%c%c%c",
	    hexDigit(16*r/max),
	    hexDigit(16*g/max),
	    hexDigit(16*b/max));
  } else {
    sprintf(s, "#%c%c%c%c%c%c",
	    hexDigit(256*r/max/16),
	    hexDigit(256*r/max % 16),
	    hexDigit(256*g/max/16),
	    hexDigit(256*g/max % 16),
	    hexDigit(256*b/max/16),
	    hexDigit(256*b/max % 16));
  }
}

static changeRGB(cw, which)
CpickWidget cw;
int which;
{
  RGB rgb;
  HSV hsv;
  CMY cmy;
  char str[13];
  int max;

  max = cw->cpick.max;
  if (which < H) {
    rgb.r = cw->cpick.values[R]*cw->cpick.ratio;
    rgb.g = cw->cpick.values[G]*cw->cpick.ratio;
    rgb.b = cw->cpick.values[B]*cw->cpick.ratio;
    hsv = RGBToHSV(rgb);
    cw->cpick.values[H] = (int) (hsv.h*(max-1));
    cw->cpick.values[S] = (int) (hsv.s*(max-1));
    cw->cpick.values[V] = (int) (hsv.v*(max-1));
    XtBargraphSetValue(cw->cpick.slides[H],cw->cpick.values[H]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[S],cw->cpick.values[S]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[V],cw->cpick.values[V]/(float) (max-1));
    changelabel(cw, H);
    changelabel(cw, S);
    changelabel(cw, V);
    cmy = RGBToCMY(rgb);
    cw->cpick.values[C] = cmy.c/cw->cpick.ratio;
    cw->cpick.values[M] = cmy.m/cw->cpick.ratio;
    cw->cpick.values[Y] = cmy.y/cw->cpick.ratio;
    XtBargraphSetValue(cw->cpick.slides[C],cw->cpick.values[C]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[M],cw->cpick.values[M]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[Y],cw->cpick.values[Y]/(float) (max-1));
    changelabel(cw, C);
    changelabel(cw, M);
    changelabel(cw, Y);
  } else if (which < C) {
    hsv.h = cw->cpick.values[H]/(float) (max-1);
    hsv.s = cw->cpick.values[S]/(float) (max-1);
    hsv.v = cw->cpick.values[V]/(float) (max-1);
    rgb = HSVToRGB(hsv);
    cw->cpick.values[R] = rgb.r/cw->cpick.ratio;
    cw->cpick.values[G] = rgb.g/cw->cpick.ratio;
    cw->cpick.values[B] = rgb.b/cw->cpick.ratio;
    XtBargraphSetValue(cw->cpick.slides[R],cw->cpick.values[R]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[G],cw->cpick.values[G]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[B],cw->cpick.values[B]/(float) (max-1));
    changelabel(cw, R);
    changelabel(cw, G);
    changelabel(cw, B);
    cmy = RGBToCMY(rgb);
    cw->cpick.values[C] = cmy.c/cw->cpick.ratio;
    cw->cpick.values[M] = cmy.m/cw->cpick.ratio;
    cw->cpick.values[Y] = cmy.y/cw->cpick.ratio;
    XtBargraphSetValue(cw->cpick.slides[C],cw->cpick.values[C]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[M],cw->cpick.values[M]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[Y],cw->cpick.values[Y]/(float) (max-1));
    changelabel(cw, C);
    changelabel(cw, M);
    changelabel(cw, Y);
  } else {
    cmy.c = cw->cpick.values[C]*cw->cpick.ratio;
    cmy.m = cw->cpick.values[M]*cw->cpick.ratio;
    cmy.y = cw->cpick.values[Y]*cw->cpick.ratio;
    rgb = CMYToRGB(cmy);
    cw->cpick.values[R] = rgb.r/cw->cpick.ratio;
    cw->cpick.values[G] = rgb.g/cw->cpick.ratio;
    cw->cpick.values[B] = rgb.b/cw->cpick.ratio;
    XtBargraphSetValue(cw->cpick.slides[R],cw->cpick.values[R]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[G],cw->cpick.values[G]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[B],cw->cpick.values[B]/(float) (max-1));
    changelabel(cw, R);
    changelabel(cw, G);
    changelabel(cw, B);
    hsv = RGBToHSV(rgb);
    cw->cpick.values[H] = (int) (hsv.h*(max-1));
    cw->cpick.values[S] = (int) (hsv.s*(max-1));
    cw->cpick.values[V] = (int) (hsv.v*(max-1));
    XtBargraphSetValue(cw->cpick.slides[H],cw->cpick.values[H]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[S],cw->cpick.values[S]/(float) (max-1));
    XtBargraphSetValue(cw->cpick.slides[V],cw->cpick.values[V]/(float) (max-1));
    changelabel(cw, H);
    changelabel(cw, S);
    changelabel(cw, V);
  }
  createHex(cw->cpick.values[R], cw->cpick.values[G], cw->cpick.values[B], str, max);
  labelargs2[0].value = (XtArgVal) str;
  labelargs2[1].value = (XtArgVal) get(cw->cpick.box, XtNwidth);
  XtSetValues(cw->cpick.hex, labelargs2, XtNumber(labelargs2));
  (cw->cpick.allocated)->red = cw->cpick.values[R]*cw->cpick.ratio;
  (cw->cpick.allocated)->green = cw->cpick.values[G]*cw->cpick.ratio;
  (cw->cpick.allocated)->blue = cw->cpick.values[B]*cw->cpick.ratio;
  changePalette(cw, FALSE);
  if (XtIsRealized(cw) && cw->cpick.changeProc) {
    XtCallCallbacks(cw, XtNchangeProc, (caddr_t)(cw->cpick.allocated));
  }
}

static update(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  int which;
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  which = (int) cdata;
  cw->cpick.values[which] = (int)(position*(cw->cpick.max-1));
  changelabel(cw, which);

  changeRGB(cw, which);
  updateBox(cw);
}

static newRGB(cw, r, g, b)
CpickWidget cw;
int r, g, b;
{
  cw->cpick.values[R] = (int)(r/(float) (MAXIMUM-1)*(cw->cpick.max-1));
  cw->cpick.values[G] = (int)(g/(float) (MAXIMUM-1)*(cw->cpick.max-1));
  cw->cpick.values[B] = (int)(b/(float) (MAXIMUM-1)*(cw->cpick.max-1));
  changelabel(cw, R);
  changelabel(cw, G);
  changelabel(cw, B);
  XtBargraphSetValue(cw->cpick.slides[R], r/(float) (MAXIMUM-1));
  XtBargraphSetValue(cw->cpick.slides[G], g/(float) (MAXIMUM-1));
  XtBargraphSetValue(cw->cpick.slides[B], b/(float) (MAXIMUM-1));
  changeRGB(cw, R);
  updateBox(cw);
}
			      

static scroll(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     int position;
{
  int which;
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  which = (int) cdata;
  if (position < 0) {
    cw->cpick.values[which] = cw->cpick.values[which]+cw->cpick.inc;
    if (cw->cpick.values[which] > cw->cpick.max-1)
      cw->cpick.values[which] = cw->cpick.max-1;
  } else {
    cw->cpick.values[which] = cw->cpick.values[which]-cw->cpick.inc;
    if (cw->cpick.values[which] < MINIMUM)
      cw->cpick.values[which] = MINIMUM;
  }
  XtBargraphSetValue(cw->cpick.slides[which], cw->cpick.values[which]/(float) (cw->cpick.max-1));
  changelabel(cw, which);

  if (cw->cpick.box != NULL) {
    changeRGB(cw, which);
    updateBox(cw);
  }

}

static changelabel(cw, which)
CpickWidget cw;
int which;
{
  char str[5];

  if ((which < H) || (which > V)) {
    sprintf(str, "%-5d", cw->cpick.values[which]);
  } else {
    sprintf(str, "%-5.4f", cw->cpick.values[which]/(float) (cw->cpick.max-1));
  }
  labelargs1[0].value = (XtArgVal) str;
  XtSetValues(cw->cpick.labels[which], labelargs1, XtNumber(labelargs1));
}

static createSlides(cw, argv0)
CpickWidget cw;
String argv0;
{
  int each;
  Widget temp;
  char *chptr;
  XColor xc, ignore;

  largs[3].value = (XtArgVal) XLoadQueryFont(XtDisplay(cw), FONT);
  targs[3].value = largs[3].value;
  cargs[5].value = largs[3].value;
  hargs[3].value = largs[3].value;
  pargs[3].value = largs[3].value;

  largs[0].value = (XtArgVal) NULLSTR;
  largs[1].value = NULL;
  cw->cpick.toplabel = XtCreateManagedWidget(argv0, labelWidgetClass, cw->cpick.tlevel,
				   largs, XtNumber(largs));
  sargs[1].value = (XtArgVal) cw->cpick.toplabel;
  largs[1].value = (XtArgVal) cw->cpick.toplabel;
  largs[2].value = (XtArgVal) cw->cpick.toplabel;
  XAllocNamedColor(XtDisplay(cw), cw->cpick.cmap, SBACKGD, &xc, &ignore);
  sargs[3].value = (XtArgVal) xc.pixel;

  for (each=0; each<NUM; each++) {
    if ((each % 3 == 0) && (each != 0)) {
      temp = XtCreateManagedWidget(argv0, labelWidgetClass, cw->cpick.tlevel,
				    largs, XtNumber(largs));
      largs[2].value = (XtArgVal) temp;
      sargs[1].value = (XtArgVal) temp;
    }

    if (cw->cpick.usecolors && ((each < H) || (each > V))) {
      XAllocNamedColor(XtDisplay(cw),
		       cw->cpick.cmap,
		       colors[each], &xc, &ignore);
      XtSetArg(sargs[2], XtNfillColor, xc.pixel);
    } else {
      XtSetArg(sargs[2], XtNfillPixmap, XtGrayPixmap(XtScreen(cw)));
    }

    cw->cpick.slides[each] = XtCreateManagedWidget(argv0, slideWidgetClass, cw->cpick.tlevel,
					 sargs, XtNumber(sargs));
    XtAddCallback(cw->cpick.slides[each], XtNthumbProc, update, (caddr_t) each);
    XtAddCallback(cw->cpick.slides[each], XtNscrollProc, scroll, (caddr_t) each);
    largs[1].value = (XtArgVal) cw->cpick.slides[each];
    cw->cpick.labels[each] = XtCreateManagedWidget(argv0, labelWidgetClass, cw->cpick.tlevel,
					 largs, XtNumber(largs));
    targs[2].value = largs[2].value;
    chptr = (char *)(targs[0].value);
    chptr[0] = STRING[each];
    temp = XtCreateManagedWidget(argv0, labelWidgetClass, cw->cpick.tlevel,
				 targs, XtNumber(targs));
    sargs[1].value = (XtArgVal) cw->cpick.slides[each];
    largs[2].value = (XtArgVal) cw->cpick.slides[each];
  }
}

static dohex(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;
  char response[256];
  Arg args[1];

  cw = (CpickWidget) XtParent(XtParent(cmd));

  XtSetArg(args[0], XtNlabel, (XtArgVal) response);
/*
  XtGetValues(cw->cpick.hex, args, XtNumber(args));
  XtSetArg(args[0], XtNvalue, (XtArgVal) response);
  XtGetValues(cw->cpick.dialog, args, XtNumber(args));
*/
  XtManageChild(cw->cpick.dialog);

/*
  labelargs2[0].value = (XtArgVal) XtDialogGetValueString(cw->cpick.dialog);
  labelargs2[1].value = (XtArgVal) get(cw->cpick.box, XtNwidth);
  XtSetValues(cw->cpick.hex, labelargs2, XtNumber(labelargs2));
  XtUnmanageChild(cw->cpick.dialog);
*/
}

static createBox(cw, argv0)
CpickWidget cw;
String argv0;
{
  bargs[0].value = (XtArgVal) cw->cpick.labels[H];
  bargs[1].value = (XtArgVal) cw->cpick.toplabel;
  cw->cpick.box = XtCreateManagedWidget(argv0, boxWidgetClass,
			      cw->cpick.tlevel, bargs, XtNumber(bargs));
  hargs[1].value = (XtArgVal) cw->cpick.box;
  hargs[2].value= (XtArgVal) cw->cpick.toplabel;
/* dialog stuff doesn't work   :-(
  cw->cpick.hex = XtCreateManagedWidget(argv0, commandWidgetClass,
			      cw->cpick.tlevel, hargs, XtNumber(hargs));
  XtAddCallback(cw->cpick.hex, XtNcallback, dohex, NULL);
*/
  cw->cpick.hex = XtCreateManagedWidget(argv0, labelWidgetClass,
			      cw->cpick.tlevel, hargs, XtNumber(hargs));
}

static doNew(cw)
CpickWidget cw;
{
  static Arg args[] = {
    {XtNbackground, NULL},
  };

  newRGB(cw,
	 (*(cw->cpick.allocated)).red,
	 (*(cw->cpick.allocated)).green,
	 (*(cw->cpick.allocated)).blue);
  if (cw->cpick.box) {
    XtSetArg(args[0], XtNbackground,
	     (XtArgVal) (*(cw->cpick.allocated)).pixel);
    XtSetValues(cw->cpick.box, args, XtNumber(args));
  }
}

static nButtonHandler(w, val, event)
Widget w;
struct vals *val;
XButtonEvent *event;
{
  int newpix;
  static Arg args[] = {
    {XtNbackground, NULL},
  };
  XColor xc;
  CpickWidget cw = (CpickWidget) XtParent(XtParent(w));

  newpix = val->pix(cw, (event->x-val->x0)/val->iw +
		        ((event->y-val->y0)/val->ih)*val->rownum);
  if (newpix != MAXIMUM) {
    xc.pixel = newpix;
    XQueryColor(XtDisplay(cw), cw->cpick.cmap, &xc);
    (*(cw->cpick.allocated)).red = xc.red;
    (*(cw->cpick.allocated)).green = xc.green;
    (*(cw->cpick.allocated)).blue = xc.blue;
    cw->cpick.keep = TRUE;
    doNew(cw);
  }
}

static unsigned long nPixel(cw, each)
CpickWidget cw;
int each;
{
  if (each < cw->cpick.nearpixels)
    return cw->cpick.nearcells[each].pixel;
  else
    return MAXIMUM;
}

static createGrid(wid, num, x0, y0, h, w, proc, val, pix)
Widget wid;
int num, x0, y0, h, w;
XtEventHandler proc;
struct vals *val;
PixProc pix;
{
  int each, x, y, hs, ws;
  double hsize, wsize;
  GC gc;
  XGCValues gcv;
  unsigned long gcMask, black;

  val->pix = pix;

  hsize = sqrt((double) num*VNEARRATIO/HNEARRATIO);
  wsize = ceil(hsize*HNEARRATIO/VNEARRATIO);
  hsize = ceil(hsize);

  val->ih = (int) ((h-1)/hsize);
  val->iw = (int) ((w-1)/wsize);
  val->rownum = (int) wsize;
  hs = (int) hsize*val->ih+1;
  ws = (int) wsize*val->iw+1;

  XtMoveWidget(wid, x0, y0);
  XtResizeWidget(wid, w, h, 1);

  val->y0 = (h-hs)/2;
  val->x0 = (w-ws)/2;

  gcv.function = GXcopy;
  gcv.fill_style = FillSolid;
  black = XBlackPixel(XtDisplay(wid),
		      XDefaultScreen(XtDisplay(wid)));
  gcv.background = black;
  gc = XCreateGC(XtDisplay(wid), XtWindow(wid),
		 GCBackground | GCFunction | GCFillStyle, &gcv);

  XSync(XtDisplay(wid),0);
  for (each=0; each<num; each++) {
    x = (each % val->rownum)*val->iw;
    y = (each/val->rownum)*val->ih;
    XSetForeground(XtDisplay(wid), gc, pix(XtParent(XtParent(wid)), each));
    XFillRectangle(XtDisplay(wid), XtWindow(wid), gc, val->x0+x, val->y0+y,
		   val->iw, val->ih);
    XSetForeground(XtDisplay(wid), gc, black);
    XDrawRectangle(XtDisplay(wid), XtWindow(wid), gc, val->x0+x, val->y0+y,
		   val->iw, val->ih);
  }

  XtAddEventHandler(wid, ButtonPressMask, FALSE, proc, val);
  XFreeGC(XtDisplay(wid), gc);
}

static doExpose(cw)
CpickWidget cw;
{
  createGrid(cw->cpick.nlevel, cw->cpick.nearpixels, get(cw->cpick.box, XtNx)+NHDIST,
	     get(cw->cpick.box, XtNy)+get(cw->cpick.box, XtNheight)+NVDIST,
	     (int) (get(cw->cpick.box, XtNheight)*NFACTOR),
	     get(cw->cpick.box, XtNwidth)+HHDIST+get(cw->cpick.hex, XtNwidth),
	     nButtonHandler, &nval, nPixel);
}

static Boolean
ExposePending(display, event, arg)
Display *display;
XEvent *event;
Widget arg;
{
  return((event->type == Expose) &&
	 (((XExposeEvent *)event)->window == XtWindow(arg)));
}

static exposeHandler(w, client_data, event)
Widget w;
caddr_t client_data;
XEvent *event;
{
  XEvent ev;
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(w));

  XFlush(XtDisplay(w));
  while (XCheckIfEvent(XtDisplay(w), &ev, ExposePending, w)) {
    /* eat it */
  }
  
  if (((XExposeEvent *)event)->count == 0) {
    doExpose(cw);
  }
}

static doselect(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  if (cw->cpick.selectProc) {
    XtCallCallbacks(cw, XtNselectProc, (caddr_t)(cw->cpick.allocated));
  }
}

static docancel(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  *(cw->cpick.allocated) = cw->cpick.oldvalue;
  doNew(cw);
}

static dorestore(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  if (cw->cpick.restoreProc) {
    XtCallCallbacks(cw, XtNrestoreProc, (caddr_t)(cw->cpick.allocated));
  }
  changePalette(cw, TRUE);
}

static dook(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  if (cw->cpick.okProc) {
    XtCallCallbacks(cw, XtNokProc, (caddr_t)(cw->cpick.allocated));
  }
}

static createCommands(cw)
CpickWidget cw;
{
  Widget last;

  last = cw->cpick.labels[H];

  cargs[1].value = (XtArgVal) last;
  cargs[2].value = (XtArgVal) cw->cpick.labels[C];
  if (cw->cpick.selectlabel) {
    cargs[0].value = (XtArgVal) cw->cpick.selectlabel;
    last = cw->cpick.select0 = XtCreateManagedWidget(argv0, commandWidgetClass,
	 		      cw->cpick.tlevel, cargs, XtNumber(cargs));
    XtAddCallback(cw->cpick.select0, XtNcallback, doselect, NULL);
  }
  cargs[1].value = (XtArgVal) last;
  cargs[3].value = CDIST;
  if (cw->cpick.cancellabel) {
    cargs[0].value = (XtArgVal) cw->cpick.cancellabel;
    last = cw->cpick.cancel = XtCreateManagedWidget(argv0, commandWidgetClass,
				 cw->cpick.tlevel, cargs, XtNumber(cargs));
    XtAddCallback(cw->cpick.cancel, XtNcallback, docancel, NULL);
  }
  cargs[1].value = (XtArgVal) last;
  if (cw->cpick.restorelabel) {
    cargs[0].value = (XtArgVal) cw->cpick.restorelabel;
    last = cw->cpick.restore = XtCreateManagedWidget(argv0, commandWidgetClass,
				  cw->cpick.tlevel, cargs, XtNumber(cargs));
    XtAddCallback(cw->cpick.restore, XtNcallback, dorestore, NULL);
  }
  cargs[1].value = (XtArgVal) last;
  if (cw->cpick.oklabel) {
    cargs[0].value = (XtArgVal) cw->cpick.oklabel;
    last = cw->cpick.ok = XtCreateManagedWidget(argv0, commandWidgetClass,
			     cw->cpick.tlevel, cargs, XtNumber(cargs));
    XtAddCallback(cw->cpick.ok, XtNcallback, dook, NULL);
  }
  cw->cpick.dialog = XtCreateManagedWidget(argv0, dialogWidgetClass, cw->cpick.tlevel,
				    dargs, XtNumber(dargs));
  XtUnmanageChild(cw->cpick.dialog);
}

static initPalette(cw)
CpickWidget cw;
{
  unsigned long cells[MAXPIXELS];
  int each;

  if (!XAllocColorCells(XtDisplay(cw), cw->cpick.cmap, FALSE, NULL, 0,
			cells, cw->cpick.nearpixels)) {
    printf("Can't allocate %d cells for palette.\n", cw->cpick.nearpixels);
    exit(1);
  }
  for (each=0; each<cw->cpick.nearpixels; each++) {
    cw->cpick.nearcells[each].pixel = cells[each];
    cw->cpick.nearcells[each].flags = DoRed | DoGreen | DoBlue;
  }
  changePalette(cw, TRUE);
}

static changePalette(cw, new)
CpickWidget cw;
Boolean new;
{
  int each, each2, r, g, b, nr, ng, nb, eachr, eachg, eachb;
  int delta, halfr, halfg, halfb, num, near;
  double hueinc;
  RGB rgb;
  HSV hsv;
  int mods[MAXPIXELS][3], nummods;
  float hue[MAXPIXELS], temp;

  if (cw->cpick.keep) {
    cw->cpick.keep = FALSE;
  } else {
    if (cw->cpick.wide == NARROW) {
      halfr = halfg = halfb = cw->cpick.nearpixels/2;
      r = (cw->cpick.allocated)->red;
      g = (cw->cpick.allocated)->green;
      b = (cw->cpick.allocated)->blue;

      for (each=0; each<cw->cpick.nearpixels/2; each++) {
	if (r-halfr*NARROWNEAR < 0)
	  halfr--;
	if (r+(cw->cpick.nearpixels-1-halfr)*NARROWNEAR >= MAXIMUM)
	  halfr++;
	if (g-halfg*NARROWNEAR < 0)
	  halfg--;
	if (g+(cw->cpick.nearpixels-1-halfg)*NARROWNEAR >= MAXIMUM)
	  halfg++;
	if (b-halfb*NARROWNEAR < 0)
	  halfb--;
	if (b+(cw->cpick.nearpixels-1-halfb)*NARROWNEAR >= MAXIMUM)
	  halfb++;
      }

      halfb = halfg = halfr = (halfr+halfg+halfb)/3;
      for (each=0; each<cw->cpick.nearpixels; each++) {
	nr = r+(each-halfr)*NARROWNEAR;
	ng = g+(each-halfg)*NARROWNEAR;
	nb =  b+(each-halfb)*NARROWNEAR;
	if (nr < 0)
	  nr = 0;
	if (ng < 0)
	  ng = 0;
	if (nb < 0)
	  nb = 0;
	if (nr >= MAXIMUM)
	  nr = MAXIMUM-1;
	if (ng >= MAXIMUM)
	  ng = MAXIMUM-1;
	if (nb >= MAXIMUM)
	  nb = MAXIMUM-1;
	cw->cpick.nearcells[each].red = nr;
	cw->cpick.nearcells[each].green = ng;
	cw->cpick.nearcells[each].blue = nb;
      }
      XStoreColors(XtDisplay(cw), cw->cpick.cmap, cw->cpick.nearcells,
		   cw->cpick.nearpixels);
    } else if (cw->cpick.wide == WIDE) {
      near = WIDENEAR;
      delta = (int) exp(log((double) cw->cpick.nearpixels)/3.0);
      halfr = halfg = halfb = delta/2;

      r = (cw->cpick.allocated)->red;
      g = (cw->cpick.allocated)->green;
      b = (cw->cpick.allocated)->blue;

      for (each=0; each<delta/2; each++) {
	if (r-halfr*near < 0)
	  halfr--;
	if (r+(delta-1-halfr)*near >= MAXIMUM)
	  halfr++;
	if (g-halfg*near < 0)
	  halfg--;
	if (g+(delta-1-halfg)*near >= MAXIMUM)
	  halfg++;
	if (b-halfb*near < 0)
	  halfb--;
	if (b+(delta-1-halfb)*near >= MAXIMUM)
	  halfb++;
      }

      nummods = 0;
      for (eachb=0; eachb<delta; eachb++) {
	for (eachg=0; eachg<delta; eachg++) {
	  for (eachr=0; eachr<cw->cpick.nearpixels/(delta*delta); eachr++) {
	    mods[nummods][R] = eachr-halfr;
	    mods[nummods][G] = eachg-halfg;
	    mods[nummods][B] = eachb-halfb;
	    nummods++;
	  }
	}
      }
      for (each=0; each<nummods-1; each++) {
	for (each2=each+1; each2<nummods; each2++) {
	  if (mods[each][R]+mods[each][G]+mods[each][B] >
	      mods[each2][R]+mods[each2][G]+mods[each2][B]) {
	    eachr = mods[each][R];
	    eachg = mods[each][G];
	    eachb = mods[each][B];
	    mods[each][R] = mods[each2][R];
	    mods[each][G] = mods[each2][G];
	    mods[each][B] = mods[each2][B];
	    mods[each2][R] = eachr;
	    mods[each2][G] = eachg;
	    mods[each2][B] = eachb;
	  }
	}
      }

      for (each=0; each<nummods; each++) {
	cw->cpick.nearcells[each].red = r+mods[each][R]*near;
	cw->cpick.nearcells[each].green = g+mods[each][G]*near;
	cw->cpick.nearcells[each].blue = b+mods[each][B]*near;
      }
      XStoreColors(XtDisplay(cw), cw->cpick.cmap, cw->cpick.nearcells,
		   cw->cpick.nearpixels);
    } else if (new) {
      hueinc = 1.0/cw->cpick.nearpixels;
      hsv.s = hsv.v = 1.0;
      hsv.h = 0.0;
      for (each=0; each<cw->cpick.nearpixels; each++) {
	rgb = HSVToRGB(hsv);
	cw->cpick.nearcells[each].red = rgb.r;
	cw->cpick.nearcells[each].green = rgb.g;
	cw->cpick.nearcells[each].blue = rgb.b;
	hsv.h = hsv.h + hueinc;
      }
      XStoreColors(XtDisplay(cw), cw->cpick.cmap, cw->cpick.nearcells,
		   cw->cpick.nearpixels);
    }
  }
}

static dopalette(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  CpickWidget cw;

  cw = (CpickWidget) XtParent(XtParent(cmd));

  cw->cpick.wide = (cw->cpick.wide+1) % (RANGE+1);
  if (cw->cpick.wide == NARROW) {
    plabelargs[0].value = (XtArgVal) "wide";
  } else if (cw->cpick.wide == WIDE) {
    plabelargs[0].value = (XtArgVal) "range";
  } else {
    plabelargs[0].value = (XtArgVal) "narrow";
  }
  XtSetValues(cw->cpick.palette, plabelargs, XtNumber(plabelargs));
  changePalette(cw, TRUE);
}

static createPalette(cw)
CpickWidget cw;
{
  nargs[0].value = (XtArgVal) XWhitePixel(XtDisplay(cw),
					  XDefaultScreen(XtDisplay(cw)));
  nargs[1].value = (XtArgVal) cw->cpick.box;
  nargs[2].value = (XtArgVal) cw->cpick.box;
  cw->cpick.nlevel = XtCreateManagedWidget(argv0, formWidgetClass,
				 cw->cpick.tlevel, nargs, XtNumber(nargs));
  XtAddEventHandler(cw->cpick.nlevel, ExposureMask, TRUE, exposeHandler, NULL);

  pargs[1].value = (XtArgVal) cw->cpick.box;
  pargs[2].value = (XtArgVal) cw->cpick.hex;
  cw->cpick.wide = RANGE;
  cw->cpick.keep = FALSE;
  cw->cpick.palette = XtCreateManagedWidget(argv0, commandWidgetClass,
					    cw->cpick.tlevel, pargs,
					    XtNumber(pargs));
  XtAddCallback(cw->cpick.palette, XtNcallback, dopalette, NULL);
}

static void Initialize( request, new )
   Widget request;		/* what the client asked for */
   Widget new;			/* what we're going to give him */
{
  static Arg args[] = {
    {XtNbackground, NULL},
  };
  int each, depth;
  unsigned int ignore;

  CpickWidget cw = (CpickWidget) new;

  if (cw->cpick.nearpixels == NULL)
    cw->cpick.nearpixels = NEARPIXELS;

  cw->cpick.tlevel = XtCreateManagedWidget(argv0, formWidgetClass,
					   cw, NULL, 0);

  depth = XDisplayPlanes(XtDisplay(cw),
			 XDefaultScreen(XtDisplay(cw)));
  cw->cpick.max = 1;
  for (each=0; each<depth; each++) {
    cw->cpick.max = cw->cpick.max*2;
  }
  cw->cpick.ratio = MAXIMUM/cw->cpick.max;
  cw->cpick.inc = INCREMENT/cw->cpick.ratio;
  if (!cw->cpick.inc)
    cw->cpick.inc = 1;

  cw->cpick.box = NULL;
  createSlides(cw, argv0);

  createBox(cw, argv0);

  createCommands(cw);

  createPalette(cw);
  initPalette(cw);

  if (cw->cpick.allocated == NULL) {
    printf("Must set XtNallocated resource.\n");
    exit(1);
    doselect(cw->cpick.select0, NULL, NULL);
  } else {
    doNew(cw);
  }

  if (cw->core.width == 0)
    cw->core.width = DEFAULTWIDTH;
  if (cw->core.height == 0)
    cw->core.height = DEFAULTHEIGHT;
}
