/*
 * pixedit.c - Pixel color editor for X11
 * 
 * Author:	Mike Yang
 * 		Western Research Laboratory
 *	 	Digital Equipment Corporation
 * Date:	Mon Aug 9 1988
 * Copyright (c) 1988 Mike Yang
 */

#include <stdio.h>
#include <math.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Form.h>
#include "Cpick.h"
#include <X11/cursorfont.h>

XColor allocated, current;
Widget realtop, toplevel, cpick;
XColor mapv[MAXPIXELS];
Colormap cmap;
Boolean picking;
int maxpixels, numpixels, numfree, realfree;
unsigned long avail[MAXPIXELS], got[MAXPIXELS];
char *argv0;

typedef unsigned long (*PixProc)();

struct vals {
  int ih, iw, x0, y0, rownum;
  PixProc pix;
} gval, nval;

Arg gargs[] = {
  {XtNborderColor, NULL},
  {XtNheight, 1},
  {XtNwidth, 1},
  {XtNfromHoriz, NULL},
  {XtNfromVert, NULL},
  {XtNhorizDistance, (XtArgVal) 0},
  {XtNvertDistance, (XtArgVal) 0},
};

Arg setargs[] = {
  {XtNallocated, (XtArgVal) &allocated},
};

int get(w, s)
Widget w;
String s;
{
  int result;
  Arg args[1];

  XtSetArg(args[0],s,(XtArgVal) &result);
  XtGetValues(w, args, XtNumber(args));

  return(result);
}

saveCurrent()
{
  current.red = allocated.red;
  current.green = allocated.green;
  current.blue = allocated.blue;
  XStoreColor(XtDisplay(toplevel), cmap, &current);
}

restoreCmap()
{
  Display *dpy;
  int screen, each, each2, count;
  Boolean found;
  XColor copy[MAXPIXELS];

  dpy = XtDisplay(toplevel);
  screen = XDefaultScreen(XtDisplay(toplevel));

  count = 0;
  for (each=0; each<numpixels; each++) {
    found = FALSE;
    for (each2=0; (each2<=realfree) && !found; each2++) {
      if (avail[each2] == got[each])
	found = TRUE;
    }
    if (!found)
      copy[count++] = mapv[got[each]];
  }

  XStoreColors(dpy,cmap,copy,count);
  XInstallColormap(dpy,cmap);

  XStoreColors(dpy,cmap,copy,count);
  XInstallColormap(dpy,cmap);
}

doSelect(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  Window chosen, ignorew, last;
  int ignore;
  XEvent ev;
  int x, y;

  printf("Click on a pixel to edit...\n");
  picking = TRUE;
  XGrabPointer(XtDisplay(toplevel),
	       XRootWindowOfScreen(XDefaultScreenOfDisplay(XtDisplay(toplevel))),
	       FALSE,
	       ButtonPressMask,
	       GrabModeAsync,
	       GrabModeSync,
	       None,
	       XCreateFontCursor(XtDisplay(toplevel), XC_crosshair),
	       CurrentTime);

  XMaskEvent(XtDisplay(toplevel), ButtonPressMask, &ev);
  if (ev.type != ButtonPress) {
    printf("Impossible.\n");
    exit(1);
  }
  last = XDefaultRootWindow(XtDisplay(toplevel));
  chosen = last;
  while (chosen != None) {
    XQueryPointer(XtDisplay(toplevel), last,  &ignorew, &chosen,
		  &ignore, &ignore, &ignore, &ignore, &ignore);
    if (chosen != None)
      last = chosen;
  }
  XUngrabPointer(XtDisplay(toplevel), CurrentTime);
  if (!cpick)
    createCpick(last);
  if (picking) {
    x = ((XButtonEvent *) &ev)->x_root;
    y = ((XButtonEvent *) &ev)->y_root;
    current.pixel = XGetPixel(XGetImage(XtDisplay(toplevel), 
					XRootWindowOfScreen(XDefaultScreenOfDisplay(XtDisplay(toplevel))),
					x, y, 1, 1,
					512-1 /* yuck dependency */, ZPixmap),
			      0, 0);
    XQueryColor(XtDisplay(toplevel), cmap, &current);
    allocated.red = current.red;
    allocated.green = current.green;
    allocated.blue = current.blue;
    XSync(XtDisplay(toplevel), 0);
  }
  if (picking) {
    /* generates error if can't allocate */
    XStoreColor(XtDisplay(toplevel), cmap, &current);
    XSync(XtDisplay(toplevel), 0);
    if (picking) {
      XtSetValues(cpick, setargs, XtNumber(setargs));
      picking = FALSE;
    } else {
      doSelect(cmd, cdata, position);
    }
  } else {
    doSelect(cmd, cdata, position);
  }
}

doOk(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  restoreCmap();
  exit(0);
}

doChange(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  saveCurrent();
}

doRestore(cmd, cdata, position)
     Widget cmd;
     caddr_t cdata;
     float position;
{
  restoreCmap();
  XQueryColor(XtDisplay(toplevel), cmap, &current);
  allocated.red = current.red;
  allocated.green = current.green;
  allocated.blue = current.blue;
  XtSetValues(cpick, setargs, XtNumber(setargs));
}

int createCmap(num, wcmap, visual)
int num;
Colormap wcmap;
Visual *visual;
{
  Display *dpy;
  int screen, each, real;
  XSetWindowAttributes xswa;

  real = num;

  dpy = XtDisplay(toplevel);
  screen = XDefaultScreen(XtDisplay(toplevel));

  for (each=0; each<maxpixels; each++) {
    mapv[each].pixel = each;
    mapv[each].flags = (DoRed | DoGreen | DoBlue);
  }
  XQueryColors(dpy, wcmap, mapv, numpixels);

  while ((real > 1) &&
	 (!XAllocColorCells(dpy, wcmap, FALSE, NULL, 0, avail,
			    real+1))) {
    real = real*3/4;
  }

  if (real <= 1) {
    printf("Sorry, can't allocate enuf colormap cells.\n");
    exit(1);
  }

  cmap = XCreateColormap(dpy, XRootWindow(dpy,screen),
			 visual, AllocNone);

  XAllocColorCells(dpy, cmap, FALSE, NULL, 0, got, numpixels);
  XStoreColors(dpy,cmap,mapv,numpixels);
  XFreeColors(dpy, cmap, avail, real-1, 0);
  allocated = mapv[avail[real-1]];

  XInstallColormap(dpy,cmap);

  return real;
}

errorHandler(dpy, event)
Display *dpy;
XErrorEvent *event;
{
  char buf[256];

  if ((event->error_code == BadAccess) || (event->request_code == 91)) {
    printf("Can't allocate that colormap cell.  Pick another.\n");
    picking = FALSE;
  } else {
    XGetErrorText(dpy, event->error_code, buf, 256);
    printf("X protocol error detected by server: %s\n", buf);
    printf("  Failed request major op code %d\n", (int) event->request_code);
    exit(1);
  }
}

createCpick(win)
Window win;
{
  static Arg args[] = {
    {XtNcmap, NULL},
    {XtNuseColors, TRUE},
    {XtNnearPixels, NULL},
    {XtNallocated, (XtArgVal) &allocated},
    {XtNfromHoriz, NULL},
    {XtNfromVert, NULL},
    {XtNhorizDistance, (XtArgVal) 0},
    {XtNvertDistance, (XtArgVal) 0},
    {XtNokLabel, (XtArgVal) "quit"},
  };
  
  XVisualInfo *vip, viproto;
  XWindowAttributes xwa;
  int nvi;

  XGetWindowAttributes(XtDisplay(toplevel), win, &xwa);
  viproto.visual = xwa.visual;
  vip = XGetVisualInfo(XtDisplay(toplevel), VisualNoMask, &viproto, &nvi);
  if (vip->class != PseudoColor) {
    printf("Sorry, that window doesn't have a colormap to edit.  Pick another.\n");
    picking = FALSE;
  } else {
    numpixels = vip->colormap_size;
    XFree(vip);
    maxpixels = 1;
    while (maxpixels < numpixels) {
      maxpixels = maxpixels*2;
    }
    
    if (numpixels < 11) {
      printf("Sorry, you don't have enough colormap cells.\n");
      exit(1);
    } else if (numpixels < 58) {
      args[1].value = (XtArgVal) FALSE;
      args[2].value = (XtArgVal) 9;
      numfree = 9;
    } else if (numpixels < 136) {
      args[1].value = (XtArgVal) TRUE;
      args[2].value = (XtArgVal) 25;
      numfree = 8+25;
    } else {
      args[1].value = (XtArgVal) TRUE;
      args[2].value = (XtArgVal) 64;
      numfree = 8+64;
    }
    
    realfree = createCmap(numfree, xwa.colormap, xwa.visual);
    
    args[0].value = (XtArgVal) cmap;
    if (realfree != numfree)
      if (args[1].value == (XtArgVal) TRUE)
	args[2].value = (XtArgVal) 8+realfree;
      else
	args[2].value = (XtArgVal) 8+realfree;
    
    cpick = XtCreateManagedWidget(argv0, cpickWidgetClass,
				  toplevel, args, XtNumber(args));
    XtAddCallback(cpick, XtNselectProc, doSelect, NULL);
    XtAddCallback(cpick, XtNokProc, doOk, NULL);
    XtAddCallback(cpick, XtNchangeProc, doChange, NULL);
    XtAddCallback(cpick, XtNrestoreProc, doRestore, NULL);
    
    XtManageChild(cpick);
    XtRealizeWidget(realtop);
  
  }
}

main(argc, argv)
    int argc;
    char **argv;
{
  int each;
  
  argv0 = argv[0];
  allocated.flags = current.flags = DoRed | DoGreen | DoBlue;
  
  realtop = XtInitialize(argv[0], "PixEdit", NULL, 0, &argc, argv);
  toplevel = XtCreateManagedWidget(argv[0], formWidgetClass,
				   realtop, NULL, 0);
  
/*  why does this core dump?
  if (XPlanesOfScreen(XDefaultScreen(XDefaultScreenOfDisplay(XtDisplay(toplevel)))) == 1) {
    printf("Sorry, you need a color display.\n");
    exit(1);
  }
*/
  if (XDisplayPlanes(XtDisplay(toplevel),
		     XDefaultScreen(XtDisplay(toplevel))) == 1) {
    printf("Sorry, you need a color display.\n");
    exit(1);
  }

  XSetErrorHandler(errorHandler);
  
  doSelect(cpick, NULL, NULL);

  XtMainLoop();
}
