/*
.nf
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */

/*
 * AsciiLoad.c  -- load ascii widget hierarchies from disk
 *
 *  This software provides ascii pickling of widgets.
 *  Ascii Loading is SLOWWW...........
 *  Binary pickling would speed loading up, binary loading from a single
 *  archive file would speed it up even more. Binary pickling and unpickling
 *  has not been written at this time.
 *     (it still hasn't been written 8-21-88).
 *
 *	author: Richard Carling	11/11/87
 */

/*
 * AsciiSave.c  -- save ascii widget hierarchies to disk
 *
 *  Binary representations may be supported sometime
 *  in the future and will provide higher performance loading.
 *  The binary pickling requires a Widget Editor, which is
 *  not going to be available for a month or so, and so will
 *  not be on the tape.
 *
 *	author: Richard Carling	4/4/88
 */


#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/LabelP.h>
#include <X11/CommandP.h>
#include <X11/BoxP.h>
#include "XwP.h"
#include "DLLabelP.h"
#include "DLCommandP.h"
#include "DLObedientP.h"
#include "Fileio.h"

#define SUCCESS	1
#define FAIL	0

extern char *loadpath;
extern int Local_Directory;
extern char directory_name[256];
extern char default_path[256];
extern char directory[256];


extern WidgetClass labelWidgetClass;
extern WidgetClass commandWidgetClass;
extern WidgetClass boxWidgetClass;
extern WidgetClass DLcommandWidgetClass;
extern WidgetClass DLlabelWidgetClass;
extern WidgetClass DLobedientWidgetClass;
extern WidgetClass xwWidgetClass;

/* some useful macro's */

/*
#define XtIsComposite(widget)	\
		XtIsSubclass( widget, (WidgetClass) compositeWidgetClass )
*/
#define XtIsButtonBox(widget)	\
		XtIsSubclass( widget, (WidgetClass) boxWidgetClass )

#define XtIsCommand(widget)	\
		XtIsSubclass( widget, (WidgetClass) commandWidgetClass )
		
#define XtIsXw(widget)	\
		XtIsSubclass( widget, (WidgetClass) xwWidgetClass )
		
#define XtIsLabel(widget)	\
		XtIsSubclass( widget, (WidgetClass) labelWidgetClass )
		
#define XtIsDLLabel(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLlabelWidgetClass )
		
#define XtIsDLObedient(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLobedientWidgetClass )
		
#define XtIsDLCommand(widget)	\
		XtIsSubclass(widget, (WidgetClass) DLcommandWidgetClass)

static char window_name[256];
		
ascii_save_primary_widget( widget )  Widget widget;
{   
	char Name[128];
	FILE *fp, *fopen();

	/* Widget MUST be a primary level widget!!! */
	
	/* open widget file */

	fp = NULL;

	if (Local_Directory) strcpy( directory, loadpath);
	else strcpy( directory, default_path);
	sprintf( window_name, widget->core.name);
	sprintf( directory_name,"%s/%s",directory,window_name);  
	sprintf( Name,"%s/%s", directory_name, widget->core.name);
	fp = fopen( Name, "w" );
	if (!fp) mkdir( directory_name, 0777);
	fclose( fp );
	ascii_save_internal_widget( widget );
}

ascii_save_internal_widget( widget )  Widget widget;
{   
	Cardinal i; int children;
	Widget get_primary_widget();
	CompositeWidget cw;
	FILE *fp, *fopen();
	char *ftn_name, *RetrieveFtnName();
	char Name[128], msg[256];
	DLLabelWidget DLlbw;
	DLCommandWidget DLcbw; 
	DLObedientWidget DLobw;
	LabelWidget lbw;

	printf("saving widget %s to disk in %s/%s\n", widget->core.name, directory, window_name );
	sprintf( Name,"%s/%s/%s", directory, window_name, widget->core.name);
	
	fp = fopen(Name,"w");
	if (!fp) 
	{	
		sprintf(msg,"ascii_save_widget(%s):can't open %s",
				widget->core.name,Name);
		fprintf( stderr, msg );
		return FAIL; 
	}

/*	obj->type &= ~MODIFIED;   need a marker like this, perhaps part of
					being edited!! */

	/* 
 	 * save essential widget information 
	 */
	 
	if ( XtIsButtonBox(  widget ) ) fprintf( fp, "class: button\n");
	if ( XtIsDLObedient( widget ) ) fprintf( fp, "class: dlobedient\n" );
	if ( XtIsDLCommand(  widget ) ) fprintf( fp, "class: dlcommand\n" );
	if ( XtIsXw (        widget ) ) fprintf( fp, "class: Xwindow\n");
	if ( XtIsDLLabel(    widget ) ) fprintf( fp, "class: dllabel\n" );
	if ( XtIsCommand(    widget ) ) fprintf( fp, "class: command\n" );
	if ( XtIsLabel(      widget ) ) fprintf( fp, "class: label\n" );
	/* add additional classes here... */

	fprintf( fp, "x: %d\n", widget->core.x );
	fprintf( fp, "y: %d\n", widget->core.y );
	fprintf( fp, "width: %d\n", widget->core.width );
	fprintf( fp, "height: %d\n", widget->core.height );
	    
	/* if a standard command or label (not a display list based) widget */
	    
	if (XtIsLabel( widget )) {
		lbw = (LabelWidget) widget;
		fprintf( fp, "label: %s\n", lbw->label.label );
	}
	/*
	 * if a command widget, save the callback list
	 */
	 if (XtIsCommand( widget) || XtIsDLCommand( widget ))
	/*     while (ftn_name = RetrieveNextFtnName( widget )) loops 00 */
	       if (ftn_name = RetrieveFtnName( widget )) {
	           fprintf( fp, "callback: %s\n", ftn_name );
	       }
	/*
	 * save display list information for the widget's which support them
	 */

	if (XtIsDLObedient( widget )) {
		DLobw = (DLObedientWidget) widget;
		fprintf( fp, "displaylist:\n");
		save_ascii_display_list( fp, DLobw->obedient.DL );
	}
	if (XtIsDLCommand( widget )) {
		DLcbw = (DLCommandWidget) widget;
		fprintf( fp, "displaylist:\n");
		save_ascii_display_list( fp, DLcbw->command.DL );

printf("Not saving ADDITIONAL display lists, not currently supported\n");

	/* terrible hack, for now we just save the display list 3 times for command's */

		fprintf( fp, "set_displaylist:\n");
	/*	save_ascii_display_list( fp, DLcbw->command.setDL );  */
		save_ascii_display_list( fp, DLcbw->command.DL );

		fprintf( fp, "highlighted_displaylist:\n");
	/*	save_ascii_display_list( fp, DLcbw->command.highlightedDL );  */
		save_ascii_display_list( fp, DLcbw->command.DL );

	}
	
	if (XtIsDLLabel( widget )) {
		DLlbw = (DLLabelWidget) widget;
		fprintf( fp, "displaylist:\n");
		save_ascii_display_list( fp, DLlbw->label.DL );
	}


	/* if there are any objects below us in the heirarchy, save them */

	if (!XtIsComposite( widget )) { fclose( fp ); return SUCCESS; } /* don't bother if not a composite widget */
	
	children = FALSE;
	cw = (CompositeWidget) widget;
	
	for ( i=0; i< cw->composite.num_children; i++) 
	{	
		widget = cw->composite.children[i];
		if (widget) children = TRUE;
	}
	/* save the names of the children */

	for ( i=0; i< cw->composite.num_children; i++) 
	{	
		widget = cw->composite.children[i];
		if (widget) fprintf( fp, "child: %s\n", widget->core.name );
	}
	fprintf( fp, "end\n");
	fclose ( fp );
	
	/* now recursively save the children */
	
	for ( i=0; i< cw->composite.num_children; i++) 
	{	
		widget = cw->composite.children[i];
		if (widget) ascii_save_internal_widget( widget );
	}
	return SUCCESS;
}


