/*
.nf
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		      Author:  Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP. MASSCOMP MAKES
 * NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
 * PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 *
 */


#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include "DLLabelP.h"


/*
 *  stuff for handling Display Lists 
 */

extern GC GlobalGC;
extern GC GlobalGrayGC;
extern Pixmap GlobalGrayPixmap;


/*
 * class record values
 */

static void Initialize();
static void Realize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();

DLLabelClassRec DLlabelClassRec = {
    {
		/* core_class fields */	
	
	(WidgetClass) &widgetClassRec, /* superclass */
	"DLLabel",		/* class name */
	sizeof(DLLabelRec),	/* widget size */
	ClassInitialize, /* class initialized rtn */
	NULL,		/* class part initialize */
	FALSE,		/* class initialized flag */
	Initialize,	/* instance initialize rtn */
	NULL,		/* initialize hook */
	Realize,	/* realize rtn */
	NULL,		/* action list */
	0,		/* number of actions */
	NULL,		/* resource list */
	0,		/* number of resources */
	NULLQUARK,	/* xrm class? */
	TRUE,		/* compress motion events */
	TRUE,		/* compress exposure events */
	TRUE,		/* compress enterleave */
	FALSE,		/* visible interest */
	NULL,		/* instance destroy rtn */
	Resize,		/* instance resize rtn */
	Redisplay,	/* instance redisplay rtn */
	SetValues,	/* instance set values rtn */
	NULL,		/* set values hook */
	XtInheritSetValuesAlmost,    /* set_values_almost */
	NULL,		/* get values hook */
	NULL,		/* accept focus */
	XtVersion,	/* version */
	NULL,		/* callback private */
	NULL,		/* tm_table */
	NULL,		/* query_geometry */
    }
};

#define IsSensitive(w)	((w)->core.sensitive && (w)->core.ancestor_sensitive)

WidgetClass DLlabelWidgetClass = (WidgetClass)&DLlabelClassRec;

/*
 *
 * Private Procedures
 *
 */



static void ClassInitialize()
{
}


static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
{
    DLLabelWidget lw = (DLLabelWidget) new;

    lw->label.DLSize = 0;
    lw->label.DL = NULL;
}

static void Realize(w, valueMask, attributes)
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
    DLLabelWidget lw = (DLLabelWidget)w;


    XtCreateWindow( w, (unsigned int)InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes );
}

/*
 * Resize the widgets display list
 */

static void Resize( lw )
DLLabelWidget lw;
{
	/* resize our displaylist, if we have one */
	
	if (lw->label.DL)
		resize_display_list( lw->label.DL, lw->core.x, lw->core.y, 
			lw->core.width,  lw->core.height);
}

/*
 * Repaint the widget window
 */


static void Redisplay( w, event, region )
Widget w;
XEvent *event;
Region region;	/* unused */
{
   DLLabelWidget lw = (DLLabelWidget) w;

   if (lw->label.DLSize > 0)
	draw_display_list( XtDisplay(w), XtWindow(w),
		IsSensitive(lw) ? GlobalGC : GlobalGrayGC,
					lw->label.DL );
}


/*
 * Set specified arguments into widget
 */

static Boolean SetValues( current, request, new )
Widget current, request, new;
{
	DLLabelWidget curlw = (DLLabelWidget) current;
	DLLabelWidget newlw = (DLLabelWidget) new;

	/*
	 * we are not handling any really useful ones rightnow.
	 * In particular, setting a new label value in the
	 * display list should be added soon
 	 */
	
	if ((curlw->core.sensitive != newlw->core.sensitive ||
	 curlw->core.ancestor_sensitive != newlw->core.ancestor_sensitive)
	&& XtIsRealized(newlw)) {
		if (IsSensitive(newlw))
			XSetWindowBorder( XtDisplay(newlw), XtWindow(newlw), 
			      newlw->core.border_pixel );
		else
			XSetWindowBorderPixmap(XtDisplay(newlw),
				XtWindow(newlw), GlobalGrayPixmap);
		return True;
	}
	return False;
}
