/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */

/*
 *	user interface support for paint via X11 Toolkit
 */


#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

extern Window work_area_window;
extern Widget workarea;
	
extern int max_colors;
extern int color_display;
extern int cur_color;
extern GC gc;

Widget XtInitialize();

extern void line_cmd();
extern void rectangle_cmd();
extern void filled_rectangle_cmd();
extern void exit_cmd();

/*
	top_level_window is the window the application wants
	the XToolkit to view as the top level rootWindow
 */

load_uims( toplevel )
Widget toplevel;
{
    Widget ascii_load_widgets();
    unsigned int mask;

    /*
     * register all our exposed (to the user interface, e.g. XToolkit)
     * routines from the application
     */
    
    XtRegisterFtn( line_cmd, "line_cmd" );
    XtRegisterFtn( rectangle_cmd, "rectangle_cmd" );
    XtRegisterFtn( filled_rectangle_cmd, "filled_rectangle_cmd" );
    XtRegisterFtn( exit_cmd, "exit_cmd" );
    
    /* this tells the toolkit which directory the widgets are in */
    
    XtUseDirectory( "./widgets" );
    
    /* now load our user interface from disk */
				
    if (toplevel) {
	ascii_load_widgets( "obedient", toplevel );
	XtRealizeWidget( toplevel );
    } else {
	fprintf(stderr, "No TopLevel Widget passed to load_uims();\n");
	exit();
    }
    /*
     * here we use a private routine to get our event mask, 
     * 	expose it you guys (or give us a replacement)
     */
    mask = XtBuildEventMask( toplevel ); 
    XFlush( XtDisplay( toplevel ) );
    return mask;
}

#define BXWD		40
#define BXHT		20
#define SELECTION_HT	20
static int vlt_rows = 4;

void color_handler( w, closure, event ) 
Widget w; caddr_t closure; XEvent *event;
{
    int i, x, y, col, row, index;
    Display *display; Window window;
    
    display = XtDisplay( w );
    window = XtWindow( w );
    
    vlt_rows = (w->core.height - SELECTION_HT) / BXHT;
    if (vlt_rows <= 1) vlt_rows = 1;
    if (event->type == Expose) {
	for (i=0; i< max_colors; i++) {
		XSetForeground( display, gc, i );
		XFillRectangle( display, window, gc, 
			/* X integer truncate in X down the column */
			/* Y advances for each value then modulo's to top */
    			BXWD*(i/vlt_rows), SELECTION_HT + BXHT*(i%vlt_rows),
					BXWD, BXHT);
	}
        XSetForeground( display, gc, cur_color );
	XFillRectangle( display, window, gc,
			0, 0, w->core.width, SELECTION_HT );
	
    }
    if (event->type == ButtonRelease) {
	x = event->xbutton.x;
	y = event->xbutton.y;
	y -= SELECTION_HT;
	if (y < 0) {
		cur_color++;
		if (cur_color > max_colors) cur_color = 0;
	} else {
		
		row = y / BXHT;
		col = x / BXWD;
		index = row + col * vlt_rows;
		if (cur_color > max_colors) cur_color = 0;
		else cur_color = index;
		printf(" x:%d, y:%d, col:%d, row:%d, index:%d, color:%d\n",
				x, y, col, row, index, cur_color );
	}
        XSetForeground( display, gc, cur_color );
	XFillRectangle( display, window, gc,
			0, 0, w->core.width, SELECTION_HT );
    }
}



