.\" This man page was written by Dan Heller <island!argv@sun.com>
.\" or <dheller@ucbcory.berkeley.edu>
.TH WidgetWrap 3X "" "1 March 1988" "X Version 11" 
.SH NAME
WidgetCreate, WidgetSet, WidgetGet \- programmer's convenience routines
.SH SYNTAX
WidgetCreate\^(\fIname\fP\^, \fIclass\fP\^, \fIparent\fP\^, \fIvarargs\fP)
.br
      char *\fIname\fP\^;
.br
      WidgetClass \fIclass\fP\^;
.br
      Widget \fIparent\fP\^;
.LP
WidgetSet\^(\^\fIwidget\fP, \fIvarargs\fP\^)
.br
      Widget *\fIwidget\fP\^;
.LP
WidgetGet\^(\^\fIwidget\fP, \fIvarargs\fP\^)
.br
      Widget *\fIwidget\fP\^;
.LP
char *
GenericWidgetName\^(\^\fIbuf\fP)
.br
      char *\fIbuf\fP\^;
.SH ARGUMENTS
.IP \fIbuf\fP 1i
Buffer to place new widget name.
.IP \fIclass\fP 1i
The class of the widget to be created.
.IP \fIname\fP 1i
The name of the widget when created.
.IP \fIparent\fP 1i
The parent of the widget to be created.
.IP \fIwidget\fP 1i
The widget to set or get attributes.
.SH DESCRIPTION
.ds WC .PN WidgetCreate
The purpose of these functions is to allow the programmer to create
widgets and set and get widget attributes via a variable argument list
style of function call.  This eliminates the need for many local
variables and bothersome XtSetArg() calls and so forth.  An example
of usage:
.sp
.in +2
.nf
Widget foo;
.sp
foo = WidgetCreate("foo", labelWidgetClass, toplevel,
.in +2
XtNlabel,           "Widget",
XtNforeground,      WhitePixelOfScreen(XtScreen(toplevel)),
XtNbackground,      BlackPixelOfScreen(XtScreen(toplevel)),
XtNborderWidth,     1,
NULL);
.sp
.fi
.in -4
As you can see, the list must be NULL terminated.  You may pass up to
to MAXARGS argument pairs (which is defined in WidgetWrap.h).  There are
special args available to the Create/Get/Set functions that are available:
.sp
.in +2
XtNmanaged\ \ \ \ pass "False" to create a non-managed widget.
XtNargList\ \ \ \ takes \fItwo\fP parameters.
.in -2
.sp
The XtNargList makes it possible to pass attributes to the Create/Get/Set
calls that are probably common to many widgets to be created or reset.
.sp
.in +2
.nf
static Arg args[] = {
.in +2
XtNforeground,   black,
XtNbackground,   white,
XtNwidth,        20,
XtNheight,       10,
.ti -2
};
.sp
.ti -2
foo = WidgetCreate(NULL, widgetClass, toplevel,
XtNargList,      args, XtNumber(args),
NULL);
.in -4
.fi
.sp
Most large applications will create huge numbers of widgets which the
programmer has to think up unique names for all of them.  What's more,
typically, as noted by the examples above, the names are constant strings
which takes up memory, disk spaces, etc...  So, if WidgetCreate() gets
NULL as the name of the widget, then a widget name will be created
automatically by calling GenericWidgetName() since most of the time,
user's don't care what the name of a widget is, this capability is available.
.SH DIAGNOSTICS
WidgetCreate() will return NULL if a widget cannot be created.  It uses
the routines (and is a front end for) XtCreateWidget() and
XtCreateManagedWidget().
.SH "SEE ALSO"
XtCreateWidget(3X),
XtCreateManagedWidget(3X),
.br
\fIXlib \- C Language X Interface\fP
