
# line 40 "gram.y"
#include <stdio.h>
#include <ctype.h>
#include "twm.h"
#include "menus.h"
#include "list.h"
#include "util.h"
#include "screen.h"
#include "parse.h"
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>

static char *Action = "";
static char *Name = "";
static MenuRoot	*root, *pull = NULL;

static MenuRoot *GetRoot();

static Bool CheckWarpScreenArg(), CheckWarpRingArg();
static Bool CheckColormapArg();
static void GotButton(), GotKey(), GotTitleButton();
static char *ptr;
static name_list **list;
static int cont = 0;
static int color;
int mods = 0;
unsigned int mods_used = (ShiftMask | ControlMask | Mod1Mask);

extern int do_single_keyword(), do_string_keyword(), do_number_keyword();
extern name_list **do_colorlist_keyword();
extern int do_color_keyword();
extern int yylineno;

# line 73 "gram.y"
typedef union 
{
    int num;
    char *ptr;
} YYSTYPE;
# define LB 257
# define RB 258
# define LP 259
# define RP 260
# define MENUS 261
# define MENU 262
# define BUTTON 263
# define DEFAULT_FUNCTION 264
# define PLUS 265
# define MINUS 266
# define ALL 267
# define OR 268
# define CURSORS 269
# define PIXMAPS 270
# define ICONS 271
# define COLOR 272
# define MONOCHROME 273
# define FUNCTION 274
# define ICONMGR_SHOW 275
# define ICONMGR 276
# define WINDOW_FUNCTION 277
# define ZOOM 278
# define ICONMGRS 279
# define ICONMGR_GEOMETRY 280
# define ICONMGR_NOSHOW 281
# define MAKE_TITLE 282
# define ICONIFY_BY_UNMAPPING 283
# define DONT_ICONIFY_BY_UNMAPPING 284
# define STICKY 285
# define NO_TITLE 286
# define AUTO_RAISE 287
# define NO_HILITE 288
# define ICON_REGION 289
# define META 290
# define SHIFT 291
# define LOCK 292
# define CONTROL 293
# define WINDOW 294
# define TITLE 295
# define ICON 296
# define ROOT 297
# define FRAME 298
# define COLON 299
# define EQUALS 300
# define SQUEEZE_TITLE 301
# define DONT_SQUEEZE_TITLE 302
# define START_ICONIFIED 303
# define NO_TITLE_HILITE 304
# define TITLE_HILITE 305
# define MOVE 306
# define RESIZE 307
# define WAIT 308
# define SELECT 309
# define KILL 310
# define LEFT_TITLEBUTTON 311
# define RIGHT_TITLEBUTTON 312
# define NUMBER 313
# define KEYWORD 314
# define NKEYWORD 315
# define CKEYWORD 316
# define CLKEYWORD 317
# define FKEYWORD 318
# define FSKEYWORD 319
# define SKEYWORD 320
# define DKEYWORD 321
# define JKEYWORD 322
# define PKEYWORD 323
# define WINDOW_RING 324
# define WARP_CURSOR 325
# define ERRORTOKEN 326
# define NO_STACKMODE 327
# define ICON_TITLE 328
# define NO_ICON_TITLE 329
# define STRING 330
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 624 "gram.y"

yyerror(s) char *s;
{
    twmrc_error_prefix();
    fprintf (stderr, "error in input file:  %s\n", s ? s : "");
    ParseError = 1;
}
RemoveDQuote(str)
char *str;
{
    register char *i, *o;
    register n;
    register count;

    for (i=str+1, o=str; *i && *i != '\"'; o++)
    {
	if (*i == '\\')
	{
	    switch (*++i)
	    {
	    case 'n':
		*o = '\n';
		i++;
		break;
	    case 'b':
		*o = '\b';
		i++;
		break;
	    case 'r':
		*o = '\r';
		i++;
		break;
	    case 't':
		*o = '\t';
		i++;
		break;
	    case 'f':
		*o = '\f';
		i++;
		break;
	    case '0':
		if (*++i == 'x')
		    goto hex;
		else
		    --i;
	    case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		n = 0;
		count = 0;
		while (*i >= '0' && *i <= '7' && count < 3)
		{
		    n = (n<<3) + (*i++ - '0');
		    count++;
		}
		*o = n;
		break;
	    hex:
	    case 'x':
		n = 0;
		count = 0;
		while (i++, count++ < 2)
		{
		    if (*i >= '0' && *i <= '9')
			n = (n<<4) + (*i - '0');
		    else if (*i >= 'a' && *i <= 'f')
			n = (n<<4) + (*i - 'a') + 10;
		    else if (*i >= 'A' && *i <= 'F')
			n = (n<<4) + (*i - 'A') + 10;
		    else
			break;
		}
		*o = n;
		break;
	    case '\n':
		i++;	/* punt */
		o--;	/* to account for o++ at end of loop */
		break;
	    case '\"':
	    case '\'':
	    case '\\':
	    default:
		*o = *i++;
		break;
	    }
	}
	else
	    *o = *i++;
    }
    *o = '\0';
}

static MenuRoot *GetRoot(name, fore, back)
char *name;
char *fore, *back;
{
    MenuRoot *tmp;

    tmp = FindMenuRoot(name);
    if (tmp == NULL)
	tmp = NewMenuRoot(name);

    if (fore)
    {
	int save;

	save = Scr->FirstTime;
	Scr->FirstTime = TRUE;
	GetColor(COLOR, &tmp->hi_fore, fore);
	GetColor(COLOR, &tmp->hi_back, back);
	Scr->FirstTime = save;
    }

    return tmp;
}

static void GotButton(butt, func)
int butt, func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0)
	    continue;

	Scr->Mouse[butt][i][mods].func = func;
	if (func == F_MENU)
	{
	    pull->prev = NULL;
	    Scr->Mouse[butt][i][mods].menu = pull;
	}
	else
	{
	    root = GetRoot(TWM_ROOT, NULLSTR, NULLSTR);
	    Scr->Mouse[butt][i][mods].item = AddToMenu(root,"x",Action,
		    NULLSTR, func, NULLSTR, NULLSTR);
	}
    }
    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}

static void GotKey(key, func)
char *key;
int func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0) 
	  continue;
	if (!AddFuncKey(key, i, mods, func, Name, Action)) 
	  break;
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}


static void GotTitleButton (bitmapname, func, rightside)
    char *bitmapname;
    int func;
    Bool rightside;
{
    if (!CreateTitleButton (bitmapname, func, Action, pull, rightside, True)) {
	twmrc_error_prefix();
	fprintf (stderr, 
		 "unable to create %s titlebutton \"%s\"\n",
		 rightside ? "right" : "left", bitmapname);
    }
    Action = "";
    pull = NULL;
}

static Bool CheckWarpScreenArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0 ||
	strcmp (s,  WARPSCREEN_BACK) == 0)
      return True;

    for (; *s && isascii(*s) && isdigit(*s); s++) ;
    return (*s ? False : True);
}


static Bool CheckWarpRingArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0)
      return True;

    return False;
}


static Bool CheckColormapArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s, COLORMAP_NEXT) == 0 ||
	strcmp (s, COLORMAP_PREV) == 0 ||
	strcmp (s, COLORMAP_DEFAULT) == 0)
      return True;

    return False;
}


twmrc_error_prefix ()
{
    fprintf (stderr, "%s:  line %d:  ", ProgramName, yylineno);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 14,
	257, 16,
	-2, 18,
-1, 20,
	257, 27,
	-2, 29,
-1, 23,
	257, 34,
	-2, 36,
-1, 24,
	257, 37,
	-2, 39,
-1, 25,
	257, 40,
	-2, 42,
-1, 26,
	257, 43,
	-2, 45,
-1, 27,
	257, 46,
	-2, 48,
-1, 40,
	257, 73,
	-2, 75,
-1, 45,
	257, 155,
	-2, 154,
-1, 46,
	257, 158,
	-2, 157,
-1, 249,
	257, 147,
	-2, 146,
	};
# define YYNPROD 192
# define YYLAST 403
short yyact[]={

   4,  48, 251, 134, 276, 242,  33,  47,  38,  96,
  63,  64,  52,  13,  12,  35,  36,  37,  34,  22,
  65,  39,  11,  21,  10,  20,  29,  14,  19,  32,
  26,  31,  24,   9,  52, 203, 196, 190,  63,  64,
 184, 135, 103, 102, 245,  45,  46,  30,  23,  67,
  48,  48, 237, 238, 258,  15,  16, 273,  42,  44,
 193, 235, 164, 199,  43, 165, 279, 256,  41,  40,
 122,  25,  28,  27,  48, 236,  48,  48,  61, 230,
 231, 232, 233, 234, 228,  18, 262, 263, 268, 167,
 101, 132, 127, 138, 128,  49,  50, 148, 144, 126,
 110,  58,  59,  60,  63,  64, 137,  48,  48,  48,
  56, 143,  48,  63,  64,  48, 105,  87,  88,  82,
  83, 202, 201,  54, 100, 243, 226, 227, 194,  91,
 141, 142, 246, 140,  52, 224, 195, 160,  51, 197,
 168, 145, 146, 147, 149, 150, 185, 160, 151, 225,
 104, 191, 162, 219, 220, 221, 222, 223, 217, 156,
 157, 158, 159,  94, 170,  93, 277, 274, 161, 156,
 157, 158, 159, 267, 259, 200, 169, 139, 154, 129,
  99, 152, 153,  92, 106, 136,  95,  98, 229,  97,
 218, 155, 189, 107, 108, 187, 111, 112, 113, 114,
 115, 116, 117, 118, 119, 120, 121,  90, 163,  89,
  86,  85, 125,  84, 130, 131, 166, 124, 123, 133,
 265,  81,  80, 172,  79,  78, 173, 174, 175, 176,
 177, 178, 179, 180, 181, 182, 183, 186,  77,  76,
  75,  74,  73,  72,  71, 109,  70,  69, 192,  68,
  57,  55,  53,   8, 198,   7, 204,   6,   5, 206,
 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
   3,   2,   1, 171, 247, 239,  66,  62, 240, 241,
 244, 260,  17,   0, 248,   0,   0, 249, 250,   0,
   0,   0,   0,   0,   0, 188, 252,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 253,   0,   0,
 205,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 257,   0,   0, 255,   0, 272,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 266,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 281, 275,
 278,   0,   0,   0, 280,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 254,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 261,   0,   0,   0, 264,   0,   0,   0,   0, 269,
   0, 270, 271 };
short yypact[]={

-1000,-1000,-256,-1000,-1000,-1000,-1000,-1000,-1000,-329,
-329,-301,-134,-147,-1000,-329,-329,-280,-251,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-329,-329,-1000,-1000,-1000,-308,-308,
-1000,-1000,-1000,-329,-301,-1000,-1000,-301,-1000,-312,
-301,-1000,-1000,-1000,-1000,-1000,-1000,-167,-257,-258,
-1000,-1000,-1000,-1000,-329,-1000,-1000,-1000,-167,-167,
-157,-167,-167,-167,-167,-167,-167,-167,-167,-167,
-167,-167,-189,-1000,-158,-163,-163,-1000,-1000,-167,
-167,-1000,-1000,-166,-167,-1000,-318,-1000,-217,-165,
-1000,-1000,-308,-308,-1000,-121,-131,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-329,-192,-168,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-301,-1000,-1000,-329,-1000,-1000,
-329,-329,-329,-329,-329,-329,-329,-329,-329,-329,
-329,-218,-1000,-1000,-1000,-1000,-301,-1000,-1000,-1000,
-1000,-1000,-221,-239,-1000,-1000,-1000,-1000,-222,-195,
-223,-301,-1000,-329,-329,-329,-329,-329,-329,-329,
-329,-329,-329,-329,-1000,-1000,-1000,-141,-1000,-215,
-1000,-1000,-329,-329,-253,-214,-1000,-1000,-329,-1000,
-1000,-329,-329,-1000,-320,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-308,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-308,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-279,-193,-1000,-1000,-205,-1000,-1000,-1000,-1000,-1000,
-1000,-179,-1000,-1000,-1000,-301,-1000,-1000,-329,-169,
-301,-1000,-301,-301,-1000,-192,-242,-1000,-1000,-1000,
-1000,-1000,-1000,-329,-254,-194,-1000,-1000,-329,-308,
-1000,-1000 };
short yypgo[]={

   0,  85,  78, 282, 138, 281, 277, 276, 272, 271,
 270, 258, 257, 255, 253, 252, 251, 250, 124, 249,
 247, 246, 245, 244, 243, 242, 241, 240, 239, 238,
 225, 224, 222, 221, 220,  62, 218, 217, 216, 213,
 212, 211,  92, 210, 209, 207, 116, 195, 192, 191,
 190, 188, 187, 185, 180, 177, 176, 175, 174, 173,
 167, 166, 165, 164, 163, 152, 151, 148, 146, 140,
 139, 136, 132, 128, 125 };
short yyr1[]={

   0,   8,   9,   9,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  17,  10,  10,  10,
  10,  10,  10,  10,  10,  19,  10,  20,  10,  10,
  21,  10,  23,  10,  24,  10,  10,  25,  10,  10,
  26,  10,  10,  27,  10,  10,  28,  10,  10,  29,
  10,  30,  10,  31,  10,  32,  10,  33,  10,  34,
  10,  36,  10,  37,  10,  39,  10,  41,  10,  43,
  10,  10,  10,  44,  10,  10,  45,  10,  11,  12,
  13,   6,   7,  46,  46,  49,  49,  49,  49,  49,
  49,  47,  47,  50,  50,  50,  50,  50,  50,  50,
  50,  50,  48,  48,  51,  51,  51,  51,  51,  51,
  51,  51,  51,  51,  15,  52,  52,  53,  16,  54,
  54,  55,  55,  55,  55,  55,  55,  55,  55,  55,
  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,
  55,  55,  55,  42,  56,  56,  57,  58,  57,  57,
  59,  60,  60,  61,  14,  62,  14,  14,  64,  14,
  63,  63,  22,  65,  65,  66,  66,  18,  67,  67,
  68,  40,  69,  69,  70,  38,  71,  71,  72,  35,
  73,  73,  74,  74,   2,   2,   5,   5,   5,   3,
   1,   4 };
short yyr2[]={

   0,   1,   0,   2,   1,   1,   1,   1,   1,   6,
   3,   2,   2,   1,   2,   2,   0,   3,   1,   4,
   4,   2,   2,   2,   2,   0,   3,   0,   3,   1,
   0,   3,   0,   3,   0,   3,   1,   0,   3,   1,
   0,   3,   1,   0,   3,   1,   0,   3,   1,   0,
   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
   9,   0,   4,   0,   4,   0,   3,   0,   3,   0,
   3,   2,   2,   0,   3,   1,   0,   3,   1,   2,
   2,   6,   6,   0,   2,   1,   1,   1,   1,   2,
   1,   0,   2,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   0,   2,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   3,   0,   2,   2,   3,   0,
   2,   3,   2,   3,   2,   3,   2,   3,   2,   3,
   2,   3,   2,   3,   2,   3,   2,   3,   2,   3,
   2,   3,   2,   3,   0,   2,   2,   0,   4,   2,
   3,   0,   2,   2,   1,   0,   5,   1,   0,   3,
   0,   5,   3,   0,   2,   3,   4,   3,   0,   2,
   1,   3,   0,   2,   2,   3,   0,   2,   1,   3,
   0,   2,   2,   7,   1,   2,   1,   2,   2,   2,
   1,   1 };
short yychk[]={

-1000,  -8,  -9, -10, 256, -11, -12, -13, -14, 289,
 280, 278, 270, 269, 283, 311, 312,  -3,  -1, 284,
 281, 279, 275, 304, 288, 327, 286, 329, 328, 282,
 303, 287, 285, 262, 274, 271, 272, 273, 264, 277,
 325, 324, 314, 320, 315, 301, 302, 263, 330,  -1,
  -1,  -4, 313, -15, 257, -16, 257, -17,  -1,  -1,
  -1,  -2,  -6, 318, 319, 300,  -7, 300, -19, -20,
 -21, -23, -24, -25, -26, -27, -28, -29, -30, -31,
 -32, -33,  -1,  -1, -39, -41, -43,  -2,  -2, -44,
 -45,  -1,  -4, -62, -64,  -4, 321,  -4, -52, -54,
 -18, 257, 300, 300,  -1, -46, -46, -18, -18, -22,
 257, -18, -18, -18, -18, -18, -18, -18, -18, -18,
 -18, -18, 259, -36, -37, -40, 257, -42, 257, -42,
 -18, -18, 257, -18, 321, 258, -53, 323, 258, -55,
 298, 295, 296, 276, 263, 306, 307, 308, 262, 309,
 310, -67,  -2,  -2, 299, -49, 290, 291, 292, 293,
 268, 299, -65,  -1, -35, 257, -38, 257, -69, -56,
 -63,  -4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1, 258, -68,  -1, -47,  -4, -48,
 258, -66,  -1, 299, -73, -71, 258, -70,  -1, 258,
 -57, 317, 316, 258,  -1,  -4,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1,  -1, 299, -50, 294,
 295, 296, 297, 298, 276, 290, 267, 268, 299, -51,
 294, 295, 296, 297, 298, 276, 290, 267, 268,  -1,
  -1,  -1, 258, -74,  -1, 258, -72,  -2,  -1,  -1,
  -1, 322,  -2,  -2,  -4,  -1, 260,  -2, 259, -58,
  -5,  -4, 265, 266,  -4, -34,  -1, -59, 257,  -4,
  -4,  -4, -35, 299, -60,  -1, 258, -61,  -1, 260,
  -1,  -2 };
short yydef[]={

   2,  -2,   1,   3,   4,   5,   6,   7,   8,   0,
   0,  13,   0,   0,  -2,   0,   0,   0,   0,  25,
  -2,  30,  32,  -2,  -2,  -2,  -2,  -2,  49,  51,
  53,  55,  57,   0,   0,  65,  67,  69,   0,   0,
  -2,  76,  78,   0,   0,  -2,  -2,   0, 190,   0,
  11,  12, 191,  14, 115,  15, 119,   0,   0,   0,
  21,  22,  24, 184,   0,  83,  23,  83,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  61,  63,   0,   0,   0,  71,  72,   0,
   0,  79,  80,   0,   0, 189,   0,  10,   0,   0,
  17, 168,   0,   0, 185,   0,   0,  26,  28,  31,
 163,  33,  35,  38,  41,  44,  47,  50,  52,  54,
  56,  58,   0,   0,   0,  66, 172,  68, 144,  70,
  74,  77, 160, 159,   0, 114, 116,   0, 118, 120,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  19,  20,  91,  84,  85,  86,  87,  88,
  90, 102,   0,   0,  62, 180,  64, 176,   0,   0,
   0,   0, 117, 122, 124, 126, 128, 130, 132, 134,
 136, 138, 140, 142, 167, 169, 170,   0,  89,   0,
 162, 164,   0,   0,   0,   0, 171, 173,   0, 143,
 145,   0,   0, 156,   0,   9, 121, 123, 125, 127,
 129, 131, 133, 135, 137, 139, 141,   0,  92,  93,
  94,  95,  96,  97,  98,  99, 100, 101,   0, 103,
 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
   0,   0, 179, 181,   0, 175, 177, 178, 174,  -2,
 149,   0,  81,  82, 165,   0,  59, 182,   0,   0,
   0, 186,   0,   0, 166,   0,   0, 148, 151, 161,
 187, 188,  60,   0,   0,   0, 150, 152,   0,   0,
 153, 183 };
/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 *
 * $Source: /ibm/acis/usr/src/usr.bin/yacc/RCS/yaccpar,v $ 
 */

#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
static char rcsidyaccpar[] = "$Header:yaccpar 12.0$";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 9:
# line 113 "gram.y"
{ AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num); } break;
case 10:
# line 114 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->iconmgr.geometry=yypvt[-1].ptr;
						    Scr->iconmgr.columns=yypvt[-0].num;
						  }
						} break;
case 11:
# line 120 "gram.y"
{ if (Scr->FirstTime)
						    Scr->iconmgr.geometry = yypvt[-0].ptr;
						} break;
case 12:
# line 123 "gram.y"
{ if (Scr->FirstTime)
					  {
						Scr->DoZoom = TRUE;
						Scr->ZoomCount = yypvt[-0].num;
					  }
					} break;
case 13:
# line 129 "gram.y"
{ if (Scr->FirstTime) 
						Scr->DoZoom = TRUE; } break;
case 14:
# line 131 "gram.y"
{} break;
case 15:
# line 132 "gram.y"
{} break;
case 16:
# line 133 "gram.y"
{ list = &Scr->IconifyByUn; } break;
case 18:
# line 135 "gram.y"
{ if (Scr->FirstTime) 
		    Scr->IconifyByUnmapping = TRUE; } break;
case 19:
# line 137 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, False);
					} break;
case 20:
# line 140 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, True);
					} break;
case 21:
# line 143 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR);
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = F_MENU;
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = root;
					} break;
case 22:
# line 147 "gram.y"
{ Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num,NULLSTR,NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 23:
# line 163 "gram.y"
{ GotKey(yypvt[-1].ptr, yypvt[-0].num); } break;
case 24:
# line 164 "gram.y"
{ GotButton(yypvt[-1].num, yypvt[-0].num); } break;
case 25:
# line 165 "gram.y"
{ list = &Scr->DontIconify; } break;
case 27:
# line 167 "gram.y"
{ list = &Scr->IconMgrNoShow; } break;
case 29:
# line 169 "gram.y"
{ Scr->IconManagerDontShow = TRUE; } break;
case 30:
# line 170 "gram.y"
{ list = &Scr->IconMgrs; } break;
case 32:
# line 172 "gram.y"
{ list = &Scr->IconMgrShow; } break;
case 34:
# line 174 "gram.y"
{ list = &Scr->NoTitleHighlight; } break;
case 36:
# line 176 "gram.y"
{ if (Scr->FirstTime)
						Scr->TitleHighlight = FALSE; } break;
case 37:
# line 178 "gram.y"
{ list = &Scr->NoHighlight; } break;
case 39:
# line 180 "gram.y"
{ if (Scr->FirstTime)
						Scr->Highlight = FALSE; } break;
case 40:
# line 182 "gram.y"
{ list = &Scr->NoStackModeL; } break;
case 42:
# line 184 "gram.y"
{ if (Scr->FirstTime)
						Scr->StackMode = FALSE; } break;
case 43:
# line 186 "gram.y"
{ list = &Scr->NoTitle; } break;
case 45:
# line 188 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoTitlebar = TRUE; } break;
case 46:
# line 190 "gram.y"
{ list = &Scr->NoIconTitleL; } break;
case 48:
# line 192 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoIconTitle = TRUE; } break;
case 49:
# line 194 "gram.y"
{ list = &Scr->IconTitleL; } break;
case 51:
# line 196 "gram.y"
{ list = &Scr->MakeTitle; } break;
case 53:
# line 198 "gram.y"
{ list = &Scr->StartIconified; } break;
case 55:
# line 200 "gram.y"
{ list = &Scr->AutoRaise; } break;
case 57:
# line 202 "gram.y"
{ list = &Scr->StickyL; } break;
case 59:
# line 204 "gram.y"
{
					root = GetRoot(yypvt[-5].ptr, yypvt[-3].ptr, yypvt[-1].ptr); } break;
case 60:
# line 206 "gram.y"
{ root->real_menu = TRUE;} break;
case 61:
# line 207 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 62:
# line 208 "gram.y"
{ root->real_menu = TRUE; } break;
case 63:
# line 209 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 65:
# line 211 "gram.y"
{ list = &Scr->IconNames; } break;
case 67:
# line 213 "gram.y"
{ color = COLOR; } break;
case 69:
# line 215 "gram.y"
{ color = MONOCHROME; } break;
case 71:
# line 217 "gram.y"
{ Scr->DefaultFunction.func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->DefaultFunction.menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->DefaultFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 72:
# line 233 "gram.y"
{ Scr->WindowFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->WindowFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 73:
# line 241 "gram.y"
{ list = &Scr->WarpCursorL; } break;
case 75:
# line 243 "gram.y"
{ if (Scr->FirstTime) 
					    Scr->WarpCursor = TRUE; } break;
case 76:
# line 245 "gram.y"
{ list = &Scr->WindowRingL; } break;
case 78:
# line 250 "gram.y"
{ if (!do_single_keyword (yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
					"unknown singleton keyword %d\n",
						     yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 79:
# line 260 "gram.y"
{ if (!do_string_keyword (yypvt[-1].num, yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown string keyword %d (value \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 80:
# line 270 "gram.y"
{ if (!do_number_keyword (yypvt[-1].num, yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown numeric keyword %d (value %d)\n",
						     yypvt[-1].num, yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 81:
# line 282 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 82:
# line 285 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 85:
# line 292 "gram.y"
{ mods |= Mod1Mask; } break;
case 86:
# line 293 "gram.y"
{ mods |= ShiftMask; } break;
case 87:
# line 294 "gram.y"
{ mods |= LockMask; } break;
case 88:
# line 295 "gram.y"
{ mods |= ControlMask; } break;
case 89:
# line 296 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Mod1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 90:
# line 306 "gram.y"
{ } break;
case 93:
# line 313 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 94:
# line 314 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 95:
# line 315 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 96:
# line 316 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 97:
# line 317 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 98:
# line 318 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 99:
# line 319 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 100:
# line 320 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 101:
# line 321 "gram.y"
{  } break;
case 104:
# line 328 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 105:
# line 329 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 106:
# line 330 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 107:
# line 331 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 108:
# line 332 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 109:
# line 333 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 110:
# line 334 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 111:
# line 335 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 112:
# line 336 "gram.y"
{ } break;
case 113:
# line 337 "gram.y"
{ Name = yypvt[-0].ptr; cont |= C_NAME_BIT; } break;
case 117:
# line 348 "gram.y"
{ do_pixmap_keyword(yypvt[-1].num,yypvt[-0].ptr); } break;
case 121:
# line 359 "gram.y"
{
			NewBitmapCursor(&Scr->FrameCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 122:
# line 361 "gram.y"
{
			NewFontCursor(&Scr->FrameCursor, yypvt[-0].ptr); } break;
case 123:
# line 363 "gram.y"
{
			NewBitmapCursor(&Scr->TitleCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 124:
# line 365 "gram.y"
{
			NewFontCursor(&Scr->TitleCursor, yypvt[-0].ptr); } break;
case 125:
# line 367 "gram.y"
{
			NewBitmapCursor(&Scr->IconCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 126:
# line 369 "gram.y"
{
			NewFontCursor(&Scr->IconCursor, yypvt[-0].ptr); } break;
case 127:
# line 371 "gram.y"
{
			NewBitmapCursor(&Scr->IconMgrCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 128:
# line 373 "gram.y"
{
			NewFontCursor(&Scr->IconMgrCursor, yypvt[-0].ptr); } break;
case 129:
# line 375 "gram.y"
{
			NewBitmapCursor(&Scr->ButtonCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 130:
# line 377 "gram.y"
{
			NewFontCursor(&Scr->ButtonCursor, yypvt[-0].ptr); } break;
case 131:
# line 379 "gram.y"
{
			NewBitmapCursor(&Scr->MoveCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 132:
# line 381 "gram.y"
{
			NewFontCursor(&Scr->MoveCursor, yypvt[-0].ptr); } break;
case 133:
# line 383 "gram.y"
{
			NewBitmapCursor(&Scr->ResizeCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 134:
# line 385 "gram.y"
{
			NewFontCursor(&Scr->ResizeCursor, yypvt[-0].ptr); } break;
case 135:
# line 387 "gram.y"
{
			NewBitmapCursor(&Scr->WaitCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 136:
# line 389 "gram.y"
{
			NewFontCursor(&Scr->WaitCursor, yypvt[-0].ptr); } break;
case 137:
# line 391 "gram.y"
{
			NewBitmapCursor(&Scr->MenuCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 138:
# line 393 "gram.y"
{
			NewFontCursor(&Scr->MenuCursor, yypvt[-0].ptr); } break;
case 139:
# line 395 "gram.y"
{
			NewBitmapCursor(&Scr->SelectCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 140:
# line 397 "gram.y"
{
			NewFontCursor(&Scr->SelectCursor, yypvt[-0].ptr); } break;
case 141:
# line 399 "gram.y"
{
			NewBitmapCursor(&Scr->DestroyCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 142:
# line 401 "gram.y"
{
			NewFontCursor(&Scr->DestroyCursor, yypvt[-0].ptr); } break;
case 146:
# line 412 "gram.y"
{ if (!do_colorlist_keyword (yypvt[-1].num, color,
								     yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled list color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 147:
# line 421 "gram.y"
{ list = do_colorlist_keyword(yypvt[-1].num,color,
								      yypvt[-0].ptr);
					  if (!list) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color list keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 149:
# line 432 "gram.y"
{ if (!do_color_keyword (yypvt[-1].num, color,
								 yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 153:
# line 451 "gram.y"
{ if (Scr->FirstTime &&
					      color == Scr->Monochrome)
					    AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 154:
# line 456 "gram.y"
{ 
#ifdef SHAPE
				    if (HasShape) Scr->SqueezeTitle = TRUE;
#endif
				} break;
case 155:
# line 461 "gram.y"
{ list = &Scr->SqueezeTitleL; 
#ifdef SHAPE
				  if (HasShape && Scr->SqueezeTitle == -1)
				    Scr->SqueezeTitle = TRUE;
#endif
				} break;
case 157:
# line 468 "gram.y"
{ Scr->SqueezeTitle = FALSE; } break;
case 158:
# line 469 "gram.y"
{ list = &Scr->DontSqueezeTitleL; } break;
case 161:
# line 474 "gram.y"
{
				if (Scr->FirstTime) {
				   do_squeeze_entry (list, yypvt[-3].ptr, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
				}
			} break;
case 165:
# line 489 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-2].ptr, (char *)
						AllocateIconManager(yypvt[-2].ptr, NULLSTR,
							yypvt[-1].ptr,yypvt[-0].num));
					} break;
case 166:
# line 495 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-3].ptr, (char *)
						AllocateIconManager(yypvt[-3].ptr,yypvt[-2].ptr,
						yypvt[-1].ptr, yypvt[-0].num));
					} break;
case 170:
# line 509 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-0].ptr, 0);
					} break;
case 174:
# line 521 "gram.y"
{ if (Scr->FirstTime) AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 178:
# line 531 "gram.y"
{ AddToMenu(root, "", Action, NULLSTR, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					} break;
case 182:
# line 544 "gram.y"
{ AddToMenu(root, yypvt[-1].ptr, Action, pull, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					  pull = NULL;
					} break;
case 183:
# line 549 "gram.y"
{
					  AddToMenu(root, yypvt[-6].ptr, Action, pull, yypvt[-0].num,
						yypvt[-4].ptr, yypvt[-2].ptr);
					  Action = "";
					  pull = NULL;
					} break;
case 184:
# line 557 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 185:
# line 558 "gram.y"
{
				yyval.num = yypvt[-1].num;
				Action = yypvt[-0].ptr;
				switch (yypvt[-1].num) {
				  case F_MENU:
				    pull = GetRoot (yypvt[-0].ptr, NULLSTR,NULLSTR);
				    pull->prev = root;
				    break;
				  case F_WARPRING:
				    if (!CheckWarpRingArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.warptoring argument \"%s\"\n",
						 Action);
					yyval.num = F_NOP;
				    }
				  case F_WARPTOSCREEN:
				    if (!CheckWarpScreenArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr, 
			"ignoring invalid f.warptoscreen argument \"%s\"\n", 
					         Action);
					yyval.num = F_NOP;
				    }
				    break;
				  case F_COLORMAP:
				    if (CheckColormapArg (Action)) {
					yyval.num = F_COLORMAP;
				    } else {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.colormap argument \"%s\"\n", 
						 Action);
					yyval.num = F_NOP;
				    }
				    break;
				} /* end switch */
				   } break;
case 186:
# line 599 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 187:
# line 600 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 188:
# line 601 "gram.y"
{ yyval.num = -(yypvt[-0].num); } break;
case 189:
# line 604 "gram.y"
{ yyval.num = yypvt[-0].num;
					  if (yypvt[-0].num == 0)
						yyerror("bad button 0");

					  if (yypvt[-0].num > MAX_BUTTONS)
					  {
						yyval.num = 0;
						yyerror("button number too large");
					  }
					} break;
case 190:
# line 616 "gram.y"
{ ptr = (char *)malloc(strlen(yypvt[-0].ptr)+1);
					  strcpy(ptr, yypvt[-0].ptr);
					  RemoveDQuote(ptr);
					  yyval.ptr = ptr;
					} break;
case 191:
# line 621 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
		}
		goto yystack;  /* stack new state and value */

	}
