	.file	"blkout.s"
/*									*/
/*	void								*/
/*	blockoutw( unsigned short *values, int n )			*/
/*									*/
/*	This routine destroys the contents of %eax, %ecx & %edx		*/
/*	All other registers are preserved.				*/
/*									*/

	.def	blockoutw;	.val	blockoutw;
	.scl	2;	.type	055;	.endef
	.globl	blockoutw
.align 4
	movw	%ax, %ax	/* Aligning "nop" */
blockoutw:
	xchgl	%esi, 4(%esp)	/* get "values" */
	xchgl	%ebx, 8(%esp)	/* get "n" */
/* Bottom half of %edx is I/O addr of the queue status port	0xDAE8 */
/* Top half of %edx is I/O addr of the variable-data port	0xE2E8 */
	movl	$0xE2E8DAE8, %edx

.testQ1:	/* Now %dx points to the queue status port */
	inw	(%dx)		/* Read The Queue Status Port */
	xorb	$0xFF, %al	/* same as logical negation, but set flags */
	jz	.testQ1		/* If no slots are available, spin & burn */

	bsfl	%eax, %ecx
	rorl	$16, %edx	/* Point %dx at the VAR-DATA I/O port */
	subb	$8, %cl		/* The number of empty slots -- NEGATED !! */
	negb	%cl		/* The number of empty slots !! */
	subl	%ecx, %ebx	/* The number of words remaining after this */
	jle	.final_batch
	rep
	outsw	/* (%dx), (%esi) */
	rorl	$16, %edx	/* Point %dx at the Queue Status I/O port */
	jmp	.testQ1

.final_batch:
	add	%ebx, %ecx	/* The number of words left !! */
	jz	.done1		/* Are there any words left ?? */
	rep
	outsw	/* (%dx), (%esi) */
.done1:
	movl	4(%esp), %esi
	movl	8(%esp), %ebx
	ret
	.def	blockoutw;	.val	.;	.scl	-1;	.endef

/*	void					*/
/*	blockouttransmogrifiedw( values, n )	*/
/*	register unsigned char *values	;	*/
/*	register int n ;			*/
/*	{					*/
/*	register unsigned char tmp ;		*/
/*						*/
/*	do {					*/
/*		tmp = *values++ ;		*/
/*		tmp = transmogrify( tmp ) ;	*/
/*		ibm8514CheckQueue( 1 ) ;	*/
/*		outw( VARDATA, tmp ) ;		*/
/*	} while ( --n ) ;			*/
/*	return	;				*/
/*	}					*/
	/* .align	4 */ /* Better off without this !! */
	.def	blockouttransmogrifiedw;	.val	blockouttransmogrifiedw;
	.scl	2;	.type	055;	.endef
	.globl	blockouttransmogrifiedw
	.text
blockouttransmogrifiedw:
	xchgl	0x4(%esp), %esi
	movl	0x8(%esp), %ecx
	jcxz	.done2
/* Top half of %edx is I/O addr of the queue status port	0xDAE8 */
/* Bottom half of %edx is I/O addr of the variable-data port	0xE2E8 */
	movl	$0xDAE8E2E8, %edx
.Loop_Top:
	rorl	$16, %edx
/*		do { */
.testQ2:		/* ibm8514CheckQueue( 1 ) ;	*/
/*		ibm8514CheckQueue( 1 ) ;	*/
	inw	(%dx)		/* Read The Queue Status Port */
	testb	$128, %al
	jnz	.testQ2
	lodsb		/* tmp = *values++ ; ---- Does Increment For Us !! */
/*		tmp = transmogrify( tmp ) ;	*/
	shll	$4, %eax
	shrb	$4, %al
	addl	%eax, %eax
	xchgb	%ah, %al
/*		outw( VARDATA, tmp ) ;		*/
	rorl	$16, %edx
	outw	(%dx)
/*	} while ( --n ) ;			*/
	loop	.Loop_Top
.done2:
	movl	0x4(%esp), %esi
	ret
	
	.def	blockouttransmogrifiedw;	.val	.;
	.scl	-1;	.endef
