/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcOutL.c,v 6.3 89/05/07 15:12:37 paul Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcOutL.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcOutL.c,v 6.3 89/05/07 15:12:37 paul Exp $" ;
#endif

/* SOLID AREA FILL OUTLINE
 *
 * This draws a strange line intended to be used as an outline for area fill
 * IT SHOULD NOT BE USED FOR ANYTHING ELSE
 * 
 */

#include "X.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;

#define VERT	1
#define HORIZ	2
#define SLOP1	3
#define SLOPN1	4
#define YUCK	5

void
ibm8514Outline( planes, x0, y0, x1, y1 )
unsigned long int planes ;
int x0, y0, x1, y1 ;
{
int saved ;
int qd,k1,k2,dx,dy,adx,ady ;

TRACE(("ibm8514OutLine(x0=%d, y0=%d, x1=%d, y1=%d)\n", x0,y0,x1,y1)) ;

dx = x1 - x0 ;
adx = ABS( dx ) ;
dy = y1 - y0 ;
ady = ABS( dy ) ;

saved = !ibm8514cursorSemaphore
     && ibm8514CheckCursor( MIN( x0, x1 ), MIN( y0, y1 ), adx, ady ) ;

ibm8514ATRNotBusy ;
ibm8514CheckQueue( 5 ) ;
SETFN1( FNCOLOR1, mergexlate[GXxor] ) ;
SETCOL1( 255 ) ;
PLNWENBL( planes ) ;
PLNRENBL( FILL_STAGE_RPLANE ) ;
SETET( 0 ) ; /* bresenham error term.  See README file about this */

if ( !dx )
	qd = VERT ;
else if ( !dy )
	qd = HORIZ ;
else if ( dx == dy )
	qd = SLOPN1 ;
else if ( adx == ady )
	qd = SLOP1 ;
else
	qd = YUCK ;

ibm8514CheckQueue( 6 ) ; /* Max # of outw's in switch statement */
switch ( qd ) {
	case VERT:
		SETLX( ady ) ; /* stepping along Y */
		SETY0( ( dy > 0 ) ? y0 : y1 ) ;
 		SETX0( x0 ) ;
		COMMAND( 0xA0DF ) ;
		break ;
	case HORIZ:
		break ;
	case SLOP1:
		SETLX( adx ) ;
		if ( dx > 0 ) {
			SETX0( x1 ) ;
			SETY0( y1 ) ;
		}
		else {
			SETX0( x0 ) ;
			SETY0( y0 ) ;
		}
		COMMAND( 0xA0BF ) ;
		break ;
	case SLOPN1:
		SETLX( adx ) ;
		if ( dx > 0 ) {
			SETX0( x0 ) ;
			SETY0( y0 ) ;
		}
		else {
			SETX0( x1 ) ;
			SETY0( y1 ) ;
		}
		COMMAND( 0xA0FF ) ;
		break ;
	case YUCK: /* slope is not 0,1,-1,or infinite */
		if ( adx >= ady ) { /* STEPX */
			k1 = 2 * ady ;
			SETK1( k1 ) ;
			k2 = k1 - 2 * adx ;
			SETK2( k2 ) ;
			SETLX( adx ) ;
			if ( dy > 0 ) {
				SETX0( x0 ) ;
				SETY0( y0 ) ;
				if ( dx > 0 )
					COMMAND( 0xA0B7 ) ; /*QUAD1*/
				else
					COMMAND( 0xA097 ) ; /*QUAD 4*/
			}
			else {
				SETX0( x1 ) ;
				SETY0( y1 ) ;
				if ( dx > 0 )
					COMMAND( 0xA097 ) ; /*QUAD8*/
				else
					COMMAND( 0xA0B7 ) ; /*QUAD 5*/
			}
		}
		else { /* STEPY */
			k1 = 2 * adx ;
			SETK1( k1 ) ;
			k2 = k1 - 2 * ady ;
			SETK2( k2 ) ;
			SETLX( ady ) ;
			if ( dy > 0 ) {
				SETX0( x0 ) ;
				SETY0( y0 ) ;
				if ( dx > 0 )
					COMMAND( 0xA0F7 ) ; /*QUAD2*/
				else
					COMMAND( 0xA0D7 ) ; /*QUAD 3*/
			}
			else {
				SETX0( x1 ) ;
				SETY0( y1 ) ;
			  	if ( dx > 0 )
					COMMAND( 0xA0D7 ) ; /*QUAD7*/
				else
					COMMAND( 0xA0F7) ; /*QUAD 6*/
			}
		}
		break ;
	} /* end switch */

ibm8514ClearQueue( 3 ) ;
SETFN1( FNCOLOR1, FNREPLACE ) ;
PLNWENBL( ibm8514ALLPLANES ) ;
PLNRENBL( ibm8514ALLPLANES ) ;

if ( saved )
	ibm8514ReplaceCursor() ;
return ;
}
