/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcProcs.h,v 6.4 88/11/21 13:47:06 jeff Exp $ */
/* $Source: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcProcs.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidibm8514procs = "$Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcProcs.h,v 6.4 88/11/21 13:47:06 jeff Exp $";
#endif

#if !defined(NO_FUNCTION_PROTOTYPES)
/* brcCurs.o */

extern int ibm8514CheckCursor(
	const int x,
	const int y,
	const int lx,
	const int ly ) ;

extern void ibm8514ReplaceCursor(
	void ) ;

extern int ibm8514cursorSemaphore ;

#if !defined(CURSOR_ONLY)
extern void ibm8514RemoveCursor(
	void ) ;

extern void ibm8514CursorInit(
	int index ) ;

extern Bool ibm8514RealizeCursor(
	ScreenPtr pScr,
	CursorPtr pCurs ) ;

extern Bool ibm8514UnrealizeCursor(
	ScreenPtr pScr,
	CursorPtr pCurs ) ;

extern void ibm8514ColorCursor(
	unsigned long int fg,
	unsigned long int bg ) ;

extern void ibm8514RecolorCursor(
	ColormapPtr cmap ) ;

extern int ibm8514DisplayCursor(
	ScreenPtr pScr,
	CursorPtr pCurs ) ;

extern void ibm8514ShowCursor(
	int x,
	int y ) ;

/* brcBlit.o */

extern void ibm8514Bitblt(
	int merge,
	int rpm,
	int wpm,
	int x0,
	int y0,
	int x1,
	int y1,
	int lx,
	int ly ) ;

extern void ibm8514BlitFG(
	int rpm,
	int wpm,
	int fg,
	int merge,
	int x0,
	int y0,
	int x1,
	int y1,
	int lx,
	int ly ) ;

extern void ibm8514BlitFGBG(
	int rpm,
	int wpm,
	int fg,
	int bg,
	int merge,
	int x0,
	int y0,
	int x1,
	int y1,
	int lx,
	int ly ) ;

/* brcCmap.o */

extern void ibm8514SetColor(
	unsigned long int number,
	unsigned short int r,
	unsigned short int g,
	unsigned short int b,
	VisualPtr pVisual ) ;

/* brcFillSp.o */

extern void ibm8514SolidFS(
	DrawablePtr pDrawable,
	GCPtr pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514TileFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514StippleFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514OPStippleFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

/* brcFillSp.o */

extern void ibm8514SolidFS(
	DrawablePtr pDrawable,
	GCPtr pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514TileFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514StippleFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

extern void ibm8514OPStippleFS(
	DrawablePtr pDrawable,
	GC *pGC,
	int nInit,
	DDXPointPtr pptInit,
	int *pwidthInit,
	int fSorted ) ;

/* brcGC.o */
extern Mask ibm8514ChangeGCtype(
	GC *pGC,
	ppcPrivGCPtr devPriv ) ;

extern Mask ibm8514ChangeWindowGC(
	GC *pGC,
	Mask changes ) ;

/* brcGetSp.o */

extern void ibm8514GetSpans(
	DrawablePtr pDrawable,
	int wMax,
	DDXPointPtr ppt,
	int *pwidth,
	int nspans,
	unsigned int *pdstStart ) ;

/* brcImg.o */

extern void ibm8514DrawColorImage(
	int x,
	int y,
	int w,
	int h,
	unsigned char *data,
	int RowIncrement,
	int merge,
	unsigned long int planes ) ;

extern void ibm8514ReadColorImage(
	int x,
	int y,
	int lx,
	int ly,
	unsigned char *data,
	int RowIncrement ) ;

/* brcMono.o */

extern void ibm8514AlignMonoImage(
	unsigned long int planes,
	int merge,
	int x,
	int y,
	int lx,
	int ly,
	unsigned char *data ) ;

extern void ibm8514StageMono(
	int lx,
	int ly,
	unsigned char *data ) ;

extern void ibm8514FillMonoImage(
	unsigned long int planes,
	unsigned long int fg,
	unsigned long int bg,
	int merge,
	int x,
	int y,
	int lx,
	int ly,
	unsigned char *data ) ;

extern void ibm8514DrawMonoByteImage(
	unsigned char *data,
	int x,
	int y,
	int lx,
	int ly,
	unsigned long int fg,
	int merge,
	unsigned long int planes ) ;

extern void ibm8514DrawMonoImage(
	unsigned char *data,
	int x,
	int y,
	int lx,
	int ly,
	unsigned long int fg,
	int merge,
	unsigned long int planes ) ;

extern void ibm8514ByteAlignMonoImage(
	unsigned long int planes,
	int merge,
	int x,
	int y,
	int lx,
	int ly,
	unsigned char *data ) ;
/* brcScrInit.o */

extern Bool ibm8514InitScreen(
	int index,
	ScreenPtr pScreen,
	pointer pbits,
	int xsize,
	int ysize,
	int dpix,
	int dpiy ) ;

/* brcSuspScr.o */

extern void ibm8514SuspendScreenAndSave(
	void ) ;

extern void ibm8514RestoreScreenAndActivate(
	void ) ;

/* brcIO.c */

extern Bool ibm8514ScreenInit(
	const int index,
	ScreenPtr const pScreen,
	int const argc,
	char * const * const argv ) ;

extern Bool ibm8514ScreenClose(
	const int index,
	ScreenPtr const pScreen ) ;

/* brcUtils.o */

extern short int ibm8514QueryHead(
	void ) ;

extern int ibm8514QueryPlanes(
	void ) ;

extern void ibm8514InitializeHardwareState(
	void ) ;

extern int ibm8514ScreenInitHW(
	int index ) ;

#if defined(ibm032)
extern unsigned short int ibm8514inw(
	unsigned int addr ) ;
#endif

/* brcGBlt.o */

extern void ibm8514ImageGlyphBlt(
	DrawablePtr pDrawable,
	GC *pGC,
	int x,
	int y,
	unsigned int nglyph,
	CharInfoPtr *ppci,
	unsigned char *pglyphBase ) ;

/* brcLine.o */

extern void ibm8514HorzLine(
	unsigned long int color,
	int alu,
	unsigned long int mask,
	int x,
	int y,
	int w ) ;

extern void ibm8514VertLine(
	unsigned long int color,
	int alu,
	unsigned long int mask,
	int x,
	int y,
	int h ) ;

extern void ibm8514BresLine(
	unsigned long int color,
	int alu,
	unsigned long int mask,
	int signdx,
	int signdy,
	int axis,
	int x,
	int y,
	int et,
	int e1,
	int e2,
	int len ) ;

/* brcStip.o */

extern void ibm8514UnnaturalOpStipple(
	PixmapPtr pStipple,
	unsigned long int fg,
	unsigned long int bg,
	int merge,
	unsigned long int planes,
	int x,
	int y,
	int w,
	int h,
	int xSrc,
	int ySrc ) ;

extern void ibm8514UnnaturalStipple(
	PixmapPtr pStipple,
	unsigned long int fg,
	int merge,
	unsigned long int planes,
	int x,
	int y,
	int w,
	int h,
	int xSrc,
	int ySrc ) ;

extern void ibm8514Stipple(
	PixmapPtr pStipple,
	unsigned long int fg,
	int merge,
	unsigned long int planes,
	int x,
	int y,
	int w,
	int h,
	int xSrc,
	int ySrc ) ;

extern void ibm8514OpStipple(
	PixmapPtr pStipple,
	unsigned long int fg,
	unsigned long int bg,
	int merge,
	unsigned long int planes,
	int x,
	int y,
	int w,
	int h,
	int xSrc,
	int ySrc ) ;

/* brcFont.o */

extern void ibm8514InitFontCache(
	void ) ;

extern Bool ibm8514RealizeFont(
	ScreenPtr pscr,
	FontPtr pFont ) ;

extern Bool ibm8514UnrealizeFont(
	ScreenPtr pscr,
	FontPtr pFont ) ;

/* brcText.o */

extern int ibm8514PolyText8(
	DrawablePtr pDraw,
	GCPtr pGC,
	int x,
	int y,
	int count,
	char *chars ) ;

extern int ibm8514PolyText16(
	DrawablePtr pDraw,
	GCPtr pGC,
	int x,
	int y,
	int count,
	unsigned short int *chars ) ;

extern void ibm8514ImageText8(
	DrawablePtr pDraw,
	GCPtr pGC,
	int x,
	int y,
	int count,
	char *chars ) ;

extern void ibm8514ImageText16(
	DrawablePtr pDraw,
	GCPtr pGC,
	int x,
	int y,
	int count,
	unsigned short int *chars ) ;

/* brcPoly.c */

extern int ibm8514SolidFillPoly(
	DrawablePtr pDraw,
	GCPtr pGC,
	int count,
	DDXPointPtr pts ) ;

/* brcPgon.o */

extern void ibm8514FillPolygon(
	DrawablePtr dst,
	GCPtr pgc,
	int shape,
	int mode,
	int count,
	DDXPointPtr pPts ) ;

/* brcOutL.o */

extern void ibm8514Outline(
	unsigned long int planes,
	int x0,
	int y0,
	int x1,
	int y1 ) ;

/* brcRect.o */

extern void ibm8514DrawRectangle(
	unsigned long int color,
	int merge,
	unsigned long int planes,
	short int x0,
	short int y0,
	short int lx,
	short int ly ) ;

/* brcTile.o */

extern void ibm8514TileRect(
	PixmapPtr pTile,
	int merge,
	unsigned long int planes,
	int x,
	int y,
	int w,
	int h,
	int xSrc,
	int ySrc ) ;

extern int ibm8514RotateTile(
	int w,
	int h,
	int dx,
	int dy ) ;

/* brcPushPxl.o */

extern void ibm8514PushPixels(
	GCPtr pGC,
	PixmapPtr pBitMap,
	DrawablePtr pDrawable,
	int dx,
	int dy,
	int xOrg,
	int yOrg ) ;

/* brcOSD.o */

extern void ibm8514osdInit(
	int index ) ;

extern int ibm8514Probe(
	void ) ;

extern void blockoutw(
	unsigned int port,
	unsigned short int *values,
	int n ) ;

extern void blockinw(
	unsigned short int addr,
	unsigned short int *data,
	int n ) ;

#endif /* CURSOR_ONLY */
#else
/* brcCurs.o */
extern int ibm8514CheckCursor() ;
extern void ibm8514ReplaceCursor() ;
extern int ibm8514cursorSemaphore ;
#if !defined(CURSOR_ONLY)
extern void ibm8514RemoveCursor() ;
extern void ibm8514CursorInit() ;
extern Bool ibm8514RealizeCursor() ;
extern Bool ibm8514UnrealizeCursor() ;
extern void ibm8514ColorCursor() ;
extern void ibm8514RecolorCursor() ;
extern int ibm8514DisplayCursor() ;
extern void ibm8514ShowCursor() ;
/* brcBlit.o */
extern void ibm8514Bitblt() ;
extern void ibm8514BlitFG() ;
extern void ibm8514BlitFGBG() ;
/* brcCmap.o */
extern void ibm8514SetColor() ;
/* brcFillSp.o */
extern void ibm8514SolidFS() ;
extern void ibm8514TileFS() ;
extern void ibm8514StippleFS() ;
extern void ibm8514OPStippleFS() ;
/* brcFillSp.o */
extern void ibm8514SolidFS() ;
extern void ibm8514TileFS() ;
extern void ibm8514StippleFS() ;
extern void ibm8514OPStippleFS() ;
/* brcGC.o */
extern Mask ibm8514ChangeGCtype() ;
extern Mask ibm8514ChangeWindowGC() ;
/* brcGetSp.o */
extern void ibm8514GetSpans() ;
/* brcImg.o */
extern void ibm8514DrawColorImage() ;
extern void ibm8514ReadColorImage() ;
/* brcMono.o */
extern void ibm8514AlignMonoImage() ;
extern void ibm8514StageMono() ;
extern void ibm8514FillMonoImage() ;
extern void ibm8514DrawMonoByteImage() ;
extern void ibm8514DrawMonoImage() ;
extern void ibm8514ByteAlignMonoImage() ;
/* brcScrInit.o */
extern Bool ibm8514InitScreen() ;
/* brcSuspScr.o */
extern void ibm8514SuspendScreenAndSave() ;
extern void ibm8514RestoreScreenAndActivate() ;
/* brcIO.c */
extern Bool ibm8514ScreenInit() ;
extern Bool ibm8514ScreenClose() ;
/* brcUtils.o */
extern short int ibm8514QueryHead() ;
extern int ibm8514QueryPlanes() ;
extern void ibm8514InitializeHardwareState() ;
extern int ibm8514ScreenInitHW() ;
#if defined(ibm032)
extern unsigned short int ibm8514inw() ;
#endif
/* brcGBlt.o */
extern void ibm8514ImageGlyphBlt() ;
/* brcLine.o */
extern void ibm8514HorzLine() ;
extern void ibm8514VertLine() ;
extern void ibm8514BresLine() ;
/* brcStip.o */
extern void ibm8514UnnaturalOpStipple() ;
extern void ibm8514UnnaturalStipple() ;
extern void ibm8514Stipple() ;
extern void ibm8514OpStipple() ;
/* brcFont.o */
extern void ibm8514InitFontCache() ;
extern Bool ibm8514RealizeFont() ;
extern Bool ibm8514UnrealizeFont() ;
/* brcText.o */
extern int ibm8514PolyText8() ;
extern int ibm8514PolyText16() ;
extern void ibm8514ImageText8() ;
extern void ibm8514ImageText16() ;
/* brcPoly.c */
extern int ibm8514SolidFillPoly() ;
/* brcPgon.o */
extern void ibm8514FillPolygon() ;
/* brcOutL.o */
extern void ibm8514Outline() ;
/* brcRect.o */
extern void ibm8514DrawRectangle() ;
/* brcTile.o */
extern void ibm8514TileRect() ;
extern int ibm8514RotateTile() ;
/* brcPushPxl.o */
extern void ibm8514PushPixels() ;
/* brcOSD.o */
extern void ibm8514osdInit() ;
extern int ibm8514Probe() ;
extern void blockoutw() ;
extern void blockinw() ;
#endif /* CURSOR_ONLY */
#endif
