/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 * ibm8514PushPixels
 */
#include "X.h"
#include "misc.h"
#include "gcstruct.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "regionstr.h"
#include "pixmapstr.h"
#include "miscstruct.h"
#include "maskbits.h"

#include "OScompiler.h"

#include "ppc.h"

#include "x8514.h"
extern int mfbGCPrivateIndex;

void
ibm8514PushPixels(pGC, pBitMap, pDrawable, dx, dy, xOrg, yOrg)
    GCPtr	pGC;
    PixmapPtr	pBitMap;
    DrawablePtr pDrawable;
    int		dx, dy, xOrg, yOrg;
{
register int		thisX, thisY;
ppcPrivGC               *gcPriv  = (ppcPrivGC *) ( pGC->devPrivates[mfbGCPrivateIndex].ptr ) ;
int			alu = 	gcPriv->colorRrop.alu;
int			fillstyle = gcPriv->colorRrop.fillStyle;
RegionPtr               prgnDst ;
BoxPtr                  pbox ;
unsigned int            nbox ;
int 			dxInWords, wInWords, i;
unsigned char 		*data;
ScreenPtr		pScrn;

if (alu == GXnoop)
	return;

if (dy > MONO_STAGE_SIZE) 
	{
	ppcPushPixels(pGC, pBitMap, pDrawable, dx, dy, xOrg, yOrg);
	return;
	}

switch (fillstyle)
	{
	case FillSolid:
		break;
	case FillTiled:
	case FillOpaqueStippled:
	case FillStippled:
		ppcPushPixels(pGC, pBitMap, pDrawable, dx, dy, xOrg, yOrg);
		return;
	default :
		ErrorF( "ibm8514PushPixels: Unknown fill Style\n" ) ;
		return ;
	}

/* Find The Actual Regions To Fill
 * by intersecting the destination's clip-region with
 * the box defined by our arguments.
 */
{
        BoxRec          dstBox ;

        dstBox.x2 = ( dstBox.x1 = xOrg ) + dx ;
        dstBox.y2 = ( dstBox.y1 = yOrg ) + dy ;

	pScrn = (ScreenPtr) pDrawable->pScreen ;

        prgnDst = (* pScrn->RegionCreate )( &dstBox,
                                            REGION_NUM_RECTS(gcPriv->pCompositeClip)) ;
        (* pScrn->Intersect)( prgnDst, prgnDst, gcPriv->pCompositeClip ) ;
        if ( !( nbox = REGION_NUM_RECTS(prgnDst) ) )
		{
		(* pScrn->RegionDestroy )( prgnDst);
                return ;
		}
        pbox = REGION_RECTS(prgnDst) ;
}

dx =  MIN(dx,_8514_SCREEN_WIDTH);

dxInWords = (dx+31) >> 5;
wInWords = (pBitMap->drawable.width + 31) >> 5;

if (dxInWords < wInWords)
	{
	/* fill the stage line by line */
	data = pBitMap->devPrivate.ptr;
	for ( i = 0 ; i < dy ; i++ )
		{
		/* since I know I'm one line high, I can lie about
		   end-of-line padding and use ByteAlign */
		ibm8514ByteAlignMonoImage(MONO_STAGE_WPLANE, GXcopy,
			MONO_STAGE_X,  MONO_STAGE_Y+i,
			dx, 1, data);
		data += pBitMap->devKind;
		}
	}
   else 
	ibm8514AlignMonoImage(MONO_STAGE_WPLANE, GXcopy,
			MONO_STAGE_X,  MONO_STAGE_Y,
			dx, dy, pBitMap->devPrivate.ptr );

/* OK, the bitmap is on the stage */
switch (fillstyle)
	{
	case FillSolid:
		for ( nbox = REGION_NUM_RECTS(prgnDst), pbox = REGION_RECTS(prgnDst) ;
		      nbox-- ;
		      pbox++ )
			{
			thisX = pbox->x1;
			thisY = pbox->y1;
			ibm8514BlitFG(MONO_STAGE_RPLANE, 
					gcPriv->colorRrop.planemask,
					gcPriv->colorRrop.fgPixel, alu, 
					MONO_STAGE_X + thisX - xOrg,
					MONO_STAGE_Y + thisY - yOrg,
					thisX, thisY,
					pbox->x2 - thisX,
					pbox->y2 - thisY  );
			}
		break;
	case FillTiled:
	case FillOpaqueStippled:
	case FillStippled:
		ErrorF(
		"ibm8514PushPixels: Serious Error. Unsupported fill Style\n" ) ;
		break;
	default :
		ErrorF( "ibm8514PushPixels: Unknown fill Style\n" ) ;
		break;
	}
(* pScrn->RegionDestroy )( prgnDst);
return ;
}
