/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcRect.c,v 6.3 89/05/07 15:11:19 paul Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcRect.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcRect.c,v 6.3 89/05/07 15:11:19 paul Exp $" ;
#endif

#include "x8514.h"
#include "ibmTrace.h"

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;

void
ibm8514DrawRectangle(color, merge, planes, x0, y0, lx, ly)
unsigned long int color ;
int merge ;
unsigned long int planes ;
short  x0, y0, lx, ly ;
{
int CursorIsSaved ;
TRACE(("ibm8514DrawRectangle(color=%d, merge=x%x, planes=%02x, x=%d, y=%d, lx=%d, ly=%d\n",
	color, merge, planes, x0, y0, lx, ly)) ;

   if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;
   CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor(x0, y0, lx, ly) ;

   ibm8514ATRNotBusy ;
   ibm8514CheckQueue(8) ;
   SETFN1(FNCOLOR1, mergexlate[merge]) ;
   SETCOL1(color) ;
   PLNWENBL(planes) ;
   SETY0(y0) ;
   SETX0(x0) ;
   SETLY(ly-1) ;
   SETLX(lx-1) ;
   COMMAND(0x80b3) ; /* Horizontal Rect operation, DX = DY = 'increasing'*/

   ibm8514ClearQueue(2) ;
   PLNWENBL( ibm8514ALLPLANES ) ;
   SETFN1(FNCOLOR1, FNREPLACE) ;

   if (CursorIsSaved)
	ibm8514ReplaceCursor() ;
   return ;
}
