/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#include "X.h"
#include "misc.h"
#include "miscstruct.h"
#include "scrnintstr.h"
#include "cursorstr.h"

#include "ibmScreen.h"

#include "x8514.h"

extern Bool ibm8514ScreenInit() ;
extern Bool ibm8514Probe() ;
extern void ibm8514RemoveCursor() ;
extern void ibm8514ShowCursor() ;
extern void ibm8514SuspendScreenAndSave() ;
extern void ibm8514RestoreScreenAndActivate() ;
extern PixmapFormatRec ibm8514Formats[] ;

ibmPerScreenInfo ibm8514ScreenInfoStruct = {

	{ 0, 0,
	  _8514_SCREENWIDTH - 1,
	  _8514_SCREENHEIGHT - 1 },	/* BoxRec	 ibm_ScreenBounds ; */
	1,			/* int		 ibm_NumFormats ; */
	ibm8514Formats,		/* PixmapFormatRec	*ibm_ScreenFormats ; */
	ibm8514ScreenInit,	/* Bool		(*ibm_InitFunc)() ; */
	ibm8514Probe,		/* int		(*ibm_ProbeFunc)() ; */
	ibm8514RemoveCursor,	/* void		(*ibm_HideCursor)() ; */
	"-8514",		/* char		 *ibm_ScreenFlag ; */
	IBM8514_DEV_FILE,		/* char		 *ibm_ScreenDevice ; */
	"/dev/ms8514",			/* char		 *ibm_ScreenPointer ; */
	ibm8514SuspendScreenAndSave,/* void		(*ibm_SaveFunc)() ; */
	ibm8514RestoreScreenAndActivate,/* void	(*ibm_RestoreFunc)() ; */
	(ScreenPtr) 0,		/* ScreenPtr	  ibm_Screen */
	-1,			/* int		  ibm_ScreenFD */
	0,			/* int		  ibm_Wanted */
	0,			/* short	  ibm_CursorHotX */
	0,			/* short	  ibm_CursorHotY */
	ibm8514ShowCursor,	/* void		(*ibm_CursorShow)() */
	(CursorPtr) 0,		/* CursorPtr	  ibm_CurrentCursor */
	SCREEN_UNINITIALIZED	/* int		  ibm_ScreenState */
} ;
