/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcText.c,v 6.4 89/05/18 15:05:05 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcText.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcText.c,v 6.4 89/05/18 15:05:05 jeff Exp $";
#endif

/* Draw character glyphs on the screen, knowing that they have been
 * cached offscreen.  Worry about traditional X clipping and such.
 * 
 * You may wonder why I figure the background rectangle size every
 * time this is called, rather than just multiplying some font-specific
 * char size times the number of glyphs and using that.  The protocol
 * evidently has other views of this issue, so we do what it says;
 * the protocol is the bible here.  If the glyphs vary widely in size,
 * we come through with flying colors. (figuratively)
 * 
 */
#include	"X.h"
#include	"Xproto.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"gcstruct.h"
#include	"windowstr.h"
#include	"scrnintstr.h"
#include	"pixmapstr.h"
#include	"regionstr.h"

#include	"mfb.h"

#include	"OScompiler.h"

#include	"ppc.h"

#include	"x8514.h"
#include 	"brcFonts.h"

#include	"ibmTrace.h"

extern int ibm8514Disabled ;

extern ibm8514FontCacheRec ibm8514FontCacheEntry[];
extern int ibm8514cursorSemaphore ;
extern int mfbGCPrivateIndex ;

static unsigned int
miWidth(n, charinfo)
    register unsigned int n;
    register CharInfoPtr charinfo[];
{
    register unsigned int w = 0;

    while ( n-- )
	w += charinfo[n]->metrics.characterWidth ;

    return w;
}

static int 
ibm8514CachedPolyText( pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    char	*chars;
    FontEncoding fontEncoding;
{
    CharInfoPtr 	*ppci;
    ExtentInfoRec 	info;
    RegionPtr		prgnClip, pCC;
    int			CursorIsSaved,i, alu ;
    unsigned long int	rPM, wPM ;
    int			index, nbox, x0, y0;
    unsigned long int	fg ;
    ScreenPtr		pscr;
    FontPtr		pFont;
    InstalledFontPtr	pInFont;
    InstalledCharPtr	pChar;
    xRectangle		backrect;
    BoxRec		*pbox, bbox, cbox;
    xCharInfo		*pBig, *pMetrics;
    int			maxw, maxh, charoffset, lineoffset;
    int			charFirst, charLast;
    unsigned short 	*chars16 = (unsigned short *) chars;

pCC = ((ppcPrivGC *)pGC->devPrivates[mfbGCPrivateIndex].ptr)->pCompositeClip;
if ( !( nbox = REGION_NUM_RECTS(pCC) ) )
	return 0 ;
pbox = REGION_RECTS(pCC);

pscr = pGC->pScreen;
pFont = pGC->font;
index = pscr->myNum;
pInFont = (InstalledFontPtr) pFont->devPriv[index];
rPM = ibm8514FontCacheEntry[pInFont->CacheIndex].RPlaneMask;

alu = pGC->alu;
wPM = pGC->planemask;
fg  = pGC->fgPixel;
  
x += pDraw->x;
y += pDraw->y;

lineoffset = pInFont->startline;
charFirst  = charoffset = pInFont->firstchar;
charLast   = pInFont->lastchar;

ppci = (CharInfoPtr *) ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
switch ( fontEncoding)
	{
	case Linear16Bit:
		{
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars16[i]) &&  
	     		(charLast  >= chars16[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars16[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
		}
	case Linear8Bit:
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars[i]) &&  
	     		(charLast  >= chars[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
	default:
		ErrorF("ibm8514CachedPolyText: bad font encoding");
		return 0;
	}

QueryGlyphExtents(pFont,ppci,count,&info);
DEALLOCATE_LOCAL(ppci);

backrect.x = x + info.overallLeft;
backrect.y = y - pFont->pFI->fontAscent;
backrect.width = info.overallRight - info.overallLeft;
backrect.width = MAX( backrect.width, info.overallWidth );
backrect.height = pFont->pFI->fontAscent + pFont->pFI->fontDescent;

pBig = &(pFont->pFI->maxbounds.metrics);
maxw = count * (pBig->rightSideBearing - pBig->leftSideBearing);
maxh =  (pBig->ascent + pBig->descent);

CursorIsSaved = !ibm8514cursorSemaphore
     && ( ibm8514CheckCursor( backrect.x, backrect.y,
			      backrect.width, backrect.height )
/* if fonts are correct, the next line may get deleted someday */
       || ibm8514CheckCursor(x, y, maxw, maxh) ) ;
ibm8514cursorSemaphore++ ;

bbox.x1 = x + info.overallLeft;
bbox.y1 = y - info.overallAscent;
bbox.x2 = x + info.overallRight;
bbox.y2 = y + info.overallDescent;

switch ( (*pscr->RectIn)(pCC, &bbox))
	{
	case rgnOUT: 
		break;
	case rgnIN:
		while ( count--)
			{
			if (fontEncoding == Linear8Bit)
				index = *chars++ - charoffset;
			   else index = *chars16++ - charoffset;

			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if (pChar->pInfo->exists)
				{
				x0 = x + pMetrics->leftSideBearing;
				y0 = y - pMetrics->ascent;
if ( !ibm8514Disabled )
				ibm8514BlitFG(rPM,wPM,fg,alu,
					pChar->x, lineoffset + pChar->y, 
					x0, y0, pChar->w, pChar->h);
				}
			x += pMetrics->characterWidth;
			}	 
		break;
	case rgnPART:
		prgnClip = (*(pscr->RegionCreate))((BoxRec *)NULL,1);
		while ( count--)
			{
			index = *chars++ - charoffset;
			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if (pChar->pInfo->exists)
				{
				cbox.x1 = x0 = x + pMetrics->leftSideBearing;
				cbox.y1 = y0 = y - pMetrics->ascent;
				cbox.x2 = cbox.x1 + pChar->w;
				cbox.y2 = cbox.y1 + pChar->h;

				switch ( (*pscr->RectIn)(pCC, &cbox))
					{
					case rgnOUT:
						break;
					case rgnIN:
if ( !ibm8514Disabled )
						ibm8514BlitFG(rPM,wPM,fg,alu,
							pChar->x, 
							lineoffset+pChar->y, 
							x0, y0, 
							pChar->w, pChar->h);
						break;
					case rgnPART:
						(*(pscr->RegionReset))(
						   prgnClip, &cbox);
						(*(pscr->Intersect))(
						   prgnClip,prgnClip,pCC);
						pbox = REGION_RECTS(prgnClip);
						nbox = REGION_NUM_RECTS(prgnClip);
						if (nbox==0) break;
if ( !ibm8514Disabled )
						for (i = 0 ; i <nbox; i++, pbox++)
							{
							ibm8514ClearQueue(4);
							SETXMIN(pbox->x1);
							SETYMIN(pbox->y1);
							SETXMAX(pbox->x2-1);
							SETYMAX(pbox->y2-1);
							ibm8514BlitFG(
								rPM,
								wPM,
								fg,
								alu,
								pChar->x, 
								lineoffset +
								pChar->y, 
								x0, 
								y0, 
								pChar->w, 
								pChar->h);
							}
if ( !ibm8514Disabled ) {
						ibm8514ClearQueue(4);
						SETXMIN(0);
						SETYMIN(0);
						SETXMAX(_8514_SCREENWIDTH-1);
						SETYMAX( 1023 );
}
						break;
					} /* end second switch */
				}
			x += pMetrics->characterWidth;
			}
		(*(pscr->RegionDestroy))(prgnClip);
	default:
		break;
	}/* end main switch */
if ( !(--ibm8514cursorSemaphore) && CursorIsSaved )
	ibm8514ReplaceCursor();

return x- pDraw->x;
}

static int
ibm8514CachedImageText( pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    char	*chars;
    FontEncoding fontEncoding;
{
    CharInfoPtr 	*ppci;
    ExtentInfoRec 	info;
    RegionPtr		prgnClip, pCC;
    int			CursorIsSaved,i ;
    unsigned long int	rPM, wPM ;
    int			index, nbox, x0, y0;
    unsigned long int	fg, bg;
    ScreenPtr		pscr;
    FontPtr		pFont;
    InstalledFontPtr	pInFont;
    InstalledCharPtr	pChar;
    xRectangle		backrect;
    BoxRec		*pbox, bbox, cbox;
    xCharInfo		*pBig, *pMetrics;
    int			maxw, maxh, charoffset, lineoffset;
    int			charFirst, charLast;
    unsigned short 	*chars16 = (unsigned short *) chars;


pCC = ((ppcPrivGC *)pGC->devPrivates[mfbGCPrivateIndex].ptr)->pCompositeClip;
if ( !( nbox = REGION_NUM_RECTS(pCC) ) )
	return 0 ;
pbox = REGION_RECTS(pCC);

pscr = pGC->pScreen;
pFont = pGC->font;
index = pscr->myNum;
pInFont = (InstalledFontPtr) pFont->devPriv[index];
rPM = ibm8514FontCacheEntry[pInFont->CacheIndex].RPlaneMask;

wPM = pGC->planemask;
bg  = pGC->bgPixel;
fg  = pGC->fgPixel;
  
x += pDraw->x;
y += pDraw->y;

lineoffset = pInFont->startline;
charFirst  = charoffset = pInFont->firstchar;
charLast   = pInFont->lastchar;


ppci = (CharInfoPtr *) ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
switch ( fontEncoding)
	{
	case Linear16Bit:
		{
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars16[i]) &&  
	     		(charLast  >= chars16[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars16[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
		}
	case Linear8Bit:
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars[i]) &&  
	     		(charLast  >= chars[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
	default:
		ErrorF("ibm8514CachedImageText: bad font encoding");
		return 0;
	}

QueryGlyphExtents(pFont,ppci,count,&info);
DEALLOCATE_LOCAL(ppci);

backrect.x = x + info.overallLeft;
backrect.y = y - pFont->pFI->fontAscent;
backrect.width = info.overallRight - info.overallLeft;
backrect.width = MAX( backrect.width, info.overallWidth );
backrect.height = pFont->pFI->fontAscent + pFont->pFI->fontDescent;

pBig = &(pFont->pFI->maxbounds.metrics);
maxw = count * (pBig->rightSideBearing - pBig->leftSideBearing);
maxh =  (pBig->ascent + pBig->descent);

CursorIsSaved = !ibm8514cursorSemaphore
     && ( ibm8514CheckCursor( backrect.x, backrect.y,
			      backrect.width, backrect.height )
/* if fonts are correct, the next line may get deleted someday */
       || ibm8514CheckCursor(x, y, maxw, maxh) ) ;
ibm8514cursorSemaphore++ ;

if ( !ibm8514Disabled ) {
for ( i = 0 ; i <nbox; i++, pbox++)
	{
	ibm8514ClearQueue(4);
	SETXMIN(pbox->x1);
	SETYMIN(pbox->y1);
	SETXMAX(pbox->x2-1);
	SETYMAX(pbox->y2-1);
	ibm8514DrawRectangle(bg,GXcopy,wPM, backrect.x, backrect.y,
				backrect.width, backrect.height);
	}
ibm8514ClearQueue(4);
SETXMIN(0);
SETYMIN(0);
SETXMAX(_8514_SCREENWIDTH-1);
SETYMAX( 1023 );
}

bbox.x1 = x + info.overallLeft;
bbox.y1 = y - info.overallAscent;
bbox.x2 = x + info.overallRight;
bbox.y2 = y + info.overallDescent;

switch ( (*pscr->RectIn)(pCC, &bbox))
	{
	case rgnOUT: 
		break;
	case rgnIN:
		while (count--)
			{
				/* 2d16bit already bombed */
			if (fontEncoding == Linear8Bit)
				index = *chars++ - charoffset;
			   else index = *chars16++ - charoffset;

			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if (pChar->pInfo->exists)
				{
				x0 = x + pMetrics->leftSideBearing;
				y0 = y - pMetrics->ascent;
if ( !ibm8514Disabled )
				ibm8514BlitFG(rPM,wPM,fg,GXcopy,
					pChar->x, lineoffset + pChar->y, 
					x0, y0, pChar->w, pChar->h);
				}
			x += pMetrics->characterWidth;
			}	 
		break;
	case rgnPART:
		prgnClip = (*(pscr->RegionCreate))((BoxRec *)NULL,REGION_NUM_RECTS(pCC));
		while ( count--)
			{
			index = *chars++ - charoffset;
			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if (pChar->pInfo->exists)
				{
				cbox.x1 = x0 = x + pMetrics->leftSideBearing;
				cbox.y1 = y0 = y - pMetrics->ascent;
				cbox.x2 = cbox.x1 + pChar->w;
				cbox.y2 = cbox.y1 + pChar->h;

				switch ( (*pscr->RectIn)(pCC, &cbox))
					{
					case rgnOUT:
						break;
					case rgnIN:
if ( !ibm8514Disabled )
						ibm8514BlitFG(rPM,wPM,fg,GXcopy,
							pChar->x, 
							lineoffset+pChar->y, 
							x0, y0, 
							pChar->w, pChar->h);
						break;
					case rgnPART:
						(*(pscr->RegionReset))(
						   prgnClip,&cbox);
						(*(pscr->Intersect))(
						   prgnClip,prgnClip,pCC);
						pbox = REGION_RECTS(prgnClip);
						nbox = REGION_NUM_RECTS(prgnClip);
						if (nbox==0) break;
if ( !ibm8514Disabled ) {
						for (i = 0 ; i <nbox; i++, pbox++)
							{
							ibm8514ClearQueue(4);
							SETXMIN(pbox->x1);
							SETYMIN(pbox->y1);
							SETXMAX(pbox->x2-1);
							SETYMAX(pbox->y2-1);
							ibm8514BlitFG(
								rPM,
								wPM,
								fg,
								GXcopy,
								pChar->x, 
								lineoffset +
								pChar->y, 
								x0, 
								y0, 
								pChar->w, 
								pChar->h);
							}
						ibm8514ClearQueue(4);
						SETXMIN(0);
						SETYMIN(0);
						SETXMAX(_8514_SCREENWIDTH-1);
						SETYMAX( 1023 );
}
						break;
					} /* end second switch */
				}
			x += pMetrics->characterWidth;
			}
		(*(pscr->RegionDestroy))(prgnClip);
	default:
		break;
	}/* end main switch */
if ( !(--ibm8514cursorSemaphore) && CursorIsSaved )
	ibm8514ReplaceCursor();

return x - pDraw->x;
}

static int
ibm8514PolyText(pDraw, pGC, x, y, count, chars, fontEncoding )
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    char 	*chars;
    FontEncoding fontEncoding;
{
    CharInfoPtr *charinfo;
    unsigned int n, w = 0;

switch ( (long) pGC->font->devPriv[pDraw->pScreen->myNum] )
	{
	case FT_VARPITCH:
	case FT_FIXPITCH:
	case FT_SMALLPITCH:
		break;
	default:
		switch (pGC->fillStyle )
			{
			case FillSolid:
				return ibm8514CachedPolyText(pDraw, pGC, 
					x, y, count, chars, fontEncoding);
			case FillOpaqueStippled :
			case FillStippled :
				return ibm8514StipCachedText( pDraw, pGC, 
					x, y, count, chars, fontEncoding);
			default:
				break;
			}
	}

if ( !(charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(
		count*sizeof(CharInfoPtr ))))
	return x ;
GetGlyphs(pGC->font, count, chars, fontEncoding, &n, charinfo);
if ( n ) {
	w = miWidth(n, charinfo);
	(*pGC->ops->PolyGlyphBlt)(
	pDraw, pGC, x, y, n, charinfo, pGC->font->pGlyphs);
}

DEALLOCATE_LOCAL(charinfo);
return x + w ;
}

static int
ibm8514ImageText(pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int 	x, y;
    int 	count;
    char 	*chars;
    FontEncoding fontEncoding;
{
CharInfoPtr *charinfo;
unsigned int n, w = 0;

switch ( (long) pGC->font->devPriv[pDraw->pScreen->myNum] )
	{
	case FT_VARPITCH:
	case FT_FIXPITCH:
	case FT_SMALLPITCH:
    		if ( !(charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(
				count*sizeof(CharInfoPtr ))))
			return x ;
    		GetGlyphs(pGC->font, count, chars, fontEncoding, &n, charinfo);
    		if ( n ) {
    			w = miWidth(n, charinfo);
        		(*pGC->ops->ImageGlyphBlt)(
	    		pDraw, pGC, x, y, n, charinfo, pGC->font->pGlyphs);
		}
		
    		DEALLOCATE_LOCAL(charinfo);
    		return x + w ;
	}
return ibm8514CachedImageText(pDraw, pGC, x, y, count, chars, fontEncoding);
}

int
ibm8514PolyText8(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int 	count;
    char	*chars;
{
    return ibm8514PolyText(pDraw, pGC, x, y, count, chars, Linear8Bit);
}

int
ibm8514PolyText16(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    unsigned short *chars;
{
return ibm8514PolyText( pDraw, pGC, x, y, count, (char *)chars,
			( (pGC->font->pFI->lastRow == 0)
			? Linear16Bit : TwoD16Bit ) ) ;
}

void
ibm8514ImageText8(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    char	*chars;
{
    ibm8514ImageText(pDraw, pGC, x, y, count, chars, Linear8Bit);
}

void
ibm8514ImageText16(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    unsigned short *chars;
{
ibm8514ImageText( pDraw, pGC, x, y, count, (char *)chars,
			( (pGC->font->pFI->lastRow == 0)
			? Linear16Bit : TwoD16Bit ) ) ;
return ;
}

static int 
ibm8514StipCachedText( pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    char	*chars;
    FontEncoding fontEncoding;
{
    CharInfoPtr 	*ppci;
    ExtentInfoRec 	info;
    RegionPtr		prgnDst, pCC;
    int			CursorIsSaved,i, alu ;
    unsigned long int	rPM, wPM ;
    int			index, nbox, x0, y0, icount;
    char*               ichars = chars;
    unsigned long int	fg , bg;
    ScreenPtr		pscr;
    FontPtr		pFont;
    InstalledFontPtr	pInFont;
    InstalledCharPtr	pChar;
    BoxRec		*pbox, bbox ;
    xCharInfo		*pBig, *pMetrics;
    int			maxw, maxh, charoffset, lineoffset;
    int			charFirst, charLast;
    unsigned short 	*chars16 = (unsigned short *) chars;
    int			stageX, stageY;
    void		GetStippleOnStage();

pCC = ((ppcPrivGC *)pGC->devPrivates[mfbGCPrivateIndex].ptr)->pCompositeClip;

pscr = pGC->pScreen;
pFont = pGC->font;
index = pscr->myNum;
pInFont = (InstalledFontPtr) pFont->devPriv[index];
rPM = ibm8514FontCacheEntry[pInFont->CacheIndex].RPlaneMask;

x += pDraw->x;
y += pDraw->y;

if (!( REGION_NUM_RECTS(pCC))) return x- pDraw->x;
if ((alu = pGC->alu) == GXnoop) return x- pDraw->x;
wPM = pGC->planemask;
fg  = pGC->fgPixel;
bg  = pGC->bgPixel;

lineoffset = pInFont->startline;
charFirst  = charoffset = pInFont->firstchar;
charLast   = pInFont->lastchar;

ppci = (CharInfoPtr *) ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
switch ( fontEncoding)
	{
	case Linear16Bit:
		{
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars16[i]) &&  
	     		(charLast  >= chars16[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars16[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
		}
	case Linear8Bit:
		for (i = 0 ; i <count; i++) 
			if ( (charFirst <= chars[i]) &&  
	     		(charLast  >= chars[i]) )
	   		then	ppci[i] = pInFont->
					ppCharacter[chars[i]-charoffset]->
					pInfo;
	   		else 	{ i--; count--; } /* ignore this character */
		break;
	default:
		ErrorF("ibm8514CachedPolyText: bad font encoding");
		return 0;
	}

QueryGlyphExtents(pFont,ppci,count,&info);
DEALLOCATE_LOCAL(ppci);

pBig = &(pFont->pFI->maxbounds.metrics);
maxw = count * (pBig->rightSideBearing - pBig->leftSideBearing);
maxh =  (pBig->ascent + pBig->descent);

bbox.x1 = x + info.overallLeft;
bbox.y1 = y - info.overallAscent;
bbox.x2 = x + info.overallRight;
bbox.y2 = y + info.overallDescent;


prgnDst = (* pscr->RegionCreate )( &bbox, REGION_NUM_RECTS(pCC)) ;
(* pscr->Intersect)( prgnDst, prgnDst, pCC ) ;

if (!( REGION_NUM_RECTS(prgnDst)))
	return x- pDraw->x;

CursorIsSaved = !ibm8514cursorSemaphore
     && ( ibm8514CheckCursor( bbox.x1, bbox.y1,
			      bbox.x2 - bbox.x1, bbox.x2 - bbox.x1 )
/* if fonts are correct, the next line may get deleted someday */
       || ibm8514CheckCursor(x, y, maxw, maxh) ) ;
ibm8514cursorSemaphore++ ;

switch (pGC->fillStyle)
	{
	case FillOpaqueStippled:
		stageX = 0;
		stageY = MONO_STAGE_Y + info.overallAscent;
		GetStippleOnStage(pGC, &bbox);
		icount = count;
		while ( icount--)
			{
			if (fontEncoding == Linear8Bit)
				index = *chars++ - charoffset;
	   		else index = *chars16++ - charoffset;
		
			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if ((pChar->pInfo->exists) && 
					(stageX+x+pChar->w >= bbox.x1))
				{
				x0 = stageX + pMetrics->leftSideBearing;
				y0 = stageY - pMetrics->ascent;
if ( !ibm8514Disabled )
				ibm8514BlitFGBG(
					rPM, MONO_STAGE_WPLANE,
					255,0,GXandInverted,
					pChar->x, lineoffset + pChar->y, 
					x0, y0, 
					pChar->w, pChar->h);
				}
			stageX += pMetrics->characterWidth;
			if (stageX + x > bbox.x2) break;
			}	 
if ( !ibm8514Disabled )
		for (nbox = REGION_NUM_RECTS(prgnDst), pbox = REGION_RECTS(prgnDst);
				nbox--;
				pbox++)
			{
			x0 = pbox->x1;
			y0 = pbox->y1;
			ibm8514BlitFG(
				MONO_STAGE_RPLANE, wPM, bg, alu,
				MONO_STAGE_X + x0 - x,
				stageY +y0-y,
				x0, y0,
				pbox->x2 - x0,
				pbox->y2 - y0 );
			}

		/* fall through to do the foreground */
	case FillStippled:
		stageX = 0;
		stageY = MONO_STAGE_Y + info.overallAscent;
if ( !ibm8514Disabled )
		GetStippleOnStage(pGC, &bbox);
		icount = count;
		if (fontEncoding == Linear8Bit)
			chars = ichars;
	   	else chars16 = (unsigned int*)ichars;
		while ( icount--)
			{
			if (fontEncoding == Linear8Bit)
				index = *chars++ - charoffset;
	   		else index = *chars16++ - charoffset;
		
			pChar=(InstalledCharPtr)pInFont->ppCharacter[index];
			pMetrics = (xCharInfo *)(&(pChar->pInfo->metrics));
			if ((pChar->pInfo->exists) && 
					(stageX+x+pChar->w >= bbox.x1))
				{
				x0 = stageX + pMetrics->leftSideBearing;
				y0 = stageY - pMetrics->ascent;
if ( !ibm8514Disabled )
				ibm8514BlitFGBG(
					rPM, MONO_STAGE_WPLANE,
					255,0,GXand,
					pChar->x, lineoffset + pChar->y, 
					x0, y0, 
					pChar->w, pChar->h);
				}
			stageX += pMetrics->characterWidth;
			if (stageX + x > bbox.x2) break;
			}	 
if ( !ibm8514Disabled )
		for (nbox = REGION_NUM_RECTS(prgnDst), pbox = REGION_RECTS(prgnDst);
				nbox--;
				pbox++)
			{
			x0 = pbox->x1;
			y0 = pbox->y1;
			ibm8514BlitFG(
				MONO_STAGE_RPLANE, wPM, fg, alu,
				MONO_STAGE_X + x0 - x,
				stageY +y0-y,
				x0, y0,
				pbox->x2 - x0,
				pbox->y2 - y0 );
			}

		break;
	}
if ( !(--ibm8514cursorSemaphore) && CursorIsSaved )
	ibm8514ReplaceCursor();

return x- pDraw->x;
}


static void
GetStippleOnStage(pGC, pbox)
GCPtr	pGC;
BoxRec *pbox;
{
PixmapPtr 	pStipple;
register int j;
int tlx, tly, boxW, boxH, drawW, drawH, grow;
int hoffset, voffset, vremaining, hremaining;
int xSrc, ySrc;

pStipple = pGC->stipple;

tlx = pStipple->drawable.width;
tly = pStipple->drawable.height;
xSrc = pGC->patOrg.x;
ySrc = pGC->patOrg.y;

boxH = pbox->y2 - pbox->y1;
boxW = pbox->x2 - pbox->x1;
drawW = MIN(boxW, tlx);
drawH = MIN(boxH, tly);

if ((hoffset = ((pbox->x1-xSrc)%tlx)) < 0)
		hoffset += tlx;
hremaining = tlx-hoffset;

if ((voffset = ((pbox->y1-ySrc)%tly)) < 0)
		voffset += tly;
vremaining = tly-voffset;

#define FILL_STAGE_X 0
#define FILL_STAGE_Y 802
if (hoffset)
	{
	ibm8514AlignMonoImage(FILL_STAGE_WPLANE, GXcopy,
			FILL_STAGE_X, FILL_STAGE_Y,
			tlx, drawH, pStipple->devPrivate.ptr );
	/* LOWER RIGHT RECTANGLE */
        ibm8514Bitblt
                (
                GXcopy, RPLANE1, MONO_STAGE_WPLANE,
                FILL_STAGE_X+hoffset, FILL_STAGE_Y+voffset,
                MONO_STAGE_X, MONO_STAGE_Y,
                MIN(hremaining,drawW), MIN(vremaining,drawH)
                );

        /* LOWER LEFT RECTANGLE */
        if (drawW > hremaining)
        ibm8514Bitblt
                (
                GXcopy, RPLANE1, MONO_STAGE_WPLANE,
                FILL_STAGE_X, FILL_STAGE_Y+voffset,
                MONO_STAGE_X+hremaining, MONO_STAGE_Y,
                drawW-hremaining, MIN(vremaining,drawH)
                );

        /* UPPER RIGHT RECTANGLE */
        if (drawH > vremaining)
            {
            ibm8514Bitblt
                (
                GXcopy, RPLANE1, MONO_STAGE_WPLANE,
                FILL_STAGE_X+hoffset, FILL_STAGE_Y,
                MONO_STAGE_X, MONO_STAGE_Y+vremaining,
                MIN(hremaining,drawW), drawH - vremaining
                );

        /* UPPER LEFT RECTANGLE */
            if (drawW > hremaining)
                ibm8514Bitblt
                        (
                        GXcopy, RPLANE1, MONO_STAGE_WPLANE,
                        FILL_STAGE_X, FILL_STAGE_Y,
                        MONO_STAGE_X+hremaining, MONO_STAGE_Y+vremaining,
                        drawW-hremaining, drawH-vremaining
                        );
	     }
	}
   else {
	if (voffset)
		{
		j = MIN(vremaining,drawH); 
		ibm8514AlignMonoImage(MONO_STAGE_WPLANE, GXcopy,
			MONO_STAGE_X, MONO_STAGE_Y,
			tlx, j,
			pStipple->devPrivate.ptr +
				voffset*pStipple->devKind);
		if (j<drawH)
			ibm8514AlignMonoImage(MONO_STAGE_WPLANE, GXcopy,
				MONO_STAGE_X, MONO_STAGE_Y + j,
				tlx, drawH-j,
				pStipple->devPrivate.ptr );
			
		}
	   else ibm8514AlignMonoImage(MONO_STAGE_WPLANE, GXcopy,
			MONO_STAGE_X, MONO_STAGE_Y,
			tlx, drawH, pStipple->devPrivate.ptr );
	}
while (  drawW < boxW)
	{
	grow = MIN(drawW, boxW-drawW);
	ibm8514Bitblt(GXcopy,MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		0, MONO_STAGE_Y,
		drawW, MONO_STAGE_Y,
		grow, drawH);
	drawW += grow;
	}
while ( drawH < boxH)
	{
	grow = MIN(drawH, boxH-drawH);
	ibm8514Bitblt(GXcopy,MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		0, MONO_STAGE_Y,
		0, drawH,
		drawW, grow);
	drawH += grow;
	}

return ;
}
