/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *
 * Hardware interface routines for IBM 8514/A adapter for
 * X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/ibm8514reg.h,v 30.0 89/01/23 19:24:09 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/ibm8514reg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidibm8514reg = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/ibm8514reg.h,v 30.0 89/01/23 19:24:09 paul Exp $";
#endif

/* Magic I/O port addresses */
#define QSTATADD 	0xDAE8
#define QCTRLADD 	0x42E8

#if !defined(IBM_OS_HAS_HFT)
#define PALMASK 	0x42EA
#define PALREAD_ADDR 	0x42EB
#define PALWRITE_ADDR 	0x42EC
#define PALDATA 	0x42ED
#else /* HFT on Danbury Kernel. Yuk. */
#define PALMASK 	0x02EA
#define PALREAD_ADDR 	0x02EB
#define PALWRITE_ADDR 	0x02EC
#define PALDATA 	0x02ED
#endif

#define VARDATA		0xE2E8

/* Register Constants -- Wait on I/O busy */
#define ibm8514WaitOnIO		0x4000	/* This Does Wait IF busy */
#define ibm8514_Y0		( 0x82E8 | ibm8514WaitOnIO )
#define ibm8514_X0		( 0x86E8 | ibm8514WaitOnIO )
#define ibm8514_Y1		( 0x8AE8 | ibm8514WaitOnIO )
#define ibm8514_X1		( 0x8EE8 | ibm8514WaitOnIO )
#define ibm8514_K1		ibm8514_Y1
#define ibm8514_K2		ibm8514_X1
#define ibm8514_ErrorAcc	( 0x92E8 | ibm8514WaitOnIO )
#define ibm8514_LX		( 0x96E8 | ibm8514WaitOnIO )
#define ibm8514_Qstatus		( 0x9AE8 )
#define ibm8514_CMD		( ibm8514_Qstatus | ibm8514WaitOnIO )
#define ibm8514_ShortStroke	( 0x9EE8 | ibm8514WaitOnIO )
#define ibm8514_Color0		( 0xA2E8 | ibm8514WaitOnIO )
#define ibm8514_Color1		( 0xA6E8 | ibm8514WaitOnIO )
#define ibm8514_PlaneWE		( 0xAAE8 | ibm8514WaitOnIO )
#define ibm8514_PlaneRE		( 0xAEE8 | ibm8514WaitOnIO )
#define ibm8514_ColorCMP	( 0xB2E8 | ibm8514WaitOnIO )
#define ibm8514_Func0		( 0xB6E8 | ibm8514WaitOnIO )
#define ibm8514_Func1		( 0xBAE8 | ibm8514WaitOnIO )
#define ibm8514_SecDecode	( 0xBEE8 | ibm8514WaitOnIO )
#define ibm8514_Control		( 0x42E8 )
#define ibm8514_Status		ibm8514_Control
#define ibm8514_PromPage	( 0x46E8 )
#define ibm8514_MiscIO		( 0x4AE8 )

/* Manifest Constants */
#define IM_DEEP8 	0x01
#define IM_DEEP4 	0x44
#define IM_MON0  	0x13	/* clear image */
#define IM_MON1  	0x23	/* transmorgrified, and twice as big */

#define M_ONES	 	0xA000
#define M_PATTS  	0xA040
#define M_VAR	 	0xA080
#define M_CPYRCT 	0xA0C0
#define M_ACROSS 	0xA004
#define M_DEPTH  	0xA000
#define M_PLFILL  	0xA004

#define FNCOLOR0 	0x0000
#define FNCOLOR1 	0x0020
#define FNVAR	 	0x0040
#define FNCPYRCT 	0x0060
#define FNREPLACE	0x0007
#define FNNOP		0x0003
#define FNAND		0x000C
#define FNOR		0x000B
#define FNXOR		0x0005
#define FNMIN		0x0010
#define FNMAX		0x0014

#define CLOSE 		ibm8514outw( QCTRLADD, 0 )
#define FULLSC(C) 	rect( C, 0, 0, 1024, 1024 )

#define IBM8514MAXPLANES 8
#define ibm8514ALLPLANES ~( ( ~0 ) << IBM8514MAXPLANES )

#define WPLANE0		0x0001
#define WPLANE1		0x0002
#define WPLANE2		0x0004
#define WPLANE3		0x0008
#define WPLANE4		0x0010
#define WPLANE5		0x0020
#define WPLANE6		0x0040
#define WPLANE7		0x0080
#define WPLANES		ibm8514ALLPLANES

#define RPLANE0		0x0002
#define RPLANE1		0x0004
#define RPLANE2		0x0008
#define RPLANE3		0x0010
#define RPLANE4		0x0020
#define RPLANE5		0x0040
#define RPLANE6		0x0080
#define RPLANE7		0x0001
#define RPLANES		ibm8514ALLPLANES

/* ************************ COMMAND MACROS ************************ */
#define SETMODE(M)	ibm8514outw( ibm8514_SecDecode, M )
#define SETCOL0(C)	ibm8514outw( ibm8514_Color0, C )
#define SETCOL1(C)	ibm8514outw( ibm8514_Color1, C )
#define SETFN0(C, ALU)	ibm8514outw( ibm8514_Func0, ( ( C ) | ( ALU ) ) )
#define SETFN1(C, ALU)	ibm8514outw( ibm8514_Func1, ( ( C ) | ( ALU ) ) )
#define PLNWENBL(C)	ibm8514outw( ibm8514_PlaneWE, C )
#define PLNRENBL(C)	ibm8514outw( ibm8514_PlaneRE, C )
#define COLRCOMP(C)	ibm8514outw( ibm8514_ColorCMP, C )
#define SETVAR(C)	ibm8514outw( VARDATA, C )
#define GETVAR		ibm8514inw( VARDATA )

#define CRTCMODE(C)  	outb( 0x22E8, C )
#define MISCIO(C)   	ibm8514outw( ibm8514_MiscIO, C )
#define SETET(C)   	ibm8514outw( ibm8514_ErrorAcc, C )
#define SETK1(C)   	ibm8514outw( ibm8514_K1, C )
#define SETK2(C)   	ibm8514outw( ibm8514_K2, C )
#define SETY0(C)   	ibm8514outw( ibm8514_Y0, ((C)&0x07FF) )
#define SETX0(C)   	ibm8514outw( ibm8514_X0, ((C)&0x07FF) )
#define SETY1(C)   	ibm8514outw( ibm8514_Y1, ((C)&0x07FF) )
#define SETX1(C)   	ibm8514outw( ibm8514_X1, ((C)&0x07FF) )
#define SETLX(C)   	ibm8514outw( ibm8514_LX, C )
#define SETLY(C)   	ibm8514outw( ibm8514_SecDecode, C )
#define SETXMAX(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x0FFF)|0x4000))
#define SETXMIN(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x0FFF)|0x2000))
#define SETYMAX(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x0FFF)|0x3000))
#define SETYMIN(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x0FFF)|0x1000))
#define SETPAT0(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x001E)|0x8000))
#define SETPAT1(C)  	ibm8514outw( ibm8514_SecDecode, (((C) & 0x001E)|0x9000))
#define COMMAND(C)  	ibm8514outw( QSTATADD, C )

/* ************************ COMMAND DEFINES ************************ */
/* Bits 15, 14 & 13 are the command selector */
#define ibm8514cmd_Null		0x0000
#define ibm8514cmd_Vector	0x2000
#define ibm8514cmd_HRect	0x4000
#define ibm8514cmd_VRect	0x6000
#define ibm8514cmd_FRect	0x8000
#define ibm8514cmd_OutlDraw	0xA000
#define ibm8514cmd_CopyRect	0xC000
#define ibm8514cmd_ILLEGAL	0xE000

/* Bit 12 selects whether the data is byte-swapped */
#if defined(ATRIO) || defined(PCIO)
#define ibm8514ByteOrder	0x1000
#else
	******** Error ********
#endif

/* Bits 10 & 11 are always 0 */

/* Bit 9 selects for 8 or 16 bit data */
#define ibm8514cmd_WordData	0x0000
#define ibm8514cmd_ByteData	0x0200

/* Bit 8 selects for Fixed or variable Data */
#define ibm8514cmd_FData	0x0000
#define ibm8514cmd_VData	0x0100

/* Bits 7, 6 & 5 are the Coded Direction selector */
#define ibm8514cmd_pXpYpZ	0x00E0
#define ibm8514cmd_pXpYnZ	0x00C0
#define ibm8514cmd_pXnYpZ	0x00A0
#define ibm8514cmd_pXnYnZ	0x0080
#define ibm8514cmd_nXpYpZ	0x0060
#define ibm8514cmd_nXpYnZ	0x0040
#define ibm8514cmd_nXnYpZ	0x0020
#define ibm8514cmd_nXnYnZ	0x0000

/* Bit 4 deterines if the does anything */
/* if set to zero the 8514 calculates but doesn't change anything
 * Also if zero no data may be read or written */
#define ibm8514cmd_DoAccess	0x0010
#define ibm8514cmd_MoveOnly	0x0000

/* Bit 3 selects if the Coded Direction field is used */
#define ibm8514cmd_UseCDir	0x0008
#define ibm8514cmd_DontUseCDir	0x0000

/* Bit 2 selects if the Last Pel is accessed */
#define ibm8514cmd_LastPelNull	0x0004
#define ibm8514cmd_UseLastPel	0x0000

/* Bit 1 selects for Actual Pel Accrual */
#define ibm8514cmd_AccruePels	0x0002
#define ibm8514cmd_NoAccrue	0x0000

/* Bit 0 selects for Read or Write Data */
#define ibm8514cmd_Read		0x0000
#define ibm8514cmd_Write	0x0001

/* ************ Actual COMMAND Bitpattern DEFINES ************ */
#define ibm8514WriteZData	( ibm8514cmd_HRect \
				| ibm8514ByteOrder \
				| ibm8514cmd_ByteData \
				| ibm8514cmd_VData \
				| ibm8514cmd_pXpYpZ \
				| ibm8514cmd_DoAccess \
				| ibm8514cmd_DontUseCDir \
				| ibm8514cmd_UseLastPel \
				| ibm8514cmd_NoAccrue \
				| ibm8514cmd_Write )
#define ibm8514ReadZData	( ibm8514cmd_HRect \
				| ibm8514ByteOrder \
				| ibm8514cmd_ByteData \
				| ibm8514cmd_VData \
				| ibm8514cmd_pXpYpZ \
				| ibm8514cmd_DoAccess \
				| ibm8514cmd_DontUseCDir \
				| ibm8514cmd_UseLastPel \
				| ibm8514cmd_NoAccrue \
				| ibm8514cmd_Read )

#define ibm8514WriteXYData	( ibm8514cmd_HRect \
				| ibm8514ByteOrder \
				| ibm8514cmd_ByteData \
				| ibm8514cmd_VData \
				| ibm8514cmd_pXpYpZ \
				| ibm8514cmd_DoAccess \
				| ibm8514cmd_DontUseCDir \
				| ibm8514cmd_UseLastPel \
				| ibm8514cmd_AccruePels \
				| ibm8514cmd_Write )
