        .WIDTH  130
;
;(***********************************************************************)
;(*									*)
;(*  	Copyright (C) 1981, 1982 by National Semiconductor Corporation	*)
;(*									*)
;(*    	National Semiconductor Corporation				*)
;(*	2900 Semiconductor Drive					*)
;(*	Santa Clara, California 95051					*)
;(*									*)
;(*	All Rights Reserved						*)
;(* 									*)
;(*	This software is furnished under a license and may be used	*)
;(*	and copied only in accordance with the terms of such license  	*)
;(*	and with the inclusion of the above copyright notice. This 	*)
;(* 	software or any other copies thereof may not be provided or 	*)
;(*	otherwise made available to any other person. No title to and 	*)
;(*	ownership of the software is hereby transferred.		*)
;(*									*)
;(*	The information in this software is subject to change without   *)
;(*	notice and should not be construed as a commitment by National  *)
;(*	Semiconductor Corporation.					*)
;(*									*)
;(*	National Semiconductor Corporation assumes no responsibility 	*)
;(*	for the use or reliability of its software on equipment 	*)
;(*	configurations which are not supported by National 		*)
;(*     Semiconductor Corporation.					*)
;(*									*)
;(***********************************************************************)
;
;
;       PROGRAM     MON16
;
;       VERSION     2.00
;
;       DATE        31 - JAN - 1983
;
;
;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
;
;
        .MODULE MONCMD
;
;     M O N I T O R    M A I N   L O O P
;       FILE CMD.ASM   31-JUN-82
;		VERSION 2.00
;
;     GLOBAL DEFINITIONS
;
;       TERMINAL RECORD
        .IMPORTP  MNEXIT,SRDLIN,RDLIN,RDCHR,PRINTA,SPRINTA,PRCHR
        .IMPORTP  TBSRCH,HXTOBN,BNTOHX,GETPUT
        .IMPORT	  COMPS
;
	.EXPORTP  MAINLP,SYNTERR,MSGENT,ERENT,SHXTOBN,EHXTOBN
        .EXPORT   REGTB,USX,ISX
        .DSECT
INBUF:  .BLKB   64              ; INPUT BUFER
INLM:   .BLKB   4               ; POINTER TO LAST CHARACTER READ
OUTB:   .EQU    INBUF           ; OUTPUT BUFFER (SAME AS INPUT )
OUTLM:  .EQU    INLM            ; POINTER TO LAST BYTE IN OUTB TO BE PRINTED
TRMRLG: .EQU    *               ; TERMINAL RECORD LENGTH
        .ENDSEG
;
;
;     GLOBAL CONSTANTS
;
STALON: .EQU    0               ; STAND ALONE INDICATOR
TRANSP: .EQU    1               ; TRANSPARENT MODE
PNDMOD:	.EQU	2		; PENNDING INTERRUPT MODE
MONT:	.EQU	0		; MONITOR TIME INDICATOR
TRUE:   .EQU    1               ; DEFINE LOGICAL TRUE
FALSE:  .EQU    0               ; DEFINE LOGICAL FALSE
TRMA:   .EQU    0               ; TERMINAL A
TRMB:   .EQU    1               ; TERMINAL B
NSFBR:  .EQU    14              ; NUMBER OF SOFTWARE BREAK-POINTS
PSR_U:  .EQU    8               ; U BIT IN PSR
PSR_T:  .EQU    1               ; T BIT IN PSR
PSR_S:  .EQU    9               ; S BIT IN PSR
BPR_BE: .EQU    29              ; BE BIT IN BPR REG OF MMU
MOMOD:  .EQU    5               ; MONITOR MODULE NUMBER
BPTC:   .EQU    H'F2            ; BPT INSTRUCTION
SIMONIO: .EQU   700000
;
;
;     ASCII CHARACTERS
;
;
CR:     .EQU    H'0D            ; RETURN
LF:     .EQU    H'0A            ; LINE FEED
DOT:    .EQU    H'2E            ; DOT
COMMA:  .EQU    H'2C            ; COMMA CHARACTER
SPACE:  .EQU    H'20            ; SPACE CHARACTER
;
;
;     GLOBAL VARIABLES
;
STATIC: .EQU    H'8000
        .STATIC                 ; DEFINE STATIC EREA
;
OPMOD:  .BLKB   1               ; OPERATION MODE VARIABLE
OPHND:	.BLKB	1		; OPERATION MODE HAND_SHAKING
MON_USR: .BLKB  1               ; MONITOR/USER TIME FLAG
PNDF:	.BLKB	1		; PENDING INTERRPTS FLAG
DTRM:   .BLKB   4               ; POINTER TO DEFULT TERMINAL BUFFER
NDTRM:  .BLKB   1               ; #  OF DEFULT TERMINAL
SVCPF:	.BLKB	1		; SVC FLAG FOR READ WRITE ROUTINE FOR MOVUS
ERRTYP: .BLKB   1               ; ENTRY TYPE
L:      .BLKB   1	 	; SAVE COMMAND NUMBER
SCRCH1: .BLKB   4               ; SCRACH 1
SCRCH2: .BLKB   4               ; SCRACH 2
STRTADR: .BLKB  4               ; SAVE RESET ADDRESS
ENDADR:  .BLKB  4               ; SAVE END INTERRUPT ROUTINE ADDRESS
SEREA:
SVFP:   .BLKB   4               ; SAVE FP
SVUS:   .BLKB   4               ; SAVE US
SVIS:   .BLKB   4               ; SAVE IS
SVPC:   .BLKB   4               ; SAVE PC
SVMOD:  .BLKB   4               ; SAVE MOD
SVPSR:  .BLKB   4               ; SAVE PSR
SVR7:   .BLKB   4*7             ; SAVE R
SVR0:   .BLKB   4               ; SAVE R0
;
SVMSR:  .BLKB   4               ; SAVE MSR
TMPPSR:
TMPMSR:	.BLKB	4		; TEMPORAY SAVE MSR
SVBPR0: .BLKB   4               ; SAVE BPR0
SVBPR1: .BLKB   4               ; SAVE BPR1
HEAPP:  .BLKB   4               ; HEAP POINTER
HEAPE:  .BLKB   4               ; HEAP END
HEAPS:  .BLKB   4               ; HEAP BEGIN
;
CONFIG: .BLKB   1               ; CONFIGURATION BYTE
MSRWF:	.BLKB	1		; MSR WRITTEN FLAG
;
MNFP:   .BLKB   4               ; SAVE MONITOR FP
MNMSR:	.BLKB	4		; SAVE MONITOR MSR
MNSP:   .BLKB   4               ; SAVE MONITOR SP
MNSPH:	.BLKB	4		; MONITOR HIGH SP
MNPSR:  .BLKB   2               ; MONITOR PSR
BRKAR:  .BLKB   NSFBR*4         ; SOFT-BPR ARRAY
STEPFLG: .BLKB  1               ; STEP FLAG
ACKFLG: .BLKB   1               ; ACKNOLEDGE FLAGE
CXPFLG: .BLKB   1               ; CXP COMMAND COUNTER
	.BLKB	1		; ** FOR ELAINMENT **
STPCNT: .BLKB   4               ; STEP COUNTER
ACTBRK: .BLKB   4               ; # OF CURRENT BREAK
INS:    .BLKB   NSFBR           ; ARRAY OF BRPR INSTRUCTION SAVE
OLDPC:  .BLKB   8               ; SAVE OLD PC,US,IS,MOD IN CXP COMMAND
ENDPC:	.BLKB	4		; PC OF INSERTED BPT ON STACK
ENDPC1:	.BLKB	4		; PC OF BEGIN WHEN CXP ALSO
CNTRLB:	.BLKB	1		; CNTRL/B CHARACTER STARTS EVERY COMMAND
CNTRLL: .BLKB	1		; CNTRL/L CHARACTER START FAST LOAD MESSAGE
CNTRLS: .BLKB	1		; CNTRL/S CHARACTER HOLD SCREEN
CNTRLQ: .BLKB	1		; CNTRL/Q CHARACTER RESUME SCREEN
STUADD: .BLKB   16              ; STU COMMAND VERIABLE ADDRESS
MONUSR1: .BLKB	1		; TEMP SAVE OF MON_USER FLAG
RSTINT:	.BLKD	1		; SAVE RESET VALUE OF INTBASE
JMPRAM: .BLKD	2
;
TERM1:  .BLKB   TRMRLG          ; TERINAL 1 RECORD
TERM2:  .BLKB   TRMRLG          ; TERMINAL 2 RECORD
        .ENDSEG
STACKL: .EQU    H'300           ; STACK EREA END RELATIVE TO START OF SB
;
;
;
;     M A I N   L O O P
;
;
;
;
;    MAIN LOOP CODE
;
        .PROGRAM
;
;  TABLE OF COMMANDS NAME FOR SEARCH
;
REGNTB: .BYTE   "P","C"    ,"U","S"
        .BYTE   "I","S"    ,"I","N"
        .BYTE   "S","B"    ,"F","P"
        .BYTE   "M","O"    ,"P","S"
        .BYTE   "M","S"    ,"E","I"
        .BYTE   "P","T"    ,"P","F"
        .BYTE   "S","C"    ,"B","P"
        .BYTE   "B","C"    ,"M","M"
        .BYTE   "S","P"    ,"F","S"
        .BYTE   "F"," "    ,"R"," "
        .BYTE   "C","F"    ,"H","S"
        .BYTE   "H","E"    ,"H","P"
        .BYTE   "M","B"    ,"M","W"
        .BYTE   "M","D"
REGTLN: .EQU    (*-REGNTB) / 2
PRC:    .EQU    12                      ; DEFINE PRINT COMMAND
CHCM:   .EQU    13                      ; CHANGE COMMAND NUMBER
JSBC:   .EQU    7                       ; JSB COMMAND NUMBER
STWC:   .EQU    6                       ; STW COMMAND NUMBER
CMNDTB: .BYTE   "M"," "    ,"F"," "
        .BYTE   "S","R"    ,"L"," "
        .BYTE   "D"," "    ,"S","U"
        .BYTE   "S","W"    ,"J","S"
        .BYTE   "C","X"    ,"G"," "
        .BYTE   "S","T"    ,"O","M"
        .BYTE   "P"," "    ,"C"," "
        .BYTE   "B"," "	   ,"R","I"
CMNTLN: .EQU    (*-CMNDTB) / 2
CRL:    .BYTE   CR,"L",SPACE
RMSG:	.BYTE	"R VERSION_2.00_10-FEB-83"
RMSGE:
;
;
;
MAINLP:
        ADDR    OUTB+1(R7),R6           ; DTRM.OUTLM:=3
        MOVB    CR,-1(R6)             	; OUTB(DTRM.OUTLN-3):=CR
        MOVXBD  ACKFLG,R3
PROCS: 	CASEB	PROTB[R3:B]		; CASE OF ACKFLG :
PROTB: 	.BYTE	PRO0-PROCS
   	.BYTE	PRO1-PROCS
   	.BYTE	PRO2-PROCS
PRO0:	MOVMD	RMSG,0(R6),4		;   "RESET"
   			; XXX 16
   	MOVMD	RMSG+16,16(R6),(RMSGE-RMSG-16)/4
   				; XXX-16
   	ADDW	RMSGE-RMSG,R6		;    OUTBUF:= RESET MESEG
   	BR	PROPT1		;    INLM[DTRM]:=INLM[DTRM]+RMSGE-RMSG
PRO1:	MOVW	"R"+H'100*"N",0(R6)	;   " RN"
   	ADDQD	2,R6			;    OUTBUF:= "RN"
   	BR	PROPT1		;    OUTLM[DTRM]:=OUTLM[DTRM]+2
PRO2:	MOVB	"*",0(R6)		;   "*"
   	ADDQD	1,R6			;    OUTBUF:= "*"
PROPT1: MOVB    CR,0(R6)                ; OUTB[DTRM.OUTLM]:=CR
        ADDQD   1,R6                    ; DTRM.OUTLM:=DTRM.OUTLM+2;
        CXP     SPRINTA                 ; PRINT (OUTB)
        LPRD    SP,MNSPH		; SET MON.SP TO HIGH
	MOVQB	FALSE,PNDF
        CXP     SRDLIN                  ; CALL STANDARD READ LINE  ROUTINE
FSCN:   CMPD    R5,INLM(R7)             ; IF SCAN = END OF LINE GO TO MAIN LP
        BGE     MAINLP
FSCN2:  CMPB    SPACE,0(R5)             ; IF CHAR >=SPACE GO TO FSCN3
        BLT     FSCN3
        ADDQD   1,R5                    ; DTRM.SCN := DTRM.SCN+1
        BR      FSCN
FSCN3:  CMPQB   2,ACKFLG                ; IF ACKFLG>0
        BEQ     FSCN4                 ; THEN
        CMPB    "!",0(R5)               ;   IF CHR<>"!"
        BNE     MAINLP                  ;   THEN GOTO MAINLP
        MOVQB   2,ACKFLG               ;   ELSE   ACKFLG:=-1 { NOT ACKNOLEDGE}
        BR      MAINLP                  ; END
FSCN4:  ADDR    OUTB(R7),R6             ; DTRM.OUTLM:=1
        ADDR    CMNDTB,TOS              ; TBSRCH (3,CMNDTB,(CMNDTBE-CMNDTB)/4)
        MOVB    CMNTLN,TOS
        CXP     TBSRCH                  ; (* SEARCH COMMND-TABLE *)
        CMPQB   TRUE,TOS
        BNE     SYNTERR:W       ; IF COMMAND NOT FOUND IN COMMAND TABLE ERROR
        MOVB    R2,L                    ; L:=COMMAND-NUMBER
MAINCS: CASEW   BRTB:W[R2:W]            ; MAIN CASE OF COMMAND-NUMBER
BRTB:   .WORD   MOVELP-MAINCS   ; MOVE
        .WORD   FILLP-MAINCS    ; FILL
        .WORD   SRCHLP-MAINCS   ; SEARCH
        .WORD   LOADLP-MAINCS   ; LOAD
        .WORD   DUMPLP-MAINCS   ; DUMP
        .WORD   STULP-MAINCS    ; STEP UNTILE
        .WORD   STULP-MAINCS    ; STEP WHILE
        .WORD   CXPL-MAINCS     ; JSB
        .WORD   CXPL-MAINCS     ; CXP
        .WORD   GOLP-MAINCS     ; GO
        .WORD   STEPL-MAINCS    ; STEP N
   	.WORD	OPC-MAINCS	; OPERATION MOD
        .WORD   PRNTC-MAINCS    ; PRINT
        .WORD   PRNTC-MAINCS    ; CHANGE
        .WORD   BEGINL-MAINCS   ; BEGIN
	.WORD	RSTINTL-MAINCS	; RESET INTBASE
SYNTERR:
ERROR:  MOVB    "?",0(R6)      		; WRITELN (# LF ? #)
        ADDQD   1,R6                    ;  OUTB(NDTRM.OUTLM):= ?
MSGENT:
        CXP     SPRINTA
        BR      MAINLP                  ; GOTO NAINLP
EVRF:   .EQU    12                      ; VERIFY ERROR CONSTANT
EPND:	.EQU	6			; PENDING INTERRUPT ERROR
ECRC:   .EQU    7                       ; CRC ERROR
ESRC:   .EQU    8                       ; SEARCH ERROR
ECXP:   .EQU    10                      ; ERROR MORE THEN ONE CXP COMMAND
;
;     ERRORS TABLE
;
ERTAB:  .BYTE   " NMI NVI"
        .BYTE   " FPU DVZ"
        .BYTE   " UND FLG"
        .BYTE   " BPT ILL"
        .BYTE   " TRC EXT"
        .BYTE   " PRT NVL"
        .BYTE   " ABT USR"
        .BYTE   " PND CRC"
        .BYTE   " SRC SVC"
        .BYTE   " CXP VIO"
        .BYTE   " VRF RTS"
ERENT:
        MOVW    CR+H'100*"E",0(R6)  		; INSERT CR LF E
        MOVXBD  R1,R1
        MOVD    ERTAB+32[R1:D],2(R6)            ; INSERT ERROR MESSAGE
        ADDQD   6,R6
   	CMPB	R1,EVRF				; IF ERROR_NUMBER> VRF THEN
   	BLT	ERENT2			;   BEGIN {PRINT ALSO NUMBER}
   	MOVB	SPACE,0(R6)			;      ADD SPACE
   	ADDQD	1,R6
   	MOVD	R0,TOS				;      BNTOHX(R0,8,2)
   	MOVW	H'802,TOS
   	CXP	BNTOHX				;   END;
ERENT2: BR      MSGENT                          ; PRINT MESSAGE
;
;
;        S H X T O B N  ( STANDARD HXTOBN  CALL )
;
;
SHXTOBN:
        MOVD    0(SP),TOS
        ADDR    SYNTERR,4(SP)   ; EXIT ADDRESS SYNTERR
EHXTOBN:
        JSR     COMPS           ; COMPRESS LEADING SPACE'S
        ADJSPB 5                ; (* PUSH DUMMY WORD EXERR
        MOVD    R5,TOS          ; VECP:=DTRM.SCN
        MOVD    INLM(R7),TOS    ; ENDP:=DTRM.INLM
        CXP     HXTOBN          ; HEXTOBN (WORD,EXRR,DTRM,SCN,DTRM.INLM)
        MOVD    TOS,R5          ; UPDATE DTRM.SCN
        CMPQB   TRUE,TOS
        MOVD    TOS,R1          ; R1:=WORD
        BNE     SHXTBEX       ; IF EXRR THEN
        MOVD    4(SP),0(SP)     ;    EXIT TO ERROR ADDRESS
SHXTBEX:
        JSR     COMPS           ; COMPRESS LEADING SPACE'S
        RET     4
;
;
;   P R I N T  &  C H A N G E    C O M M A N D S
;
;
GETI:   .EQU    0               ; GET INDICATOR
PUTI:   .EQU    1               ; PUT INDICATOR
;
;
;       REGISTERS PARAMETERS TABLE
;
REGTB: .BYTE   H'60,H'FF,0,SVPC-SEREA          ; PC DESCRIPTION
USX:   .BYTE   H'60,H'FF,0,SVUS-SEREA          ; US
ISX:   .BYTE   H'60,H'FF,0,SVIS-SEREA          ; IS
        .BYTE   H'69,H'FF,0,0			; INTB
        .BYTE   H'60,H'FF,-2,SVMOD-SEREA        ; SB
        .BYTE   H'60,H'FF,0,SVFP-SEREA          ; FP
        .BYTE   H'40,H'FF,0,SVMOD-SEREA         ; MOD
        .BYTE   H'40,H'FF,0,SVPSR-SEREA         ; PSR
        .BYTE   H'88,H'FF,0,SVMSR-SEREA         ; MSR
        .BYTE   H'81,H'FF,0,15                  ; EADD
        .BYTE   H'81,1,0,12                     ; PTB
        .BYTE   H'61,1,0,4                      ; PF
        .BYTE   H'81,H'FF,0,8                   ; SC
BREKX:  .BYTE   H'81,1,0,0                      ; BPR
        .BYTE   H'61,H'FF,0,11                  ; BCNT
        .BYTE   H'81,H'FF,0,10                  ; REAL-MSR
        .BYTE   H'62,H'FF,0,0                   ; SP
        .BYTE   H'84,H'FF,0,0                   ; FSR
        .BYTE   H'83,7,0,0                      ; FL
        .BYTE   H'80,7,0,SVR0-SEREA             ; R
        .BYTE   H'15,H'FF,0,0                   ; CNFG
        .BYTE   H'60,H'FF,0,HEAPS-SEREA         ; HEAP START
        .BYTE   H'60,H'FF,0,HEAPE-SEREA         ; HEAP END
        .BYTE   H'60,H'FF,-2,HEAPP-SEREA        ; HEAP POINTER
        .BYTE   H'26,H'F0,0,0                   ; MB
        .BYTE   H'46,H'F0,0,2                   ; MW
        .BYTE   H'86,H'F0,0,4                   ; MD
SFTX:  .BYTE   H'87,15,2,BRKAR-8-SEREA         ; SOFT-BPT
;
BREKT:  .EQU    (BREKX-REGTB) / 4
SFTBT:  .EQU    (SFTX-REGTB) / 4
;
PRNTC:  SUBB    PRC,R2          ; PUSH GET-PUT PARAMETER
        MOVB    R2,TOS
        ADDR    REGNTB,TOS      ; TBSRCH (REGNTB,REGTLN)
        MOVB    REGTLN,TOS
        CXP     TBSRCH
        CMPQB   TRUE,TOS        ; IF TBSRCH.EXITF=FALSE GOTO SYNTERR
        BNE     SYNTERR
        MOVQD   0,R1
        CMPB    H'FF,REGTB+1[R2:D]
        BEQ     PCH1          ; IF REGTB[N1,I]<>H'FF THEN (* THERE IS N*)
        BSR     SHXTOBN         ;    HXTOBN (N) (* ON ERROR GO TO SYNTERR *)
PCH0:   CMPB    H'F0,REGTB+1[R2:D]
        BEQ     PCH1          ;    IF REGTB[N1,I]=H'FF THEN
        CHECKB  R0,REGTB+1[R2:D],R1
        BFC     PCH1          ;       IF N>REGTB.UPPER OR N<REGTB.LOWER
        CMPB    BREKT,R2        ;       THEN IF I<>BREKT THEN
        BNE     SYNTERR         ;               GOTO SYNTERR
        MOVB    SFTBT,R2        ;            ELSE I=SOFT-BREAK GO TO PCH0;
        BR      PCH0
PCH1:   MOVD    R1,TOS          ; PUSH N PARAMETER
   	MOVD	R1,R0		; {SAVE N}
        CMPQB   PUTI,4(SP)      ; IF L=CHCM (*CHANGE COMMAND *) THEN
        BNE     PCH3
        CMPB    "=",0(R5)       ;    IF M(DTRM.SCN)<> "=" GO TO SYNTERR
        BNE     SYNTERR         ;    ELSE
        ADDQD   1,R5            ;       TRM.SCM:=DTRM.SCN+1
        BSR     SHXTOBN         ;       SXTOBN(VALUE) (*ON ERROR GOTO SYNTERR*)
        CXP     GETPUT          ;       GETPUT (GET-PUT,N,VALUE);
        CMPB    0(R5),"V"       ;       IF INBUF(DTRM.SCN)="V"
        BNE     MAINLP          ;       THEN
        MOVD    R1,R3           ;         OLDVALUE:=VALUE;
        MOVQB   GETI,TOS
        MOVD	R0,TOS		;         GETPUT(GET,N,VALUE);
        CXP     GETPUT
        CMPD    R1,R3           ;         IF OLDVALUE<>VALUE
        BEQ     MAINLP          ;         THEN
        MOVB	EVRF,R1         ;           ERROR (VRF);
        BR      ERENT           ;       END;
                                ;    END;
                                ; ELSE
PCH3:   CXP     GETPUT          ;    GETPUT (GET_PUT,N,VALUE)
        MOVB    "=",0(R6)	;    OUTB(DTRM.OUTLM):="=";
        ADDQD   1,R6            ;    DTRM.OULM:=DTRM.OUTLM+1;
        MOVD    R1,TOS
        EXTSB   REGTB[R2:D],TOS,4,4     ;  (* GET REBTB.LENGTH *)
;       EXTSB   REGTB[R2:D],TOS,H'83    ;  (* GET REBTB.LENGTH *)
        MOVQB   2,TOS           ;    BNTOHX (R1,REGTB.LENGTH,2)
        CXP     BNTOHX
        CXP     SPRINTA         ;    WRITELN (OUTB)
        BR      MAINLP
;
;
;       G O    C O M M A N D
;
;
;       LOCAL CONSTANTS
;
NOTRC:  .EQU    0               ; FLAG OF NO TRACE ACTIVE
STPN:   .EQU    1               ; FLAG OF STEP N
STU:    .EQU    2               ; FLAG OF STEP UNTIL
STW:    .EQU    3               ; FLAG OF STEP WHILE
STBRK:  .EQU    4               ; FLAG OF BREAK STEP
;
GOLP:   CBITB   PSR_T,SVPSR     ; SVPSR_T:=0 (* DISABLE TRACE *)
        MOVQB   NOTRC,STEPFLG   ; STEPFLG:=STBRK;
STDGO:  MOVZBD  NSFBR,R0                ; FOR I:=NBREAK-2 DOWEN TO 1 DO
GOL1:   TBITB   BPR_BE,BRKAR-4[R0:D] ; IF BRKAR.BE[I] THEN DO (* B.P. I ENABLE
        BFC     GOL5:W          ;       BEGIN
        MOVD    BRKAR-4[R0:D],R1
        ANDD    H'FFFFFF,R1     ;         R1:=BRKAR[I].ADDR
        MOVUSB    0(R1),INS-1[R0:B] ;       INS[I]:=M(BRKAR[I].ADDR)
        CMPD    SVPC,R1         ;         IF BRKAR[I].ADDR=PC THEN
        BNE     GOL4
        SBITB   PSR_T,SVPSR     ;            PSR_T:=1 (* SET TRACE MODE ONE  *)
        MOVD    R1,ACTBRK       ;            ACTBRK:=I
        ORB	STBRK,STEPFLG   ;            STEPFLG:= STEPBRK (*FLAG GO TRACE
        BR      GOL5          ;       ELSE
;	MOVB    BPTC,0(R1)      ;           M(BRKAR[I].ADDR):=BPT;
GOL4:	MOVB	BPTC,SCRCH2
   	MOVSUB	SCRCH2,0(R1)
;   	CMPB	BPTC,0(R1)	;           IF NOT WRITTEN  THEN
   	MOVUSB	0(R1),SCRCH2
   	CMPB	BPTC,SCRCH2
   	BEQ	GOL5
   	MOVD	R1,R0		;	    ERROR VRF
   	MOVB	EVRF,R1
   	BR	ERENT
GOL5:   ACBB    -1,R0,GOL1      ; END;
        CXP     MNEXIT
;
;
;       S T E P   N    C O M M A N D
;
;
STEPL:  MOVQD   1,STPCNT        ; STEPCOUNT:=1
        ADDR    STP2,TOS
        BSR     EHXTOBN         ; SHXTOBN (N) (* ON ERROR GO TO STP2 *)
        MOVD    R1,STPCNT       ; STEPCOUNT:= N
STP2:   CMPB    CR,0(R5)        ; IF DTRM.SCN<> CR GOTO SYNTERR
        BNE     SYNTERR
        MOVQB   STPN,STEPFLG    ; STEPFLAG:=STEP N
        SBITB   PSR_T,SVPSR     ; SVPSR_T:=1 (* SET TRACE MODE *)
        BR      STDGO           ; GOTO STDGO;
;
;
;       B E G I N    J S R     C X P    C O M M A D S
;
;
BEGINL: MOVQB   1,CXPFLG        ; CXPFLG:=1 {FLAG OF BEGIN}
   	MOVQD	0,OLDPC		; OLDPC := 0 ; {RESET PC AFTER END OF PROGRAM}
        BR      CXPL2
CXPL:   CMPQB   2,CXPFLG        ; IF CXPFLG=2 {SECOND CXP}
        BNE     CXPL1         ; THEN ERROR CXP
        MOVZBD  ECXP,R1
        BR      ERENT
CXPL1:  MOVQB   2,CXPFLG        ; ELSE CXPFLG:=2;
   	MOVMD   SVPC,OLDPC,2    ; SAVE PC,US,IS,MOD
   	MOVD	ENDPC,ENDPC1	; SAVE ENDPC OF LAST BEGIN
CXPL2:  ADDR    SVUS,R3         ; R3:=ADDR OF US
        TBITB   PSR_S,SVPSR     ; IF PSR_S=1 THEN
        BFS     CXPL3         ;   R3:= ADDR OF IS
        ADDR    SVIS,R3
CXPL3:  MOVD    0(R3),R0        ; R0:=SP
        BSR     SHXTOBN         ; SHXTOBN (ADDR)
        MOVD    R1,R2           ; R2:=ADDR  (*MOD *)
        CMPB    JSBC,L          ; IF L=CXP THEN
        BEQ     CXPL5         ; BEGIN
        BSR     SHXTOBN         ;    SHXTOBN (OFFSET)
        MOVD    R2,SVMOD        ;    MOD:= READ MOD
;       ADDD    8(R2),R1        ;    R1:=OFFSET+(8+(MOD)) (* NEW PC *)
   	MOVUSD	8(R2),SCRCH2
   	ADDD	SCRCH2,R1
        ADDQD   -4,R0
   	MOVSUD	SVMOD,0(R0)	;  PUSH RETURN MOD THE SAME AS CXP MOD
   	MOVUSD	0(R0),SCRCH2	; {VERIFY WRITE}
   	CMPD	SVMOD,SCRCH2	; IF WAS'NT WRITTEN WELL GO TO VRFERROR
   	BNE	VRFERR1:W
CXPL5:  MOVD    R1,SVPC         ; GO PC:=R1
        ADDQD   -4,R0
   	ADDR	3(R0),SCRCH2	; PUT BPT ON STACK AND RETURN TO THIS POINT
   	MOVD	SCRCH2,ENDPC	; SAVE RETURN ADDRESS FOR END CHECK
   	MOVB	BPTC,SCRCH2+3
   	MOVSUD	SCRCH2,0(R0)
   	MOVUSD	0(R0),SCRCH1	; {VERIFY WRITE}
   	CMPD	SCRCH1,SCRCH2	; IF WAS'NT WRITTEN WELL GO TO VRFERROR
   	BNE	VRFERR1:W
        MOVD    R0,0(R3)        ; UPDATE USER SP
        CMPQB   2,CXPFLG        ; IF CXPFLG=2 GOTO GOLP {TO USER PROGRAM}
        BEQ     GOLP            ; ELSE GOTO MAINLP
        BR      MAINLP
;
;
;       S T E P   U N T I L  /  W H I L E
;
;
STULP:  MOVQB   STW,R3          ; R3:=0
        CMPB    STWC,L          ; IF L=STW THEN  (* COMMAND IS STW *)
        BEQ     STU2          ;   R3:=1
        MOVQB   STU,R3
STU2:   ADDR    REGNTB,TOS      ; TBSRCH(2,REGTB,REGNLN)
        MOVB    REGTLN,TOS
        CXP     TBSRCH
        CMPQB   TRUE,TOS        ; IF  NOT EXITF THEN  GOTO SYNTERR
        BNE     SYNTERR         ; ELSE
        MOVQD   0,R1            ;   N PARAMETER :=0
        CMPB    H'FF,REGTB+1[R2:D]
	BEQ	STU3		;   IF REGTB[N1,I]=H'FF THEN
	BSR	SHXTOBN		;   HXTOBN (N) (* ON ERROR GOTO SYNTERR *)
	CMPB	H'F0,REGTB+1[R2:D]; IF REGTB[N1,I]=H'FF THEN
	BEQ	STU3
	CHECKB	R0,REGTB+1[R2:D],R1;   IF N>REGTB.UPPER OR N<REGTB.LOWER
	BFS	SYNTERR		;       THEN GOTO SYNTERR;
STU3:	MOVD	R1,STUADD	;   STUADD:=N
	MOVB	R2,STUADD+3	;   STUADD.TYPE:=R2
STU5:				; END ;
	MOVQD	3,R0		; FOR I:=1 TO 3 DO
STU6:	BSR	SHXTOBN		;     SHXTOBN (VALUE) ;
	MOVD	R1,STUADD[R0:D]	;     STUADD[I]:=VALUE
	ACBB	-1,R0,STU6	; END ;
	MOVB	R3,STEPFLG	; STEPFLG:=STU OR STW
	SBITB	PSR_T,SVPSR	; PSR_T:=1 (* SET TRACE BIT *)
	BR	STDGO
;
;
;
;
;	L O A D    C O M M A N D
;
;
;
;
LOADLP:
	BSR	SHXTOBN		; SHXTOBN (ADDR) ; {ON ERROR GO TO SYNTERR}
	MOVQD	0,R3		; CRC:=0;
LOD1:	CMPD	R5,INLM(R7)	; REPEAT
	BGE	SYNTERR		; IF DTRM.SCN<=DTRM.INLM GOTO SYNTERR
	CMPB 	0(R5),'*'	; IF * THEN FAST LOAD
	BEQ	FLOAD:W
	ADJSPB	5
	MOVD	R5,TOS		; HXTOBN (X,EXITF,DTRM.SCN,DTRM.SCN+1);
	ADDR	1(R5),TOS
	CXP	HXTOBN
	MOVD	TOS,R5		; UPDATE DTRM.SCN
	CMPQB	TRUE,TOS	; R2:=X
	MOVD	TOS,SCRCH2	; IF EXITF GOTO SYNTERR
   	MOVB	SCRCH2,R2
	BEQ	SYNTERR	
	CMPB	0(R5),CR	; IF M(DTRM.SCN = CR END OF REPEAT
	BEQ	LODEND	; ELSE
	MOVSUB	SCRCH2,0(R1)	;   M(ADDR)=X;
;	CMPB	SCRCH2,0(R1)	;    IF M(ADDR)<>X THEN GOTO VRFERR
   	MOVUSB	0(R1),SCRCH2
   	CMPB	R2,SCRCH2
	BNE	VRFERR
	ADDQD	1,R1		;   ADDR:=ADDR+1;
	ADDB	R2,R3		;   CRC:=CRC+X;
	BR	LOD1		;UNTILE M(DTRM.SCN)=CR
LODEND:	CMPB	R3,R2		; IF CRC:=X THEN
	BNE	CRCERR	;    RETURN
	BR	MAINLP
CRCERR:	MOVQD	ECRC,R1		; ELSE ERROR (CRC)
	BR	ERENT
VRFERR:	MOVD	R1,R0		; R0 := ADDRESS OF VERIFICATION.
VRFERR1: MOVB	EVRF,R1		; ERROR (VRF)
	BR	ERENT
;
;  FAST LOAD
;
FLOAD:	MOVD	R1,R0		; R0 := ADDRESS OF FIRST BYTE TO LOAD
	ADDQD	1,R5		; SKIP THE *
	BSR	SHXTOBN		; R1 := NUMBER OF CHAR TO BE READ N
	CMPW	H'100,R1	; ID N > 256 ERROR
	BLT	SYNTERR
	MOVQB	7,R3
FLOD1:	MOVQW	TRUE,TOS	; FOR I := 1 TO 7 DO
	MOVB	NDTRM,TOS	;  BEGIN
	CXP	RDCHR		;    RDCHR (TRUE,CHAR,NDTRM) ; READ CHAR & WAIT
	CMPQB	0,TOS
	CMPB	CNTRLL,TOS	;    IF CHAR = CNTRL/L GO TO LOAD2;
	BEQ	FLOD2
	ACBB	-1,R3,FLOD1	;  END;
	BR	SYNTERR		; NO CNTRL/L AFTER 7 CHARS ERROR
FLOD2:	MOVB	OPHND,R3	; SAVE HANDSHAKE FLAGS
	MOVQB	0,OPHND
	MOVQB	PNDMOD,MON_USR	; HOLD INTERRUPTS UNTIL END OF READ
	MOVW	R1,TOS
	ADDQW	1,TOS		; READ CNTRL/L TOO
	MOVB	NDTRM,TOS	; RDLIN (N,NDTRM,TERM1);
	ADDR	TERM1,TOS	;  {MAX BUFFER READ IS 256}
	CXP	RDLIN
	MOVB	R3,OPHND	; RELOAD OPHND
	MOVQB	MONT,MON_USR
	CMPB	CNTRLL,TERM1[R1:B]
	BNE	SYNTERR		; IF LAST BYTE <> CNTRL/L ERROR
	MOVQD	0,R3		; FOR I := 1 TO N DO
FLOD4:	MOVSUB	TERM1[R3:B],0(R0)
	MOVUSB	0(R0),SCRCH2	;   ADR^ := TERM1[I]
	CMPB	TERM1[R3:B],SCRCH2;   IF  ADR^ <> TERM1[I] VERIFY ERROR
	BNE	VRFERR1
	ADDQD	1,R0
	ADDQD	1,R3		;  END;
	CMPW	R3,R1
	BLT	FLOD4
FLOD6:	CMPQB	TRUE,PNDF	; IF PENDING_INTERRUPT THEN
	BNE	MAINLP		;   GO TO PND ERROR
	MOVQD	EPND,R1		; ELSE GO TO MAIN LOOP
	BR	ERENT
;
;
;
;	D U M P    C O M M A N D
;
;
;
NLIN:	.EQU	16		; NUMBER OF BYTE IN A LINE
;
DUMPLP:
	MOVB	NDTRM,R4	; TERM:=NDTRM
	CMPD	"TR1 ",0(R5)	; IF M(NDTRM.SCN) = "TR1 "
	BNE	DU2		; THEN
	MOVQB	0,R4		;   TERM:=0
	BR	DU4		;   DTRM.SCN:=DTRM.SCN+4;
DU2:	CMPD	"TR2 ",0(R5)	; ELSE
	BNE	DU5		;    IF M(DTRM.SCN) = "TR2 "
	MOVQB	1,R4		;    THEN  TERM:=1;
DU4:	ADDQD	4,R5		;	   DTRM.SCN:=DTRM.SCN+4;
DU5:				; END; IF
	BSR	SHXTOBN		; HXTOBN(ADDR1);
	MOVD	R1,R2		; {R2:=ADDR1}
	CMPB	0(R5),'*'	; IF * THEN FUST DUMP
	BEQ	FDUMP:W
	BSR	SHXTOBN		; SHXTOBN(ADDR2);
DULIN:				; REPEAT
	MOVQD	0,R3		;   CRC:=0;
	ADDR	TERM1,R6	;   OUTB:=TERM1.OUTB
	CMPQB	0,R4		;   IF TERM <> TERM1
	BEQ	DUL3		;   THEN OUTB:=TERM2.OUTB
	ADDR	TERM2,R6
DUL3:	MOVD	R6,TOS		; {PUSH START ADDRESS OF PRINT ARRAY FOR PRINTA
	MOVD	CRL,0(R6)	;   OUTB(OUTLM):= CR,LF,"L";
	ADDQD	3,R6		;   OUTLM:=OUTLM+3;
	MOVD	R2,TOS		;   BNTOHX(ADDR1,6,2);
	MOVW	H'602,TOS
	CXP	BNTOHX
	MOVB	SPACE,0(R6)	;   OUTB(OUTLM):=SPACE;
	ADDQD	1,R6		;   OUTLM:=OUTLM+1
	MOVZBD	NLIN,R0		;   L := NLIN {# OF BYTES IN A LINE}
	CMPD	R1,R0		;   IF N<NLIN
	BGE	DULOOP	;   THEN L := N;
	MOVD	R1,R0
;	MOVZBD	0(R2),TOS	;   FOR I=1 TO L DO
DULOOP: MOVUSB	0(R2),SCRCH2
   	MOVZBD	SCRCH2,TOS
	ADDB	0(R2),R3	;      CRC:=CRC+M(ADDR1);
	ADDQD	1,R2		;      ADDR1:=ADDR1+1;
	MOVW	H'200,TOS	;      BNTOHX(M(ADDR1),2,0);
	CXP	BNTOHX
	ADDQD	-1,R1		;      N := N-1;
   	ACBD	-1,R0,DULOOP	;   END;   {FOR}
	MOVZBD	R3,TOS		;   BNTOHX(CRC,2,0);
	MOVW	H'200,TOS
	CXP	BNTOHX
	MOVD	R6,TOS		;   {PARAMETERS FOR PRINTA}
	MOVB	R4,TOS
	CMPQD	0,R1		;   IF N=0
	BEQ	DUEXT		;   THEN GOTO DUEXT;
	CXP	PRINTA		;   PRINTA (OUTB(1),OUTB(OUTLM),TERM,OPHND)
	BR	DULIN		; UNTIL ADDR1>ADDR2
DUEXT:	MOVB	CR,0(R6)	; OUTB(OUTLM):= CR ;
	ADDQD	1,1(SP)		; PRINTA (OUTB(1),OUTB(OUTLM+2),TERM);
	CXP	PRINTA
	BR	MAINLP
;
; FAST DUMP
;
FDUMP:  ADDQD	1,R5
	BSR	SHXTOBN		; R1 := NUMBER OF BYTES TO DUMP   N
	CMPW	R1,H'100	; IF N>256 ERROR
	BGT	SYNTERR
	MOVB	CNTRLL,TERM1	; START THE MESSAGE WITH CNTRL/L
	MOVQD	0,R3		; FOR I := 1 N DO
FDU1:	MOVUSB	0(R2),TERM1+1[R3:B]
	ADDQD	1,R2		;    TERM1[I] := ADR^.[I]
	ADDQD	1,R3		; END;
	CMPW	R3,R1
	BLT	FDU1
	MOVB	CNTRLL,TERM1+1[R3:B] ; END MESSAGE WITH CNTRL/L
	MOVQB	PNDMOD,MON_USR	; DELAY ALL INTERRUPTS
	MOVB	OPHND,R3	; SAVE HAND_SHAKING FLAG
	MOVQB	0,OPHND		; DIABLE HAND-SHAKING
	ADDR	TERM1,TOS
	ADDR	TERM1+2[R1:B],TOS; PRINTA (ADR,ADR+N,TERM);
	MOVB	R4,TOS
	CXP	PRINTA
	MOVQB	MONT,MON_USR
	MOVB	R3,OPHND	; RELOAD OPHND
	BR	FLOD6
;
;
;
;   M O V E    F I L L    S E A R C H   C O M M A N D S
;
;
;
MOVC:	.EQU	0		; # OF MOVE COMMAND
SRCHC:	.EQU	2		; # OF SRCH COMMAND
;
OPTB:	.BYTE	"B W D "	; B W D AND V OPTIONS SEARCH TABLE
OPTBL:	.EQU	(*-OPTB) / 2	; OPTION TABLE LENGTH
BCOM:	.BYTE	3,2,0		; BEGIN WORD FOR EACH COMMAND
;
;
MOVELP:
FILLP:
SRCHLP:
	ADDR	(-MOVC)(R2),R4	; L:=COMMAND NUMBER (0 MOVE 1 FILL 2 SRCH
	BSR	SHXTOBN		; SHXTOBN (ADDR1);
	MOVD	R1,R0		; R0:=ADDR1
	BSR	SHXTOBN		; SHXTOBN(ADDR2);
	MOVD	R1,R3		; R3:=ADDR2;
	BSR	SHXTOBN		; SHXTOBN(ADDR3)
   	MOVD	R1,SCRCH2	;  SAVE FILL & SEARCH DATA TO MEMORY
	ADDR	OPTB,TOS	; TBSRCH(OPTB,3);
	MOVQB	3,TOS
	CXP	TBSRCH
	CMPB	0(R5),"N"	; IF INBUF(DTRM.SCN)="N"
	BNE	SPC5		; THEN NO-VERIFY BIT:=TRUE;
	ORB	4,R2
SPC5:	ASHD	2,R2		; END IF
	ORB	BCOM[R4:B],R2
	CMPQB	MOVC,R4		; IF MOVE COMMAND
	BNE	SPC9		; THEN
	MOVD	R0,R5		;    R5:=ADDR1;
	MOVD	R3,R0		;    ADDR1:=ADDR2;
	ADDD	R1,R3		;    ADDR2:=ADDR1+N-1;
	ADDQD	-1,R3		; ELSE
SPC9:	MOVB	R2,SCRCH1	; {SAVE CASE WORD}
	ANDB	H'0F,R2
				; FOR I:= 1 TO N DO
				; BEGIN
SPCL:	MOVQD	1,TOS		;   STEP:=1;
;
;	 CASE BRANCH TABLE
;
;
SPCS:	CASEB	SPCBTB[R2:B]	;    CASE OF (OPTWORD AND V BIT)
SPCBTB:	.BYTE	SRCHB-SPCS	; SRCH  B
	.BYTE	SERR-SPCS	; NOT EXISTS
	.BYTE	FILLB-SPCS	; FILL  B
	.BYTE	MOVEB-SPCS	; MOVE  B
	.BYTE	SRCHW-SPCS	; SRCH  W
	.BYTE	SERR-SPCS	; NOT EXISTS
	.BYTE	FILLW-SPCS	; FILL  W
	.BYTE	SERR-SPCS	; MOVE  W
	.BYTE	SRCHD-SPCS	; SRCH  D
	.BYTE	SERR-SPCS	; NOT EXISTS
	.BYTE	FILLD-SPCS	; FILL  D
	.BYTE	SERR-SPCS	; MOVE  D
MOVEB:	MOVUSB	0(R5),SCRCH2	;     "B"  X:=M(SOURCE-ADDR)
	ADDQD	1,R5		; 	   SOURCE-ADDR:=SOURCE-ADDR+1;
FILLB:	MOVSUB	SCRCH2,0(R0)	;	   M(DESTINATIN-ADDR):=X;
SRCHB:
;	CMPB	R1,0(R0)
	MOVUSB	0(R0),-4(SP)
   	CMPB	SCRCH2,-4(SP)
SPCF:	TBITB	4,SCRCH1
	BFS	SPCRP		; 	  IF F THEN
	BEQ	SPC10		;	    IF M(DESTINATION-ADDR)<>X THEN
	CMPQB	SRCHC,R4	;             IF NOT SRCH COMMAND
	BNE	VRFERR1		;	      THEN GOTO VRFERR;
	BR	SPCRP
SPC10:	CMPQB	SRCHC,R4	;   	    ELSE
	BNE	SPCRP		;             IF SRCH COMMAND THEN
	MOVB	"=",0(R6)	;	      BEGIN
	ADDQD	1,R6		;	        DTRM.OUTB:= "=";
	MOVD	R0,TOS		;		DTRM.OUTLM:=DTRM:OUTLM+2;
	MOVW	H'602,TOS	;		BNTOHX (DESTENATIN-ADDR,6,2);
	CXP	BNTOHX
	BR	MSGENT		;		SPRINTA; RETURN TO MAINLP;
				;	      END;
				;	   END;
SPCRP:	ADDD	TOS,R0		;	   DESTINATION-ADDR:=DESTINATION+STEP
	CMPD	R0,R3		; END FOR
	BLE	SPCL
	CMPQB	SRCHC,R4	; IF NOT SRCH COMMAND THEN RETURN TO MAINLP
	BEQ	SPERR		; ELSE
	BR	MAINLP
SPERR:	MOVZBD	ESRC,R1		;  ERROR (SRC);
	BR	ERENT
FILLW:	ADDQD	1,0(SP)		;           STEP:=STEP+1;
	MOVSUW	SCRCH2,0(R0)	;    "W"    M(DESTINATION-ADDR):=X
SRCHW:
;	CMPW	R1,0(R0)
	MOVUSW	0(R0),-4(SP)
   	CMPW	SCRCH2,-4(SP)
	BR	SPCF
FILLD:	ADDQD	3,TOS		;	     STEP:=STEP+3;
	MOVSUD	SCRCH2,0(R0)	;     "D"    M(DESTINATION-ADDR):=X;
SRCHD:
;	CMPD	R1,0(R0)
   	MOVUSD	0(R0),-4(SP)
   	CMPD	SCRCH2,-4(SP)
	BR	SPCF
SERR:	BR	SYNTERR
;
;
; O P E R A T I N G      M O D E   C O M M A N D
;
;
OMTBL:	.BYTE 	"N","T","B","L","S","Q"
OMTCN:	.BYTE	0,H'3C,2,12,H'13,H'11	; DEFAULT VALUES
OPC:	CMPB	0(R5),CR	; IF CR GO TO MAIN LOOP
	BEQ	MAINLP
	CMPD	R5,INLM(R7)	; IF DTRM.SCN > INBUF.LM THEN ERROR
	BGT	SERR
	CMPB	0(R5),SPACE	; IF 0(R5) = SPACE THEN
	BNE	OP1		;   R5 := R5 + 1;
	ADDQD	1,R5
	BR	OPC
OP1:	MOVQB	6,R2		; FOR I := 1 TO 6 DO
OP2:	CMPB	0(R5),OMTBL-1[R2:B] ; BEGIN
	BEQ	OP3		;     IF 0(R5) = OPTABLE[I] GO TO OP3
	ACBB	-1,R2,OP2	;   END;
	BR	SERR		; IF NO MATCH ERROR
OP3:	MOVB	OMTCN-1[R2:B],R1	; R1 := DEFULT VALUE
	ADDQD   1,R5		; NEXT CHAR
	CMPB	0(R5),SPACE	; IF 0(R5) = SPACE OR CR GO TO OPCASE
	BEQ	OPCASE
	CMPB	0(R5),CR
	BEQ	OPCASE
	CMPB	0(R5),'='	; ELSE IF 0(R5) = '=' READ VALUE TO R1
	BNE	SERR		; ELSE ERROR;
        ADDQD	1,R5		; SKIP THE '='
	BSR	SHXTOBN
OPCASE: CASEB	OPCT-1[R2:B]
OPCT:	.BYTE	OPN-OPCASE
	.BYTE	OPT-OPCASE
	.BYTE	OPBLSQ-OPCASE
	.BYTE	OPBLSQ-OPCASE
	.BYTE	OPBLSQ-OPCASE
	.BYTE	OPBLSQ-OPCASE
OPN:	MOVQB	STALON,OPMOD	; OPMOD := STAND ALONE;
	BR	OPT2
OPT:	MOVQB	TRANSP,OPMOD	; OPMOD := TRANSPARENT
OPT2:	MOVB	R1,OPHND	; HAND-SHAKE FLAG := R1
	BR	OPC
OPBLSQ:
	MOVB	R1,CNTRLB-3[R2:B]
	BR	OPC
;
;
; R E S E T    I N T B A S E
;
;
RSTINTL: LPRD	INTBASE,RSTINT	; LOAD INITBASE WITH RESET VALUE
	BR	MAINLP
	.ENDSEG
