
     Name
          sh - Invokes the shell command interpreter.

     Syntax
          sh [ -ceiknrstuvx ] [ args ]

     Description
          The shell is the standard command programming language that
          executes commands read from a terminal or a file.  See
          Invocation below for the meaning of arguments to the shell.

     Commands
          A simple-command is a sequence of nonblank words separated
          by blanks (a blank is a tab or a space).  The first word
          specifies the name of the command to be executed.  Except as
          specified below, the remaining words are passed as arguments
          to the invoked command.  The command name is passed as
          argument 0 (see (NBC)exec.m).  The value of a simple-command
          is its exit status if it terminates normally, or (octal)
          1000+status if it terminates abnormally.  See (NBC)signal.m
          for a list of status values.

          A list is a sequence of one or more pipelines separated by
          ;, &, &&, or ||, and optionally terminated by ; or &.  Of
          these four symbols, ; and & have equal precedence, which is
          lower than that of && and ||.  The symbols && and || also
          have equal precedence.  A semicolon (;) causes sequential
          execution of the preceding pipeline.  The symbol && (||)
          causes the list following it to be executed only if the
          preceding pipeline returns a zero (nonzero) exit status.
          An arbitrary number of newlines may appear in a list,
          instead of semicolons, to delimit commands.

          A command is either a simple-command or one of the following
          commands.  Unless otherwise stated, the value returned by a
          command is that of the last simple-command executed in the
          command:

          for name [ in word ... ]
          do
               list
          done
          Each time a for command is executed, name is set to the next
          word taken from the in word list.  If in word is omitted, then
          the for command executes the do list once for each positional
          parameter that is set (see Parameter Substitution below).
          Execution ends when there are no more words in the list.

          case word in
               [ pattern [ | pattern ] ... ) list
               ;;  ]
          esac
          A case command executes the list associated with the first
          pattern that matches word.  The form of the patterns is the
          same as that used for filename generation (see Filename
          Generation below).

          if list then
               list
          [ elif list then
               list ]
          [ else list ]
          fi
          The list following if is executed and, if it returns a zero
          exit status, the list following the first then is executed.
          Otherwise, the list following elif is executed and, if its
          value is zero, the list following the next then is executed.
          Failing that, the else list is executed.  If no else list or
          then list is executed, then the if command returns a zero exit
          status.

          while list
          do
               list
          done
          A while command repeatedly executes the while list and, if the
          exit status of the last command in the list is zero, executes
          the do list; otherwise the loop terminates.  If no commands in
          the do list are executed, then the while command returns a zero
          exit status; until may be used in place of while to negate the
          loop termination test.

          (list)
          Executes list in a subshell.

          {list;}
          list is simply executed.

          name () {list;}
          Define a function which is referenced by name. The body
          of functions is the list of commands between { and }.
          Execution of functions is described later (see
          Execution.)


          The following words are recognized only as the first word of
          a command and when not quoted:

          if then else elif fi case esac for while until do done { }

     Comments
          A word beginning with # causes that word and all the
          following characters up to a newline to be ignored.

     Command Substitution
          The standard output from a command enclosed in a pair of
          grave accents (``) may be used as part or all of a word;
          trailing newlines are removed.

     Parameter Substitution
          The character $ is used to introduce substitutable
          parameters.  Positional parameters may be assigned values by
          set.  Variables may be set by writing:

               name=value [ name=value ] ...

          Pattern-matching is not performed on value.

          ${parameter}
               A parameter is a sequence of letters, digits, or
               underscores (a name), a digit, or any of the characters
               *, @, #, ?, -, $, and !.  The value, if any, of the
               parameter is substituted.  The braces are required only
               when parameter is followed by a letter, digit, or
               underscore that is not to be interpreted as part of its
               name.  A name must begin with a letter or underscore.
               If parameter is a digit then it is a positional
               parameter.  If parameter is * or @, then all the
               positional parameters, starting with $1, are
               substituted (separated by spaces).  Parameter $0 is set
               from argument zero when the shell is invoked.

          ${parameter:-word}
               If parameter is set and is not a null argument,
               substitute its value; otherwise substitute word.

          ${parameter:=word}
               If parameter is not set or is null, then set it to
               word; the value of the parameter is then substituted.
               Positional parameters may not be assigned to in this
               way.

          ${parameter:?word}
               If parameter is set and is not a null argument,
               substitute its value; otherwise, print word and exit
               from the shell. If word is omitted, the message
               ``parameter null or not set'' is printed.

          ${parameter:+word}
               If parameter is set and is not a null argument,
               substitute word; otherwise substitute nothing.  In the
               above, word is not evaluated unless it is to be used as
               the substituted string, so that in the following
               example, pwd is executed only if d is not set or is
               null:

                    echo ${d:-`pwd`}

               If the colon (:) is omitted from the above expressions,
               then the shell only checks whether parameter is set.

          The following parameters are automatically set by the shell:

          #    The number of positional parameters in decimal

          -    Flags supplied to the shell on invocation or by the set
               command

          ?    The decimal value returned by the last synchronously
               executed command

          $    The process number of this shell

          !    The process number of the last background command
               invoked

          The following parameters are used by the shell:

          CDPATH
               Defines search path for the cd command. See the
               section Special Commands, ``cd''.

          HOME The default argument (home directory) for the cd
               command

          PATH The search path for commands (see Execution below)

          PS1  Primary prompt string, by default ``$ ''

          PS2  Secondary prompt string, by default ``> ''

          IFS  Internal field separators, normally space, tab, and
               newline

          SHELL
               When the shell is invoked, it scans the environment
               (see Environment below) for this name.  If it is found
               and there is an `r' in the file name part of its value,
               the shell becomes a restricted shell.

               The shell gives default values to PATH, PS1, PS2, and IFS,
               while HOME is not set at all by the shell.

     Blank Interpretation
          After parameter and command substitution, the results of
          substitution are scanned for internal field separator
          characters (those found in IFS) and split into distinct
          arguments where such characters are found.  Explicit null
          arguments ("" or '') are retained.  Implicit null arguments
          (those resulting from parameters that have no values) are
          removed.

     Filename Generation
          Following substitution, each command word is scanned for the
          characters *, ?, and [.  If one of these characters appears,
          the word is regarded as a pattern.  The word is replaced
          with alphabetically sorted filenames that match the pattern.
          If no filename is found that matches the pattern, the word
          is left unchanged.  The character . at the start of a
          filename or immediately following a /, as well as the
          character / itself, must be matched explicitly. These
          characters and their matching patterns are:

          *    Matches any string, including the null string.

          ?    Matches any single character.

          [...]
               Matches any one of the enclosed characters.  A pair of
               characters separated by - matches any character
               lexically between the pair, inclusive.  If the first
               character following the opening bracket ([) is an
               exclamation mark (!), then any character not enclosed
               is matched.

     Quoting
          The following characters have a special meaning to the shell
          and cause termination of a word unless quoted:

               ;  &  ( )  |  ^  <  >  newline space  tab

          A character may be quoted (i.e., made to stand for itself)
          by preceding it with a \.  The pair \newline is ignored.
          All characters enclosed between a pair of single quotation
          marks (''), except a single quotation mark, are quoted.
          Inside double quotation marks (""), parameter and command
          substitution occurs and \ quotes the characters \, `, ", and
          $.  "$*" is equivalent to "$1 $2 ...", whereas ``$@'' is
          equivalent to "$1" "$2" ...

     Prompting
          When used interactively, the shell prompts with the value of
          PS1 before reading a command.  If at any time a newline is
          typed and further input is needed to complete a command, the
          secondary prompt (i.e., the value of PS2) is issued.

     Input/Output
          Before a command is executed, its input and output may be
          redirected using a special notation interpreted by the
          shell.  The following may appear anywhere in a
          simple-command or may precede or follow a command. They are
          passed on to the invoked command; substitution occurs
          before word or digit is used:

          <word     Use file word as standard input (file
                    descriptor 0).

          >word     Use file word as standard output (file
                    descriptor 1). If the file does not exist, it
                    is created; otherwise, it is truncated to zero
                    length.

          >>word    Use file word as standard output.  If the file
                    exists, output is appended to it (by first
                    seeking the end-of-file); otherwise, the file
                    is created.

          <<[-]word The shell input is read up to a line that is
                    the same as word, or to an end-of-file.  The
                    resulting document becomes the standard input.
                    If any character of word is quoted, no
                    interpretation is placed upon the characters
                    of the document; otherwise, parameter and
                    command substitution occurs, (unescaped)
                    \newline is ignored, and \ must be used to
                    quote the characters \, $, `, and the first
                    character of word.  If - is appended to << ,
                    all leading tabs are stripped from word and
                    from the document.

          <&digit   The standard input is duplicated from file
                    descriptor digit (see dup(S)). Similarly for
                    the standard output using >.

          <&-       The standard input is closed.  Similarly for
                    the standard output using >.

          If one of the above is preceded by a digit, the file
          descriptor created is that specified by the digit (instead
          of the default 0 or 1).  For example:

               ... 2>&1

          creates file descriptor 2 that is a duplicate of file
          descriptor 1.

          If a command is followed by &, the default standard input
          for the command is the null device. Otherwise, the
          environment for the execution of a command contains the
          file descriptors of the invoking shell as modified by
          input/output specifications.

     Environment
          The environment (see (NBC)exec.m) is a list of name-value
          pairs that is passed to an executed program in the same way
          as a normal argument list.  The shell interacts with the
          environment in several ways. On invocation, the shell scans
          the environment and creates a parameter for each name found,
          giving it the corresponding value.  Executed commands
          inherit the same environment.  If the user modifies the
          values of these parameters or creates new ones, none of
          these affect the environment unless the export command is
          used to bind the shell's parameter to the environment.  The
          environment seen by any executed command is composed of any
          unmodified name-value pairs originally inherited by the
          shell, minus any pairs removed by unset, plus any
          modifications or additions, all of which must be noted in
          export commands.

          The environment for any simple-command may be augmented by
          prefixing it with one or more assignments to parameters.
          Thus:

               TERM=450 cmd args

          and

               (export TERM; TERM=450; cmd args)

          are equivalent (as far as the above execution of cmd is
          concerned).

          If the -k flag is set, all keyword arguments are placed in
          the environment, even if they occur after the command name.

     Signals
          The INTERRUPT and QUIT signals for an invoked command are
          ignored.

     Execution
          Each time a command is executed, the above substitutions are
          carried out. If the command name does not match a Special
          Command, but matches the name of a defined function, the
          function is executed in the shell process (note how this
          differs from the execution of shell procedures). The
          positional parameters $1, $2, ... are set to the arguments
          of the function. If the command name matches neither a
          Special Command nor the name of a defined function, a new
          process is created and an attempt is made to execute the
          command via (NBC)exec.m.

          The shell parameter PATH defines the search path for the
          directory containing the command.  Alternative directory
          names are separated by a colon (:).  The default path is
          :/system/bin:/system/system (specifying the current directory,
          /system/bin, and /system/system, in that order).  Note that
          the current directory is specified by a null pathname,
          which can appear immediately after the equal sign or between
          the colon delimiters anywhere else in the path list.  If the
          command name contains a /, then the search path is not used.
          Otherwise, each directory in the path is searched for an
          executable file.  If the file is not an executable file, it
          is assumed to be a file containing shell commands.  A subshell
          (i.e., a separate process) is activated to read it.
          A parenthesized command is also executed in a subshell.

          The location in the search path where a command was found is
          remembered by the shell (to help avoid unnecessary execs
          later).  If the command was found in a relative directory,
          its location must be re-determined whenever the current
          directory changes.  The shell forgets all remembered
          locations whenever the PATH variable is changed or the
          hash -r command is executed (see below).

     Special Commands
          Input/output redirection is permitted for these commands:

          :    No effect; the command does nothing.  A zero exit code
               is returned.

          . file
               Reads and executes commands from file and returns.  The
               search path specified by PATH is used to find the
               directory containing file.

          break [ n ]
               Exits from the enclosing for or while loop, if any.  If
               n is specified, it breaks n levels.

          continue [ n ]
               Resumes the next iteration of the enclosing for or
               while loop.  If n is specified, it resumes at the n-th
               enclosing loop.

          cd [ arg ]
               Changes the current directory to arg.  The shell
               parameter HOME is the default arg.  The shell parameter
               CDPATH defines the search path for the directory
               containing arg. Alternative directory names are
               separated by a colon (:).  The default path is <null>
               (specifying the current directory).  Note that the
               current directory is specified by a null path name,
               which can appear immediately after the equal sign or
               between the colon delimiters anywhere else in the path
               list.  If arg begins with a /, the search path is not
               used.  Otherwise, each directory in the path is
               searched for arg.

          echo [ arg ]
               Writes arguments separated by blanks and terminated by
               a newline on the standard output.  Arguments may be
               enclosed in quotes.  Quotes are required so that the
               shell correctly interprets these special escape
               sequences:

               \b  Backspace
               \c  Prints line without newline.
               \f  Form feed
               \n  Newline
               \r  Carriage return
               \t  Tab
               \v  Vertical tab
               \\  Backslash
               \n  The 8-bit character whose ASCII code is the 1, 2 or 3-
                   digit octal number n must start with a zero

          eval [ arg ... ]
               The arguments are read as input to the shell and the
               resulting command(s) executed.

          exec [ arg ... ]
               The command specified by the arguments is executed in
               place of this shell without creating a new process.
               Input/output arguments may appear and, if no other
               arguments are given, cause the shell input/output to be
               modified.

          exit [ n ]
               Causes a shell to exit with the exit status specified
               by n.  If n is omitted, the exit status is that of the
               last command executed.  An end-of-file will also cause
               the shell to exit.

          export [ name ... ]
               The given names are marked for automatic export to the
               environment of subsequently executed commands.  If no
               arguments are given, a list of all names that are
               exported in this shell is printed.

          hash [ -r ] [ name ... ]
               For each name, the location in the search path of the
               command specified by name is determined and remembered
               by the shell.  The -r option causes the shell to forget
               all remembered locations.  If no arguments are given,
               information about remembered commands is presented.

          pwd  Print the current working directory.  See pwd.m for
               usage and description.

          read [ name ... ]
               One line is read from the standard input and the first
               word is assigned to the first name, the second word to
               the second name, etc., with leftover words assigned to
               the last name.  The return code is 0 unless an
               end-of-file is encountered.

          readonly [ name ... ]
               The given names are marked readonly and the values of
               the these names may not be changed by subsequent
               assignment.  If no arguments are given, a list of all
               readonly names is printed.

          return [ n ]
               Causes a function to exit with the return value
               specified by n.  If n is omitted, the return status is
               that of the last command executed.

          set [ -eknuvx [ arg ... ] ]
               -e   If the shell is noninteractive, exits immediately
                    if a command exits with a nonzero exit status.
               -f   Disables file name generation.
               -h   Locates and remembers function commands as
                    functions are defined (function commands are
                    normally located when the function is executed).
               -k   Places all keyword arguments in the environment
                    for a command, not just those that precede the
                    command name.
               -n   Reads commands but does not execute them.
               -u   Treats unset variables as an error when
                    substituting.
               -v   Prints shell input lines as they are read.
               -x   Prints commands and their arguments as they are
                    executed.
               --   Does not change any of the flags; useful in
                    setting $1 to -.

               Using + rather than - causes these flags to be turned
               off.  These flags can also be used upon invocation of
               the shell.  The current set of flags may be found in
               $-.  The remaining arguments are positional parameters
               and are assigned, in order, to $1, $2, ...  If no
               arguments are given, the values of all names are
               printed.

          shift
               The positional parameters from $2 ...  are renamed $1 ...

          test
               Evaluates conditional expressions. See test.m for
               usage and description.

          trap [ arg ] [ n ] ...
               arg is a command to be read and executed when the shell
               receives signal(s) n.  (Note that arg is scanned once
               when the trap is set and once when the trap is taken.)
               Trap commands are executed in order of signal number.
               The highest signal number allowed is 16. Any attempt
               to set a trap on a signal that was ignored on entry to
               the current shell is ineffective.  If arg is absent,
               all trap(s) n are reset to their original values.  If
               arg is the null string, this signal is ignored by the
               shell and by the commands it invokes.

               If n is 0, the command arg is executed on exit from the
               shell.  The trap command with no arguments prints a
               list of commands associated with each signal number.

          unset [ name ... ]
               For each name, remove the corresponding variable or
               function.  The variables PATH, PS1, PS2, and IFS
               cannot be unset.

          umask [ ooo ]
               The user file-creation mask is set to the octal number
               ooo where o is an octal digit. If ooo is omitted,
               the current value of the mask is printed.

     Invocation
          If the shell is invoked through (NBC)exec and the first
          character of argument 0 is -, commands are initially read
          from /system/bin/profile and then from $HOME/.profile, if such
          files exist.  Thereafter, commands are read as described
          below, which is also the case when the shell is invoked as
          /system/bin/sh.  The flags below are interpreted by the shell on
          invocation only; note that unless the -c or -s flag is
          specified, the first argument is assumed to be the name of a
          file containing commands, and the remaining arguments are
          passed as positional parameters to that command file:
          -c string If the -c flag is present, commands are read from
                    string.
          -s        If the -s flag is present or if no arguments
                    remain, commands are read from the standard input.
                    Any remaining arguments specify the positional
                    parameters. Shell output is written to file
                    descriptor 2.
          -t        If the -t flag is present, a single command is
                    read and executed, and the shell exits.  This flag
                    is intended for use by C programs only and is not
                    useful interactively.
          -i        If the -i flag is present or if the shell input
                    and output are attached to a terminal, this shell
                    is interactive.
          -r        If the -r flag is present, the shell is a
                    restricted shell.

          The remaining flags and arguments are described under the
          set command above.

     Exit Status
          Errors detected by the shell, such as syntax errors, cause
          the shell to return a nonzero exit status.  If the shell is
          being used noninteractively, execution of the shell file is
          abandoned.  Otherwise, the shell returns the exit status of
          the last command executed. See the exit command above.

     Files
          /system/bin/profile   system default profile if none is present

     See Also
          cd.m, test.m, (NBC)exec, (NBC)signal

     Notes
          The command readonly (without arguments) produces the same
          output as the command export.

          If a command is executed, and a command with the same name
          is installed in a directory in the search path before the
          directory where the original command was found, the shell
          will continue to exec the original command.  Use the hash
          command to correct this situation.

          If you move the current directory or one above it, pwd may
          not give the correct response.  Use the cd command with a
          full path name to correct this situation.

          When the shell is executed, the shell system reads and executes
          commands in /system/bin/profile.  You can, therefore, modify the
          environment for all shell users on the system by editing
          /system/bin/profile.


          (printed 5/7/94 - J B Systems)

