  @     	     NAME 	 A          putc, putchar, fputc, putw - put character or word on a A           stream          SYNTAX            #include <stdio.h>               int putc (c, stream)            int c;            FILE *stream;               int putchar (c)            int c;               int fputc (c, stream)            int c;            FILE *stream;               int putw (w, stream)            int w;            FILE *stream;          DESCRIPTION  D          Putc writes the character c onto the output stream (at the D D          position where the file pointer, if defined, is pointing). D E          Putchar(c) is defined as putc(c, stdout).  Putc and putchar E           are macros.                        @  B          Fputc behaves like putc, but is a function rather than a B E          macro.  Fputc runs more slowly than putc, but it takes less E ?          space per invocation and its name can be passed as an ? !          argument to a function. !    D          Putw writes the word (i.e. integer) w to the output stream D D          (at the position at which the file pointer, if defined, is D F          pointing).  The size of a word is the size of an integer and F C          varies from machine to machine.  Putw neither assumes nor C /          causes special alignment in the file. /    B          Output streams, with the exception of the standard error B E          stream stderr, are by default buffered if the output refers E                        @  ?          to a file and line-buffered if the output refers to a ? B          terminal.  The standard error output stream stderr is by B C          default unbuffered, but use of freopen (see fopen.m) will C @          cause it to become buffered or line-buffered.  When an @ @          output stream is unbuffered, information is queued for @ @          writing on the destination file or terminal as soon as @ D          written; when it is buffered, many characters are saved up D F          and written as a block.  When it is line-buffered, each line F E          of output is queued for writing on the destination terminal E A          as soon as the line is completed (that is, as soon as a A                                                                @  <          new-line character is written or terminal input is < B          requested).  Setbuf() may be used to change the stream's B           buffering strategy.     
     SEE ALSO 
 9          fclose.m, ferror.m, fopen.m, fread.m, printf.m, 9           puts.m, setbuf.m          DIAGNOSTICS  E          On success, these functions each return the value they have E C          written.  On failure, they return the constant EOF.  This C E          will occur if the file stream is not open for writing or if E B          the output file cannot be grown.  Because EOF is a valid B C          integer, ferror(3S) should be used to detect putw errors. C         SPECIAL CONSIDERATIONS                                                                  @  @          Because it is implemented as a macro, putc incorrectly @ E          treats a stream argument with side effects.  In particular, E E          putc(c, *f++); doesn't work sensibly.  Fputc should be used E           instead.     A          Because of possible differences in word length and byte A C          ordering, files written using putw are machine-dependent, C B          and may not be read using getw on a different processor. B    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                