  @     	     NAME 	 >          signal - specify what to do upon receipt of a signal >         SYNTAX            #include <signal.h>     &          void (*signal (sig, func))() &           int sig;            void (*func)();          DESCRIPTION  B          Signal allows the calling process to choose one of three B A          ways in which it is possible to handle the receipt of a A =          specific signal.  Sig specifies the signal and func =           specifies the choice.     F          Sig can be assigned any one of the following except SIGKILL: F    #              SIGHUP    01   hangup # &              SIGINT    02   interrupt & !              SIGQUIT   03*  quit !                                                               @  H              SIGILL    04*  illegal instruction (not reset when caught) H ?              SIGTRAP   05*  trace trap (not reset when caught) ? "              SIGABRT   06*  abort " ,              SIGEMT    07*  EMT instruction , 6              SIGFPE    08*  floating point exception  6 ?              SIGKILL   09   kill (cannot be caught or ignored) ? &              SIGBUS    10*  bus error & 3              SIGSEGV   11*  segmentation violation 3 8              SIGSYS    12*  bad argument to system call 8 C              SIGPIPE   13   write on a pipe with no one to read it C (              SIGALRM   14   alarm clock ( 8              SIGTERM   15   software termination signal 8 2              SIGUSR1   30   user-defined signal 1 2                        @  2              SIGUSR2   31   user-defined signal 2 2 A              SIGCLD    18   death of a child (see WARNING below) A ;              SIGPWR    19   power fail (see WARNING below) ;    C          See below for the significance of the asterisk (*) in the C           above list.     F          Func is assigned one of three values: SIG_DFL, SIG_IGN, or a F C          function address.  The actions prescribed by these values C           are as follows:     >          SIG_DFL - terminate process upon receipt of a signal > ?                  Upon receipt of the signal sig, the receiving ? =                  process is to be terminated with all of the = 2                  consequences outlined in exit.m. 2                                       @  !          SIG_IGN - ignore signal ! 2                  The signal sig is to be ignored. 2    =                  Note: the signal SIGKILL cannot be ignored. =    *          function address -  catch signal * ?                  Upon receipt of the signal sig, the receiving ? D                  process is to execute the signal-catching function D D                  pointed to by func.  The signal number sig will be D D                  passed as the only argument to the signal-catching D C                  function.  Additional arguments are passed to the C A                  signal-catching function for hardware-generated A ?                  signals.  Before entering the signal-catching ?                                                              @  C                  function, the value of func for the caught signal C E                  will be set to SIG_DFL unless the signal is SIGILL, E %                  SIGTRAP, or SIGPWR. %    D                  Upon return from the signal-catching function, the D F                  receiving process will resume execution at the point F %                  it was interrupted. %    D                  When a signal that is to be caught occurs during a D <                  read, a write, or an open system call on a < @                  slow device (like a terminal; but not a file), @ E                  during a pause system call, or during a wait system E B                  call that does not return immediately due to the B                                   @  <                  existence of a previously stopped process, < C                  the signal catching function will be executed and C E                  then the interrupted system call may return a -1 to E >                  the calling process with errno set to EINTR. >    <                  Note: The signal SIGKILL cannot be caught. <    D          A call to signal cancels a pending signal sig except for a D !          pending SIGKILL signal. !    >          Signal will fail if sig is an illegal signal number, > &          including SIGKILL.  [EINVAL] &         RETURN VALUE  A          Upon successful completion, signal returns the previous A C          value of func for the specified signal sig.  Otherwise, a C                            @  B          value of -1 is returned and errno is set to indicate the B           error.     
     SEE ALSO 
 +          kill.m, pause.m. wait.m, setjmp.m +         WARNING  D          Two other signals that behave differently than the signals D C          described above exist in this release of the system; they C           are:     C                  SIGCLD  18   death of a child (reset when caught) C A                  SIGPWR  19   power fail (not reset when caught) A    D          There is no guarantee that, in future releases of the UNIX D D          system, these signals will continue to behave as described D D          below; they are included only for compatibility with other D                                                         @  D          versions of the UNIX system.  Their use in new programs is D           strongly discouraged.     B          For these signals, func is assigned one of three values: B ?          SIG_DFL, SIG_IGN, or a function address.  The actions ? 4          prescribed by these values are as follows: 4    #            SIG_DFL - ignore signal # 0                    The signal is to be ignored. 0    #            SIG_IGN - ignore signal # 0                    The signal is to be ignored. 0    +            function address - catch signal + F                    If the signal is SIGPWR, the action to be taken is F F                    the same as that described above for func equal to F                                                                   @  E                    function address.  The same is true if the signal E ?                    is SIGCLD except, that while the process is ? ?                    executing the signal-catching function, any ? B                    received SIGCLD signals will be queued and the B @                    signal-catching function will be continually @ 7                    reentered until the queue is empty. 7    ,            (printed 08/01/92 - J B Systems) ,                                                                                                                                                                                                                                                                                                             