/*
   ddcat - file dump utility for listing files in side-by-side
   hex and ascii, without the option to modify the file.

   Usage is:
       ddcat file
   where:
       file1    is the file to dump.

   modified many times by Jim Bevier
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main(argc,args)
int argc;
char *args[];
{
  FILE *fp, *fopen();

  if (argc != 2) {
     printf("usage: %s file\n", args[0]);
     exit(1);
  } /* end of if */

#ifdef mpx
  /* open read and unblocked */
  fopen(args[1],"ru");
#else
  fp = fopen(args[1],"r");
#endif

  if (fp == NULL) {
     fprintf(stderr,"%s: fopen: unable to open file %s\n", args[0], args[1]);
     exit(1);
  } /* end of if */
  dodump(fp,0);
  fclose(fp);
} /* end of main */

#define PRINTABLE(x) ((x < 32) || (x > 126)) ? '.' : x

dodump(fp, fileadr)
FILE *fp;
int  fileadr;
{
   char buff[257];
   int  file_byte_count=0, curchar, buffptr, bufflen;

   buffptr = 0;
   bufflen = 16;

   fseek(fp,fileadr,0);
   while ((curchar = getc(fp)) != EOF) {
     file_byte_count++;
     if (!buffptr) printf(" %06x : ",fileadr);
     printf("%02x",curchar);
     buff[buffptr++] = PRINTABLE(curchar);
     if (!(buffptr % 4)) printf(" ");
     if (buffptr >= bufflen) {
        buff[buffptr] = 0;
        printf(" |%s|\n",buff);
        buffptr = 0;
        fileadr += bufflen;
     } /* end of if */
   } /* end of while */

   if (buffptr) {
      buff[buffptr] = 0;
      while (buffptr++ < bufflen) {
         printf("  ");
         if (!(buffptr % 4)) printf(" ");
      } /* end of while */
      printf(" |%s|\n",buff);
   } /* end of if */
   return;
} /* end of dodump */

