*
*     REVISION HISTORY
*
* 11/08/90 EHW  CORRECTED INDEX TO STATUS WRD FROM ECC RD CMD >EHW110890
*               RELOADED R2 WITH IOQ ADDR FOR LATER USE       >EHW110890
* 07/31/90 EHW  ADDED CHECK FOR B.GCBBA EQ ZERO BEFORE STORE  >EHW
* 06/18/90 EHW  REPLACED "RI   X'01'" WITH "M.KILL   'DISC'"  >EHW061890
* 04/19/88 EHW  REMOVED CEA'S & SET EXT'D BIT IN GEN'S FOR PSD>EHW041988
* 03/31/88 EHW  ADDED M.BEQS MACRO                            >EHW033188
*               REMOVED M.UTL. & M.HSMAC MACROS               >EHW033188
* 03/08/88 RMB  MPX 3.3 UPDATE - MAJOR REVISION(S) FOR NEW O/S>RMB030788
* 03/08/88 BFC  STROKE THE CM DURING A DISC FAIL CLEAR        >BFC030888
* 02/12/85 LJD  FIX FOR 'RTW' I/O ISSUED, BUT CHOSTING STOPPED>LJD021285
* 01/06/85 LJD  CORRECTED 'STOP GHOSTING' HANG PROBLEM        >LJD010685
* 11/30/84 GDM  CONVERT HANDLER TO MPX 3.2A                   >GDM113084
* 08/13/84 LJD  ADD READ TO WRITE GHOSTING FEATURE            >LJD081384
* 07/31/84 LJD  ADDED CHECK FOR SUBCHAN RE FILE ACCESS STATS  >LJD073184
* 06/05/84 LJD  RECORD ALL DISC FAILURE INFORMATION           >LJD060584
* 04/11/84 LJD  ADDED ADDITIONAL DISC FAILURE INFORMATION     >LJD041184
* 03/02/84 LJD  FIXED 'LOST INT - BUMPLESS FAILOVER' PROBLEM  >LJD030284
* 01/29/84 LJD  DELETED REFERENCE TO M.FOCA MACRO             >LJD012984
* 12/16/83 LJD  CORRECTED UDT ONLINE STATUS PROBLEM           >LJD121683
* 12/07/83 LJD  ADDED ERROR RETRY COUNT LOGIC                 >LJD120783
* 11/29/83 LJD  CORRECTED EMS DEVICE FAILURE ERROR REPORTING
* 11/18/83 LJD  EXPANDED GIOQ & PERFORMED DYNAMIC COPY TO GIOQ
* 08/26/83 LJD  EXPANDED GHOST IOQ ARRAY SIZE
*
* 03/27/83 LJD  PRIME DISC PROCESSOR PHASE II HANDLER   HEADER  H.BDP2
*DISC PROCESSOR PHASE II HANDLER  MPX-32  RELEASE 1.5   HEADER  H.DP02
*
*****************************************************************
*        RESTRICTED RIGHTS LEGEND                               *
*                                                               *
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE      *
*        RESTRICTIONS STATED IN SYSTEMS' LICENSE AGREEMENT      *
*        (FORM NO. 1218) OR, FOR GOVERNMENT CUSTOMERS,          *
*        DAR 7-104.9A.                                          *
*****************************************************************
*
*
         PROGRAM   H.BDP2         DUKE-R3.4U02
*                                                                 @
***************************************************************** @
*                                                               * @
*        GHOSTING CODE INFORMATION:                             * @
*        BREAKDOWN OF '@' SIGN SIGNIFICANCE                     * @
*        1)    @ = USED TO INDICATE GHOSTING CODE ADDITIONS     * @
*        2)   @@ = USED TO INDICATE SINGLE CONTROLLER GHOSTING  * @
*                  CODE ADDITIONS                               * @
*        3)  @@@ = USED TO INDICATE DEBUG CODE ADDITIONS        * @
*        4) @@@@ = USED TO INDICATE STATISTICAL INFORMATION     * @
*                  GATHERING CODE ADDITIONS                     * @
*                                                               * @
DBBDP2   SETF      ASSEMBLE DEBUG CODE? (SETT = YES, SETF = NO) * @
SCBDP2   SETF      ASSEMBLE SINGLE CONTROLLER GHOSTING CODE?    * @
*                  (SETT = YES, SETF = NO)                      * @
STBDP2   SETF      ASSEMBLE DISC STATISTICS CODE? (SETT = YES,  * @
*                  SETF = NO)                                   * @
*                                                               * @
***************************************************************** @
*                                                                 @
         DEF       TABBUF          ADDR OF FAILED CYL TABLE       @
         DEF       SEEKADDR        SATISIFY XIO.SUB
         DEF       VER.CXIO        SATISIFY H.DBUG UNDEFINED
         DEF       PRG.CXIO        SATISIFY H.DBUG UNDEFINED
VER.CXIO EQU       X'3203'
PRG.CXIO EQU       X'6712'
         IFT       DBBDP2,DBEND                                 @@@
         DEF       REGBUF
         DEF       LOCAL
         DEF       RG1
         DEF       RG4
         DEF       RG3
         DEF       RG8
         DEF       RG9
         DEF       IQ1
         DEF       IQ2
         DEF       IQ3
         DEF       IQ4
         DEF       IOQBUF
DBEND    ANOP                                                   @@@
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*                                                               *
*****************************************************************
*
         LIST      NOMAC,NODATA,NOREP
         M.BREGS
         M.EQUS
         M.BEQUS                   BOEING COMMUNICATION REGION>EHW033188
         M.TBLS
*        M.UTL.                    UTILIZATION EQUATES        >EHW033188
         DCA.EQUS                  CONTEXT BLOCK EQUATES
*
** DATA DEFINITION SECTION - DEFINES HANDLER SPECIFC DATA AND EQUATES
*
         SPACE     2
*
*
         EXT       S.VOMM7A        VALIDATE SYSTEM CALL   >RMB033087
*        MBR_EXT   S.VOMM7A        VALIDATE SYSTEM CALL   >RMB033087
         EXT       S.IOCS3         UNLINK I/O FROM CDT
         EXT       S.IOCS10        DELETE I/O QUEUE AND OS BUFFER
         EXT       S.IOCS12        STORE IOCD'S FOR EXTENDED I/O
         EXT       S.IOCS13        ALLOCATE I/O QUEUE & BUFFER SPACE
         EXT       S.IOCS15        DELETE I/O QUEUE AND OS BUFFER
         EXT       S.IOCS20        FETCH USERS BUFFER ADR & XFER CNT
         EXT       S.IOCS29        REPORT I/O COMPLETE
         EXT       S.IOCS31        MARK CONTROLLER OFF-LINE
         EXT       S.IOCS33        UPDATE DISC FAT
         EXT       S.IOCS34        ALLOCATE IOQ
         EXT       S.IOCS36        CALCULATE BLKS TILL EOS AND SEC ADDR
         EXT       S.IOCS37        DISC POST PROCESSING
         EXT       S.IOCS40        BUILD DATA IOCD LIST
         EXT       IOLINK          QUEUED EXIT, NO RETURN
         EXT       SERVCOMP        SERVICE COMPLETE EXIT, NO RETURN
         EXT       ILOPCODE        ILLEGAL OR INVALID EXIT, NO RETURN
         EXT       EXCPM           EXECUTE CHANNEL PROGRAM    >GDM101584
         EXT       EX.PPCI         EXCPM PPCI RECEIVER ENTRY  >GDM101584
         EXT       EX.MAPS         ROUTINE TO COUNT # MAPS CRO>GDM101584
*
         PAGE
         BOUND   1W
HAT      EQU       $
         DATAW     7               # OF ENTRY POINTS
XEP5     ACH       BDP2.5          OPCODE PROCESSING RENTRANT SERVICE
XEP2     ACH       BDP2.2          QUEUE START INTERRUPT SERVICE
XEP1     ACH       BDP2.1          QUEUE DRIVE INTERRUPT SERVICE
XEP4     ACH       BDP2.4          LOST/TIMED OUT INTERRUPT PROCESSOR
XEP6     ACH       BDP2.6          POST TRANSFER PROCESSING SERVICE
XEP3     ACH       BDP2.3          SPURIOUS INTERRUPT SERVICE ROUTINE
XEP8     ACH       BDP2.8          EP 8 INIT EP
*
SG.ADDR  ACW       XEP8
*
*** DCA EQUATES FOR EXPANDED DCA USED FOR DISC
*   SYSINIT DEFINES AND IS DEPENDENT ON THESE EQUATES FOR
*   MASTER SYSTEM IMAGES. !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*   --------------------------------------------------------
*
*
         SPACE     1
DCA.REZO EQU       DCA.SENS+4W     FIRST WORD OF EXPANDED DCA - DCA.REZO
*                                  IOCD
DCA.TIC  EQU       DCA.REZO+2W     TIC IOCD
DCA.LMOD EQU       DCA.TIC+2W      LOAD MOAD COMMAND
DCA.RECC EQU       DCA.LMOD+2W     READ ECC IOCD
DCA.ECC  EQU       DCA.RECC+2W     ECC DATA BUFFER
DCA.ECNT EQU       DCA.ECC+1W      # OF ECC CORRECTIONS THIS DEVICE
DCA.BITD EQU       DCA.ECNT+1W     BIT DISPLACEMENT REMAINDER FOR ECC
DCA.BYTD EQU       DCA.BITD+1H     BYTE DISPLACEMENT FOR ECC
DCA.A1   EQU       DCA.BITD+1W     CURRENT IOCD ADDRESS
DCA.A2   EQU       DCA.A1+1W       LAST BUFF ADDR FOR PREVIOUS IOCD
DCA.A3   EQU       DCA.A2+1W       START BUFF ADDR FOR CURRENT IOCD
DCA.A4   EQU       DCA.A3+1W       ADDR OF END OF ERRING SECTOR
DCA.A5   EQU       DCA.A4+1W       ADDR OF ERRING HALFWORD
DCA.B1   EQU       DCA.A5+1W       # OF BYTES XFER'D FOR CURRENT IOCD
DCA.B2   EQU       DCA.B1+1W       END OF CURRENT IOCD BUFFER
DCA.WST3 EQU       DCA.B2+1W       STATUS SAVE CELL FOR ECC LOGIC
DCA.WST4 EQU       DCA.WST3+1W     STATUS SAVE CELL FOR ECC LOGIC
*DCA.SCYL  EQU      DCA.WST4+1W     SECTOR/CYLINDER FOR DISC    C032-33
****  DCA.SCYL IS DEFINED IN DCA.EQUS  ****                     C032-33
DCA.EOFB EQU       DCA.SCYL+1W     EOF BUFFER FOR NON DATA XFER COMMANDS
DCA.INCA EQU       DCA.EOFB+1W     ADDR OF INITIALIZE CNTRLLER ROUTINE
DCA.UNU1 EQU       DCA.INCA+1W     UNUSED LOCATION                  2102
DCA.UNU2 EQU       DCA.UNU1+1W     UNUSED LOCATION                  2102
DCA.UREC EQU       DCA.UNU2+1W     TOT # OF UNRECOVERABLE ERRS      2102
DCA.NOP  EQU       DCA.UREC+1W     NOP IOCD FOR ERROR RESET    REV20019
DCA.NOPT EQU       DCA.NOP+2W      NOP TIC IOCD TO CHAIN       REV20019
PORIOCD  EQU       DCA.NOPT+2W     'PRIORITY' OVERRIDE IOCD            @
SIOCNT   EQU       PORIOCD+1D      SUCCESSFUL SIO COUNTER              @
RSCTLCNT EQU       SIOCNT+1W       # RESET CONTROLLER CMNDS ISSUED     @
RESTOUT  EQU       RSCTLCNT+1W     RESERVE TIMEOUT FOR ISSUING 'POR'   @
TWIN     EQU       RESTOUT+1W      COUNTERPART CONTEXT BLOCK ADDR      @
GIOQADR  EQU       TWIN+1W         GHOST IOQ ASSOCIATED WITH I/O       @
PIOQADR  EQU       GIOQADR+1W      PRIME IOQ ASSOCIATED WITH I/O       @
EXTRA    EQU       PIOQADR+1W-DCA.REZO/4  NUM XTRA WDS        REV20019
*
FLSLGTH  EQU       8
*        MISC LOCAL PARAMETERS
*
MASK3B   DATAW     X'FFFFFF'       3 BYTE MASK
MASK2B   DATAW     X'FFFF'         2 BYTE MASK
ERRMASK  DATAW     X'3FF3'         MASK FOR BITS 2-11,14,15
SENSERR  DATAW     X'00AA1D03'     HARD ERROR MASK - NO RETRY (SENSE)
SENSERR2 DATAW     X'00140014'     ERROR MASK - RETRY WHOLE IOCD LIST
STATERR  DATAW     X'3C000000'     HARD ERROR MASK - NO RETRY/STATUS
RETRYMAX DATAW     -3              NEG MAX RETRY COUNT (3 RETRYS)
LOSTINT  DATAW     X'40200000'     LOST INTERRUPT STATUS
LMRSKEL  DATAW     X'1F000000'     LOAD MODE COMMAND CODE
CCMASK   DATAW     X'78000000'     CONDITION CODE MASK
*                                                                 @
*                                                                 @
*        VARIOUS SUBROUTINES RETURN ADDRESS SAVE LOCATIONS        @
H.SDRETA DATAW     0               H.START/H.DRIVE RETURN ADDRESS @
INITRETA DATAW     0               INITIO RETURN ADDRESS          @
STATRETA DATAW     0               CKSTAT RETURN ADDRESS          @
ECCRETA  DATAW     0               ECC.0 RETURN ADDRESS           @
ERRPRETA DATAW     0               ERRTIMEO/SNSSI/SETB6 RETURN ADR@
*                                                                 @
EP4CNT   DATAW     0               # TIMES EP4 ENTERED (LOST INT) @
EP4HIO   DATAW     0               # TIME HIO ISSUED IN SUCCESSION@
*
PRIVDISC EQU       X'0800'         SMALL SCADA PRIVATE DISC CHAN  @
CPU1     EQU       1               SMALL SCADA CPU 1 INDICATOR    @
EMS      EQU       1               EMS 'B.SYSMOD' INDICATOR       @
SSCADA   EQU       2               SMALL SCADA 'B.SYSMOD' INDICATE@
*
         SPACE     2
SEEK     DATAW     X'07000000'     SEEK IOCD SKELETON
         DATAW     X'40000004'
FIXDISC  EQU       3
WRITOP   EQU       3               WRITE OPCODE
BLKSIZE  EQU       192W            DISC BLOCK SIZE FOR THIS SYSTEM
*
*        DISC LAST CYLINDER # ACCESSED TABLE  (USED FOR DISC      @
*        CLOSEST CYLINDER SEEKING & DISC STATISTICS ALGORITHMS    @
*        MONITORING DISC HEAD MOVEMENT)                           @
*        TABLE CURRENTLY ALLOWS FOR TWO DISC CONTROLLERS WITH 8   @
*        SUBCHANNELS ON EACH CONTROLLER                           @
LCATBL   REZ       8W              LAST CYLINDER ACCESSED TABLE   @
*                                                                 @
*                                                                 @
*        NOTE:     PARTIAL/NORMAL GHOSTING IS NOT SUPPORTED       @
*        ANYMORE.  REFERENCES TO PARTIAL GHOSTING ARE LEFT IN     @
*        FOR INFORMATIONAL PURPOSES.                              @
*        PARTIAL (NORMAL) GHOSTING LOW AND HIGH LIMITS FOR MHD    @
*        CAUTION: IF THESE ARE CHANGED, A FILEMGRB SAVE MUST BE   @
*        MADE OF THE AFFECTED PACK, A COLD START DONE WITH THE    @
*        NEW SYSTEM, AND THEN A FILEMGRB RESTORE                  @
BMNLL    DATAW     0               STARTING SECTOR LOW LIMIT      @
BMNHL    DATAW     0               ENDING SECTOR HIGH LIMIT       @
B.MNLL   DATAW     0               STARTING SECTOR LOW LIMIT      @
B.MNHL   DATAW     0               ENDING SECTOR HIGH LIMIT       @
*
*  SAVE AREAS FOR OLDPSD EQUIVALENCES
*
PRISIAD  DATAW     0               PRIMARY DISC OLDPSD ADDR
GSTSIAD  DATAW     0               GHOST DISC OLDPSD ADDR
*
*        FOLLOWING EQUATES RELATE TO DCA.FLAG WITHIN THE CONTEXT BLOCK
TIMEOFLG EQU       1               SET: LOST INT HIO ISSUED (EP4)
STATSTR  EQU       2               SET: I/O COMPLETED FOR DEVICE
*                                  THAT HAD TIMED OUT
*
*     THE NEXT EQUATES RELATE TO FLAG WITHIN H.EXIO
HANDLER  EQU       1               SET: IN CHT.FLGS FOR H.EXIO
*                                  ENTRY IS FROM THE HANDLER
EP4FLG   EQU       1               SET: IN DCA.FLAG THAT ENTRY
*                                  WAS FROM EP4 'HIO' STATUS STORED
*                                                                 @
*                                                                 @
*                                                                 @
*        GHOST 'IOQ ARRAY' INFORMATION                            @
GIOQSIZ  EQU       482W            GHOST IOQ ARRAY SIZE           @
*                                                                 @
*                                                                 @
*        GHOSTING RELATED EQUATES                                 @
*        B.GFLG - GHOSTING COMM REGION FLAG EQUATES               @
MGE      EQU       0               B.GFLG: MHD GHOST ENABLED      @
MGP      EQU       1               B.GFLG: MHD GHOST IN PROGRESS  @
MNG      EQU       2               B.GFLG: MHD NORMAL GHOSTING    @
MGU      EQU       3               B.GFLG: MHD GHOST UP TO SPEED  @
MRE      EQU       4               B.GFLG: MHD DUAL READ ENABLE   @
GIP      EQU       5               B.GFLG: GHOST INCH IN PROGRESS @
*                                                                 @
MBF      EQU       8               B.GFLG: DISC BUMPLESS FAILOVER @
MCG      EQU       9               B.GFLG: MULTIPLE CHAN GHOSTING @
MIA      EQU       10              B.GFLG: HIGHEST DISC INT ACTIVE@
MPF      EQU       11              B.GFLG: PRIME MHD DISC FAILURE @
MIB      EQU       12              B.GFLG: MHD EXT INTS BLOCKED   @
MUE      EQU       13              B.GFLG: MHD GHOST UNLINK ENABLE@
MDF      EQU       14              B.GFLG: MHD FAILURE            @
MDP      EQU       15              B.GFLG: MHD PRESENT IN SYSTEM  @
MDC      EQU       16              B.GFLG: MHD CHANNEL CHANGED    @
*                                                                 @
FGE      EQU       16              B.GFLG: FHD GHOST ENABLED      @
FGP      EQU       17              B.GFLG: FHD GHOST IN PROGRESS  @
FNG      EQU       18              B.GFLG: FHD NORMAL GHOSTING    @
FGU      EQU       19              B.GFLG: FHD GHOST UP TO SPEED  @
FRE      EQU       20              B.GFLG: FHD DUAL READ ENABLE   @
FPF      EQU       27              B.GFLG: PRIME FHD DISC FAILURE @
FDF      EQU       30              B.GFLG: FHD FAILURE            @
FDP      EQU       31              B.GFLG: FHD PRESENT IN SYSTEM  @
*        IOQ.FLGS - IOQ FLAGS EQUATES                             @
RIO      EQU       10              IOQ.FLGS: READ I/O REQUEST     @
EIC      EQU       31              IOQ.FLGS: ENABLE IOQ/GIOQ COPY @
*        IOQ.MOWD - IOQ READ/WRITE MODE EQUATES                   @
PIC      EQU       8               IOQ.MOWD: PSEUDO I/O COMPLETE  @
RTW      EQU       9               IOQ.MOWD: READ TO WRITE REQUEST@
RAR      EQU       10              IOQ.MOWD: DUAL READ ALLOWED    @
POR      EQU       11              IOQ.MOWD: PRIME ONLY READ      @
DUW      EQU       12              IOQ.MOWD: DUPLICATE WRITES     @
POW      EQU       13              IOQ.MOWD: PRIME ONLY WRITE     @
GOW      EQU       14              IOQ.MOWD: GHOST ONLY WRITE     @
GIC      EQU       15              IOQ.MOWD: GHOST INCH REQUEST   @
*        FCBSTAT - FCB 'PRIME ONLY'/'GHOST ONLY' I/O REQUESTS     @
FPR      EQU       14              FCBSTAT: FCB PRIME ONLY READ   @
FGW      EQU       15              FCBSTAT: FCB GHOST ONLY WRITE  @
*                                                                 @
*        DCA.FLAG - CONTEXT BLOCK DCA.FLAG EQUATE                   @
GCB      EQU       23              DCA.FLAG: GHOST CONTEXT BLOCK   @
*                                                                 @
*        H.EXIO 'OLDPSD' EQUATES                                  @
XIOCDT   EQU       25W             EXT EQUATE TO H.EXIO CDT ADDR  @
XIOCHT   EQU       26W             EXT EQUATE TO H.EXIO CHT ADDR  @
INCHIOCD EQU       X'2C'           EXT EQUATE TO H.EXIO INCH ADDR @
         IFT       STBDP2,STEND                                @@@@
*                                                              @@@@
*                                                              @@@@
*        DISC STATISTICS RELATED EQUATES                       @@@@
*                                                              @@@@
THBASE   EQU       0W              TOTAL I/O HIST BASE ADDR    @@@@
RHBASE   EQU       2400W           READ I/O HIST BASE ADDR     @@@@
WHBASE   EQU       4800W           WRITE I/O HIST BASE ADDR    @@@@
BSTATSIZ EQU       500W            BASE STATISTICS ARRAY SIZE  @@@@
IHISTSIZ EQU       800W            INDIVIDUAL HISTOGRAM SIZE   @@@@
AHISTSIZ EQU       7200W           CHANNEL CYL ACCESS HIST SIZE@@@@
MHISTSIZ EQU       2400W           CYL MOVEMENT HISTOGRAM SIZE @@@@
*                                                              @@@@
STIM     EQU       0W              DWD STATISTICS START TIME   @@@@
ETIM     EQU       2W              DWD STATISTICS END TIME     @@@@
PST      EQU       4W              1WD PRIME START I/O TIME    @@@@
PET      EQU       5W              1WD PRIME END I/O TIME      @@@@
*                                                              @@@@
TSIO     EQU       10W             1WD TOTAL I/O COUNT         @@@@
TRIO     EQU       11W             1WD TOTAL READ I/O COUNT    @@@@
TWIO     EQU       12W             1WD TOTAL WRITE I/O COUNT   @@@@
*                                                              @@@@
PSIO     EQU       13W             1WD TOTAL PRIME I/O COUNT   @@@@
PRIO     EQU       14W             1WD TOTAL PRIME READ I/O CNT@@@@
PWIO     EQU       15W             1WD TOTAL PRIME WRITE I/O # @@@@
*                                                              @@@@
GSIO     EQU       16W             1WD TOTAL GHOST I/O COUNT   @@@@
GRIO     EQU       17W             1WD TOTAL GHOST READ I/O #  @@@@
GWIO     EQU       18W             1WD TOTAL GHOST WRITE I/O # @@@@
*                                                              @@@@
TSEQ     EQU       100W            TOTAL I/O QUEUE ENTRIES HIST@@@@
TREQ     EQU       150W            TOTAL READ I/O QUEUE ENTRIES@@@@
TWEQ     EQU       200W            TOTAL WRITE I/O QUEUE ENTRY @@@@
*                                                              @@@@
NRBW     EQU       250W            # READ BEFORE WRITE IOQ ENT @@@@
NWBR     EQU       300W            # WRITE BEFORE READ IOW ENT @@@@
*                                                              @@@@
*PTH     EQU       500W            2400W PRIME I/O HISTOGRAM   @@@@
*PRH     EQU       2900W           2400W PRIME READ I/O HIST   @@@@
*PWH     EQU       5300W           2400W PRIME WRITE I/O HIST  @@@@
*                                                              @@@@
*GTH     EQU       7700W           2400W GHOST I/O HISTOGRAM   @@@@
*GRH     EQU       10100W          2400W GHOST READ I/O HIST   @@@@
*GWH     EQU       12500W          2400W GHOST WRITE I/O HIST  @@@@
*                                                              @@@@
*PMH     EQU       14900W          2400W PRIME MOVEMENT HIST   @@@@
*GMH     EQU       17300W          2400W GHOST MOVEMENT HIST   @@@@
STEND    ANOP                                                  @@@@
         PAGE
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*            ENTRY POINT 1                                      *
*            QUEUE DRIVE INTERRUPT SERVICE ROUTINE              *
*            ENTRY POINT 1 PERFORMS I/O POST-ACCESS PROCESSING  *
*            FOR COMPLETED I/O REQUESTS AND PRE-ACCESS          *
*            PROCESSING ASSOCIATED WITH ALL QUEUED I/O REQUESTS *
*            FOR NON BUSY DEVICES ON THE INTERRUPTING CHANNEL.  *
*                                                               *
*****************************************************************
*        ENTERED VIA BRANCH FROM H.EXIO                         *
*            X3 = CONTEXT BLOCK ADDR OF COMPLETING SUBCHANNEL   *
*            STATUS SAVED IN CONTEXT BLOCK                      *
*****************************************************************
         SPACE     2
BDP2.1   EQU       $
         BL        H.DRIVE         QUEUE DRIVE INTERRUPT ROUTINE
         ZBM       MIB,B.GFLG      BEI IN EFFECT FROM EP-4?       @
         BNS       BDP2.1A         NO...BRANCH                    @
         ZBM       MBF,B.GFLG      ENSURE BUMPLESS FAILOVER BIT 0 @
         BU        *IOCSRET        RETURN TO IOCS (FROM EP-4)     @
*                                                                 @
BDP2.1A  EQU       $                                              @
         TRR       R3,R0           ENSURE R0 = CONTEXT BLK ADDR
*                                  (POSSIBLE 'SIO-STATUS STORED
         LW        R3,DCA.CHTA,X3  CHT ADDRESS FROM DCA
*                                  ENTRY' TO H.EXIO)
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       HIOAGAIN        R4: 0=> RETURN TO ENTRY POINT 4
         BEQ       *CHT.RTN,X3
         BU        *CHT.EXIT,X3
         PAGE
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*            ENTRY POINT 2                                      *
*            QUEUE START SERVICE ROUTINE                        *
*            ENTRY POINT 2 SERVES AS THE LINK BETWEEN EP2 OF    *
*            H.EXIO AND THE PRE-ACCESS PROCESSING CODE OF EP1   *
*            OF THE HANDLER.                                    *
*                                                               *
*****************************************************************
*        ENTERED VIA BL FROM H.IOCS                             *
*            X3 = CONTEXT BLOCK ADDRESS ASSOCIATED WITH THE     *
*                 I/O REQUEST                                   *
*            BEI IN EFFECT                                      *
*****************************************************************
         SPACE 3
BDP2.2   EQU       $
         SBM       MIB,B.GFLG      SHOW EXT INTS BLOCKED          @
         BL        H.START         QUEUE START INTERRUPT ROUTINE
         TRR       R3,R0           ENSURE R0 = CONTEXT BLK ADDR
*                                  (POSSIBLE 'SIO-STATUS STORED
         LW        R3,DCA.CHTA,X3  CHT ADDRESS FROM DCA
*                                  ENTRY' TO H.EXIO)
         ZBM       MIB,B.GFLG      SHOW EXT INTS UNBLOCKED        @
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       HIOAGAIN        R4: 0=> RETURN TO ENTRY POINT 4
         BEQ       *CHT.RTN,X3     R4: 1=> RETURN TO EP1.3 OF H.EXIO
         BU        *CHT.EXIT,X3    R4: 2=> RETURN TO EXIT OF H.EXIO
         PAGE
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*            ENTRY POINT 3                                      *
*            SPURIOUS INTERRUPT SERVICE ROUTINE                 *
*            ENTRY POINT 3 IS A DUMMY ENTRY POINT WHICH IS      *
*            NEVER CALLED BECAUSE SPURIOUS INTERRUPTS ARE       *
*            DISCOVERED AND PROCESSED AT EP3 OF H.EXIO.         *
*                                                               *
*****************************************************************
         SPACE     3
BDP2.3   EQU       $
         TRSW      R0              RETURN, THIS ENTRY POINT SHOULD
         NOP                       NEVER BE CALLED
         PAGE
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*            ENTRY POINT 4                                      *
*            LOST INTERRUPT SERVICE ROUTINE                     *
*            ENTRY POINT 4 IS ENTERED FROM S.IOCS5 TO TAKE      *
*            CORRECTIVE MEASURES APPROPRIATE TO THE DEVICE      *
*            WHEN AN EXPECTED SERVICE INTERRUPT (SI) FAILS      *
*            TO OCCUR.                                          *
*                                                               *
*****************************************************************
*        ENTERED VIA BL FROM S.IOCS5                            *
*            X1 = UDT ADDRESS                                   *
*            BEI IN EFFECT                                      *
*****************************************************************
         SPACE     3
BDP2.4   EQU       $
         TRR       R3,R1            INSURE UDT IS IN R1
         ABM       31,EP4CNT       INC # TIMES EP4 ENTERED        @
*        M.HSMAC   R1,UTL.LSI      COUNT LOST INTERRUPTS      >EHW033188
         SBM       MIB,B.GFLG      SHOW EXT INTS BLOCKED          @
         LW        R3,UDT.CBLK,X1  FETCH CONTEXT BLOCK ADDRESS
         ZBM       TIMEOFLG,DCA.FLAG,X3  HAS HIO ALREADY BEEN ISSUED?
         BNS       DOHIO           NO...BRANCH
         LW        R2,DCA.CHTA,X3  CHT ADDRESS
         STW       R0,CHT.REGS,X2  SAVE EP4 RETURN ADDRESS
         ABM       31,RSCTLCNT,X3  INCR # OF RST CNTRL CMNDS (SUBC)
         LH        R7,DCA.UADD,X3  FETCH CHANNEL ADDRESS
         RSCTL     R7,0            DEVICE MUST BE BROKEN, RESET
         LI        R4,-32000       LOAD DELAY COUNT
         BIB       R4,$            DELAY
DOHIO    EQU       $
         LH        R7,DCA.UADD,X3    FETCH CHANNEL ADDR & SUB ADDR
         ACI       R7,0            ACTIVATE THIS LEVEL
         HIO       R7,0            ISSUE HALT I/O
         BCT       2,GOH.EXIO      BRANCH IF STATUS STORED RESPONSE
         SBM       TIMEOFLG,DCA.FLAG,X3  SET LOST INT HIO ISSUED FLAG
         LI        R5,-2           LOAD NEG 2  TIMER UNITS
         STW       R5,UDT.PTOV,X1  STORE TIME OUT INTO UDT
         DACI      R7,0            DEACTIVATE THIS LEVEL
         ABM       31,EP4HIO       INC # TIME HIO ISSUED          @
         LW        R5,EP4HIO       CHECK IF 5 HIO'S HAVE BEEN     @
         CI        R5,5            ISSUED IN SUCCESSION           @
         BNE       DOHIOC          NO...BRANCH                    @
         LW        R2,DCA.IOQA,X3     GET ACTIVE IOQ ADDRESS         @
         LW        R5,LOSTINT      GET LOST INTERRUPT STATUS      @
         STW       R5,IOQ.IST2,X2  STORE INTO IOQ                 @
         STW       R0,IOCSRET      SAVE IOCS RETURN ADDRESS       @
         BL        FAILURE         GO TERMINATE THIS OPERATION    @
DOHIOC   EQU       $                                              @
         ZBM       MIB,B.GFLG      SHOW EXT INTS UNBLOCKED        @
         TRSW      R0              RETURN TO S.IOCS5
         NOP
GOH.EXIO EQU       $
         LW        R2,DCA.CHTA,X3    CHT ADDRESS
         SBM       EP4FLG,DCA.FLAG,X3  SHOW H.EXIO ENTRY FROM EP4
         SBM       HANDLER,CHT.FLGS,X2  SHOW H.EXIO ENTRY FROM HANDLER
         STW       R0,CHT.REGS,X2       SAVE EP4 RETURN ADDRESS
         STW       R3,CHT.REGS+1W,X2    SAVE CONTEXT BLOCK ADDRESS
         STW       R1,CHT.REGS+2W,X2  SAVE UDT ADDRESS
         TRR       R3,R0           R0 = CONTEXT BLOCK ADDRESS
         TRR       R2,R3           R3 = CHT ADDRESS FOR H.EXIO
         ZBM       MIB,B.GFLG      SHOW EXT INTS UNBLOCKED        @
         BU        *CHT.RTN,X3     BRANCH TO H.EXIO
IOCSRET  DATAW     0               IOCS RETURN ADDRESS            @
         SPACE     1
*****************************************************************
*                                                               *
*            HIOAGAIN                                           *
*            LOST INTERRUPT PROCESSING (CONTINUED)              *
*                                                               *
*****************************************************************
*        ENTERED VIA BRANCH FROM ENTRY POINT 2                  *
*            (DECISION MADE AT EP2MERGE)                        *
*            X2 = H.EXIO OLDPSD ADDRESS                         *
*            X3 = CHANNEL HW TABLE ADDRESS                      *
*            BEI IN EFFECT                                      *
*****************************************************************
HIOAGAIN EQU       $
         TRR       R3,R2           R2 = CHT ADDRESS
         TRR       R0,R3           R3 = DCA ADDRESS
         LW        R0,CHT.REGS,X2  FETCH EP4 RETURN ADDRESS
         CAMW      R3,CHT.REGS+1W,X2  WAS STATUS STORED FOR DEVICE
*                                  FOR WHICH THE HIO WAS ISSUED?
         BNE       RSTCBLK         NO, BRANCH
         SBM       STATSTR,DCA.FLAG,X3  SHOW I/O ACTUALLY COMPLETED
RSTCBLK  EQU       $
         LW        R3,CHT.REGS+1W,X2  FETCH ORIGINAL CONTEXT BLK ADDR
         LW        R1,CHT.REGS+2W,X2  RESTORE ORIGINAL UDT ADDRESS
         BU        DOHIO           BRANCH
         PAGE
*****************************************************************
*                                                               *
*        DISC PROCESSOR PHASE II HANDLER                        *
*            ENTRY POINT 5                                      *
*            OPCODE PROCESSING SERVICE ROUTINE                  *
*            ENTRY POINT 5 IS CALLED BY IOCS TO PROCESS         *
*            VARIOUS USER I/O REQUESTS.                         *
*                                                               *
*****************************************************************
*        ENTERED VIA BL FROM H.IOCS                             *
*            R1 = FCB ADDRESS                                   *
*            R2 = HAT ADDRESS                                 >GDM101584
*            R3 = UDT ADDRESS                                 >GDM101584
*        EP5 EXIT MUST HAVE:                                    *
*            R1 = FCB ADDRESS                                   *
*****************************************************************
         SPACE     3
OP.      EQU       $
         SPACE     3                                          >GDM101584
         BOUND     1W                                         >GDM101584
*                                                             >GDM101584
** THE OPCODE VECTOR TABLE WHICH FOLLOWS CONTAINS THE ADDRESSES OF
** THE OPCODE PROCESSING PROCEDURES ORDERED BY OPCODE NUMBER. EACH
** ENTRY HAS BIT 0 SET IF THE ASSOCIATED PROCEDURE REQUIRES AN I/O
** QUEUE ENTRY. SYMBOLIC OPCODES ARE ALSO LISTED.
*                                                             >GDM101584
OPTAB    EQU       $                                          >GDM101584
         GEN       1/0,31/W(OPEN)  OPEN                       >GDM101584
OPEN.OP  EQU       0                                          >GDM101584
         GEN       1/0,31/W(RWND)  REWIND                     >GDM101584
RWND.OP  EQU       1                                          >GDM101584
         GEN       1/0,31/W(RDWRIT)  READ RECORD              >GDM101584
READ.OP  EQU       2                                          >GDM101584
         GEN       1/0,31/W(RDWRIT)  WRITE RECORD             >GDM101584
WRIT.OP  EQU       3                                          >GDM101584
         GEN       1/1,31/W(WEOF)  WRITE END-OF-FILE RECORD   >GDM101584
WEOF.OP  EQU       4                                          >GDM101584
         GEN       1/0,31/W(EXCPM) EXECUTE CHANNEL PROGRAM SUB>GDM101584
EXCP.OP  EQU       5                                          >GDM101584
         GEN       1/1,31/W(ADVR)  ADVANCE RECORD             >GDM101584
ADVR.OP  EQU       6                                          >GDM101584
         GEN       1/1,31/W(ADVF)  ADVANCE FILE               >GDM101584
ADVF.OP  EQU       7                                          >GDM101584
         GEN       1/1,31/W(BKSR)  BACKSPACE RECORD           >GDM101584
BKSR.OP  EQU       8                                          >GDM101584
         GEN       1/1,31/W(BKSF)  BACKSPACE FILE             >GDM101584
BKSF.OP  EQU       9                                          >GDM101584
         GEN       1/1,31/W(UPSP)  UPSPACE - USED TO FORMAT DI>GDM101584
UPSP.OP  EQU       10                                         >GDM101584
         GEN       1/0,31/W(ERPT)  ERASE OR PUNCH TRAILER     >GDM101584
ERPT.OP  EQU       11                                         >GDM101584
         GEN       1/0,31/W(EJCT)  EJECT                      >GDM101584
EJCT.OP  EQU       12                                         >GDM101584
         GEN       1/0,31/W(CLSE)  CLOSE                      >GDM101584
CLSE.OP  EQU       13                                         >GDM101584
         GEN       1/1,31/W(RESER) RESERVE PORT               >GDM101584
RESE.OP  EQU       14                                         >GDM101584
         GEN       1/1,31/W(RELES) RELEASE PORT               >GDM101584
RELE.OP  EQU       15                                         >GDM101584
         SPACE     3                                          >GDM101584
         BOUND     1W                                         >GDM101584
*                                                             >GDM101584
** THE COMMAND TABLE WHICH FOLLOWS CONTAINS THE IOP DISC CONTROLLER
** COMMAND REQUIRED FOR EACH OPERATION IN OPCODE ORDER. NOTE THAT
** THE 8-BIT COMMAND CODES ARE POSITIONED AS THEY WILL APPEAR IN
** WORD 1 OF AN I/O COMMAND DOUBLEWORD (IOCD).
*                                                             >GDM101584
COMTAB   EQU       $                                          >GDM101584
         DATAW     0                                          >GDM101584
         DATAW     0                                          >GDM101584
         DATAW     X'02000000'     READ RECORD                >GDM101584
         DATAW     X'01000000'     WRITE RECORD               >GDM101584
         DATAW     X'01000000'     WRITE EOF (WRITE)          >GDM101584
         DATAW     0                                          >GDM101584
         DATAW     X'02000000'     ADVANCE RECORD (READ)      >GDM101584
         DATAW     X'02000000'     ADVANCE FILE (ADVF)        >GDM101584
         DATAW     X'02000000'     BACKSPACE RECORD (READ)    >GDM101584
         DATAW     X'02000000'     BACKSPACE FILE (BKSF)      >GDM101584
         DATAW     0               UPSPACE (SEE UPSP PROCEDURE>GDM101584
         DATAW     0                                          >GDM101584
         DATAW     0                                          >GDM101584
RES.IOCD DATAW     X'23000000'     RESERVE PORT               >GDM101584
REL.IOCD DATAW     X'33000000'     RELEASE PORT               >GDM101584
*                                                             >GDM101584
**  THE FOLLOWING WORD IS FOR LOCKING THE RESOURCE            >GDM101584
**  DESCRIPTOR ON A DUAL PORTED XIO DISC                      >GDM101584
*                                                             >GDM101584
LOCKIOCD GEN       8/X'01',24/W(LOCK)    LOCK IOCD WORD 1     >GDM101584
LOCK     DATAW     X'FFFFFFFF'           LOCK IOCD BUFFER ADDR>GDM101584
*                                        ONLY LEFT HW IS USED >GDM101584
         PAGE                                                 >GDM101584
BDP2.5   EQU       $
         SPACE                                                >GDM101584
***  INITIALIZE CHANNEL IF NECESSARY                      >GDM101584
         SPACE                                                >GDM101584
OP.1.00  EQU       $                                          >GDM101584
         SPACE                                                >GDM101584
         LW        R3,UDT.CBLK,X3  GET ADDR OF CONTEXT BLOCK  >GDM101584
         LW        R2,DCA.CHTA,X3  GET CHT ADDRESS
*        M.SHUT
         TBM       0,CHT.FLGS,X2   HAS INCH BEEN PERFORMED ?
         BS        OP.1.05         BRANCH IF CHANNEL ALREADY INCHED
         BL        *CHT.INCH,X2    GO TO BEXIO TO PERFORM INCH
         BU        FAILURE         RETURN HERE IF FAILURE
*
         SPACE
*
** PROCEDURE TO ALLOCATE AN I/O QUEUE ENTRY,IF NECESSARY, AND
** VECTOR TO THE APPROPIATE OPCODE PROCESSING PROCEDURE
*
         SPACE
OP.1.05  EQU       $
*        M.OPEN
         LW        R3,DCA.UDTA,X3   R3 = UDT ADDRESS
         LB        R2,FCB.OPCD,X1  GET OPCODE FROM FCB
         SLL       R2,2            WORD ADJUST OPCODE
         TBM       0,OPTAB,X2      TEST TO SEE IF IOQ NEEDED
         BNS       OP.0.00         BR IF IOQ NOT REQU'D
         TRR       R2,R4           SAVE DCA ADDR FOR LATER
         BL        S.IOCS13        GET I/O QUEUE ENTRY
         LW        R2,UDT.CBLK,X3  GET CONTEXT BLOCK ADDRESS
         LW        R3,FCB.IOQA,X1  GET IOQ ENTRY ADDRESS
         STB       R4,IOQ.FCT1,X3  SAVE OPCODE IN IOQ ENTRY
         ABM       29,IOQ.IST1,X3  INCR ADDR TO START BUILDING IOCL
         LW        R6,IOQ.IST1,X3  GET START ADDR OF IOCL
         STW       R6,IOQ.IOCD,X3  SAVE IOCL START ADDR FOR EP I.Q.
         ZMB       IOQ.IST1,X3     CLEAR LOAD MODE BUFFER
         LEAR      R6,IOQ.IST1,X3  GET MODE BYTE REAL ADDR
         ORMW      R6,DCA.LMOD,X2   OR IN THE LOAD MODE CMD BYTE
         LW        R7,DCA.LMOD+1W,X2   GET WORD 2 OF THE LOAD MODE IOCD
         LW        R2,DCA.UDTA,X2   GET THE UDT ADRR BACK FROM CONTXT BL
         BL        S.IOCS12        STORE LMODE IOCD INTO IOCL SPACE
         TRR       R4,R2           RESTORE OPCODE TO R2
OP.0.00  EQU       $
         BU        *OPTAB,R2       VECTOR TO OPCODE PROCEDURE
         SPACE     2
*
** PROCEDURE TO PERFORM READ AND WRITE PREPROCESSING AND IOQ ALLOCATION
*
         SPACE
RDWRIT   BL        S.IOCS20        GET FCB XFER ADDRESS AND COUNT
RW.2.00  EQU       $
         STW       R6,FCB.IOQA,X1  SAVE DATA ADDRESS FOR LATTER
         STW       R7,FCB.RECL,X1  SAVE XFER COUNT FOR LATTER
         TRR       R7,R7           COUNT ZERO?
         BZ        RW.3.00         BR IF NO DATA XFERED
**** CONVERT BYTE COUNT TO DISC BLOCK COUNT
         ZR        R6              CLEAR R6 FOR DIVIDE
         DVI       R6,BLKSIZE      DIVIDE BYTE COUNT BY BYTES PER BLK
         TRR       R6,R6           ANY REMAINDER ?
         BZ        RW.3.00         BR IF NO REMAINDER
         ABR       R7,31           INCR 1 BLK FOR REMAINDER
RW.3.00  EQU       $
**** GOTO S.IOCS33 TO CHECK FOR EOF, EOM, OR BOM
         SBM       0,FCB.IOQA,X1   INDICATE DATA IN FCB.IOQA    REV20007
         LW        R2,FCB.FATA,X1  A(FCB) FOR S.IOCS33              2107
         BL        S.IOCS33        PROCESS FAT FOR CURRENT OPERATION
         ZBM       0,FCB.IOQA,X1   CLEAR DATA INDICATOR         REV20007
         TRR       R6,R6           OPERATION WITHIN FILE BOUNDS ?
         BZ        GETIOQ          BR IF NO SHORT XFER
         BP        RW.3.05         BR IF NOT BOM, EOM, OR EOF
         ZMW       FCB.IOQA,X1     CLEAR TEMP STORAGE WORD
         ZMW       FCB.RECL,X1     CLEAR TEMP STORAGE WORD
         BU        SERVCOMP        REPORT I/O COMPLETE
**** ADJUST TRANSFER COUNT FOR SHORT TRANSFER
RW.3.05  EQU       $
         ZR        R6              CLEAR R6 FOR MULTIPLY
         MPI       R6,BLKSIZE      CALCULATE NEW XFER COUNT
         STW       R7,FCB.RECL,X1  PLACE NEW XFER COUNT IN FCB
         SPACE     2
*
** PROCEDURE TO CALCULATE THE NUMBER OF EXTRA WORDS NEEDED IN THE
** IOQ FOR THE IOCL. THEN ALLOCATE THE IOQ WITH THE EXTRA WORDS.
*
         SPACE
GETIOQ   EQU       $
         LW        R7,FCB.RECL,X1  GET ACTUAL XFER COUNT
         LW        R6,FCB.IOQA,X1  GET DATA ADDRESS
         LI        R5,5            GET 5 XTRA WRDS FOR LOAD MODE CMD
*                                  AND FIRST SEEK CMD
         STW       R5,FCB.IOQA,X1  REUSE FCB.IOQA FOR THE COUNT OF
*                                  XTRA WORDS NEEDED IN THE IOQ
         TRR       R7,R3           SAVE ACTUAL XFER COUNT IN R3
**** COUNT UP NUMBER OF MAPS CROSSED BY TRANSFER
         BL        EX.MAPS         GET NUMBER OF MAPS CROSSED * 2
         TBM       FCB.DPLK,FCB.SCFG,X1  RD LOCK SET?               2101
         BNS       ADDXTRA         NO, BRANCH                       2101
         SLL       R7,1            ALLOW FOR MAP CROSSING           2101
         ADI       R7,6            ADD 6W FOR LOCK MECHANISM        2101
ADDXTRA  EQU       $                                                2101
         ADI       R7,2            ADD 2 MORE WORDS FOR 1ST XFER
         ARMW      R7,FCB.IOQA,X1  ADD NUMBER OF XTRA WRDS FOR DATA
*                                  CHAINING TO TOTAL XTRA WRDS NEEDED
         CI        R3,BLKSIZE      IS XFER .LE. TO 1 BLK
         BLE       IOQ.2.00        BR IF XFER .LE. 1 BLK
         LW        R5,DFT.POS,X2   GET REL START DISC POSITION
         TRR       R3,R4           SAVE XFER COUNT IN R4
         SPACE
*
** PROCEDURE TO COUNT UP NUMBER OF TRANSFERS NEEDED FOR SEGMENTED
** FILES.
*
         SPACE
IOQ.1.00 EQU       $
         SBM       0,FCB.IOQA,X1   SET DATA BIT IN FCB.IOQA     REV20007
         BL        S.IOCS36        GET LENGTH OF SEGEMENT FOR THIS
*                                  STARTING BLOCK NUMBER
         ZBM       0,FCB.IOQA,X1   CLEAR DATA BIT IN FCB.IOQA   REV20007
         LI        R3,5            INCR XTRA WRDS BY 5 FOR THIS XFER
         ARMW      R3,FCB.IOQA,X1  INCR COUNT
         ADR       R7,R5           ADD BLKS TILL EOS TO CUR BLK # TO
*                                  GET NEXT STARTING BLK #
         ZR        R6              CLEAR R6 FOR MULTIPLY
         MPI       R6,BLKSIZE      CONVERT # OF BLKS TO # OF BYTES
*                                  TILL END-OF-SEGEMENT
         TRN       R7,R7           MAKE BYTE COUNT NEG.
         ARMW      R7,FCB.RECL,X1  ADD TO REMAINING BYTE COUNT
         BGT       IOQ.1.00        BR IF MORE DATA IS TO BE XFERED
         STW       R4,FCB.RECL,X1  RESTORE ACTUAL BYTE COUNT IN FCB
         SPACE
*
** PROCEDURE TO ALLOCATE IOQ WITH XTRA SPACE
*
         SPACE
IOQ.2.00 EQU       $
         LW        R7,FCB.IOQA,X1  GET XTRA WRDS TO ALLOCATE
         LW        R6,FCB.RECL,X1  GET ACTUAL XFER COUNT
         BL        S.IOCS34        ALLOCATE IOQ W/ XTRA WRDS
         LW        R3,FCB.IOQA,X1  GET IOQ ADDRESS
         STW       R6,IOQ.FCT3,X3  SET XFER COUNT TO ACTUAL XFER CNT
         STW       R6,IOQ.UTRN,X3  SET ACTUAL DATA TRANSFERED TO
*                                  XFER COUNT
         LB        R6,FCB.OPCD,X1  GET OPCODE OUT OF FCB
         TRR       R6,R7           MOVE TO R7
         SLL       R7,2            WORD ADJUST OPCODE
         STB       R7,IOQ.FCT1,X3  SAVE WRD ADJUSTED OPCODE IN FCT1
         ZMW       FCB.RECL,X1     CLEAR ACTUAL XFER COUNT
         CI        R6,WRITOP       CHECK FOR WRITE COMMAND
         BEQ       WRITE           BR TO BUILD IOCL IF WRITE
         SPACE     2
*
** PROCEDURE TO PERFORM READ. IF END-OF-FILE DETECTION IS REQUIRED
** SUBSEQUENT TO COMPLETION OF THE READ, BIT 8 OF IOQ ENTRY FUNCTION
** WORD 1 (IOQ.FCT1) WILL BE SET.
*
         SPACE
READ     EQU       $
OP.3.00  EQU       $
         TBM       2,FCB.CBRA,X1   DATA FORMATTING INHIBITED?
         BS        READ0           BR IF FMT INHIBITED - NO EOF DETECT
         LW        R2,FCB.FATA,X1  GET FAT ADDRESS
         TBM       0,DFT.FLGS,X2   BLOCKED I/O?
         BS        READ0           BR IF BLOCKED - NO EOF DETECTION
         TBM       4,FCB.GCFG,X1   RANDOM ACCESSING?
         BS        READ0           BR IF RAN ACC - NO EOF DETECTION
         SBM       29,IOQ.FLGS,X3  INDICATE EOF DETECTION REQ'D
READ0    EQU       $
         SPACE     2
         TBM       MGE,B.GFLG      GHOSTING ENABLED?              @
         BNS       READ1           NO...BRANCH                    @
         TBM       FPR,FCB.CBRA,X1 READ TO WRITE I/O REQUEST?     @
         BNS       READ1           NO...BRANCH                    @
         SBM       RTW,IOQ.MOWD,X3  SET READ TO WRITE BIT         @
         BU        READ4                                          @
READ1    EQU       $                                              @
         TBM       MGU,B.GFLG      MHD GHOSTING UP TO SPEED?      @
         BNS       READ3           NO...BRANCH                    @
READ2    EQU       $               READ FROM RESTRICTED ZONE      @
         SBM       RAR,IOQ.MOWD,X3  PERMIT DUAL READ              @
         BU        READ4                                          @
READ3    EQU       $               PRIME READ ONLY ALLOWED        @
         SBM       POR,IOQ.MOWD,X3  SET PRIME ONLY READ BIT       @
READ4    EQU       $                                              @
         SBM       10,IOQ.FLGS,X3  SET READ FLAG IN IOQ
         BU        IOCLBLD         BRANCH
*
*
WRITE    EQU       $
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BS        WRITE3          YES...BRANCH                   @
         LB        R6,B.CURFN      CHECK IF NON SCADA OR SAC WRITE@
         BZ        WRITE1          IS BEING ATTEMPTED TO RESERVED @
         CI        R6,X'03'        DISC AREA                      @
         BLT       WRITE5          OK FOR SCADA OR SAC WRITE      @
WRITE1   EQU       $                                              @
         BU        WRITE5          SKIP NORMAL GHOST CHECK        @
WRITE3   EQU       $                                              @
         TBM       FGW,FCB.CBRA,X1 GHOST ONLY WRITE?              @
         BNS       WRITE4          NO...BRANCH                    @
         SBM       GOW,IOQ.MOWD,X3  GHOST ONLY WRITE ALLOWED      @
         BU        WRITE6                                         @
*                                                                 @
*        DUPLICATE WRITE TO BOTH DISCS                            @
WRITE4   EQU       $                                              @
         TBM       GIP,B.GFLG      GHOST INCH IN PROGRESS?        @
         BS        WRITE5          YES...BRANCH                   @
         SBM       DUW,IOQ.MOWD,X3  SET DUPLICATE WRITE TO BE MADE@
         BU        WRITE6                                         @
*                                                                 @
*        PRIME ONLY WRITE PERMITTED                               @
WRITE5   EQU       $                                              @
         SBM       POW,IOQ.MOWD,X3  SET PRIME ONLY WRITE BIT      @
WRITE6   EQU       $                                              @
         SBM       11,IOQ.FLGS,X3  SET WRITE FLAG IN IOQ
         BU        IOCLBLD         BRANCH, NO RETURN
*
*
RWND     EQU       $
         LW        R2,FCB.FATA,X1  GET FAT ADDRESS            >GDM101584
         ZMW       DFT.POS,X2      SET CURRENT DISC ADDR TO 0 >GDM101584
         BL        SERVCOMP        BRANCH, NO RETURN
         PAGE                                                 >GDM101584
         SPACE
*
** PROCEDURE TO BUILD THE IOCL FOR A DATA XFER
**       IN : R1 = FCB ADDR
*
         SPACE
IOCLBLD  EQU       $
         SBM       12,IOQ.FLGS,X3  SET POST PROCESSING TO OCCUR
         ABM       29,IOQ.IST1,X3  INCR ADDRESS OF FIRST IOCD TO
*                                  IOQ.IOCD+1W
         LW        R4,IOQ.IST1,X3  GET ADDR OF IOCL
         STW       R4,IOQ.IOCD,X3  SAVE ADDR OF IOCL IN IOQ.IOCD
         LW        R4,IOQ.IST2,X3  GET END ADDRESS OF SEEK ADDR AREA
         STW       R4,IOQ.FCT4,X3  STORE END ADDR IN FCT4 TO BE USED
*                                  BEFORE TIMEOUT IS PLACED IN FCT4
         ZMB       IOQ.IST1,X3     CLEAR LOAD MODE BUFFER
         LEAR      R6,IOQ.IST1,X3  GET REAL ADDR OF MODE DATA
         TRR       R2,R4           SAVE THE FAT ADDR
         LW        R2,IOQ.CBLK,X3  GET THE DCA ADDRESS FROM IOQ
         ORMW      R6,DCA.LMOD,X2   BUILD LOAD MODE IOCD1
         LW        R7,DCA.LMOD+1W,X2   GET LOAD MODE IOCD2
         TRR       R4,R2           RESTORE FAT ADDR
         BL        S.IOCS12        PLACE LOAD MODE IOCD IN IOCL
         LW        R5,DFT.POS,X2   GET CUR DISC ADDR FROM FAT
         SPACE
*
** PROCEDURE TO BUILD IOCL. BUILD SEEK ADDR FOR EACH SEG. CROSSED AND
** BUILD DATA XFER IOCD'S FOR EACH SEG. CROSSED.
*        IN : R2 = FATA   R3 = IOQA   R5 = CURR BLK #
*
         SPACE
IOL.2.00 EQU       $
         LW        R1,IOQ.IST2,X3  GET END ADDR OF IOCL TO BUILD SEEK
*                                  DATA
         LEAR      R6,0W,X1        GET SEEK DATA ADDR
         ORMW      R6,SEEK         BUILD SEEK IOCD WRD 1
         LW        R7,SEEK+1W      GET SEEK IOCD WRD 2
         BL        S.IOCS12        PLACE IN IOCL
         LW        R1,IOQ.FCBA,X3  GET FCB ADDRESS FOR S.IOCS36
         TRR       R3,R4           SAVE IOQ ADDR
         BL        S.IOCS36        GET REAL DISC ADDR TO USE FOR SEEK
         TRR       R4,R3           RESTORE IOQ ADDR
         STW       R6,*IOQ.IST2,X3  STORE REAL DISC ADDR IN DATA AREA
         LW        R6,IOQ.IST2,X3  GET SK DATA AREA ADDR
         SUI       R6,1W           DECR BY 1 WORD
         STW       R6,IOQ.IST2,X3  AND RESTORE TO IOQ
         ADR       R7,R5           GET NEXT SEG BLK NUM
         TRR       R7,R4           SAVE BLKS TILL EOS
         ZR        R6              CLEAR WORK REG
         MPI       R6,BLKSIZE      CALC WORDS TILL EOS
         CAMW      R7,IOQ.FCT3,X3  COMPARE WORDS TILL EOS TO XFER CNT
         BGE       IOL.3.00        BR IF XFER DOES NOT CROSS EOS
         LW        R4,IOQ.FCT3,X3  GET REMAINING XFER COUNT
         STW       R7,IOQ.FCT3,X3  STORE WORDS TILL EOS AS XFER COUNT
         LB        R1,IOQ.FCT1,X3  GET OPCODE
         LW        R6,COMTAB,X1    GET IOCD WRD 1 FOR OPERATION
         SUR       R7,R4           CALCULATE COUNT AFTER THIS XFER
         ZR        R7              MAKE XFER IOCD WRD2 0
         SBR       R7,1            SET COMMAND CHAINNING FOR NEXT SEEK
         TRR       R4,R1           SAVE NEW XFER COUNT THRU CALL
         BL        S.IOCS40        BUILD XFER IOCD IN IOCL
         TRR       R1,R4           RESTORE NEW XFER COUNT TO R4
         LW        R6,IOQ.FCT3,X3  GET OLD XFER COUNT
         ARMW      R6,IOQ.FCT2,X3  ADD TO XFER ADDR TO GET NEW ADDR
         STW       R4,IOQ.FCT3,X3  PLACE NEW XFER COUNT IN IOQ
         LW        R2,IOQ.FATA,X3  GET FATA ADDR USED IN LOOP
         BU        IOL.2.00        REPEAT LOOP TILL ALL DATA XFERED
         SPACE
*
** PROCEDURE TO BUILD LAST SEEK AND XFER IOCD FOR THIS IOCL
*
         SPACE
IOL.3.00 EQU       $
         LB        R1,IOQ.FCT1,X3  GET OPCODE
         LW        R6,COMTAB,X1    GET I/O COMMAND FOR DATA XFER
         ZR        R7              CLEAR IOCD WRD 2 - NO FLAGS SET
         BL        S.IOCS40        BUILD IOCD IN IOCL FOR XFER
         SPACE
*                                                                   2101
**   PROCEDURE TO PERFORM RESOURCE DESCRIPTOR LOCK FOR DUAL         2101
**   PORTED XIO DISC                                                2101
*                                                                   2101
         LW        R1,IOQ.FCBA,X3  FETCH FCB ADDR                   2101
         TBM       FCB.DPLK,FCB.SCFG,X1  DESCRIPTOR LOCK REQUEST?   2101
         BNS       CYLTRK          NO, BRANCH                       2101
         LB        R1,IOQ.FCT1,X3  FETCH WORD ADJUSTED OPCODE       2101
         CI        R1,8            IS IT A READ?                    2101
         BNE       CYLTRK          NO, BRANCH                       2101
         LW        R1,IOQ.UDTA,X3  FETCH UDT ADDRESS                2101
         TBM       1,UDT.STAT,X1   DUAL PORTED DISC?                2101
         BNS       CYLTRK          NO, BRANCH                       2101
         LI        R4,-1           R4 = MINUS ONE FOR S.VOMM7A      2101
         BL        S.VOMM7A        OPERATING SYSTEM CALL? >RMB0330872101
*        MBR_BL    S.VOMM7A        OPERATING SYSTEM CALL? >RMB0330872101
*        BS        CYLTRK          BRANCH IF NOT SYSTEM CALL        2101
*        BNS       CYLTRK          BRANCH IF NOT A SYSTEM CALL
*   MUST BE A VALID LOCK REQUEST, CONTINUE                          2101
         LW        R1,IOQ.IOCD,X3  FETCH IOCD ADDRESS               2101
         LW        R6,2W,X1        SEEK IOCD WORD 1                 2101
         LW        R7,3W,X1        SEEK IOCD WORD 2                 2101
         BL        S.IOCS12        PUT SEEK INTO IOCD LIST          2101
         LW        R6,4W,X1        FETCH FIRST READ IOCD            2101
         LW        R7,5W,X1        FETCH IOCD WORD 2                2101
         ZBR       R6,6            CLEAR READ COMMAND               2101
         SBR       R6,7            MAKE IOCD A WRITE                2101
         SBR       R7,0            SET DATA CHAIN                   2101
         BS        STRIOCD         BRANCH IF ALREADY SET            2101
         SBM       1,5W,X1         SET COMMAND CHAIN BIT            2101
         BU        DECCOUNT        BRANCH                           2101
STRIOCD  EQU       $                                                2101
         BL        S.IOCS12        PUT INTO IOQ                     2101
         LW        R6,6W,X1        FETCH 2 ND READ IOCD             2101
         LW        R7,7W,X1        FETCH IOCD WORD 2                2101
         SBM       1,7W,X1         SET COMMAND CHAIN BIT            2101
         ZBR       R6,6            CLEAR READ COMMAND               2101
         SBR       R6,7            MAKE IOCD A WRITE                2101
         SBR       R7,0            SET DATA CHAIN                   2101
DECCOUNT EQU       $                                                2101
         SUI       R7,1H           SUBTRACT 1H FROM XFER CNT        2101
         BL        S.IOCS12        PUT INTO IOQ                     2101
         LW        R6,LOCKIOCD     FETCH LOCK IOCD                  2101
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
         LI        R7,2            LOAD BYTE COUNT                  2101
         BL        S.IOCS12        PUT INTO IOQ                     2101
*                                                                   2101
*                                                                   2101
*
** PROCEDURE TO MAKE REAL DISC ADDRESSES INTO CYL/TRACK/HEAD FORMAT
*
         SPACE
CYLTRK   EQU       $                                                2101
         LW        R1,IOQ.IST2,X3  GET ADDRESS (MINUS 1 WRD) OF REAL
*                                  DISC ADDRESS LIST
         ADI       R1,1W           INCR TO POINT TO LIST
         LW        R7,IOQ.FCT4,X3  GET END ADDR OF SEEK ADDR AREA
         BL        SEEKADDR        GO BUILD LIST OF CYL/TRK/HEAD FORMAT
*                                  DISC ADDRESSES
         TRR       R3,R2           RESTORE IOQ ADDRESS
         LW        R1,IOQ.FCBA,X2  RESTORE FCB ADDRESS
         SPACE
*
** PROCEDURE TO GET TIMEOUT VALUE AND RETURN TO IOCS
*
         SPACE
GETTIMO  EQU       $
         LB        R3,FCB.OPCD,X1  FETCH OP CODE FROM FCB WD0
         SLL       R3,2            CONVERT BYTE INDEX TO WORD
         ADMW      R3,IOQ.CBLK,X2  ADD DCA OFFSET FOR TIMWOUT
         LW        R4,DCA.TIMO,X3  FETCH TIME OUT VALUE
STOTIMO  EQU       $
         STW       R4,IOQ.FCT4,X2  SAVE IN IOQ.FCT4 TILL IQ. TIME
         LW        R1,IOQ.FCBA,X2  GET FCB ADDR TO RETURN TO IOCS WITH
         BU        IOLINK          GOTO IOCS TO LINK IOQ
         PAGE
*
*
** PROCEDURE TO PERFORM WRITE END-OF-FILE. BIT 10 OF IOQ ENTRY FUNCTION
** WORD 1 (IOQ.FCT1) IS SET TO INDICATE NO USER DATA WILL BE TRANSFERED.
*
         SPACE
WEOF     EQU       $
OP.5.00  EQU       $
         LW        R2,IOQ.CBLK,X3  GET CONTEXT BLOCK ADDRESS
         SBM       10,IOQ.FCT1,X3  INDICATE NO USER DATA XFERED
         SBM       31,WEOFDATA     SET TO X'0FE0FE0F'              3201
         LA        R6,WEOFDATA     GET ADDRESS OF WEOF DATA
         STW       R6,IOQ.FCT2,X3  STORE INTO IOQE FUNC WD 2
         LI        R6,4            GET WEOF BYTE XFER COUNT
         STW       R6,IOQ.FCT3,X3  STORE INTO IOQE FUNC WD 3
         STW       R6,IOQ.UTRN,X3  STORE IN IOQ ACTUAL XFER COUNT
         LI        R7,1            SET TO 1 BLK XFER
*
** PROCEDURE TO CHECK FOR EOF/EOM/BOM FOR WEOF, ADVR, AND BKSR
*
         SPACE
OP.6.00  EQU       $
         LW        R2,FCB.FATA,X1  GET FAT ADDRESS
         BL        S.IOCS33        PROCESS FAT FOR CURRENT OPERATION
         LW        R3,FCB.IOQA,X1  RESTORE IOQ ADDRESS
         TRR       R6,R6           OPERATION WITHIN FILE BOUNDS ?
         BN        SERVCOMP        BR IF EOF/EOM/BOM
*                                                              REV20015
*  SAVE POSITION INFORMATION FOR ADVF, BKSF SI ENTRY           REV20015
*                                                              REV20015
         LW        R4,DFT.POS,X2                               REV20015
         LW        R5,DFT.EOM,X2                               REV20015
         STW       R4,IOQ.FBUF,X3  SAVE CURRENT POSITION       REV20015
         STW       R5,IOQ.RTN,X3   AND EOM POSITION            REV20015
         BU        IOCLBLD         BR TO BUILD IOCL
         SPACE
WEOFDATA DATAW     X'0FE0FE0E'     WEOF DATA  07/25/80              3201
*                                 MODIFIED AT RUN TIME             3201
         SPACE     2
*
** PROCEDURE TO PERFORM ADVANCE RECORD.  BIT 29 OF IOQ FLAGS
** (IOQ.FLGS) IS SET TO INDICATE EOF DETECTION IS REQUIRED.
*
         SPACE
ADVR     EQU       $
OP.8.00  EQU       $
         LI        R7,1            INDICATE FILE ADDR TO MOVE 1 BLK FRWD
OP.8.05  EQU       $
         ZBM       4,FCB.CBRA,X1   SEQUEN OP - FORCE RAN ACCESSING OFF
         SBM       29,IOQ.FLGS,X3  INDICATE EOF DETECTION REQ'D
         SBM       10,IOQ.FCT1,X3  INDICATE NO USER DATA XFERED
         LW        R2,IOQ.CBLK,X3  GET DCA ADDR FROM IOQ
         LA        R6,DCA.A2,X2        GET EOF READ BUFFER ADDRESS
         STW       R6,IOQ.FCT2,X3  STORE INTO IOQE FUNC WD 2
         STW       R6,IOQ.TBUF,X3  SAVE BUFFER ADDRESS FOR POST
*                                  PROCESSING
         LI        R6,4            BYTE XFER COUNT
         STW       R6,IOQ.FCT3,X3  STORE BYTE COUNT INTO IOQE FUNC WD 3
         STW       R6,IOQ.UTRN,X3  STORE IN ACTUAL XFER COUNT
         BU        OP.6.00         GO PROCESS THE FAT FOR EOF/EOM/BOM
*                                                              REV20015
*  ADVANCE FILE                                                REV20015
*                                                              REV20015
ADVF     BOUND     1W                                          REV20015
         LW        R2,IOQ.FATA,X3  IS THIS                     REV20015
         TBM       5,DFT.STB,X2    VOLUME RESOURCE?            REV20015
         BS        ILOPCODE        NO NO NO!                   REV20015
         SBM       31,IOQ.FLGS,X3  FLAG CONTINUOUS EOF SEARCH  REV20015
         BU        ADVR            MERGE WITH ADVR CODE        REV20015
         SPACE     2                                           REV20015
*
** PROCEDURE TO PERFORM BACKSPACE RECORD. BIT 30 OF IOQ FLAGS
** WORD (IOQ.FLGS) IS SET TO INDICATE REVERSE FILE MOVEMENT.
*
         SPACE
BKSR     EQU       $
         LI        R7,-1           NEG MOVE FLAG FOR IOCS33    REV20015
OP.A.00  EQU       $
         LW        R2,FCB.FATA,X1  GET FAT ADDR
         LW        R4,DFT.POS,X2   GET CURRENT DISC POSITION
         SUI       R4,1            DECR BY ONE BLK
         STW       R4,DFT.POS,X2   STORE BACK IN FAT
         SBM       30,IOQ.FLGS,X3  INDICATE NO FILE MOVEMENT    REV20013
         BU        OP.8.05         SAME PROCESSING AS FOR ADVR
         SPACE     2                                           REV20015
BKSF     BOUND     1W                                          REV20015
         LW        R2,IOQ.FATA,X3  IS THIS                     REV20015
         TBM       5,DFT.STB,X2    VOLUME RESOURCE?            REV20015
         BS        ILOPCODE        NO NO NO!                   REV20015
         SBM       31,IOQ.FLGS,X3  FLAG CONTINUOUS EOF SEARCH  REV20015
         BU        BKSR                                        REV20015
         SPACE     2
*
** PROCEDURE TO PERFORM UPSPACE - THIS SERVICE/OPCODE MAY BE USED TO
** FORMAT A VIRGIN DISKETTE PRIOR TO USAGE.
*
         SPACE
UPSP     EQU       $
OP.B.00  EQU       $
         LW        R6,=X'37000000' IOCD1 WITH DCA.REZO COMMAND
         LW        R7,=X'40000000' IOCD2 WITH COMMAND CHAINING
         BL        S.IOCS12        STORE DCA.REZO IOCD INTO IOQ ENTRY
         LA        R6,FRMTDATA     GET ADDRESS OF FORMAT DATA
         LW        R5,=X'0B000000' FORMAT COMMAND POSITIONED FOR IOCD1
         ORR       R5,R6           FORMAT IOCD1
         LI        R7,1            FORMAT IOCD2 - BYTE COUNT=1
         BL        S.IOCS12        STORE FORMAT IOCD INTO IOQ ENTRY
         BU        GETTIMO         GET TIMEOUT VALUE
FRMTDATA DATAB     X'01'           FRMT FROM "STAR" TO END WITH DEF FRMT
         BOUND     1W
         SPACE     2
*
** PROCEDURE TO PERFORM ERASE OR PUNCH TRAILER
*
         SPACE
ERPT     EQU       $
OP.C.00  EQU       $
         BU        ILOPCODE
         SPACE     2
*
** PROCEDURE TO PERFORM EJECT
*
         SPACE
EJCT     EQU       $
OP.D.00  EQU       $
         BU        ILOPCODE
         SPACE     2
*
** PROCEDURE TO PERFORM CLSE
*
         SPACE
CLSE     EQU       $
OP.E.00  EQU       $
         BU        SERVCOMP
         SPACE     2
*
** PROCEDURE TO PERFORM RESERVE FOR A DUAL PORTED DISC
*
         SPACE
RESER    EQU       $
         LW        R2,IOQ.UDTA,X3  GET UDT ADDR FROM IOQ
         TBM       1,UDT.STAT,X2   IS THIS A DUAL PORTED DISC
         BNS       SERVCOMP        IF NOT DUAL PORTED RETURN COMPELETE
         LW        R6,RES.IOCD     GET WORD 1 OF RESERVE IOCD
         ZR        R7              WORD 2 OF RESERVE IOCD = 0
         SBM       9,IOQ.FLGS,X3   SET RESERVE CMD TO BE ISSUSED IN IOQ
         BL        S.IOCS12        PLACE RESERVE IOCD INTO IOCL SPACE
         LI        R4,-3           RESERVE TIME OUT FOR CHANNEL END
         BU        STOTIMO         STORE TIMEOUT VALUE & RETURN TO IOCS
         SPACE     2
*
** PROCEDURE TO PERFORM RELEASE FOR A DUAL PORTED DISC
*
         SPACE
RELES    EQU       $
         LW        R2,IOQ.UDTA,X3  GET UDT ADDR FROM IOQ
         TBM       1,UDT.STAT,X2   IS THIS A DUAL PORTED DISC
         BNS       SERVCOMP        IF NOT DUAL PORTED RETURN COMPLETE
         LW        R6,REL.IOCD     GET WORD 1 OF RELEASE IOCD
         ZR        R7              WORD 2 OF RELEASE IOCD = 0
         SBM       18,IOQ.FLGS,X3  SET RELEASE CMD TO BE ISSUSED IN IOQ
         BL        S.IOCS12        PLACE RELEASE IOCD INTO IOCL SPACE
         BU        GETTIMO         GET TIMEOUT VALUE & RETURN TO IOCS
         SPACE     2
*
** PROCEDURE TO PROCESS ILLEGAL OPCODE FOR THIS DEVICE
*
         SPACE
ILLOP    EQU       $
         BU        ILOPCODE        TAKE ILLEGAL OPCODE RETURN
         PAGE
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
************************************************************************
*                                                                      *
*                  SEEKADDR - SEEK ADDRESS BUILDING ROUTINE            *
*                                                                      *
************************************************************************
*                                                                      *
*        THIS ROUTINE TAKES A LIST OF REAL BINARY DISC ADDRESSES AND   *
*        CHANGES THEM INTO CYL/TRACK/HEAD FORMAT SEEK ADDRESSES. THIS  *
*        ROUTINE MUST BE USED TO BUILD A SEEK ADDRESSES THAT IS        *
*        COMPATABLE BETWEEN ALL XIO DISC. THE CALCULATION USED IS :    *
*          1)      (BLK # * SECTOR/BLK) / (SECTOR/TRACK) = CYL #       *
*          2)      REMAINDER 1 / (SECTOR/TRACK) = TRACK #              *
*          3)      REMAINDER 2 = SECTOR #                              *
*                                                                      *
************************************************************************
*                                                                      *
*        REGS IN : R1 = ADDR OF BINARY SEEK ADDR AREA                  *
*                  R3 = IOQA                                           *
*                  R7 = ADDR OF END OF BINARY SEEK ADDR AREA           *
*                                                                      *
*        REGS OUT : R7 = R1 = END OF SEEK ADDR AREA                    *
*                   R2 = UDTA                                          *
*                   R3 = IOQA                                          *
*                                                                      *
*        DESTROYED : R4,R5,R6                                          *
*                                                                      *
************************************************************************
         SPACE     2
SEEKADDR EQU       $
         SPACE
*
** PROCEDURE TO CALCULATE CYL/TRACK/HEAD FORMAT DISC ADDRESSES
*
         SPACE
         LW        R2,IOQ.UDTA,X3  GET UDT ADDR
SK.0.05  EQU       $
         LW        R5,0W,X1        GET BINARY DISC ADDRESS
         ZR        R4              CLEAR WORKING REG
         TRR       R2,R6           SAVE UDT ADDR
         MPMB      R4,UDT.SPB,X2   (BLK # * SECTORS/BLK) = SECTOR #
         LW        R2,UDT.DCAA,X2  GET DCA ADDR
         DVMW      R4,DCA.SCYL,X2   SECTOR # / (SEC/CYL) = CYL #
         STH       R5,0W,X1        STORE CYL # IN SEEK ADDR WRD
         TRR       R4,R5           REMAINDER INTO R5
         TRR       R6,R2           RESTORE UDT ADDR
         ZR        R4              CLEAR WORK REG
         DVMB      R4,UDT.SPT,X2   REMAINDER / (SEC/TRACK) = TRACK #
         STB       R5,2B,X1        STORE TRACK # IN SEEK ADDR WRD
         STB       R4,3B,X1        REMAINDER = SECTOR #; STORE IN SEEK
*                                  ADDR WRD
         CAR       R1,R7           ARE WE AT END OF SEEK ADDR AREA
         BLE       SK.1.00         BR IF AT END OF SEEK AREA
         ABR       R1,29           INCR SEEK ADDR WRD BY 1 WRD
         BU        SK.0.05         REPEAT FOR NEXT SEEK ADDR
         SPACE
*
** RETURN
*
SK.1.00  EQU       $
         TRSW      R0
*
*
         BOUND     1W
OPEN     EQU       $
         BL        GETCDT          R3 = CDT ADDR
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING?     @
         BNS       OPE0            NO...BRANCH                    @
         CAMW      R3,B.GCDTA      I/O DIRECTLY TO GHOST DEVICE?  @
         BEQ       INVALID         YES...BRANCH TO INVALID ENTRY  @
OPE0     EQU       $                                              @
         LH        R6,CDT.CHAN,X3  FETCH CHANNEL ADDR FROM CDT
         LW        R3,B.PCBBA      PRIME CONTEXT BLOCK ADDRESS
         LW        R3,DCA.CHTA,X3  PRIME CHT ADDRESS
         SBM       0,CHT.FLGS,X3   INCH BEEN PERFORMED ?
*        BNS       OPE1            NO.. GO BUILD IOQ ENTRY
         BS        OPE1            YES.. CHECK GHOSTING STATUS   @
         TRR       R3,R2           CHT ADDR TO R2 FOR CHT.INCH   @
         BL        *CHT.INCH,X2    GO INCH THE CHANNEL           @
         BL        FAILURE         OOPS... ERROR ON PRIME        @
OPE1     EQU       $                                             @
         TBM       MGE,B.GFLG      MHD GHOSTING ENABLED?          @
         BNS       SCRTN           NO...GO TO SERVICE COMPLETE    @
         LW        R3,B.GCBBA      GET 2ND (GHOST) DCA ADDR       @
         BZ        INVALID         GHOSTING INVALID IF NO CDT ADDR@
         LW        R3,DCA.CHTA,X3  GHOST CHT ADDRESS              @
         TBM       0,CHT.FLGS,X3   INCH PERFORMED FOR GHOST CHAN? @
         BS        SCRTN           YES.. GO HOME                  @
*
         TRR       R3,R2           R2= CHT ADDRESS FOR INCH       @
         BL        *CHT.INCH,X2    GO PERFORM INCH                @
         BU        GSTFAIL         OOPS... ERROR ON GHOST CHANNEL @
         SBM       MGP,B.GFLG      SET MHD GHOSTING IN PROGRESS   @
         SBM       MUE,B.GFLG      SET GHOST UNLINK ENABLED       @
         BU        SCRTN           AND RETURN FAT,DUMB AND HAPPY  @
*
*        SBM       GIP,B.GFLG      GHOST INCH IN PROGRESS?        @
*        BS        SCRTN           YES...DO NOT ISSUE ANOTHER REQ @
*        LW        R3,B.GCDTA      RESTORE GHOST CDT ADDRESS      @
*        LH        R6,CDT.CHAN,X3  FETCH CHANNEL ADDR FROM CDT    @
*        LW        R3,B.PCDTA      RESTORE ORIGINAL CDT ADDRESS   @
*        SBM       MGP,B.GFLG      SET MHD GHOSTING IN PROGRESS   @
*OPE1    EQU       $                                              @
*        BL        S.IOCS13        GET IOQ ENTRY
*        LW        R2,FCB.IOQA,X1  R2 = IOQ ADDRESS
*        SBM       GIC,IOQ.MOWD,X2  SET GHOST INCH REQUESTED      @
*        SBM       GOW,IOQ.MOWD,X2  SET GHOST ONLY WRITE I/O      @
*        LW        R3,IOQ.CDTA,X2  R3 = CDT ADDRESS
*        RSCHNL    R6,0            ISSUE RESET CHANNEL (HALT CHAN)
*        LI        R4,-32000       DELAY
*        BIB       R4,$              LOOP
*        DCI       R6,0            DISABLE CHANNEL INTERRUPTS
*        ECI       R6,0            ENABLE CHANNEL INTERRUPTS
*        TBM       GIP,B.GFLG      GHOST INCH IN PROGRESS?        @
*        BNS       OPE2            NO...BRANCH                    @
*        LW        R3,B.GCDTA      GET GHOST CDT ADDR             @
*OPE2    EQU       $                                              @
*        LW        R3,CDT.SIHA,X3 FETCH H.EXIO HAT ADDR FOR CHAN
*        LW        R3,INCHIOCD,X3  FETCH ADDR OF INCH IOCD
*                                  FOR RESIDENT SYSTEM, VIRTUAL = ABS
*        STW       R3,IOQ.IOCD,X2  STORE INTO IOQ
*        LW        R1,IOQ.FCBA,X2  RESTORE FCB ADDR TO R1
*
*
*SETXCHAN EQU      $
*        SBM       23,IOQ.FLGS,X2  SHOW EXECUTE CHANNEL PROGRAM
*        BU        GETTIMO         GET TIMEOUT VALUE
*
*
GSTFAIL  EQU       $
         LW        R3,B.GCBBA
         BL        FAILMSG         GO TELL THE WORLD WE HAVE A PROBLEM @
         BU        SCRTN           RETURN FOR ANOTHER TRY              @
*
*
*        ALL ENTRY POINT 5 RETURNS ARE THROUGH ONE OF THE FOLLOWING
QRTN     BL        IOLINK          QUEUED EXIT, NO RETURN
SCRTN    BL        SERVCOMP        SERVICE COMPLETE EXIT, NO RETURN
INVALID  BL        ILOPCODE        ILLEGAL OR INVALID EXIT, NO RETURN
         SPACE     2
*****************************************************************
*        GETCDT SUBROUTINE                                      *
*        ROUTINE TO FETCH CDT ADDRESS                           *
*        ENTER: R2 = FAT ADDRESS                                *
*        EXIT:  R3 = CDT ADDRESS                                *
*****************************************************************
GETCDT   EQU       $
         LW        R2,FCB.FATA,X1  FAT ADDRESS                >GDM101584
         ZR        R6              CLEAR FOR MULTIPLY
         LH        R7,DFT.CDTX,X2  FETCH CDT INDEX
         MPI       R6,CDT.SIZE     TIMES CDT SIZE
         LW        R3,C.CDTA       FETCH BASE CDT ADDRESS
         ADR       R7,R3           GIVES DESIRED CDT ADDRESS
         TRSW      R0              RETURN
         PAGE
************************************************************************
         PAGE
************************************************************************
*                                                                      *
*                  PX. - SPECIAL POST XFER PROCESSOR                   *
*                                                                      *
************************************************************************
*                                                                      *
*   THIS ENTRY POINT IS CALLED BY S.IOCS1 (GENERALIZED I/O POST        *
*   PROCESSING) WHENEVER RETURN FROM OP. IS VIA "POSTPROS". THIS       *
*   ENTRY POINT EXECUTES AT TASK PRIORITY, AND THEREFORE CAN BE        *
*   USED TO PROVIDE ANY SPECIAL PROCESSING ASSOCIATED WITH A DATA      *
*   TRANSFER (EG., DATA TRANSLATION) AT A LOW LEVEL OF SYSTEM          *
*   OVERHEAD.                                                          *
*                                                                      *
*   THIS ENTRY POINT IS USED BY THE DISC HANDLER TO CHECK FOR EOF      *
*   IN THE USERS DATA BUFFER ON INPUT. IT ALSO ADJUSTS THE CURRENT     *
*   DISC ADDR TO THE NEW POSITION FOR ALL DISC ACCESSES, TAKING IN     *
*   ACCOUNT THE ACTUAL AMOUNT OF DATA XFERED AND ANY EOF'S THAT MAY    *
*   BE IN ENCOUNTERED. A EOF ENCOUNTERED IN THE FIRST DISC BLOCK OF    *
*   READ FROM A FILE IS MARKED IN THE FCB AS A EOF BUT IF A EOF IS     *
*   FOUND IN ANY OTHER DISC BLOCK THEN THE ACTUAL XFER COUNT IS SET    *
*   TO THE AMOUNT OF DATA XERED UP TO THE EOF BLOCK, BUT NOT INCLUDING *
*   THE EOF BLOCK AND THE TRANSFER COMPLETES NORMALLY. THE CURRENT     *
*   DISC ADDRESS IS SET TO THE EOF BLOCK SO ON THE NEXT READ THE EOF   *
*   WILL BE IN THE FIRST DISC BLOCK READ AND A EOF INDICATION WILL     *
*   BE GIVEN IN THE FCB.                                               *
*                                                                      *
************************************************************************
*                                                                      *
*        CALLER:                   S.IOCS1                             *
*                                                                      *
*        CALLERS PRIORITY:         TASK LEVEL                          *
*                                                                      *
*        INTERRUPTS:               UNBLOCKED                           *
*                                                                      *
*        CALLING SEQUENCE:         BL   *5W,X2                         *
*                                                                      *
*        REGISTERS IN:             R1 = FCB ADDRESS                    *
*                                  R2 = HAT ADDRESS                    *
*                                  R3 = UDT ADDRESS                    *
*                                                                      *
*        RETURN SEQUENCE:          TRSW  R0   FROM S.IOCS37            *
*                                                                      *
*        REGISTERS OUT:            R1 = FCB ADDRESS                    *
*                                                                      *
************************************************************************
         SPACE     3
         BOUND     1W
BDP2.6   EQU       $
         LW        R2,FCB.IOQA,X1  GET CONTEXT                 REV20015
         TBM       31,IOQ.FLGS,X2  BKSF OR ADVF?               REV20015
         BNS       PX.1            NO.                         REV20015
         LW        R4,IOQ.FBUF,X2  NEW POSITION                REV20015
         LW        R2,FCB.FATA,X1  GET FAT                     REV20015
         STW       R4,DFT.POS,X2   UPDATE POSITION             REV20015
PX.1     EQU       $                                           REV20015
         SPACE
*
** CALL 'S.IOCS37' TO DO PROCESSING IN PLACE OF THIS ROUTINE. LEAVE R0
** IN TAC SO 'S.IOCS37' WILL RETURN DIRECTLY TO 'S.IOCS1'
*
         SPACE
         BU        S.IOCS37        BR TO DISC POST PROCESSING ROUTINE
         PAGE
*******************************************************************
*                                                                 *
*        EXTENDED I/O MHDS-2 HANDLER                              *
*            QUEUE DRIVE INTERRUPT SERVICE ROUTINE                *
*                                                                 *
*******************************************************************
*        ENTERED VIA BL FROM H.BDP2 ENTRY POINT 1 AND 2           *
*            R0 = RETURN ADDRESS                                  *
*            X3 = CONTEXT BLOCK ADDRESS                           *
*            STATUS SAVED IN CONTEXT BLOCK                        *
*******************************************************************
*        EXIT                                                     *
*            R2 = H.EXIO OLDPSD ADDRESS                           *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*            R4 = ACTION TO TAKE ON RETURN                        *
*                 0 - BRANCH TO HIOAGAIN IN ENTRY POINT 4         *
*                 1 - BRANCH TO EP1.3 OF H.EXIO                   *
*                 2 - BRANCH TO EXIT OF H.EXIO                    *
*******************************************************************
         SPACE     2
H.DRIVE  EQU       $
         STW       R0,H.SDRETA     SAVE H.DRIVE RETURN ADDRESS
         IFT       DBBDP2,DBEND                                 @@@
         LD        R0,LOCMIN                                    @@@
         SLLD      R0,4                                         @@@
         STD       R0,LOCMIN                                    @@@
         ABM       31,DRICNT                                    @@@
         TBM       GCB,DCA.FLAG,X3                               @@@
         BNS       SHI1                                         @@@
         SBM       29,LOCAL                                     @@@
         BU        SHI2                                         @@@
SHI1     SBM       28,LOCAL                                     @@@
         BU        SHI2                                         @@@
         BOUND     1D                                           @@@
LOCMIN   DATAW     0                                            @@@
LOCAL    DATAW     0                                            @@@
         REZ       16W                                          @@@
COPCNT   REZ       1W                                           @@@
DRICNT   REZ       1W                                           @@@
STICNT   REZ       1W                                           @@@
SHI2     EQU       $                                            @@@
DBEND    ANOP                                                   @@@
         LW        R2,DCA.IOQA,X3     GET ACTIVE IOQ ADDR IN CONTEXT BK
         LW        R1,IOQ.UDTA,X2  FETCH COMPLETING UDT ADDR
         ZMW       UDT.PTOV,X1     CLEAR UDT TIME OUT VALUE
         TBM       22,IOQ.FLGS,X2  WAS THE KILL COMMAND ISSUED?
         BS        CLRFLGS         YES, BRANCH
*                                                              REV20015
*  PROCEDURE TO PROCESS ADVF AND BSKF SEARCH FOR EOF           REV20015
*                                                              REV20015
*  IN : R2 = A(IOQ), R3 = A(DCA), R1 = A(UDT)                  REV20015
*                                                              REV20015
*  EXIT : BU  SI.EXIT (IF EOF NOT YET FOUND) WITH R2 = A(DCA)  REV20015
*         BU   NOR.2.00 (IF EOF, BOM, EOM)   WITH R2 = A(DCA)  REV20015
*                                                              REV20015
         TBM       31,IOQ.FLGS,X2  EOF SEARCH?                 REV20015
         BNS       NOR.2.00        NO.                         REV20015
*                                                              REV20015
*  TEST FOR EOF FOUND THIS READ                                REV20015
*                                                              REV20015
         LW        R3,IOQ.TBUF,X2  DATA BUFFER ADDRESS.        REV20015
         SBM       31,WEOFDATA     SET TO X'0FE0FE0F'              3201
         LW        R6,0W,X3        COMPARE FIRST WORD          REV20015
         CAMW      R6,WEOFDATA     FOR EOF                     REV20015
         BEQ       NOR.2.00        ALL DONE.  NORMAL EXIT.     REV20015
*                                                              REV20015
*  UPDATE FAT CURRENT FILE POSITION TO NEXT SECTOR             REV20015
*                                                              REV20015
         LI        R7,1            R7 IS MOVEMENT QUANTUM      REV20015
         TBM       30,IOQ.FLGS,X2  BKSF?                       REV20015
         BNS       NOR.0.50        NO.                         REV20015
         TRN       R7,R7           NEGATIVE MOVEMENT FOR BKSF. REV20015
NOR.0.50 LW        R6,IOQ.FBUF,X2  UPDATE THE                  REV20015
         ADR       R7,R6           CURRENT FILE POSITION       REV20015
         BLT       NOR.1.70        CANNOT BSKR PAST BOM.  EXIT REV20015
         STW       R6,IOQ.FBUF,X2  STORE NEW POSITION.         REV20015
         CAMW      R6,IOQ.RTN,X2   EOM?                        REV20015
         BGE       NOR.1.80        CANNOT ADVR PAST EOM.  EXIT REV20015
*                                                              REV20015
*  HERE WE DEPEND ON THE READ LOCATION BEING LAST IN THE IOQ.  REV20015
*          ------                                              REV20015
*  WE HAVE NO POINTERS TO IT .                                 REV20015
*                                                              REV20015
         LH        R3,IOQ.XTRA,X2  # XTRA WORDS IN IOQ         REV20015
         SLL       R3,2            TO WORD INDEX               REV20015
         ADI       R3,IOQ.SIZE-1W  PLUS IOQ SIZE               REV20015
         ADR       R2,R3           PLUS IOQ ADDR GIVES SEEK    REV20015
*                                                              REV20015
*  COMPUTE ABS SECTOR ADDRESS FROM CYL,TRK,SEC FORMAT          REV20015
*                                                              REV20015
         STW       R6,0W,X3        STORE NEW LOGICAL BLK #     REV20015
*                                                              REV20015
*  SEEKADR WILL CONVERT NEW ABS SECTOR TO CYL,TRK,SEC FORMAT   REV20015
*                                                              REV20015
*  IN : R1 = R7 = ADDR OF ABS SECTOR VALUE                     REV20015
*       R3 = A(IOQ)                                            REV20015
* OUT : R3 = A(IOQ)                                            REV20015
*                                                              REV20015
         XCR       R2,R3           R1 = A(SECT VALUE)          REV20015
*                                  R3 = A(IOQ)                 REV20015
         TRR       R2,R7           R7 = A(SECT VALUE)          REV20015
         BL        SEEKADDR        (DESTROYS R0 BUT WE DON'T CAREV20015
         TRR       R3,R2           IOQ ADDR TO R2
         LW        R3,IOQ.CBLK,X2  R2 = A(DCA)                 REV20015
         BU        MOIOQ           GO ISSUE THE REQUEST.       REV20015
*                                                              REV20015
*                                                              REV20015
NOR.1.70 SBM       5,IOQ.IOST,X2   SET BOM                     REV20015
         BU        NOR.2.00        RETURN                      REV20015
*                                                              REV20015
NOR.1.80 SBM       6,IOQ.IOST,X2   SET EOF                     REV20015
         SBM       7,IOQ.IOST,X2   AND EOM                     REV20015
         BU        NOR.2.00        RETURN                      REV20015
         SPACE     3
NOR.2.00 TBM       3,IOQ.CONT,X2   IS STATUS TESTING INHIBITED?
         BS        SEEPPCI         YES, BRANCH
         TBM       TIMEOFLG,DCA.FLAG,X3    SI FROM LOST INTERRUPT?
         BNS       H.DR1           NO...BRANCH
         BL        ERRTIMEO        YES...PROCESS LOST INTERRUPT
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       FAILURE         R4: 0=> BRANCH TO FAILURE      @
         BU        ANYMO           R4: 1=> BRANCH TO ANYMO
*
H.DR1    EQU       $
         ZBM       1,IOQ.STAT,X2   SI FROM SENSE COMMAND?
         BNS       H.DR2           NO...BRANCH
         BL        SNSSI           YES...PROCESS STATUS POSTING
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       FAILURE         R4: 0=> BRANCH TO FAILURE      @
         BU        ANYMO           R4: 1=> BRANCH TO ANYMO
*
H.DR2    EQU       $
         ZBM       5,IOQ.STAT,X2   SI FOR READ ECC?
         BNS       H.DR3           NO...BRANCH
         BL        ECC.0           YES...PROCESS ECC DATA
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       UNLINK          R4: 0=> BRANCH TO UNLINK
         BEQ       ANYMO           R4: 1=> BRANCH TO ANYMO
*
         BL        SETB6           R4: 2=> RETRY WHOLE IOCD LIST
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       FAILURE         R4: 0=> BRANCH TO FAILURE      @
         BU        ANYMO           R4: 1=> BRANCH TO ANYMO
*
H.DR3    EQU       $
         BL        CKSTAT          CHECK STATUS REGISTER
         CI        R4,1            DETERMINE WHERE TO BRANCH
         BLT       UNLINK          R4: 0=> BRANCH TO UNLINK
         BU        ANYMO           R4: 1=> BRANCH TO ANYMO
*
SEEPPCI  EQU       $
         TRR       R2,R6           SAVE IOQ ADDRESS
         LW        R2,DCA.CHTA,X3  CHT ADDRESS
         LW        R2,CHT.STAD,X2  STATUS ADDRESS
         ZBM       1,2H,X2         POST PROGRAM CONTROLLED INTERPT?
         BS        ANYMO           YES...BRANCH
*
         TRR       R6,R2           RETURN IOQ ADDRESS TO R2
*
CLRFLGS  EQU       $
         ZMW       DCA.FLAG,X3      CLEAR FLAGWORD BITS
         PAGE
*
*
*
*        SECTION TO UNLINK IOQ ENTRIES                            @
*        ENTER:  X2 = IOQ ENTRY ADDRESS                           @
*                X3 = CONTEXT BLOCK ADDRESS                       @
UNLINK   EQU       $
         ZMW       EP4HIO          CLEAR EP4 HIO ISSUED CNT       @
         IFT       STBDP2,STEND                                @@@@
         LH        R0,IOQ.FCT1,X2  GET CYLINDER #              @@@@
         LB        R5,IOQ.SUBA,X2  GET SUBCHAN #               @@@@
         LA        R1,LCATBL       GET LAST CYL ACCESSED TABLE @@@@
         ADR       R5,R1           INDEX INTO LAST CYL TABLE   @@@@
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'UNLINK'?    @@@@
         BNS       UNL1            NO...BRANCH                 @@@@
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING?    @@
         BNS       UNL1            NO...BRANCH                   @@
SCEND    ANOP                                                    @@
         ADI       R1,4W           INDEX INTO GHOST AREA OF TAB@@@@
UNL1     EQU       $                                           @@@@
         STH       R0,0H,X1        SAVE LAST CYL # ACCESSED    @@@@
STEND    ANOP                                                  @@@@
         LB        R4,B.CURFN      MPX-ONLY MODE OF OPERATION?    @
         BZ        UNL2            YES...BRANCH                   @
         LW        R1,DCA.UDTA,X3   GET UDT ADDR FROM CONTEXT BLK  @
         SBM       UDT.ONLI,UDT.STAT,X1  DEVICE OFF-LINE?         @
         BNS       FAILURE         YES...BRANCH                   @
UNL2     EQU       $                                              @
         IFT       DBBDP2,DBEND                                 @@@
         LW        R1,B.PCDTA                                   @@@
         LB        R4,CDT.IOCT,X1                               @@@
RG1      BL        REGSAV                                       @@@
IQ1      BL        IOQSAV                                       @@@
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO UNLINK?       @@@
         BNS       UNL3            NO...BRANCH                  @@@
         TBM       GIP,B.GFLG      GHOST INCH IN PROGRESS?      @@@
         BNS       UNL3            NO...BRANCH                  @@@
         BU        $               ERROR CONDITION              @@@
         BL        *C.DEBUG                                     @@@
UNL3     EQU       $                                            @@@
DBEND    ANOP                                                   @@@
         STW       R3,CBLKSAV      SAVE ORIGINAL CONTEXT BLK ADDR @
         TBM       MUE,B.GFLG      MHD GHOST UNLINK ENABLED?      @
         BNS       UNL9            NO...BRANCH                    @
         TBM       MGP,B.GFLG      MHD  GHOSTING IN PROGRESS?     @
         BS        UNL8            YES...BRANCH                   @
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING?    @@
         BS        UNL6            YES...BRANCH                  @@
         LB        R4,CDT.NUOC,X1  GET # OF UNITS ON CONTROLLER  @@
         TRN       R4,R4           NEGATE #                      @@
         TRR       R1,R0           SAVE CDT ADDR                 @@
         LW        R1,UDT.UT0,X1   GET 1ST UDT ADDR              @@
UNL4     EQU       $                                             @@
         LB        R5,UDT.DTC,X1   GET DEVICE TYPE CODE          @@
         CI        R5,U0.DTC       GHOST DEVICE?                 @@
         BNE       UNL5            NO...BRANCH                   @@
         TBM       1,UDT.FLGS,X1   I/O OUTSTANDING?              @@
         BNS       UNL5            NO...BRANCH                   @@
         TRR       R0,R1           RESTORE CDT ADDR              @@
         BU        UNL8                                          @@
UNL5     EQU       $                                             @@
         ADI       R1,UDT.SIZE     INCREMENT TO NEXT UDT         @@
         BIB       R4,UNL4         LOOP UNTIL GHOST UDTS CHECKED @@
         TRR       R0,R1           RESTORE CDT ADDR              @@
         BU        UNL7                                          @@
UNL6     EQU       $                                             @@
SCEND    ANOP                                                    @@
         LW        R1,B.GCDTA      GET GHOST CDT ADDRESS          @
         LB        R4,CDT.IOCT,X1  ANY GHOST ENTRIES TO UNLINK?   @
         BNZ       UNL8            YES...BRANCH                   @
UNL7     EQU       $                                             @@
         ZBM       MUE,B.GFLG      CLEAR MHD GHOST UNLINK ENABLE  @
         ZBM       GIP,B.GFLG      ENSURE GHOST INCH BIT CLEARED  @
UNL8     EQU       $                                              @
         TBM       DUW,IOQ.MOWD,X2  DUPLICATE WRITE I/O REQUEST?  @
         BS        UNL15           YES...BRANCH                   @
*                                                                 @
*        GHOSTING MODE: UNLINK READ I/O REQUEST (OR GHOST ONLY WR)@
*        NON-GHOSTING MODE: UNLINK READ OR WRITE I/O REQUEST      @
UNL9     EQU       $                                              @
         ZMW       DCA.IOQA,X3        SHOW NO IOQ ACTIVE FOR DEVICE  @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'UNLINK'?       @
         BS        UNL12           YES...BRANCH                   @
         ZBM       0,IOQ.STAT,X2   ENSURE IOQ ACTIVE BIT IS CLEAR @
         ZBM       RTW,IOQ.MOWD,X2  IS THIS A READ TO WRITE I/O?  @
         BNS       UNL14           NO...BRANCH                    @
         TBM       MGE,B.GFLG      GHOSTING STILL ENABLED?    >LJD@10685
         BS        UNL9B           YES...BRANCH               >LJD@21285
*                                                             >LJD@10685
*        GHOSTING WAS TURNED OFF BEFORE THE GHOST COMPONENT OF>LJD@10685
*        THE READ-TO-WRITE (RTW) REQUEST WAS ISSUED...CLEAN UP>LJD@10685
*        THAT REQUEST HERE                                    >LJD@10685
         LW        R1,TWIN,X3      GET GHOST CONTEXT BLK ADDR >LJD@10685
         ZMW       DCA.IOQA,X1        SHOW NO IOQ ACTIVE FOR DEV >LJD@10
         LW        R1,B.GCDTA      GET GHOST CDT ADDR         >LJD@10685
         LB        R4,CDT.IOCT,X1  DECREMENT NUMBER OF I/O    >LJD@10685
         BZ        UNL9A           SKIP DEC IF ALREADY CLEARED>LJD@21285
         SUI       R4,1            ENTRIES FOR THE GHOST CDT  >LJD@10685
         STB       R4,CDT.IOCT,X1                             >LJD@10685
         BNZ       UNL14           CONTINUE IF MORE ENTRIES   >LJD@10685
UNL9A    EQU       $                                          >LJD@21285
         ZBM       MUE,B.GFLG      ENSURE UNLINK ENABLE IS 0  >LJD@10685
         ZBM       GIP,B.GFLG      CLEAR GHOST INCH IN PROGRES>LJD@10685
         BU        UNL14           CONTINUE WITH PRIME UNLINK >LJD@10685
UNL9B    EQU       $                                          >LJD@10685
         LW        R2,IOQ.UDTA,X2  GET PRIME UDT ADDRESS          @
         ZMW       UDT.PTOV,X2     CLEAR TIMEOUT VALUE IN UDT     @
         ZBM       1,UDT.FLGS,X2   CLEAR I/O OUTSTANDING BIT      @
         LW        R2,GIOQADR,X3   GET GHOST IOQ ADDR             @
         ZBM       RTW,IOQ.MOWD,X2  SWITCH OFF GHOST RTW INHIBIT  @
         SBM       GOW,IOQ.MOWD,X2  RE-DO READ AS GHOST ONLY WRITE@
         LW        R2,IOQ.IOCD,X2  IOCD ADDRESS                   @
         ADI       R2,4W           SET TO DATA XFER IOCD          @
         LI        R5,X'01'        DISC I/O WRITE COMMAND         @
UNL10    EQU       $                                              @
         LB        R4,0B,X2        GET IOCD COMMAND BYTE          @
         CI        R4,X'02'        IS IT A READ COMMAND?          @
         BNE       UNL11           NO...BRANCH                    @
         STB       R5,0B,X2        SWITCH TO A WRITE COMMAND      @
         ADI       R2,1D           INCREMENT TO NEXT IOCD         @
         BU        UNL10           LOOP UNTIL ALL READS ARE DONE  @
UNL11    EQU       $                                              @
         BU        GETCBLK                                        @
*                                                                 @
UNL12    EQU       $                                              @
         LW        R3,PIOQADR,X3   GET PRIME IOQ ADDR             @
         LW        R4,IOQ.SFA,X3   ENSURE GIOQ ARRAY HAS THE      @
         STW       R4,IOQ.SFA,X2   LATEST STRING FORWARD AND BACK @
         LW        R4,IOQ.SBA,X3   ADDRESSES PRIOR TO UNLINKING   @
         STW       R4,IOQ.SBA,X2   THIS IOQ ENTRY                 @
         LW        R3,B.PCDTA      GET PRIME CDT ADDR             @
         STH       R3,IOQ.CDTA+1H,X2  PRIME CDT ADDR TO GIOQ ARRAY@
         IFT       DBBDP2,DBEND                                 @@@
         LB        R4,CDT.IOCT,X3                               @@@
RG3      BL        REGSAV                                       @@@
DBEND    ANOP                                                   @@@
         BL        S.IOCS3         UNLINK IOQ ENTRY               @
         LW        R1,B.GCDTA      GET GHOST CDT ADDR             @
         LI        R4,-1           DECREMENT NUMBER OF I/O    >LJD@21285
         ARMB      R4,CDT.IOCT,X1  ENTRIES FOR THE GHOST CDT  >LJD@21285
         LW        R1,IOQ.CBLK,X2  GET GHOST CONTEXT BLK ADDR     @
         LW        R1,PIOQADR,X1   GET PRIME IOQ ADDR             @
         TRR       R1,R4           SAVE PRIME IOQ ADDR IN R4      @
         LB        R5,IOQ.STAT,X2  TRANSFER IOQ.STAT BYTE FROM    @
         STB       R5,IOQ.STAT,X1  GHOST TO PRIME IOQ ARRAY       @
         ADI       R1,12W          PREPARE TO TRANSFER WORDS 12   @
         ADI       R2,12W          THROUGH 19 FROM THE GHOST TO   @
         LI        R5,-8W          THE PRIME IOQ ARRAY            @
UNL13    EQU       $                                              @
         LW        R6,0,X2         GET GHOST VALUE                @
         STW       R6,0,X1         TRANSFER TO PRIME IOQ          @
         ABR       R2,29           INCREMENT POINTERS             @
         ABR       R1,29                                          @
         BIW       R5,UNL13                                       @
         TRR       R4,R2           RESTORE PRIME IOQ ADDR TO R2   @
         BU        UNL19                                          @
*                                                                 @
*        NON-GHOSTING MODE: UNLINK READ OR WRITE I/O REQUEST      @
UNL14    EQU       $                                              @
         LW        R3,DCA.CDTA,X3   GET PRIME CDT ADDR             @
         IFT       DBBDP2,DBEND                                 @@@
         LB        R4,CDT.IOCT,X3                               @@@
RG4      BL        REGSAV                                       @@@
DBEND    ANOP                                                   @@@
         BL        S.IOCS3         UNLINK IOQ FROM PRIME CDT      @
         BU        UNL19                                          @
*                                                                 @
*        GHOSTING MODE: CHECK IF DUPLICATE WRITE I/O REQUEST      @
*        SHOULD BE UNLINKED NOW                                   @
UNL15    EQU       $                                              @
         TRR       R2,R1           TRANSFER IOQ ADDR TO R1        @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'UNLINK'?       @
         BNS       UNL16           NO...BRANCH                    @
         LW        R1,PIOQADR,X3   GET PRIME IOQ ADDR             @
UNL16    EQU       $                                              @
         SBM       PIC,IOQ.MOWD,X1  BOTH I/O'S FINISHED?          @
         BS        UNL17           YES...BRANCH                   @
*                                                                 @
*        GHOSTING MODE: DUPLICATE WRITE I/O REQUEST (BOTH I/O     @
*        REQUESTS NOT YET FINISHED)                               @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'UNLINK'?       @
         BNS       GETCBLK         NO...BRANCH                    @
         BL        GHSTCLR         CLEAR GHOST IOQ INFORMATION    @
         BU        GETCBLK                                        @
*                                                                 @
*        GHOSTING MODE: DUPLICATE WRITE I/O REQUEST (BOTH I/O     @
*        REQUESTS NOW FINISHED)                                   @
UNL17    EQU       $                                              @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'UNLINK'?       @
         BNS       UNL18           NO...BRANCH                    @
         BL        GHSTCLR         CLEAR GHOST IOQ INFORMATION    @
         LW        R2,PIOQADR,X3   GET PRIME IOQ ADDR             @
         LW        R3,IOQ.CBLK,X2  GET PRIME CONTEXT BLK ADDR     @
UNL18    EQU       $                                              @
         ZMW       DCA.IOQA,X3        SHOW NO IOQ ACTIVE IN CNTXT BLK@
         LW        R3,IOQ.CDTA,X2  GET PRIME CDT ADDR             @
         IFT       DBBDP2,DBEND                                 @@@
         LB        R4,CDT.IOCT,X3                               @@@
RG8      BL        REGSAV                                       @@@
DBEND    ANOP                                                   @@@
         BL        S.IOCS3         UNLINK IOQ FROM PRIME CDT      @
UNL19    EQU       $                                              @
         IFT       DBBDP2,DBEND                                 @@@
         LB        R4,CDT.IOCT,X3                               @@@
RG9      BL        REGSAV                                       @@@
IQ2      BL        IOQSAV                                       @@@
DBEND    ANOP                                                   @@@
         ZBM       0,IOQ.STAT,X2   CLEAR IOQ IS ACTIVE BIT        @
         LB        R1,IOQ.PRGN,X2  R1=PROG #, R2=IOQ ADDRESS
         TBM       22,IOQ.FLGS,X2  IS THIS A TASK DELETE?
         BNS       GOEXEC          NO...BRANCH
         TRR       R2,R3           SET UP IOQ ADDRESS
         BL        S.IOCS15        DELETE IOQ ENTRY
         BU        GETCBLK         R1 CONTAINS IOQ ADDRESS ON RETURN
*
GOEXEC   EQU       $
         BL        S.IOCS29        REPORT I/O COMPLETE
*                                  R1 = PROGRAM #
*                                  R2 = IOQ ADDRSS
         TRR       R6,R1           R1 = IOQ ADDRESS
         NOP
GETCBLK  EQU       $               IOQ INFO SHOULD STILL BE VALID
         LW        R3,CBLKSAV      GET ORIGINAL CONTEXT BLK ADDR  @
         LB        R2,B.SYSMOD     CHECK IF SPECIAL I/O STA NEEDED@
         CI        R2,SSCADA       SMALL SCADA SYSTEM?            @
         BNE       ANYMO           NO...BRANCH                    @
         LH        R2,DCA.UADD,X3  GET CURRENT CHANNEL ADDR       @
         CI        R2,PRIVDISC     SMALL SCADA PRIVATE DISC?      @
         BNE       GET2            NO...BRANCH                    @
         LB        R2,B.CPUID      GET THIS CPU ID #              @
         CI        R2,CPU1         CPU 1?                         @
         BNE       GET1            NO...BRANCH                    @
         ZBM       B.CS,B.MHD1     ENSURE CURRENT STAT = GOOD     @
         BU        ANYMO                                          @
GET1     EQU       $                                              @
         ZBM       B.CS,B.MHD2     ENSURE CPU DISC STAT = GOOD    @
         BU        ANYMO                                          @
GET2     EQU       $                                              @
         ZBM       B.CS,B.MHD3     ENSURE SHARED DISC STAT = GOOD @
         BU        ANYMO           SKIP OVER SAVING OF RETURN ADDR
*                                                                 @
*        ROUTINE TO UPDATE GHOST IOQ RELATED INFORMATION          @
GHSTCLR  EQU       $                                              @
         LW        R1,IOQ.UDTA,X2  GET GHOST UDT ADDR             @
         ZMW       UDT.PTOV,X1     CLEAR TIMEOUT VALUE IN UDT     @
         ZBM       1,UDT.FLGS,X1   CLEAR I/O OUTSTANDING BIT      @
         LW        R1,B.GCDTA      GET GHOST CDT ADDR             @
         LI        R4,-1           DECREMENT NUMBER OF I/O     LJD@21285
         ARMB      R4,CDT.IOCT,X1  ENTRIES FOR THE GHOST CDT   LJD@21285
         ZMW       DCA.IOQA,X3        SHOW NO IOQ ACTIVE FOR THIS CBK@
         TRSW      R0                                             @
CBLKSAV  DATAW     0               UNLINK ENTRY CNTXT BLK SAVE LOC@
         PAGE
*
*                                                                 @
*        SECTION TO HANDLE PRIME/GHOST DISC FAILURES              @
*        ENTER: X3 = CONTEXT BLOCK ADDRESS                        @
ROADDR   DATAW     0               RETURN ADDRESS SAVE LOC        @
FAILURE  EQU       $                                              @
         STW       R0,ROADDR       SAVE RETURN ADDRESS            @
         LH        R4,DCA.UADD,X3  SAVE FAILED DISC CHAN/SUBCHAN  @
         STW       R4,FAILDISC     ADDRESS                        @
         STW       R4,*TABPNT      INSERT IN CIRCULAR BUFFER      @
         ABM       29,TABPNT       INCREMENT TO NEXT LOCATION     @
         LW        R4,DCA.SENS,X3   GET CYLINDER/HEAD/SECTOR CRASH @
         STW       R4,CYLINFO      INFO AND SAVE                  @
         STW       R4,*TABPNT      INSERT IN CIRCULAR BUFFER      @
         ABM       29,TABPNT       INCREMENT TO NEXT LOCATION     @
         LW        R4,DCA.SENS+1W,X3  GET CONTENTS OF SENSE BUFFER @
         STW       R4,SENSEBUF     INFO AND SAVE                  @
         STW       R4,*TABPNT      INSERT IN CIRCULAR BUFFER      @
         ABM       29,TABPNT       INCREMENT TO NEXT LOCATION     @
         LW        R4,TABPNT       GET TABLE POINTER              @
         CAMW      R4,TABEND       END OF TABLE?                  @
         BLT       FAI1            NO...BRANCH                    @
         LA        R4,TABBUF       GET BEGINNING TABLE ADDR       @
         STW       R4,TABPNT       AND INSERT IN TABLE POINTER    @
FAI1     EQU       $                                              @
         LB        R4,B.SYSMOD     SPECIAL ERR REPORTING NEEDED?  @
         BZ        UNLINK          NO...BRANCH                    @
         TBM       GCB,DCA.FLAG,X3  GHOST MHD FAIL?                @
         BS        FAI2            YES...BRANCH                   @
         LB        R4,B.RADCON+1B  SUPPRESS PRIME FAILURE?        @
         BZ        FAI3            NO...BRANCH                    @
         BU        UNLINK          GO UNLINK IOQ ENTRY            @
FAI2     EQU       $                                              @
         LB        R4,B.RADCON+2B  SUPPRESS GHOST FAILURE?        @
         BNZ       UNLINK          YES...GO UNLINK IOQ ENTRY      @
FAI3     EQU       $                                              @
         LW        R2,DCA.WST2,X3    GET WORKING STATUS WORD 2 AND  @
         STW       R2,WRKSTAT      SAVE                           @
         LW        R2,DCA.IOQA,X3     GET ACTIVE IOQ ADDRESS         @
         LB        R2,IOQ.PRGN,X2  GET PROGRAM DQE #              @
         SLL       R2,2            CONVERT TO WORD OFFSET         @
         ADMW      R2,C.ADAT       ADDR TO DQE ADDR IN DQE TABLE  @
         LW        R2,0W,X2        GET PROGRAM DQE ADDRESS        @
         LD        R0,DQE.LMN,X2   GET TASK NAME AND SAVE IN      @
         STD       R0,TASKNAME     CRASH TABLE                    @
         STW       R3,CBLKSAV      SAVE ORIGINAL CONTEXT BLK ADDR @
         LW        R1,DCA.UDTA,X3   GET AND SAVE FAILED DEVICE     @
         STW       R1,UDTSAV       UDT ADDRESS                    @
         SBM       MDF,B.GFLG      SHOW MHD FAILED                @
         LW        R1,B.PCDTA      GET PRIME CDT ADDR             @
         ZBM       1,CDT.FLGS,X1   CLEAR I/O OUTSTANDING BIT      @
         LW        R1,B.GCDTA      GET GHOST CDT ADDR             @
         ZBM       1,CDT.FLGS,X1   CLEAR I/O OUTSTANDING BIT      @
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING     @@
         BNS       FAI4            NO...BRANCH                   @@
SCEND    ANOP                                                    @@
         LW        R1,DCA.CHTA,X3  GHOST CHT ADDRESS              @
         ZBM       0,CHT.FLGS,X1   SET INCH NOT DONE FOR GHOST CHT@
FAI4     EQU       $                                             @@
         LW        R1,DCA.CDTA,X3   GET FAILED CDT ADDR            @
         TBM       GCB,DCA.FLAG,X3  GHOST MHD FAIL?                @
         BS        FAI5            YES...BRANCH                   @
         SBM       MPF,B.GFLG      SHOW PRIME MHD FAILED          @
FAI5     EQU       $                                              @
         LW        R6,B.GFLG       SAVE ORIGINAL VALUE OF B.GFLG  @
         STW       R6,BGFLG                                       @
         LNB       R6,CDT.NUOC,X1  GET # OF UDT'S ON THIS CDT     @
         LW        R2,CDT.UDTA,X1  GET ADDR OF 1ST UDT ON THIS CDT@
FAI6     EQU       $                                              @
         ZMW       UDT.PTOV,X2     CLEAR TIMEOUT VALUE IN UDT     @
         ZBM       1,UDT.FLGS,X2   CLEAR I/O OUTSTANDING BIT      @
         LW        R3,UDT.CBLK,X2  GET CONTEXT BLK ASSOC WITH UDT @
         LW        R1,DCA.IOQA,X3     GET ACTIVE IOQ ADDR            @
         BZ        FAI7            BRANCH...NO ACTIVE IOQ ADDR    @
         BL        FAILCLR         CLEAR ACTIVE SUBCHAN & IOQ     @
FAI7     EQU       $                                              @
         LW        R3,TWIN,X3      GET COUNTERPART CONTEXT BLK ADR@
         LW        R1,DCA.UDTA,X3   GET COUNTERPART UDT ADDR       @
         ZMW       UDT.PTOV,X1     CLEAR TIMEOUT VALUE IN UDT     @
         ZBM       1,UDT.FLGS,X1   CLEAR I/O OUTSTANDING BIT      @
         LW        R1,DCA.IOQA,X3     GET ACTIVE IOQ ADDR            @
         BZ        FAI8            BRANCH...NO ACTIVE IOQ ADDR    @
         BL        FAILCLR         CLEAR ACTIVE SUBCHAN & IOQ     @
FAI8     EQU       $                                              @
         ADI       R2,UDT.SIZE     INCREMENT TO NEXT UDT TABLE    @
         ABR       R6,31           ANY MORE UDT'S TO LOOK AT?     @
         BNZ       FAI6            YES...BRANCH                   @
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING     @@
         BNS       FAI9            NO...BRANCH                   @@
SCEND    ANOP                                                    @@
         LW        R1,B.GCDTA      GET GHOST CDT ADDR             @
         ZMB       CDT.IOCT,X1     CLEAR # OF GHOST IOQ ENTRIES   @
FAI9     EQU       $                                             @@
         ZBM       MPF,B.GFLG      PRIME MHD FAIL?                @
         BS        FAI10           YES...BRANCH                   @
*                                                                 @
*                                                                 @
*                                                                 @
*        BACKUP DISC FAILURE: GHOSTING IN PROGRESS                @
*        ACTION: GHOSTING TO BE TERMINATED                        @
         LB        R7,B.SYSMOD     CHECK FOR EMS VS. SMALL SCADA  @
         CI        R7,EMS          EMS SYSTEM?                    @
         BEQ       FAI15           YES...BRANCH                   @
         SBM       B.ALARM,B.GHOST  SHOW GHOSTING STOPPED FOR     @
         SBM       B.CS,B.GHOST    SMALL SCADA                    @
         BU        FAI15                                          @
*                                                                 @
*                                                                 @
*                                                                 @
*        PRIME DISC FAILURE                                       @
FAI10    EQU       $                                              @
         TBM       MGU,B.GFLG      MHD GHOSTING UP TO SPEED?      @
         BS        FAI11           YES...BRANCH                   @
*                                                                 @
*        PRIME DISC FAILURE: NO GHOSTING IN EFFECT                @
         BL        FAILMSG                                        @
         BEI                       BLOCK EXTERNAL INTERRUPTS      @
         LH        R7,B.PRIMHD     GET THE PRIME MHD CHAN #       @
         STH       R7,B.HDACI+3H   ENSURE THIS CHAN DEACTIVATED   @
         BL        B.HDACI         DEACTIVATE THIS CHAN           @
         LF        R0,TASKNAME     GET CRASH INFO TO REGISTERS    @
***      RI        X'01'           REQUEST INTERNAL SOI       >EHW061890
***      UEI                       UNBLOCK EXTERNAL INTERRUPTS>EHW061890
***      WAIT                      HANG                       >EHW061890
         M.KILL    DISCERR         HALT SYSTEM ON DISC ERROR  >EHW061890
*                                                                 @
*                                                                 @
*        GHOSTING IN EFFECT                                       @
FAI11    EQU       $                                              @
         LB        R7,B.SYSMOD     CHECK FOR EMS VS. SMALL SCADA  @
         CI        R7,EMS          EMS SYSTEM?                    @
         BEQ       FAI12           YES...BRANCH                   @
         SBM       B.ALARM,B.GHOST  SHOW GHOSTING STOPPED FOR     @
         SBM       B.CS,B.GHOST    SMALL SCADA                    @
FAI12    EQU       $                                              @
*        TBM       MNG,B.GFLG      NORMAL GHOSTING IN EFFECT?     @
*        BS        FAI15           YES...BRANCH                   @
*                                                                 @
*        PRIME DISC FAILURE: FULL GHOSTING IN EFFECT              @
*        ACTION: BUMPLESS FAILOVER TO OCCUR HERE                  @
*        SWAP VITAL CDT,UDT,CONTEXT BLOCK INFORMATION             @
         SBM       MBF,B.GFLG      INDICATE BUMPLESS DISC FAILOVER@
         SBM       MDC,B.GFLG      CHANGE DISC ADDRESS FLAG       @
         LW        R1,CBLKSAV      GET ADDRESS OF THE UDT THAT    @
         LW        R1,TWIN,X1      IS TO BE MARKED AS OFF-LINE    @
         LW        R1,DCA.UDTA,X1                                  @
         STW       R1,UDTSAV                                      @
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING     @@
         BNS       FAI14           NO...BRANCH                   @@
SCEND    ANOP                                                    @@
         LW        R1,B.PCDTA      GET PRIME CDT ADDR             @
         LW        R2,B.GCDTA      GET GHOST CDT ADDR             @
         LB        R6,CDT.IPL,X1   PRIME CDT PRIORITY LEVEL TO    @
         LB        R7,CDT.IPL,X2   GHOST CDT PRIORITY LEVEL       @
         STB       R6,CDT.IPL,X2   SWAP                           @
         STB       R7,CDT.IPL,X1                                  @
         LH        R6,CDT.CHAN,X1  PRIME CHAN/SUBCHAN # TO        @
         LH        R7,CDT.CHAN,X2  GHOST CHAN/SUBCHAN #           @
         STH       R6,CDT.CHAN,X2  SWAP                           @
         STH       R7,CDT.CHAN,X1                                 @
         LW        R6,*CDT.SIAD,X1  PRIME INT FIELDER ADDR        @
         STW       R6,PRISIAD       SAVE THAT PUPPY FOR LATER     @
         LW        R7,*CDT.SIAD,X2  GHOST INT FIELDER ADDR        @
         STW       R7,GSTSIAD       SAVE THIS ONE ALSO            @
         LW        R6,CDT.SIAD,X1  PRIME SERVICE INTERRUPT ADDR TO@
         LW        R7,CDT.SIAD,X2  GHOST SERVICE INTERRUPT ADDR   @
         STW       R6,CDT.SIAD,X2  SWAP                           @
         STW       R7,CDT.SIAD,X1                                 @
         LNB       R5,CDT.NUOC,X1  GET # OF UDT'S ON CDT          @
         LW        R1,CDT.UT0,X1   GET 1ST PRIME UDT ADDR         @
         LW        R2,CDT.UT0,X2   GET 1ST GHOST UDT ADDR         @
*                                                                 @
FAI13    EQU       $                                              @
         SBM       UDT.ONLI,UDT.STAT,X1  ENSURE DEVICE ONLINE     @
         SBM       UDT.ONLI,UDT.STAT,X2  ENSURE DEVICE ONLINE     @
         LH        R6,UDT.CHAN,X1  PRIME CHAN/SUBCHAN # TO        @
         LH        R7,UDT.CHAN,X2  GHOST CHAN/SUBCHAN #           @
         STH       R6,UDT.CHAN,X2  SWAP                           @
         STH       R7,UDT.CHAN,X1                                 @
         TRR       R1,R0           SAVE PRIME UDT ADDR            @
         TRR       R2,R4           SAVE GHOST UDT ADDR            @
         LW        R1,UDT.CBLK,X1  GET PRIME CONTEXT BLK ADDR     @
         LW        R2,UDT.CBLK,X2  GET GHOST CONTEXT BLK ADDR     @
*
         LH        R6,DCA.UADD,X1  PRIME CHAN/SUBCHAN # TO        @
         LH        R7,DCA.UADD,X2  GHOST CHAN/SUBCHAN #           @
         STH       R6,DCA.UADD,X2  SWAP                           @
         STH       R7,DCA.UADD,X1                                 @
*
*  SWAP CHT IPL AND CHAN
*
         LW        R1,DCA.CHTA,X1  PRINE CHT ADDRESS              @
         LW        R2,DCA.CHTA,X2  GHOST CHT ADDRESS              @
         LB        R6,CHT.CHAN,X1  OLD PRIME CHAN                 @
         LB        R7,CHT.CHAN,X2  OLD GHOST CHAN                 @
         STB       R7,CHT.CHAN,X1  BECOMES NEW PRIME CHAN         @
         STB       R6,CHT.CHAN,X2  AND NEW GHOST PRIME            @
*
         LB        R6,CHT.IPL,X1   OLD PRIME INTERRUPT VALUE      @
         LB        R7,CHT.IPL,X2   AND GHOST INTERRUPT VALUE      @
         STB       R7,CHT.IPL,X1   BECOME NEW PRIME INT VALUE     @
         STB       R6,CHT.IPL,X2   AND GHOST VALUE                @
*
         ZBM       0,CHT.FLGS,X2   SHOW INCH NEEDS TO BE PERFORMED@
*                                  ON GHOST CHANNEL               @
         TRR       R0,R1           RESTORE UDT ADDR               @
         TRR       R4,R2                                          @
         ADI       R1,UDT.SIZE     INCREMENT TO NEXT UDT ADDR     @
         ADI       R2,UDT.SIZE                                    @
         ABR       R5,31           ANY MORE UDT'S TO LOOK AT?     @
         BNZ       FAI13           YES...BRANCH                   @
*                                                                 @
         LW        R6,PRISIAD      PRIME OLDPSD ADDRESS          @
         LW        R7,GSTSIAD      GHOST OLDPSD ADDRESS           @
         LW        R1,B.PCDTA      PRIME CDT ADDRESS              @
         LW        R2,B.GCDTA      GHOST CDT ADDRESS              @
         LW        R1,CDT.SIAD,X1  PRIME SI LOCATION              @
         LW        R2,CDT.SIAD,X2  GHOST SI LOCATION              @
         STW       R6,0W,X1        REST PRIME POINTER TO PRI SI   @
         STW       R7,0W,X2        REST GHST POINTER TO GST SI    @
         LH        R6,B.PRIMHD     SWAP MHD PRIME AND GHOST CHAN  @
         LH        R7,B.GMHD       NUMBERS IN COMM REGION         @
         STH       R6,B.GMHD                                      @
         STH       R7,B.PRIMHD                                    @
*        BU        FAI15                                          @
*                                                                @@
*        SINGLE CONTROLLER GHOSTING: BUMPLESS FAILOVER           @@
FAI14    EQU       $                                             @@
*        NO CODE IS ENTERED HERE AT THIS TIME, HOWEVER THE BASE  @@
*        UDT LOCATION IN THE CDT WOULD HAVE TO BE SWITCHED,      @@
*        ALONG WITH THE DEVICE TYPE CODES IN THE UDT'S.          @@
*                                                                @@
FAI15    EQU       $                                              @
         BL        FAILMSG                                        @
         LW        R3,CBLKSAV      RESTORE ORIGINAL CNTXT BLK ADDR@
         LB        R2,B.SYSMOD     CHECK IF SPECIAL I/O STA NEEDED@
         CI        R2,SSCADA       SMALL SCADA SYSTEM?            @
         BNE       FAI18           NO...BRANCH                    @
         LW        R2,FAILDISC     GET FAILED CHAN/SUBCHAN ADDR   @
         CI        R2,PRIVDISC     SMALL SCADA PRIVATE DISC?      @
         BNE       FAI17           NO...BRANCH                    @
         LB        R2,B.CPUID      GET THIS CPU ID #              @
         CI        R2,CPU1         CPU 1?                         @
         BNE       FAI16           NO...BRANCH                    @
         SBM       B.CS,B.MHD1     ENSURE CURRENT STAT = BAD      @
         SBM       B.ALARM,B.MHD1                                 @
         BU        FAI18                                          @
FAI16    EQU       $                                              @
         SBM       B.CS,B.MHD2     ENSURE CPU DISC STAT = BAD     @
         SBM       B.ALARM,B.MHD2                                 @
         BU        FAI18                                          @
FAI17    EQU       $                                              @
         SBM       B.CS,B.MHD3     ENSURE SHARED DISC STAT = BAD  @
         SBM       B.ALARM,B.MHD3                                 @
FAI18    EQU       $                                              @
         BU        ANYMO           CHECK IF ANY MORE IOQ ENTRIES  @
*                                                                 @
*                                                                 @
BGFLG    DATAW     0               B.GFLG PRIOR TO BEING CLEARED  @
*                                                                 @
         BOUND     1F              DISC CRASH REGISTER INFO       @
TASKNAME DATAD     0               TASK NAME OF I/O REQUEST       @
SENSEBUF DATAW     0               CONTENTS OF SENSE BUFFER       @
WRKSTAT  DATAW     0               WORKING STATUS WORD 2          @
UDTSAV   DATAW     0               FAILED DEVICE UDT ADDRESS      @
DISCERR  DATAW     C'DISC'         SYSTEM CRASH ORIGIN 'DISC'     @
FAILDISC DATAW     0               FAILED DISC CHAN/SUBCHAN ADDR  @
CYLINFO  DATAW     0               CYLINDER,HEAD,SECTOR INFO      @
*                                                                 @
TABBUF   REZ       3F              CHAN / CYLINDER / STATUS INFO  @
TABEND   ACW       $                                              @
TABPNT   ACW       TABBUF          DIAGNOSTIC TABLE POINTER       @
*                                                                 @
*                                                                 @
*                                                                 @
*        ROUTINE TO CLEAR AN ACTIVE SUBCHANNEL AND IOQ ENTRY      @
*        ENTER: X3 = CONTEXT BLOCK ADDRESS                        @
FAILCLR  EQU       $                                              @
*
*        TAKE A ONE-SHOT STROKE TO KEEP THE CONFIG MNGR FROM  <BFC030888
*        GETTING A WATCH-DOG TIMER FAILURE CAUSING A RESTART. <BFC030888
         DI        X'03'           DISABLE INT LEVEL 3        <BFC030888
         RI        X'03'           REQUEST INT LEVEL 3        <BFC030888
         LH        R5,DCA.UADD,X3  TERMINATE ANY I/O OPERATION    @
         SRL       R5,8            SHIFT OFF SUBCHAN              @
         SLL       R5,8                                           @
         HIO       R5,0            ISSUE HALT I/O                 @
         RSCTL     R5,0            RESET CONTROLLER/SUBCHANNEL    @
         LI        R4,-32000       LOAD DELAY COUNT               @
         BIB       R4,$            DELAY                          @
         DCI       R5,0            DISABLE CHANNEL INTERRUPTS     @
         ECI       R5,0            ENABLE CHANNEL INTERRUPTS      @
         ZMW       DCA.IOQA,X3        CLEAR ACTIVE IOQ ADDR          @
         TBM       GCB,DCA.FLAG,X3  IS THIS A GHOST CONTEXT BLK?   @
         BNS       FCL1            NO...BRANCH                    @
         LW        R1,PIOQADR,X3   GET PRIME ACTIVE IOQ ADDR      @
FCL1     EQU       $                                              @
         ZBM       6,IOQ.FLGS,X1   CLEAR ERROR FOUND BIT          @
         ZMB       IOQ.STAT,X1     CLEAR IOQ STATUS BYTE          @
         ZMW       IOQ.IOST,X1     CLEAR IOQ STAT WRD, FCB WRD 3  @
         ZMW       IOQ.IST1,X1     CLEAR IOQ INT STAT WRD 1       @
         ZMW       IOQ.IST2,X1     CLEAR IOQ INT STAT WRD 2       @
         ZBM       RTW,IOQ.MOWD,X1  ENSURE RTW BIT IS CLEARED     @
         TRSW      R0                                             @
*                                                                 @
*                                                                 @
*                                                                 @
*        ROUTINE TO SETUP FAILOVER RELATED DATA                   @
FAILMSG  EQU       $                                              @
         STW       R0,FAILRET      SAVE RETURN ADDR               @
         ZMB       B.GFLG          CLEAR GHOST FLAGS IN COMM AREA @
         LB        R2,B.SYSMOD     EMS VS. SMALL SCADA SYS INFO   @
         CI        R2,EMS          EMS SYSTEM?                    @
         BNE       FMS9            NO...SKIP EMS ERROR MESSAGE    @
         LW        R2,UDTSAV       FLAG THE FAILED DEVICE UDT AS  @
         ZBM       UDT.ONLI,UDT.STAT,X2  OFF-LINE                 @
         LW        R0,FAILDISC     GET FAILED DISC CHAN ADDRESS   @
         LH        R2,B.PRIMHD     GET PRIME MHD CHAN ADDRESS     @
*        TBM       MGP,BGFLG       GHOSTING IN PROGRESS?          @
*        BNS       FMS1            NO...BRANCH                    @
         STH       R2,B.CMGPRI     SAVE PRIME MHD CHAN/SUBCHAN    @
         STH       R0,B.CMGHST     SAVE GHOST MHD CHAN/SUBCHAN    @
         ZMB       B.CMGSTA        INDICATE GHOSTING STOPPED      @
         SBM       0,B.CMDEVS      INDICATE GHOSTING STATUS CHANGE@
*        BU        FMS2                                           @
FMS1     EQU       $               COPY-MODE DISC ERROR           @
*        STH       R2,B.CMCPRI     SAVE PRIME MHD CHAN/SUBCHAN    @
*        STH       R0,B.CMCOPY     SAVE COPY MHD CHAN/SUBCHAN     @
*        ZMB       B.CMCSTA        INDICATE COPY STOPPED          @
FMS2     EQU       $                                              @
         SRL       R0,8            SHIFT OFF SUBCHAN ADDRESS      @
         CI        R0,X'08'        CHANNEL X'08' FAILURE?         @
         BNE       FMS3            NO...BRANCH                    @
         SBM       1,B.CMDEVS      INDICATE CHANNEL 8 FAILURE     @
         BU        FMS6                                           @
FMS3     EQU       $                                              @
         CI        R0,X'0C'        CHANNEL X'0C' FAILURE?         @
         BNE       FMS4            NO...BRANCH                    @
         SBM       2,B.CMDEVS      INDICATE CHANNEL X'0C' FAILURE @
         BU        FMS6                                           @
FMS4     EQU       $                                              @
         CI        R0,X'04'        CHANNEL X'04' FAILURE?         @
         BNE       FMS5            NO...BRANCH                    @
         SBM       3,B.CMDEVS      INDICATE CHANNEL X'04' FAILURE @
         BU        FMS6                                           @
FMS5     EQU       $                                              @
         SBM       4,B.CMDEVS      INDICATE 4TH DISC CHAN FAILURE @
FMS6     EQU       $                                              @
*        LB        R2,C.MACH       GET CPU MACHINE TYPE           @
*        CI        R2,X'02'        CONCEPT SERIES (27/87) CPU?    @
*        BLT       FMS7            NO...BRANCH                    @
         RI        X'1A'           27/87: NOTIFY CONFIG MANAGER   @
*        BU        FMS8                                           @
FMS7     EQU       $                                              @
*        RI        X'2A'           7X SERIES: NOTIFY CONFIG MAN   @
FMS8     EQU       $                                              @
FMS9     EQU       $                                              @
         ZBM       MUE,B.GFLG      CLEAR MHD GHOST UNLINK ENABLE  @
         BU        *FAILRET        RETURN                         @
FAILRET  DATAW     0                                              @
         PAGE
*           EP2  MERGE  POINT
*           ENTER:  R0 = RETURN ADDRESS
*                   R3 = CONTEXT BLOCK ADDRESS
*
*
         BOUND     1W
H.START  EQU       $
         STW       R0,H.SDRETA     SAVE H.START RETURN ADDR
         IFT       DBBDP2,DBEND                                 @@@
         LD        R0,LOCMIN                                    @@@
         SLLD      R0,4                                         @@@
         STD       R0,LOCMIN                                    @@@
         ABM       31,STICNT                                    @@@
DBEND    ANOP                                                   @@@
*
*        SEE IF THERE ARE ANYMORE IOQ'S LEFT TO PROCESS
EP2MERGE EQU       $
ANYMO    EQU       $
         ZBM       EP4FLG,DCA.FLAG,X3  H.EXIO-EP4 HIO STAT STOR ENTRY?
         BNS       ANYMO.1         NO...BRANCH
         LI        R4,0            R4: 0=> BR HIOAGAIN UPON RETURN
         BU        SDEXIT
*
ANYMO.1  EQU       $
*        TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?  >LJD@10685
*        BNS       ANYMO.2         NO...BRANCH                >LJD@10685
         LW        R3,B.PCBBA      ENSURE WORKING OFF OF PRIME CDT@
ANYMO.2  EQU       $                                              @
         LW        R1,DCA.CDTA,X3   FETCH CDT ADDRESS FROM CONTEXT BLK
         LNB       R6,CDT.IOCT,X1  FETCH NUMBER OF IOQ ENTRIES
         BZ        QEMPTY          BRANCH IF NO MORE ENTRIES
         LW        R2,CDT.FIOQ,X1  FETCH IOQ ENTRY ADDRESS
*
MOIOQ    EQU       $
         BL        INITIO          INITIATE I/O REQUEST
         CI        R4,1            DETERMINE WHERE TO BRANCH TO
         BLT       MORCK           R4: 0=> CHECK FOR MORE IOQ ENTRIES
         BEQ       SDEXIT          R4: 1=> BR TO STAT STOR EP1.3 H.EXIO
         BL        FAILURE         R4: 2=> BRANCH TO FAILURE      @
*
MORCK    EQU       $
         LW        R2,IOQ.SFA,X2   FETCH NEXT IOQ ADDRESS
         BIB       R6,MOIOQ        LOOP UNTIL ALL IOQS LOOKED AT
*
QEMPTY   EQU       $
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BNS       GQEMPTY         NO...BRANCH                    @
         LW        R1,B.GCDTA      GET GHOST CDT ADDR             @
         LB        R6,CDT.IOCT,X1  ANY GIOQ REQUESTS              @
         BZ        GQEMPTY         NO...BRANCH                    @
         LNB       R6,CDT.NUOC,X1  GET # UDTS ON CDT = # OF GIOQS @
         IFT       SCBDP2,SCEND                                  @@
         TBM       MCG,B.GFLG      MULTIPLE CHAN GHOSTING?       @@
         BS        QEM1            YES...BRANCH                  @@
         SRL       R6,1            # GIOQ'S = # UDT'S / 2        @@
QEM1     EQU       $                                             @@
SCEND    ANOP                                                    @@
         LW        R2,B.GIBA       GET BASE 'GHOST IOQ' ARRAY ADDR@
GMOIOQ   EQU       $                                              @
         BL        INITIO          INITIATE I/O REQUEST           @
         CI        R4,1            DETERMINE WHERE TO BRANCH TO   @
         BLT       GMORCK          R4: 0=> CHECK FOR MORE IOQ ENTR@
         BEQ       SDEXIT          R4: 1=> BR TO STAT STOR EP1.3  @
         BL        FAILURE         R4: 2=> BRANCH TO FAILURE      @
*                                                                 @
GMORCK   EQU       $                                              @
         ADI       R2,GIOQSIZ      FETCH NEXT IOQ ADDRESS         @
         BIB       R6,GMOIOQ       LOOP UNTIL ALL UTDS LOOKED AT  @
*                                                                 @
GQEMPTY  EQU       $                                              @
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BNS       GQE1            NO...BRANCH                    @
         LW        R3,B.PCBBA      RESTORE PRIME CBLK BASE ADDR   @
GQE1     EQU       $                                              @
         LW        R2,DCA.CDTA,X3  CDT ADDRESS
         LW        R2,CDT.SIHA,X2   OLDPSD ADDRESS
         LI        R4,2            R4: 2=> BR TO EXIT OF H.EXIO
SDEXIT   EQU       $
         IFT       DBBDP2,DBEND                                 @@@
         TRR       R1,R5                                        @@@
         LW        R0,LOCAL                                     @@@
         SLL       R0,28                                        @@@
         SRL       R0,26                                        @@@
         CI        R0,0                                         @@@
         BNE       SDE1                                         @@@
         NOP                       HALT                         @@@
         NOP                                                    @@@
         NOP                       BL  *C.DEBUG                 @@@
         NOP                                                    @@@
SDE1     EQU       $                                            @@@
         LA        R1,LOCAL+1W                                  @@@
         ADR       R0,R1                                        @@@
         ABM       31,0,X1                                      @@@
         TRR       R5,R1                                        @@@
DBEND    ANOP                                                   @@@
         BU        *H.SDRETA       RETURN
         PAGE
*******************************************************************
*                                                                 *
*        INITIATE I/O SUBROUTINE                                  *
*                                                                 *
*******************************************************************
*        ENTERED VIA BL FROM H.START (EP2MERGE)                   *
*            R0 = RETURN ADDRESS                                  *
*            R2 = FORWARD IOQ ADDR  IOQ.FIOQ                      *
*******************************************************************
*        EXIT                                                     *
*            R2 = FORWARD IOQ ADDR  IOQ.FIOQ  (IF R4 = 0,2)       *
*               = H.EXIO OLDPSD ADDRESS  (IF R4 = 1)              *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*            R4 = ACTION TO TAKE ON RETURN                        *
*                 0 - BR TO 'MORCK'  CHECK FOR MORE IOQ ENTRIES   *
*                 1 - BR TO CALLING ENTRY POINT - THEN EP1.3      *
*                     OF H.EXIO                                   *
*                 2 - BRANCH TO FAILURE                           *
*******************************************************************
         BOUND     1W
INITIO   EQU       $
         STW       R0,INITRETA     SAVE INITIO RETURN ADDR
         LW        R3,IOQ.CBLK,X2  FETCH CONTEXT BLK ADDR FROM IOQ
         BZ        GETNEXT         BRANCH IF NO ADDR EXISTS       @
         LW        R1,IOQ.UDTA,X2  FETCH UDT ADDRESS
         TBM       1,UDT.FLGS,X1   IS THIS DEVICE BUSY?
         BNS       INIT3           NO...BRANCH
         ZBM       EIC,IOQ.FLGS,X2  DISABLE IOQ TO GIOQ COPY BIT  @
         TBM       3,IOQ.STAT,X2   IS SENSE COMMAND TO BE ISSUED?
         BS        DOSENSE         YES, BRANCH
         TBM       2,IOQ.STAT,X2   DCA.REZO AND RETRY?
         BS        DOREZERO          YES, BRANCH
         TBM       6,IOQ.STAT,X2   RETRY WHOLE IOCD LIST?
         BS        CKRLS           YES, BRANCH
         TBM       4,IOQ.STAT,X2   READ ECC REQUIRED?
         BS        DOECC           YES, BRANCH
         TBM       28,IOQ.FLGS,X2  PRIORITY OVERRIDE TO BE ISSUED?
         BS        DOPOR           YES, BRANCH
         TBM       7,IOQ.STAT,X2   CONTINUE AFTER ECC CORRECTION?
         BS        ZRETRY          YES...BRANCH
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BNS       GETNEXT         NO...BRANCH                    @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'INITIO'?       @
         BS        GETNEXT         YES...BRANCH                   @
         LW        R1,TWIN,X3      GET PRIME CONTEXT BLK TWIN CBA @
         LW        R1,DCA.IOQA,X1     GHOST CONTEXT BLOCK ACTIVE?    @
         BNZ       GETNEXT         YES...BRANCH                   @
         TBM       0,IOQ.STAT,X2   THIS IOQ ENTRY ACTIVE?         @
         BS        GETNEXT         YES...BRANCH                   @
         TBM       GOW,IOQ.MOWD,X2  GHOST ONLY WRITE?             @
         BS        INIT1           YES...BRANCH                   @
         TBM       RAR,IOQ.MOWD,X2  DUAL READ I/O REQUEST?        @
         BNS       GETNEXT         NO...BRANCH                    @
         TBM       MRE,B.GFLG      MHD DUAL READS ENABLED?        @
         BNS       GETNEXT         NO...BRANCH                    @
         TBM       MGU,B.GFLG      MHD GHOSTING UP TO SPEED?      @
         BNS       GETNEXT         NO...BRANCH                    @
         BU        INIT2                                          @
INIT1    EQU       $                                              @
         TBM       GIC,IOQ.MOWD,X2  GHOST INCH CMND TO BE ISSUED? @
         BNS       INIT2           NO...BRANCH                    @
         LW        R1,B.GCBBA      GET GHOST DCA ADDRESS          @
         LW        R1,DCA.CHTA,X1  GHOST CHT ADDRESS              @
         SBM       0,CHT.FLGS,X1   SHOW INCH DONE FOR GHOST CHT   @
         LW        R1,B.GCDTA      PICK UP GHOST CDT ADDRESS      @
         ZBM       GIP,B.GFLG      CLEAR GHOST INCH IN PROGRESS   @
         SBM       MUE,B.GFLG      SET GHOST UNLINK ENABLED FLAG  @
INIT2    EQU       $                                              @
         SBM       EIC,IOQ.FLGS,X2  ENABLE IOQ TO GIOQ COPY       @
         IFT       DBBDP2,DBEND                                 @@@
         ABM       31,LOCAL+14W                                 @@@
DBEND    ANOP                                                   @@@
         BL        IOQCOPY         COPY IOQ TO GIOQ ARRAY         @
         SBM       0,IOQ.STAT,X2   SHOW PRIME IOQ ACTIVE          @
         BU        GETNEXT                                        @
*                                                                 @
INIT3    EQU       $                                              @
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BS        INIT4           YES...BRANCH                   @
         ZBM       DUW,IOQ.MOWD,X2  ENSURE DUPLICATE WRITE NOT SET@
         TBM       0,IOQ.STAT,X2   THIS IOQ ACTIVE? (POSSIBLE     @
         BS        GETNEXT         YES...BRANCH  (DURING GHST STOP@
         BU        ZRETRY                                         @
INIT4    EQU       $                                              @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'INITIO'?       @
         BNS       INIT5           NO...BRANCH                    @
         TBM       RTW,IOQ.MOWD,X2  READ TO WRITE REQUEST?        @
         BS        GETNEXT         YES...BRANCH (WAIT FOR SWITCH) @
         LW        R4,DCA.IOQA,X3     VALID GIOQ DATA?               @
         BNZ       ZRETRY          YES...BRANCH                   @
         BU        GETNEXT         EXIT...EMPTY GIOQ ARRAY        @
INIT5    EQU       $                                              @
         TBM       0,IOQ.STAT,X2   THIS IOQ ENTRY ACTIVE?         @
         BS        GETNEXT         YES...BRANCH                   @
         IFT       DBBDP2,DBEND                                 @@@
         TRR       R1,R0                                        @@@
         LW        R1,B.PCDTA                                   @@@
         LB        R4,CDT.IOCT,X1                               @@@
         TRR       R0,R1                                        @@@
IQ3      BL        IOQSAV                                       @@@
DBEND    ANOP                                                   @@@
         TBM       RTW,IOQ.MOWD,X2  READ TO WRITE REQUEST?        @
         BS        INIT9            YES...BRANCH                  @
         TBM       POR,IOQ.MOWD,X2  PRIME ONLY READ?              @
         BS        ZRETRY           YES...BRANCH                  @
         TBM       POW,IOQ.MOWD,X2  PRIME ONLY WRITE?             @
         BS        ZRETRY          YES...BRANCH                   @
         TRR       R1,R4           SAVE PRIME UDT ADDR IN R4      @
         LW        R1,TWIN,X3      GET PRIME CONTEXT BLK TWIN CBA @
         LW        R1,DCA.IOQA,X1     GHOST CONTEXT BLOCK ACTIVE?    @
         BZ        INIT6           NO...BRANCH                    @
         TRR       R4,R1           RESTORE PRIME UDT ADDR TO R1   @
         TBM       RAR,IOQ.MOWD,X2  DUAL READ I/O REQUEST?        @
         BS        ZRETRY          YES...BRANCH                   @
         IFT       DBBDP2,DBEND                                 @@@
         TRR       R1,R0                                        @@@
         LW        R1,B.PCDTA                                   @@@
         LB        R4,CDT.IOCT,X1                               @@@
         TRR       R0,R1                                        @@@
IQ4      BL        IOQSAV                                       @@@
DBEND    ANOP                                                   @@@
         BU        GETNEXT         EXIT..GHOST UDT NEEDED FOR I/O @
INIT6    EQU       $                                              @
         TBM       GOW,IOQ.MOWD,X2  GHOST ONLY WRITE?             @
         BNS       INIT8           NO...BRANCH                    @
         TBM       GIC,IOQ.MOWD,X2  GHOST INCH CMND TO BE ISSUED? @
         BNS       INIT7           NO...BRANCH                    @
         LW        R1,B.GCBBA      GHOST DCA ADDRESS              @
         LW        R1,DCA.CHTA,X1  GHOST CHT ADDRESS             @
         SBM       0,CHT.FLGS,X1   SHOW INCH DONE FOR GHOST CHT   @
         ZBM       GIP,B.GFLG      CLEAR GHOST INCH IN PROGRESS   @
         SBM       MUE,B.GFLG      SET GHOST UNLINK ENABLED FLAG  @
INIT7    EQU       $                                              @
         TRR       R4,R1           RESTORE PRIME UDT ADDR TO R1   @
         SBM       EIC,IOQ.FLGS,X2  ENABLE IOQ TO GIOQ COPY       @
         IFT       DBBDP2,DBEND                                 @@@
         ABM       31,LOCAL+15W                                 @@@
DBEND    ANOP                                                   @@@
         BL        IOQCOPY         COPY IOQ ARRAY TO GIOQ ARRAY   @
         SBM       0,IOQ.STAT,X2   SHOW THIS IOQ ACTIVE           @
         BU        GETNEXT                                        @
INIT8    EQU       $                                              @
         TRR       R4,R1           RESTORE PRIME UDT ADDR TO R1   @
         TBM       DUW,IOQ.MOWD,X2  DUPLICATE WRITE TO BOTH UDT'S @
         BNS       ZRETRY          NO...BRANCH                    @
INIT9    EQU       $                                              @
         SBM       EIC,IOQ.FLGS,X2  ENABLE IOQ TO GIOQ COPY       @
*
ZRETRY   EQU       $
         ZMB       DCA.RCNT,X3       SET ERROR RETRY COUNT TO ZERO
         TBM       23,IOQ.FLGS,X2  DOES USER HAVE HIS OWN IOCD LIST?
         BNS       CKRLS           NO, BRANCH
         LW        R5,IOQ.IOCD,X2  FETCH ADDRESS OF IOCD LIST
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
         BU        SETCNT2         BRANCH
*
DOREZERO EQU       $
         LA        R5,DCA.REZO,X3    FETCH DCA.REZO IOCD ADDRESS
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
*                                  INTO DEDICATED INTERRUPT POINTER
*                                  VIA IOCDLA IN CONTEXT BLOCK
*            NOTE: IOCDLA CONTAINS THE ADDRESS OF IOCD POINTER
*        THE REZERO FUNCTION IS COMMAND CHAINED TO THE
*        ORIGINAL IOCD LIST WHICH CAUSES IT TO BE RETRIED
         BU        SETCNT2         BRANCH
*
DOECC    EQU       $
         LA        R5,DCA.RECC,X3   FETCH ADDRESS OF READ ECC IOCD
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
         BU        SETCNT2         DEDICATED INTERRUPT POINTER VIA
*                                  IOCDLA IN CONTEXT BLOCK
*
DOSENSE  EQU       $               SET UP FOR SENSE COMMAND
         LA        R5,DCA.SENI,X3   FETCH ADDRESS OF SENSE COMMAND
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
         BU        SETCNT2         BRANCH
*
DOPOR    EQU       $
         LA        R5,PORIOCD,X3   FETCH 'POR' COMMAND ADDRESS
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
         BU        SETCNT2         BRANCH
*
CKRLS    EQU       $
         TBM       18,IOQ.FLGS,X2  RELEASE COMMAND TO BE ISSUED?
         BNS       SETMODE2        NO, BRANCH
         LW        R5,DCA.RESC,X3    FETCH # OF TASKS RESERVING DEVICE
         BZ        UNLINK2         BRANCH IF NO ONE RESERVING
         SUI       R5,1            SUBTRACT ONE FOR THIS REQUEST
         STW       R5,DCA.RESC,X3    STORE BACK INTO CONTEXT BLOCK
         BNZ       UNLINK2         DON'T DO RELEASE IF STILL RESERVED
SETMODE2 EQU       $
         LW        R5,IOQ.IOCD,X2
         LW        R1,DCA.CHTA,X3  CHT ADDRESS FOR IOCL ADDRESS
         STW       R5,CHT.IOCL,X1  STORE IN VECTOR LOCATION
         LW        R1,DCA.UDTA,X3   RESTORE UDT ADDRESS
         SPACE     2
*
*            NOTES ON SIO
*    1. MAX ATTEMPTS TO ISSUE SIO = 2
*    2. SIO ACCEPTED IF ALL CC'S = 0 OR ONLY CC1 = 1
*        X1 = UDT ADDRESS
*        X2 = IOQ ADDRESS
*        X3 = CONTEXT BLOCK ADDRESS
*
SETCNT2  EQU       $
         IFT       STBDP2,STEND                                @@@@
         LW        R5,B.DISHIS     DISC STAT BUF ADDR ENTERED? @@@@
         BZ        SETC1           NO...SKIP STAT GATHERING    @@@@
         BL        DISHIS          GATHER DISC STATISTICS      @@@@
SETC1    EQU       $                                           @@@@
STEND    ANOP                                                  @@@@
         LI        R5,-2           NEGATIVE RETRY COUNT
         LH        R7,DCA.UADD,X3    FETCH CHANNEL ADDR & SUB ADDR
ISSUESIO EQU       $
         SIO       R7,0            ISSUE THE SIO
         BL        $+1W            CALL UP CONDITION CODES
         LW        R4,CCMASK       FETCH CONDITION CODE MASK
         TRRM      R0,R0           KEEP CONDITION CODES ONLY
         IFT       DBBDP2,DBEND                                 @@@
         STW       R0,CCODE                                     @@@
         STW       R2,R2IOQ                                     @@@
         TRR       R0,R2                                        @@@
         TBM       GCB,DCA.FLAG,X3                               @@@
         BNS       LJD1                                         @@@
         SBM       31,LOCAL                                     @@@
         BU        LJD2                                         @@@
LJD1     SBM       30,LOCAL                                     @@@
LJD2     EQU       $                                            @@@
         LW        R0,LOCAL                                     @@@
         SLL       R0,28                                        @@@
         SRL       R0,28                                        @@@
         CI        R0,3                                         @@@
         BNE       LJD3                                         @@@
         NOP                                                    @@@
         NOP                                                    @@@
LJD3     EQU       $                                            @@@
         LW        R0,CCODE                                     @@@
         LW        R2,R2IOQ                                     @@@
         BU        HURRY                                        @@@
CCODE    DATAW     0                                            @@@
R2IOQ    DATAW     0                                            @@@
HURRY    EQU       $                                            @@@
DBEND    ANOP                                                   @@@
         SRL       R0,25           SHIFT TO WORD INDEX
         XCR       R0,R3           R3 = INDEX INTO ACTION TABLE
*                                  R0 = CONTEXT BLOCK ADDRESS
         BU        *ACTION,X3      JUMP TO CONDITION CODE PROCESSING
*
*   CONDITION CODE ACTION TABLE
*
ACTION   EQU       $
         ACH       SIOOK           COMMAND ACCEPTED
         ACH       CHANBUSY        CHANNEL BUSY
         ACH       INOPUDEF        CHANNEL INOP OR UNDEFINED
         ACH       SUBCBUSY        SUB CHANNEL BUSY
         ACH       STATSTOR        STATUS STORED
         ACH       UNSUPTRN        UNSUPPORTED TRANSACTION
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       SIOOK           COMMAND ACCEPTED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
         ACH       UNASSIGN        UNASSIGNED
*
*
*
INOPUDEF EQU       $               CHANNEL INOP OR UNDEFINED:
         SBM       4,IOQ.IOST,X2   SET OPERATOR INTERVENTION BIT
*
UNSUPTRN EQU       $               UNSUPPORTED TRANSACTION:
UNASSIGN EQU       $               UNASSIGNED:
         SBM       6,IOQ.FLGS,X2   SET ERROR FLAG IN IOQ
         SBM       1,IOQ.IOST,X2   SET DEVICE ERROR IN IOQ
         TRR       R0,R3           RESTORE CONTEXT BLK ADDR TO R3
         NOP
*
UNLINK2  EQU       $
         LI        R4,2            R4: 2=> BR TO 'FAILURE' CODE   @
         BU        GETNEXTC
*
*
CHANBUSY EQU       $               CHANNEL BUSY:
SUBCBUSY EQU       $               SUBCHANNEL BUSY:
         TRR       R0,R3           RESTORE CONTEXT BLK ADDR TO R3
         BIB       R5,ISSUESIO     TRY MAX OF TWO TIMES
         BU        GETNEXT         SIO NOT ACTIVATED/ACCEPTED - BRNCH
*
*
STATSTOR EQU       $               STATUS STORED:
         TRR       R0,R3           RESTORE CONTEXT BLK ADDR TO R3
         LW        R2,DCA.CHTA,X3  CHT ADDRESS
         SBM       HANDLER,CHT.FLGS,X2  SHOW HANDLER ENTRY
         LI        R4,1            R4: 1=> BR TO EP1.3 OF H.EXIO
         BU        GETNEXTC
*
*
SIOOK    EQU       $               COMMAND ACCEPTED:
         TRR       R0,R3           RESTORE CONTEXT BLK ADDR TO R3
         TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?      @
         BNS       SIO1            NO...BRANCH                    @
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO 'INITIO'?       @
         BS        SIO1            YES...BRANCH                   @
         IFT       DBBDP2,DBEND                                 @@@
         ABM       31,LOCAL+16W                                 @@@
DBEND    ANOP                                                   @@@
         BL        IOQCOPY         COPY IOQ TO 'GHOST IOQ' ARRAY  @
SIO1     EQU       $                                              @
         SBM       1,UDT.FLGS,X1   SHOW I/O OUTSTANDING IN UDT
         SBM       0,IOQ.STAT,X2   SHOW IOQ BUSY
         STW       R2,DCA.IOQA,X3     ACTIVE IOQ ADDR FOR CNTXT BLK
         LW        R5,IOQ.FCT4,X2  FETCH TIME OUT VALUE FROM IOQ
         STW       R5,UDT.PTOV,X1  SET TIME OUT VALUE IN UDT
         ABM       31,SIOCNT,X3    BUMP SUCCESSFUL SIO CNTR (SUBC)
         LW        R1,DCA.CDTA,X3   FETCH CDT ADDRESS
         SBM       1,CDT.FLGS,X1   SHOW BUSY FOR THIS CHANNEL
         ZBM       7,IOQ.STAT,X2   CLEAR ECC CORRECTION PERFORMED BIT
         ZBM       28,IOQ.FLGS,X2  CLEAR POR TO BE ISSUED BIT
         ZBM       2,IOQ.STAT,X2   WAS THIS SIO FOR DCA.REZO AND RETRY?
         BS        INCCNTS         YES, BRANCH
         ZBM       6,IOQ.STAT,X2   WAS THIS SIO FOR RETRY WHOLE LIST?
         BNS       ISITECC         NO, BRANCH
INCCNTS  EQU       $
         ABM       31,DCA.RETC,X3  INCREMENT ERROR RETRY CNTR (SUBC)
ISITECC  EQU       $
         ZBM       4,IOQ.STAT,X2   WAS THIS SIO FOR READ ECC?
         BNS       CKSENSE         NO, BRANCH
         SBM       5,IOQ.STAT,X2   SHOW INTERRUPT FOR READ ECC EXPTD
         BU        GETNEXT         BRANCH
CKSENSE  EQU       $
         ZBM       3,IOQ.STAT,X2   WAS THIS SIO FOR A SENSE COMMAND?
         BNS       GETNEXT         NO, BRANCH
         SBM       1,IOQ.STAT,X2   SHOW INTERRUPT FOR SENSE EXPECTED
GETNEXT  EQU       $
         LI        R4,0            R4: 0=> NORMAL RETURN TO NEXT IOQ
GETNEXTC EQU       $
         BU        *INITRETA       RETURN
*                                                                 @
*                                                                 @
*                                                                 @
*        ROUTINE TO COPY IOQ CONTENTS TO GHOST 'IOQ ARRAY'        @
*        ENTER: R2 = IOQ ADDRESS                                  @
*               R3 = PRIME CONTEXT BLOCK ADDRESS                  @
IOQCOPY  EQU       $                                              @
         IFT       DBBDP2,DBEND                                 @@@
         ABM       31,LOCAL+13W                                 @@@
         ABM       31,COPCNT                                    @@@
DBEND    ANOP                                                   @@@
         ZBM       EIC,IOQ.FLGS,X2  IOQ TO GIOQ COPY ENABLED?     @
         BNS       IOQ4            NO...BRANCH                    @
         STF       R0,RSAV         SAVE ALL REGISTERS             @
         LW        R1,GIOQADR,X3   GET GIOQ ARRAY ADDR TO USE     @
         LH        R5,IOQ.XTRA,X2  GET # OF EXTRA IOQ WORDS       @
         ADI       R5,IOQ.SIZE/4   ADD THE STANDARD IOQ SIZE (WDS)@
         TRN       R5,R5           NEGATE IOQ SIZE (IN WORDS)     @
IOQ3     EQU       $                                              @
         LW        R6,0,X2         GET IOQ VALUE                  @
         STW       R6,0,X1         COPY TO GHOST IOQ ARRAY        @
         ABR       R2,29           INCREMENT ADDR POINTERS        @
         ABR       R1,29                                          @
         BIB       R5,IOQ3                                        @
         LW        R1,GIOQADR,X3   RESTORE GHOST GIOQ ARRAY ADDR  @
         LW        R2,B.GCDTA      GET GHOST CDT ADDR             @
         LI        R4,1            INCREMENT # OF GIOQ ENTRIES LJD@21285
         ARMB      R4,CDT.IOCT,X2  FOR THIS GHOST CONTROLLER   LJD@21285
         STH       R2,IOQ.CDTA+1H,X1  INSERT CDT INTO GIOQ ARRAY  @
         LW        R2,TWIN,X3      GET GHOST CONTEXT BLK ADDR     @
         STW       R2,IOQ.CBLK,X1  INSERT INTO GIOQ               @
         LW        R5,RSAV+2W      GET ORIGINAL PRIME IOQ ADDR    @
         STW       R5,PIOQADR,X2   INSERT PIOQ IN GHOST CNTXT BLK @
         STW       R5,PIOQADR,X3   INSERT PIOQ IN PRIME CNTXT BLK @
         LH        R7,DCA.UADD,X2  GET GHOST MHD CHAN/SUBCHAN #   @
         STH       R7,IOQ.CHNO,X1  AND INSERT INTO GIOQ           @
         LW        R4,DCA.UDTA,X2   GET GHOST UDT ADDR             @
         STW       R4,IOQ.UDTA,X1  INSERT UDT ADDR INTO GIOQ      @
         STW       R1,DCA.IOQA,X2     INSERT GIOQ ADDR INTO CTX BLK  @
         LF        R0,RSAV         RESTORE ALL REGISTERS          @
IOQ4     EQU       $                                              @
         TRSW      R0                                             @
         BOUND     1F                                             @
RSAV     RES       1F              REGISTER SAVE AREA             @
         PAGE
************************************************************** @@@@
*                                                            * @@@@
*        DISHIS SUBROUTINE                                   * @@@@
*        SUBROUTINE TO GATHER DISC STATISTICAL INFORMATION   * @@@@
*                                                            * @@@@
************************************************************** @@@@
*        ENTERED VIA BL FROM H.INITIO                        * @@@@
*            R0 = RETURN ADDRESS                             * @@@@
*            R1 = UDT ADDRESS                                * @@@@
*            R2 = IOQ ADDRESS                                * @@@@
*            R3 = CONTEXT BLOCK ADDRESS                      * @@@@
************************************************************** @@@@
*        EXIT                                                * @@@@
*            R1 = UDT ADDRESS                                * @@@@
*            R2 = IOQ ADDRESS                                * @@@@
*            R3 = CONTEXT BLOCK ADDRESS                      * @@@@
************************************************************** @@@@
         BOUND     1W                                          @@@@
DISHIS   EQU       $                                           @@@@
         IFT       STBDP2,STEND                                @@@@
         STW       R0,DISRET       SAVE RETURN ADDR            @@@@
*        BL        *C.DEBUG                                    @@@@
         XCR       R5,R1           SAVE R1 (PRIME UDT ADDR)    @@@@
         ZBR       R5,0            ENSURE I/O FLAG IS CLEARED  @@@@
         ZBR       R5,1            ENSURE GHOST ENRY FLAG IS 0 @@@@
         LW        R4,=X'00900000'  PSD2 ADDR IN SPAD          @@@@
         TSCR      R4,R7           GET CURRENT PSD WD 2        @@@@
         SBR       R7,16           ENSURE INT MODE RETAINED    @@@@
         SBR       R7,15           ENSURE RETAIN MAPS       @@>EHW041988
         STW       R7,BDP2.RET+1W  SAVE IN RETURN LPSD LOC     @@@@
         LPSD      BDP2.NEW        LOAD NEW PSD                @@@@
         BOUND     1D                                          @@@@
BDP2.NEW GEN       8/X'84',5/0,19/W(BDP2.C1)  PRIV,EXT      @@>EHW041988
         DATAW     X'00018000'     UNMAPPED, RETAIN BLK MODE @>EHW041988
R2SAV    DATAW     0               IOQ ADDR SAVE LOCATION      @@@@
R3SAV    DATAW     0               CONTEXT BLK ADDR SAVE LOC   @@@@
R6SAV    DATAW     0               OUTSIDE LOOP CNT SAVE LOC   @@@@
DISRET   DATAW     0               DISHIS RETURN ADDR          @@@@
SUBOFFST DATAW     0               SUBCHAN OFFSET INTO HISTOGRA@@@@
TIOQENT  DATAW     0               TOTAL # IOQ ENTRIES         @@@@
NRBWCNT  DATAW     0               # READ BEFORE WRITE COUNT   @@@@
NWBRCNT  DATAW     0               # WRITE BEFORE READ COUNT   @@@@
*                                                              @@@@
BDP2.C1  EQU       $                                           @@@@
         TBM       11,IOQ.FLGS,X2  WRITE I/O REQUEST?          @@@@
         BNS       TIS0            NO...BRANCH                 @@@@
         SBR       R5,0            FLAG AS WRITE I/O REQUEST   @@@@
TIS0     EQU       $                                           @@@@
         ZR        R4              COMPUTE SUBCHAN BASE ADDR   @@@@
         LB        R7,IOQ.SUBA,X2  GET SUBCHANNEL ADDR         @@@@
         BZ        TIS2            SKIP OFFSET IF ZERO         @@@@
         SRL       R7,1                                        @@@@
         TRN       R7,R7           CONVERT INTO LOOP COUNTER   @@@@
TIS1     EQU       $                                           @@@@
         ADI       R4,IHISTSIZ     INCREMENT TO NEXT HISTOGRAM @@@@
         BIB       R7,TIS1                                     @@@@
TIS2     EQU       $                                           @@@@
         STW       R4,SUBOFFST     SAVE SUBCHANNEL OFFSET      @@@@
         LH        R7,IOQ.FCT1,X2  GET CYLINDER #              @@@@
         TRR       R7,R0           SAVE CYL #                  @@@@
         SLL       R7,2            ADJUST CYL # FOR WORD ADDR  @@@@
         ADR       R4,R7           ADD IN SUBCHANNEL OFFSET    @@@@
         TBM       GCB,DCA.FLAG,X3  GHOST ENTRY TO STATISTICS?  @@@@
         BNS       TIS3            NO...BRANCH                 @@@@
         ADI       R7,AHISTSIZ     ADD IN GHOST TABLE OFFSET   @@@@
         SBR       R5,1            FLAG AS GHOST I/O ENTRY     @@@@
         NOP                                                   @@@@
*                                                              @@@@
*        DETERMINE AMOUNT OF HEAD MOVEMENT BETWEEN I/O REQUESTS@@@@
TIS3     EQU       $                                           @@@@
         LB        R4,IOQ.SUBA,X2  GET SUBCHAN #               @@@@
         LA        R1,LCATBL       GET LAST CYL TABLE ADDR     @@@@
         ADR       R4,R1           INDEX INTO TABLE            @@@@
         TBR       R5,1            GHOST ENTRY?                @@@@
         BNS       TIS4            NO...BRANCH                 @@@@
         ADI       R1,4W           ADD GHOST ENTRY OFFSET      @@@@
TIS4     EQU       $                                           @@@@
         LH        R4,0H,X1        GET LAST CYL #              @@@@
         SUR       R0,R4           CALC DIFF: R4-R0->R4        @@@@
         BGE       TIS5            BRANCH IF POSTIVE           @@@@
         TRN       R4,R4           TAKE ABSOLUTE VALUE OF DIFF @@@@
TIS5     EQU       $                                           @@@@
         SLL       R4,2            ADJUST FOR WORD INDEX       @@@@
*                                                              @@@@
*        DETERMINE I/O QUEUE STRING INFORMATION                @@@@
         STW       R2,R2SAV        SAVE IOQ ADDR               @@@@
         STW       R3,R3SAV        SAVE CONTEXT BLK ADDR       @@@@
         STW       R6,R6SAV        SAVE OUTSIDE LOOP COUNTER   @@@@
         LW        R1,B.PCDTA      GET PRIME CDT ADDR          @@@@
         LB        R0,CDT.IOCT,X1  GET TOTAL # OF IOQ ENTRIES  @@@@
         STW       R0,TIOQENT      AND SAVE                    @@@@
         LW        R2,CDT.FIOQ,X1  GET 1ST IOQ STRUNG ON CDT   @@@@
         LW        R1,B.DISHIS     GET STATISTICAL BUFFER ADDR @@@@
         SLL       R0,2            ADJUST # ENTRIES FOR WD ADDR@@@@
         ADR       R0,R1           R1 = TOTAL IOQ ENTRIES INDEX@@@@
         SRL       R0,2            RESTORE # IOQ ENTRIES       @@@@
         TRN       R0,R0           NEGATE # IOQ ENTRY FOR LOOP @@@@
         ZR        R3              CLEAR # WRITE IOQ ENTRIES   @@@@
         ZMW       NRBWCNT         CLEAR # READ BEFORE WRITE CT@@@@
         ZMW       NWBRCNT         CLEAR # WRITE BEFORE READ CT@@@@
TIS6     EQU       $                                           @@@@
         TBM       10,IOQ.FLGS,X2  READ REQUEST?               @@@@
         BS        TIS7            YES...BRANCH                @@@@
         ABR       R3,31           INC # WRITE IOQ ENTRIES     @@@@
         SBM       1,NRBWCNT       INHIBIT NRBW COUNTER        @@@@
         TBM       1,NWBRCNT       NWBR COUNTER DISABLED?      @@@@
         BS        TIS8            YES...BRANCH                @@@@
         ABM       31,NWBRCNT      INC NWBR COUNTER            @@@@
         BU        TIS8                                        @@@@
TIS7     EQU       $                                           @@@@
         SBM       1,NWBRCNT       INHIBIT NWBR COUNTER        @@@@
         TBM       1,NRBWCNT       NRBW COUNTER DISABLED?      @@@@
         BS        TIS8            YES...BRANCH                @@@@
         ABM       31,NRBWCNT      INC NRBW COUNTER            @@@@
TIS8     EQU       $                                           @@@@
         LW        R2,IOQ.SFA,X2   GET NEXT IOQ ENTRY          @@@@
         BIB       R0,TIS6         LOOP UNTIL ALL ENTRIES DONE @@@@
         LW        R2,TIOQENT      RESTORE TOTAL # IOQ ENTRIES @@@@
         SUR       R3,R2           CALC # READ ENTRY R2-R3->R2 @@@@
         SLL       R2,2            WD ADJUST TOTAL READ ENTRIES@@@@
         SLL       R3,2            WD ADJUST TOTAL WRITE ENTRY @@@@
         LB        R6,NRBWCNT+3B   ANY RBW COUNTS ENTERED?     @@@@
         BZ        TIS9            NO...GO PROCESS WBR COUNTS  @@@@
         SLL       R6,2            WD ADJUST READ COUNTS       @@@@
         ADI       R6,NRBW         ADD IN NRBW OFFSET          @@@@
         BU        TIS10                                       @@@@
TIS9     EQU       $                                           @@@@
         LB        R6,NWBRCNT+3B   GET WBR COUNTS              @@@@
         SLL       R6,2            WD ADJUST WRITE COUNTS      @@@@
         ADI       R6,NWBR         ADD IN NWBR OFFSET          @@@@
TIS10    EQU       $                                           @@@@
         LW        R0,B.DISHIS     GET STATISTICAL BUFFER ADDR @@@@
         ADR       R0,R2           COMPUTE # READ IOQ ENT ADDR @@@@
         ADR       R0,R3           COMPUTE # WRITE IOQ ENT ADDR@@@@
         ADR       R0,R6           COMPUTE NRBW OR NWBR ADDR   @@@@
*                                                              @@@@
*        UPDATE STATISTICAL COUNTS AND HISTOGRAMS              @@@@
*        R1 = TOTAL # IOQ ENTRIES INDEX                        @@@@
*        R2 = TOTAL # READ IOQ ENTRIES INDEX                   @@@@
*        R3 = TOTAL # WRITE IOQ ENTRIES INDEX                  @@@@
*        R4 = CYL MOVEMENT WD ADDR OFFSET                      @@@@
*        R5 = FLAGGED UDT ADDR                                 @@@@
*        R6 = OUTSIDE LOOP COUNTER FOR 'INITIO' ROUTINE        @@@@
*        R7 = CYL ACCESS WD ADDR OFFSET                        @@@@
         SEA                                                   @@@@
         ABM       31,TSEQ,X1      INC TOTAL # IOQ ENTRIES     @@@@
         ABM       31,TREQ,X2      INC TOTAL # READ IOQ ENTRIES@@@@
         ABM       31,TWEQ,X3      INC TOTAL # WRITE IOQ ENTRY @@@@
         TRR       R0,R1           RESTORE STAT BUF ADDR TO R1 @@@@
         TRR       R6,R2           INDEX FOR RBW OR WBR COUNTER@@@@
         ABM       31,0W,X2        INC NRBW/NWBR HISTOGRAM     @@@@
*                                                              @@@@
         ABM       31,TSIO,X1      INCREMENT TOTAL I/O COUNT   @@@@
         TBR       R5,1            GHOST I/O ENTRY?            @@@@
         BS        TIS12           YES...BRANCH                @@@@
*                                  PRIME I/O QUEUE ENTRY       @@@@
         ABM       31,PSIO,X1      INC TOTAL PRIME I/O COUNT   @@@@
         TBR       R5,0            WRITE I/O ENTRY?            @@@@
         BS        TIS11           YES...BRANCH                @@@@
         ABM       31,TRIO,X1      INC TOTAL READ I/O COUNT    @@@@
         ABM       31,PRIO,X1      INC TOTAL PRIME READ I/O CNT@@@@
         BU        TIS14                                       @@@@
TIS11    EQU       $                                           @@@@
         ABM       31,TWIO,X1      INC TOTAL WRITE I/O COUNT   @@@@
         ABM       31,PWIO,X1      INC TOTAL PRIME WRITE I/O CN@@@@
         BU        TIS14                                       @@@@
*                                  GHOST I/O QUEUE ENTRY       @@@@
TIS12    EQU       $                                           @@@@
         ABM       31,GSIO,X1      INC TOTAL GHOST I/O COUNT   @@@@
         TBR       R5,0            WRITE I/O ENTRY?            @@@@
         BS        TIS13           YES...BRANCH                @@@@
         ABM       31,TRIO,X1      INC TOTAL READ I/O COUNT    @@@@
         ABM       31,GRIO,X1      INC TOTAL GHOST READ I/O CNT@@@@
         BU        TIS14                                       @@@@
TIS13    EQU       $                                           @@@@
         ABM       31,TWIO,X1      INC TOTAL WRITE I/O COUNT   @@@@
         ABM       31,GWIO,X1      INC TOTAL GHOST WRITE I/O CN@@@@
TIS14    EQU       $                                           @@@@
         ADI       R1,BSTATSIZ     ADD IN HISTOGRAM BASE OFFSET@@@@
         ADR       R7,R1           INDEX INTO HISTOGRAM        @@@@
         ABM       31,THBASE,X1    INC TOTAL CYL HISTOGRAM     @@@@
         TBR       R5,0            WRITE I/O ENTRY?            @@@@
         BS        TIS15           YES...BRANCH                @@@@
         ABM       31,RHBASE,X1    INC READ CYL HISTOGRAM      @@@@
         BU        TIS16                                       @@@@
TIS15    EQU       $                                           @@@@
         ABM       31,WHBASE,X1    INC WRITE CYL HISTOGRAM     @@@@
TIS16    EQU       $                                           @@@@
         LW        R1,SUBOFFST     GET SUBCHAN OFFSET          @@@@
         ADI       R1,BSTATSIZ     SKIP OVER BASE STATISTICS   @@@@
         ADI       R1,AHISTSIZ     SKIP OVER CYL HIST ARRAYS   @@@@
         ADI       R1,AHISTSIZ     SKIP OVER CYL HIST ARRAYS   @@@@
         ADR       R0,R1           ADD IN STAT BUF BASE ADDR   @@@@
         TBR       R5,1            GHOST I/O ENTRY?            @@@@
         BNS       TIS17           NO...BRANCH                 @@@@
         ADI       R1,MHISTSIZ     ADD IN GHOST ARRAY OFFSET   @@@@
TIS17    EQU       $                                           @@@@
         ADR       R4,R1           ADD IN CYL MOVEMENT OFFSET  @@@@
         ABM       31,0W,X1        INC MOVEMENT HISTOGRAM CNT  @@@@
*        CEA                                                @@>EHW041988
         ZBR       R5,0            ENSURE I/O FLAG IS CLEARED  @@@@
         ZBR       R5,1            ENSURE GHOST ENRY FLAG IS 0 @@@@
         XCR       R1,R5           RESTORE R1                  @@@@
         LPSD      BDP2.RET        RETURN TO FORMER STATE      @@@@
         BOUND     1D                                          @@@@
BDP2.RET GEN       8/X'84',5/0,19/W(BDP2.C2)  PRIV, EXT     @@>EHW041988
         DATAW     0                                           @@@@
BDP2.C2  EQU       $                                           @@@@
         LW        R2,R2SAV        RESTORE IOQ ADDRESS         @@@@
         LW        R3,R3SAV        RESTORE CONTEXT BLK ADDR    @@@@
         LW        R6,R6SAV        RESTORE OUTSIDE LOOP COUNTER@@@@
         BU        *DISRET         RETURN                      @@@@
STEND    ANOP                                                  @@@@
         PAGE
*******************************************************************
*                                                                 *
*        CKSTAT SUBROUTINE                                        *
*        SUBROUTINE TO CHECK A DEVICE STATUS WHEN ITS I/O IS      *
*        COMPLETE.  IF ANY ERROR BITS WERE SET IN THE STATUS      *
*        WORD, A SENSE COMMAND IS ISSUED TO THAT DEVICE.          *
*                                                                 *
*******************************************************************
*        ENTERED VIA BL FROM H.DRIVE                              *
*            R0 = RETURN ADDRESS                                  *
*            R1 = UDT ADDRESS                                     *
*            R2 = IOQ ADDRESS                                     *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*******************************************************************
*        EXIT                                                     *
*            R1 = UDT ADDRESS                                     *
*            R2 = IOQ ADDRESS                                     *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*            R4 = ACTION TO TAKE ON RETURN                        *
*                 0 - BRANCH TO 'UNLINK'                          *
*                 1 - BRANCH TO 'ANYMO'                           *
*******************************************************************
         BOUND     1W
CKSTAT   EQU       $
         STW       R0,STATRETA     SAVE CKSTAT RETURN ADDRESS
         TRR       R1,R4           SAVE UDT ADDRESS
         LW        R1,DCA.CHTA,X3  CHT ADDRESS
         LW        R1,CHT.STAD,X1  STATUS ADDRESS
         TBM       13,1W,X1          DEVICE END PRESENT
         BS        GETSTAT         YES, BRANCH
         TRR       R4,R1           RESTORE UDT ADDRESS
         TBM       9,IOQ.FLGS,X2   DEVICE BUSY FROM RESERVE?
         BNS       STATANYM        NO, BRANCH
         LNW       R5,RESTOUT,X3   FETCH WAIT PERIOD FOR 'POR'
         BNZ       STORTO          BRANCH IF NOT IMMEDIATE
         SBM       28,IOQ.FLGS,X2  INDICATE 'POR' TO BE ISSUED
STORTO   EQU       $
         STW       R5,UDT.PTOV,X1  STORE TIME OUT INTO UDT
         SBM       27,IOQ.FLGS,X2  INDICATE RESERVE ISSUED TO DEVICE
*                                  THAT IS RESERVED TO OPPOSING CPU
         BU        STATANYM        BRANCH
GETSTAT  EQU       $
         LW        R5,0W,X1        FETCH STATUS WORD 1
         LW        R6,1W,X1       'FETCH STATUS WORD 2
         TRR       R4,R1           RESTORE UDT ADDRESS
         LW        R4,=X'FFF30000' MASK FOR ALL STATUS EXCEPT CE & DE
         TRRM      R6,R7           ANY ERRORS?
         BNZ       CKXCHANP        YES, BRANCH
STRSTAT2 EQU       $
         STW       R6,IOQ.IST2,X2  STORE STATUS INTO IOQ
         SRL       R6,16           KEEP STATUS BITS ONLY
         STH       R6,IOQ.IOST+1H,X2  STORE STATUS BITS INTO IOQ
         TBM       9,IOQ.FLGS,X2   WAS THIS A RESERVE DISC COMMAND
         BNS       STATUNL         NO, BRANCH
         ABM       31,DCA.RESC,X3    INCR # TASKS RESERVING DEVICE
         BU        STATUNL         BRANCH
CKXCHANP EQU       $
         TBM       23,IOQ.FLGS,X2  IS THIS AN EXECUTE CHANNEL PROG?
         BNS       SETSENSE        NO, BRANCH
         STW       R5,IOQ.IST1,X2  STORE STATUS WORD 1 INTO IOQ
         SBM       6,IOQ.FLGS,X2   SHOW ERROR IN IOQ
         SBM       1,IOQ.IOST,X2   SHOW ERROR FOR FCB
         BU        STRSTAT2        BRANCH
SETSENSE EQU       $
         SBM       3,IOQ.STAT,X2     INDICATE SENSE CMND TO BE ISSUED
         STW       R5,DCA.WST1,X3    SAVE STATUS WD1 IN CONTEXT BLK
         STW       R6,DCA.WST2,X3    SAVE STATUS WD2 IN CONTEXT BLK
*
STATANYM EQU       $
         LI        R4,1            R4: 1=> BRANCH TO 'ANYMO'
         BU        STATEXIT
*
STATUNL  EQU       $
         LI        R4,0            R4: 0=> BRANCH TO 'UNLINK'
*
STATEXIT EQU       $
         BU        *STATRETA       RETURN
         PAGE
*******************************************************************
*                                                                 *
*        ECC.0 SUBROUTINE                                         *
*        SUBROUTINE TO PROCESS ERROR CORRECTING CODE DATA         *
*        RESULTING FROM A PREVIOUS ECC READ OPERATION             *
*                                                                 *
*******************************************************************
*        ENTERED VIA BL FROM H.DRIVE                              *
*            R0 = RETURN ADDRESS                                  *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*******************************************************************
*        EXIT                                                     *
*            R2 = IOQ ADDRESS (IF R4 = 0,1)                       *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*            R4 = ACTION TO TAKE ON RETURN                        *
*                 0 - BRANCH TO 'UNLINK'                          *
*                 1 - BRANCH TO 'ANYMO'                           *
*                 2 - BRANCH TO 'SETB6'                           *
*******************************************************************
         BOUND     1W
ECC.0    EQU       $
         STW       R0,ECCRETA      SAVE ECC RETURN ADDRESS
         LW        R4,=X'FFF30000' MASK FOR STATUS BITS ONLY
         LW        R2,DCA.CHTA,X3  CHT ADDRESS
         LW        R2,CHT.STAD,X2  STATUS ADDRESS
*        LMW       R5,1W,X1        ANYTHING OTHER THAN CE & DE>EHW110890
         LMW       R5,1W,X2        ANYTHING OTHER THAN CE & DE>EHW110890
         BNZ       ECCSETB6        YES, BRANCH
         LH        R5,UDT.SSIZ,X1  FETCH SECTOR SIZE IN WORDS
         SLL       R5,5            CONVERT SECTOR SIZE TO BITS
         CAMH      R5,DCA.ECC,X3   IS SECTOR SIZE < DISPLACEMENT?
         BLT       ECCSETB6        YES, BRANCH
         ZR        R6              FOR DIVIDE
         LH        R7,DCA.ECC,X3   FETCH BIT DISPLACEMENT
         DVI       R6,8            CONVERT TO BITS AND BYTES
         STH       R6,DCA.BITD,X3    SAVE BIT DISPLACEMENT REMAINDER
         STH       R7,DCA.BITD+1H,X3   SAVE BYTE DISPLACEMENT
         LW        R1,DCA.WST1,X3    R1 = STATUS WORD 1
         ANMW      R1,MASK3B       KEEP IOCD ADDRESS ONLY
         SUI       R1,8            R1 = CURRENT IOCD ADDRESS (FAILED)
         SUI       R1,8            R1 = PREVIOUS IOCD ADDRESS
         TBM       0,1W,X1         IS PREVIOUS IOCD DATA CHAINED?
         BS        ECC.1           YES, BRANCH
         ZMW       DCA.A2,X3           ZERO LAST BUF ADDR FOR PREVIOUS
*                                  IOCD
         ZR        R5              SHOW THE SAME IN R5
         BU        ECC.2           BRANCH
ECC.1    EQU       $
         LW        R5,0,X1         R5 = PREVIOUS IOCD WORD 1
         ANMW      R5,MASK3B       R5 = BUFFER ADDR FOR PREVIOUS IOCD
         LH        R6,3H,X1        FETCH PREV IOCD REQ'D BYTE COUNT
         ANMW      R6,MASK2B       R6 = PREV IOCD REQ'D BYTE COUNT
         ADR       R6,R5           R5 = LAST BUF ADDR FOR PREVIOUS
         NOP                       IOCD
         STW       R5,DCA.A2,X3        SAVE INTO CONTEXT BLOCK
ECC.2    EQU       $
         ADI       R1,8            R1 = CURRENT IOCD ADDR (FAILED)
         LW        R2,0,X1         R2 = WORD 1 OF CURRENT IOCD
         ANMW      R2,MASK3B       R2 = CURRENT BUFFER ADDRESS
         STW       R2,DCA.A3,X3        STORE INTO CONTEXT BLOCK
         LH        R7,DCA.WST2+1H,X3 R7 = RESIDUAL BYTE COUNT
         ANMW      R7,MASK2B       R7= RESIDUAL BYTE COUNT
         LH        R6,3H,X1        R6 = REQUESTED BYTE COUNT
         ANMW      R6,MASK2B       R6 = REQUESTED BYTE COUNT
         SUR       R7,R6           R6 = # OF BYTES XFER'D FOR CURR
         NOP                       IOCD
         STW       R6,DCA.B1,X3       SAVE INTO CONTEXT BLOCK
         CI        R7,0            WAS THERE ANY RESIDUAL BYTE COUNT?
         BEQ       ECC.11          NO, BRANCH
         STH       R7,3H,X1        UPDATE REQUESTED BYTE COUNT IN
*                                  THE CURR IOCD FOR LATER EXECUTION
         ADR       R6,R2           R2 = ADDR OF END OF ERRING SECTOR
         STW       R2,0,X1         UPDATE BUFFER ADDR IN THE CURR
*                                  IOCD FOR LATER EXECUTION
         ZMB       0,X1            CLEAR COMMAND CODE FIELD IN IOCD
         SBM       6,0,X1          MAKE COMMAND CODE A READ FOR
*                                  LATER IOCD EXECUTION
         STW       R2,DCA.A4,X3        SAVE INTO CONTEXT BLOCK
ECC.3    EQU       $
         ABM       14,DCA.BITD+1H,X3   BUMP BYTE DISPLACEMENT BY 2
         SUMH      R2,DCA.BITD+1H,X3   R2 = ADDR OF ERRING HALFWORD
         CAMW      R2,DCA.A3,X3        IS RESULT WITHIN THE BUFFER?
         BGE       ECC.4           YES, BRANCH
         CI        R5,0            IS THERE A VALID PREVIOUS IOCD?
         BNE       ECC.3.1         YES, BRANCH
         ZR        R2              ZERO ADDR OF FIRST BYTE TO CORRECT
         BU        ECC.4           BRANCH
ECC.3.1  EQU       $
         SUMW      R2,DCA.A3,X3        SUBTRACT CURRENT BUFFER ADDR, THI
*                                  GIVES A NEGATIVE OFFSET INTO THE
*                                  PREVIOUS IOCD
         ADR       R2,R5           ADD NEGATIVE OFFSET TO THE LAST
*                                  BUFFER ADDR FOR THE PREVIOUS IOCD
         TRR       R5,R2           R2 = ADDR OF ERRING HALFWORD
ECC.4    EQU       $
         STW       R2,DCA.A5,X3        STORE INTO CONTEXT BLOCK
ECC.5    EQU       $
         LH        R5,DCA.BITD,X3    R5 = BIT DISPLACEMENT
         LH        R6,ECCSLL       R6 = SKELETON SHIFT INSTRUCTION
         ORR       R5,R6           R6 = SLL INST WITH BIT COUNT
         STH       R6,DOSLL        STORE FOR IN LINE EXECUTION
         LH        R4,DCA.ECC+1H,X3  R4 = ECC MASK
         ANMW      R4,=X'000001FF'  KEEP MASK ONLY
DOSLL    SLL       R4,0            ALIGN CORRECTION MSK TO PROPER BIT
         SEA                                                    MPX????
         LB        R5,0,X2         R5 = FIRST BYTE TO BE CORRECTED
         SLL       R5,8            MOVE INTO HIGH ORDER
         TRR       R1,R7           R7 = CURRENT IOCD ADDRESS
         TRR       R2,R1           R1 = ADDR OF FIRST BYTE TO CORRECT
         ABR       R1,31           R1= ADDR OF SECOND BYTE TO CORRECT
         CI        R1,1            IS ADDRESS WITHIN A VALID BUF?
         BLE       ECC.5.2         NO, BRANCH
         LW        R6,DCA.A2,X3        IS LAST BUFFER ADDRESS FOR
*                                  PREVIOUS IOCD = 0?
         BNZ       ECC.5.1         NO, BRANCH
         LW        R6,DCA.A3,X3        IS SECOND BYTE CORRECTABLE?
         BNZ       ECC.6           YES, BRANCH
         BU        ECC.5.2         BRANCH
ECC.5.1  EQU       $
         CAMW      R1,DCA.A2,X3        R1 < LAST BUFFER ADDR?
         BLT       ECC.6           YES, BRANCH
ECC.5.2  EQU       $
         LW        R1,DCA.A3,X3        R1 = NEW BUFFER ADDRESS
ECC.6    EQU       $
         ORMB      R5,0,X1         FETCH SECOND BYTE TO BE CORRECTED
         EOR       R4,R5           EXCLUSIVE OR MASK WITH DATA
         CI        R1,0            IS SECOND BYTE WITHIN A VALID BUF?
         BEQ       ECC.7           NO, BRANCH
         STB       R5,0,X1         CORRECT SECOND BYTE IN USERS BUF
ECC.7    EQU       $
         CI        R2,0            WAS FIRST BYTE IN A VALID BUFFER?
         BLE       ECC.7.1         NO, BRANCH
         SRL       R5,8            POSITION FIRST BYTE
         STB       R5,0,X2         CORRECT FIRST BYTE IN USERS BUFFER
ECC.7.1  EQU       $
*        CEA                                                  >EHW041988
         TRR       R7,R1           R1 = CURRENT IOCD ADDRESS
         ABM       31,DCA.ECNT,X3  INCREMENT ECC COUNTER (SUBC)
         LW        R2,DCA.CDTA,X3  CDT ADDRESS
         LW        R6,=X'03000000' R6 = NOP WORD 1 INSTRUCTION
         LW        R7,=X'40000001' R7 = NOP WORD 2 INSTRUCTION
         LH        R5,3H,X1        MORE LEFT TO DO FOR CURRENT IOCD?
         BNZ       ECC.9           YES, BRANCH
         TBM       0,1W,X1         ANY MORE IOCDS TO PROCESS?
         BNS       ALLDONE         NO, BRANCH
ECC.8    EQU       $
         STW       R6,0,X1         NOP CURRENT IOCD WORD 1
         STW       R7,1W,X1        NOP CURRENT IOCD WORD 2
ECC.9    EQU       $
         SUI       R1,8            BACK UP TO PREVIOUS IOCD
         TBM       0,1W,X1         IS THIS IOCD DATA CHAINED?
         BS        ECC.8           YES, BRANCH
         LW        R2,DCA.IOQA,X3     R2 = IOQ ADDRESS
         LW        R1,IOQ.UDTA,X2  R2 = UDT ADDRESS
         LB        R4,UDT.SPT,X1   R4 = # SECTORS PER TRACK
         CAMB      R4,DCA.SENS+3B,X3   ARE WE AT THE END OF THE TRACK?
         BGT       ECC.10          NO, BRANCH
         ZMB       DCA.SENS+3B,X3   ZERO SECTOR ADDRESS
         ABM       7,DCA.SENS+2B,X3  INCREMENT HEAD ADDRESS
         LH        R4,UDT.NHDS,X1  R4 = # OF HEADS
         CAMB      R4,DCA.SENS+2B,X3  DID HEAD COUNT OVERFLOW?
         BGT       ECC.10          NO, BRANCH
         ZMB       DCA.SENS+2B,X3   ZERO HEAD ADDRESS
         ABM       15,DCA.SENS,X3   INCREMENT CYLINDER ADDRESS
ECC.10   EQU       $
         LW        R4,DCA.SENS,X3   R4 = SEEK INFORMATION
         STW       R4,IOQ.FCT1,X2  STORE INTO IOQ WORD
         SBM       7,IOQ.STAT,X2   SHO CONTINUE AFTER ECC CORRECTION
         BU        ECCANYM         GO CONTINUE THE I/O
ECC.11   EQU       $
         LH        R5,3H,X1        R5 = REQUESTED BYTE COUNT
         STH       R7,3H,X1        ZERO CURRENT IOCD BYTE COUNT
         ANMW      R5,MASK2B       NO BAD BITS
         ADR       R5,R2           R2 = END OF CURRENT BUFFER ADDRESS
         STW       R2,DCA.B2,X3        STORE INTO CONTEXT BLOCK
         TRR       R1,R0           R0 = CURRENT IOCD ADDRESS
ECC.12   EQU       $
         SUI       R1,8            R1 = PREVIOUS IOCD ADDRESS
         TBM       0,1W,X1         IS PREVIOUS IOCD DATA CHAINED?
         BNS       ECC.13          NO, BRANCH
         LH        R6,3H,X1        R6 = REQUESTED BYTE COUNT
         ANMW      R6,MASK2B       NO BAD BITS
         ADR       R6,R5           R5 = ACCUMULATING BYTE COUNT
         BU        ECC.12          BRANCH
ECC.13   EQU       $
         LW        R1,DCA.IOQA,X3     R1 = IOQ ADDRESS
         LW        R1,IOQ.UDTA,X1  R1 = UDT ADDRESS
         LH        R1,UDT.SSIZ,X1  R1 = NUMBER OF WORDS PER SECTOR
         SLL       R1,2            R1 = NUMBER OF BYTES PER SECTOR
         ZR        R4              FOR DIVIDE
         DVR       R1,R4             DIVIDE BY BYTES PER SECTOR
         TRR       R4,R4           ANY REMAINDER?
         BZ        ECC.14          NO, BRANCH
         SUR       R4,R2           R2 = BEGINNING OF ERRING SECTOR
*                                  ADDRESS
         ADR       R1,R2           R2 = END OF ERRING SECTOR ADDR
ECC.14   EQU       $
         STW       R2,DCA.A4,X3        SAVE INTO CONTEXT BLOCK
         LH        R7,DCA.BITD+1H,X3   R7 = BYTE DISPLACEMENT
         ABR       R7,31           BUMP BY ONE BYTE
         SUR       R7,R2           SUBTRACT BYTE DISPLACEMENT FROM
*                                  END OF ERRING SECTOR
         CAMW      R2,DCA.B2,X3        IS ERROR OUTSIDE BUFFER?
         BGT       ALLDONE         YES, BRANCH
         BLT       ECC.15          BOTH BYTES ARE CORRECTABLE, BRANCH
         ZMW       DCA.A3,X3           ONLY ONE BYTE IS CORRECTABLE, ZER
*                                  CURRENT IOCD ADDRESS
ECC.15   EQU       $
         TRR       R0,R1           R1 = CURRENT IOCD ADDRESS
         LW        R6,DCA.B1,X3       R6 = BYTES XFERR'D FRM CURR BUFF
         LW        R2,DCA.A4,X3        R2 = END OF ERRING SECTOR ADDR
         LW        R5,DCA.A2,X3        R5 = LAST BUFF ADDR FOR PREV IOCD
         BU        ECC.3           BRANCH
ECCSLL   SLL       R4,0            SHIFT LEFT SKELETON INSTRUCTION
*
ALLDONE  EQU       $
         LW        R2,DCA.IOQA,X3     R2 = IOQ ADDRESS
         BU        ECCUNL          BRANCH
*
ECCSETB6 EQU       $
         LW        R2,DCA.IOQA,X3     R2 = IOQ ADDRESS        >EHW110890
         LI        R4,2            R4: 2=> BRANCH TO 'SETB6'
         BU        ECCEXIT
*
ECCANYM  EQU       $
         LI        R4,1            R4: 1=> BRANCH TO 'ANYMO'
         BU        ECCEXIT
*
ECCUNL   EQU       $
         LI        R4,0            R4: 0=> BRANCH TO 'UNLINK'
*
ECCEXIT  EQU       $
         BU        *ECCRETA        RETURN
         PAGE
*******************************************************************
*                                                                 *
*        ERRTIMEO/SNSSI/SETB6 SUBROUTINES                         *
*        ERRTIMEO:  ROUTINE TO PROCESS SERVICE INTERRUPT FROM     *
*                LOST INTERRUPT (VIA ENTRY POINT 4 AND H.EXIO)    *
*        SNSSI:  ROUTINE TO PROCESS SERVICE INTERRUPT RESULTING   *
*                FROM A SENSE COMMAND THAT WAS ISSUED             *
*        SETB6:  ROUTINE TO CAUSE THE WHOLE IOCD LIST TO BE       *
*                RE-SUBMITTED  (ERROR RETRY)                      *
*                                                                 *
*******************************************************************
*        ENTERED VIA BL FROM H.DRIVE                              *
*            R0 = RETURN ADDRESS                                  *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*******************************************************************
*        EXIT                                                     *
*            R2 = IOQ ADDRESS                                     *
*            R3 = CONTEXT BLOCK ADDRESS                           *
*            R4 = ACTION TO TAKE ON RETURN                        *
*                 0 - BRANCH TO 'FAILURE'                         *
*                 1 - BRANCH TO 'ANYMO'                           *
*******************************************************************
         BOUND     1W
ERRTIMEO EQU       $
         STW       R0,ERRPRETA     SAVE ERRTIMEO RETURN ADDR
         TBM       27,IOQ.FLGS,X2  SHOULD THE 'POR' CMND BE ISSUED?
         BNS       INCLOST         NO, BRANCH
         SBM       28,IOQ.FLGS,X2  INDICATE 'POR' TO BE ISSUED
         BU        ERRPROC         BRANCH
INCLOST  EQU       $
         ABM       31,DCA.LINC,X3   BUMP LOST INTERRUPT CNTR (SUBC)
         TBM       1,IOQ.STAT,X2   DID SENSE CMND TIME OUT?
         BNS       SETB6C          NO...BRANCH
         SBM       3,IOQ.STAT,X2   INDICATE SENSE TO BE ISSUED
         BU        ERRPROC         BRANCH
*
*                                  BRANCH POINT AFTER SI FOR SENSE
*                                  COMMAND.  DCA.SENS IN CONTEXT BLOCK
*                                  HAS THE SENSE INFORMATION
SNSSI    EQU       $
         STW       R0,ERRPRETA     SAVE SNSSI RETURN ADDRESS
         ZMH       IOQ.IOST,X2     CLEAR LH OF STATUS WORD
         LW        R4,STATERR      FETCH STATUS ERROR MASK
         LMW       R5,DCA.WST2,X3    FETCH MASKED STATUS
         BNZ       EXHAUST         BRANCH IF UNRECOVERABLE STATUS ERR
         LW        R4,SENSERR      FETCH HARD ERROR MASK (SENSE)
         LMW       R5,DCA.SENS+1W,X3   FETCH MASKED SENSE INFO
         BNZ       EXHAUST         BRANCH - UNRECOVERABLE ERROR
         LW        R4,SENSERR2     FETCH ERROR RETRY MASK
         LMW       R5,DCA.SENS+1W,X3     FETCH MASKED SENSE INFO
         BZ        CKECC           BRANCH IF NO ERROR
         BU        SETB6C
*
*
*
SETB6    EQU       $
         STW       R0,ERRPRETA     SAVE SETB6 RETURN ADDRESS
SETB6C   EQU       $
         SBM       6,IOQ.STAT,X2   INDICATE RETRY WHOLE IOCD LIST
         BU        ERRPROC         BRANCH
CKECC    EQU       $
         TBM       28,DCA.SENS+1W,X3  CORRECTABLE DATA ERROR?
         BNS       CKFAULT         NO, BRANCH
         SBM       4,IOQ.STAT,X2   SHOW NEED TO DO READ ECC
         LI        R4,1            R4: 1=> BRANCH TO 'ANYMO'
         BU        ERREXIT
*
CKFAULT  EQU       $
         TBM       8,DCA.SENS+3W,X3 FAULT ERROR DETECTED?
         BS        SREZERO         YES, BRANCH
         TBM       9,DCA.SENS+3W,X3 SEEK ERROR?
         BS        SREZERO         YES, BRANCH
         TBM       25,DCA.SENS+1W,X3  DISC ADDR OR SEEK ERROR?
         BNS       CKWRITE         NO, BRANCH
SREZERO  EQU       $
         SBM       2,IOQ.STAT,X2   INDICATE REZERO AND RETRY NEEDED
*
ERRPROC  EQU       $
         TBM       1,IOQ.CONT,X2   IS ERROR PROCESSING INHIBITED?
         BS        EXHAUST         YES, BRANCH
         LB        R5,DCA.RCNT,X3  FETCH RETRY COUNT FROM CONTEXT BLK
         BNZ       CKRETRY         BRANCH IF RETRY ALREADY INITIATED
         LW        R5,RETRYMAX     LOAD RETRY MAX COUNT
CKRETRY  EQU       $
         LW        R1,IOQ.UDTA,X2  GET UDT ADDR FROM IOQ      >LJD120783
         LH        R1,UDT.UDTI,X1  GET UDT INDEX FROM UDT     >LJD120783
         CI        R1,DEV.NENT     ENTRY TOO LARGE FOR TABLE  >LJD120783
         BGT       SKIPRCNT        YES...BRANCH               >LJD120783
         LA        R4,B.DVRTRY     GET DEV ERR RETRY TABLE ADR>LJD120783
         SLL       R1,1            CONVERT INDEX TO HALFWORD  >LJD120783
         ADR       R4,R1           COMPUTE ADDRESS            >LJD120783
         ABM       15,0H,X1        INCREMENT ERR RETRY COUNT  >LJD120783
SKIPRCNT EQU       $                                          >LJD120783
         ABR       R5,31           INCREMENT RETRY COUNT
         STB       R5,DCA.RCNT,X3    UPDATE RETRY COUNT
         BZ        EXHAUST         RETRYS UNSUCCESSFUL - BRANCH
         ZBM       TIMEOFLG,DCA.FLAG,X3  CLEAR TIME OUT BIT
         LI        R4,1            R4: 1=> BRANCH TO 'ANYMO'
         BU        ERREXIT
CKWRITE  EQU       $
         TBM       11,IOQ.FLGS,X2  IS THIS A WRITE COMMAND?
         BNS       CKOPINT         NO, BRANCH
         TBM       18,DCA.SENS+1W,X3    FILE PROTECT SET?
         BS        FILEPROT        YES, BRANCH
         TBM       12,DCA.SENS+3W,X3     IS DRIVE WRITE PROTECTED?
         BNS       CKOPINT         NO, BRANCH
FILEPROT EQU       $
         SBM       3,IOQ.IOST,X2   INDICATE FILE PROTECT VIOLATION
         BU        EXHAUST         BRANCH
CKOPINT  EQU       $
         TBM       9,DCA.SENS+1W,X3   OPERATOR INTERVENTION REQUIRED?
         BNS       STORSNS         NO, BRANCH (NO ERRORS FOUND)
         SBM       4,IOQ.IOST,X2   SET DEVICE INOP IN IOQ
         SPACE     1
EXHAUST  EQU       $
         ZBM       TIMEOFLG,DCA.FLAG,X3  WAS ERR RETRY FOR A TIMEOUT?
         BS        FINALTO         YES, BRANCH
         SBM       6,IOQ.FLGS,X2   SET ERROR FLAG IN IOQ
         SBM       1,IOQ.IOST,X2   SET DEVICE ERROR IN IOQ
STORSNS  EQU       $
         LW        R5,DCA.SENS+1W,X3     FETCH STATUS FROM DCA.SENS
         STW       R5,IOQ.IST1,X2  STORE STATUS INTO IOQ
         BU        STORSTAT
*
FINALTO  EQU       $
         LW        R5,LOSTINT      FETCH LOST INTERRUPT STATUS
         STW       R5,IOQ.IOST,X2  STORE INTO IOQ
         ZMW       IOQ.IST1,X2     ZERO INT STATUS WD1 OF IOQ
         ZBM       1,IOQ.STAT,X2   DID SENSE CMND TIME OUT?
         BS        STORSTAT        YES, BRANCH
         LW        R1,DCA.CHTA,X3  CHT ADDRESS
         LW        R1,CHT.STAD,X1  STATUS ADDRESS
         LW        R5,0W,X1          FETCH STATUS WORD 1
         STW       R5,DCA.WST1,X3    STORE INTO CONTEXT BLOCK
         LW        R5,1W,X1        FETCH STATUS WORD 2
         STW       R5,DCA.WST2,X3    STORE INTO CONTEXT BLOCK
*
*
STORSTAT EQU       $
         LW        R5,DCA.WST2,X3    FETCH STATUS WD2 FROM CONTEXT BLK
         STW       R5,IOQ.IST2,X2     STORE INTO IOQ
         SRL       R5,16           KEEP STATUS BITS ONLY
         STH       R5,IOQ.IOST+1H,X2  STORE IN IOQ
         LI        R7,X'03'        LOAD IOCD NOP COMMAND CODE
         ZR        R5              ZERO BYTE COUNT ACCUMULATION REG
         LW        R4,MASK3B       ADDRESSS MASK
         LMW       R1,DCA.WST1,X3    FETCH IOCD ADDRESS
         SUI       R1,8            BACK UP TO FAILING IOCD
         LA        R6,IOQ.IOCD,X2  FETCH ADDRES OF IOQ IOCD LIST
         CAR       R6,R1           IS FAILING IOCD ADDR <= IOQ.IOCD
         BLE       ADD9            YES, BRANCH
         CAMB      R7,0,X1         IS FAILING IOCD A NOP?
         BEQ       BIOCD1          YES, BRANCH
         ADMH      R5,DCA.WST2+1H,X3 ADD RESIDUAL TO ACCUMULATING COUNT
         BU        CKDATAC         BRANCH
ADD9     EQU       $
         TRR       R6,R1           R1 = IOQ.IOCD ADDRESS
         ADI       R1,8            BUMP TO NEXT IOCD
         CAMB      R7,0,X1         IS IOCD A NOP?
         BNE       STRUTRN         NO, BRANCH
BIOCD1   EQU       $
         ADI       R1,8            BUMP TO NEXT IOCD
         CAMB      R7,0,X1         IS IOCD A NOP?
         BEQ       BIOCD1          YES, BRANCH
ADDCNT   EQU       $
         ADMH      R5,3H,X1        ADD IN IOCD BYTE COUNT
CKDATAC  EQU       $
         TBM       0,1W,X1         IS THIS IOCD DATA CHAINED?
         BNS       SUBACC          NO, BRANCH
         ADI       R1,8            BUMP TO NEXT IOCD
         BU        ADDCNT          BRANCH
SUBACC   EQU       $
         TRN       R5,R5           NEGATE RESIDUAL BYTE CNT
         ADMW      R5,IOQ.FCT3,X2  ADD REQUESTED XFER COUNT
STRUTRN  EQU       $
         STW       R5,IOQ.UTRN,X2  STORE SUCCESSFUL TRANSFER COUNT
         LI        R4,0            R4: 0=> BRANCH TO 'FAILURE'    @
*
ERREXIT  EQU       $
         BU        *ERRPRETA       RETURN
         LPOOL                     DUMP LITERALS HERE
         PAGE
**************************************************************  @@@
*                                                            *  @@@
*        REGSAV SUBROUTINE                                   *  @@@
*        SUBROUTINE TO SAVE CONTENTS OF ALL REGISTERS IN A   *  @@@
*        CIRCULAR BUFFER                                     *  @@@
*                                                            *  @@@
**************************************************************  @@@
*        ENTERED VIA BL FROM VARIOUS LOCATIONS IN THE DISC   *  @@@
*        HANDLER                                             *  @@@
*            R0 = RETURN ADDRESS                             *  @@@
*            R1-R7 = REGISTERS TO BE SAVED                   *  @@@
**************************************************************  @@@
*        EXIT                                                *  @@@
*            R0 = RETURN ADDRESS                             *  @@@
*            R1-R7 = REGISTERS THAT WERE SAVED               *  @@@
**************************************************************  @@@
         BOUND     1W                                           @@@
REGSAV   EQU       $                                            @@@
         IFT       DBBDP2,DBEND                                 @@@
*        TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?    @@@
*        BNS       REG2            NO...BRANCH                  @@@
         STF       R0,*REGPNT      SAVE REGISTERS               @@@
         STW       R0,R0SAV        SAVE RETURN ADDR             @@@
         LI        R0,8W           INC DUMP POINTER BY 8 WORDS  @@@
         ADMW      R0,REGPNT                                    @@@
         STW       R0,REGPNT                                    @@@
         CAMW      R0,BOTTOM       CHECK FOR POINTER OVERFLOW   @@@
         BLT       REG1            BRANCH IF POINTER OK         @@@
         LA        R0,REGBUF       RESET POINTER IF OVERFLOW    @@@
         STW       R0,REGPNT                                    @@@
REG1     EQU       $                                            @@@
         LW        R0,R0SAV        RESTORE RETURN ADDR          @@@
REG2     EQU       $                                            @@@
         TRSW      R0                                           @@@
R0SAV    REZ       1W              R0 RETURN ADDR SAVE LOC      @@@
REGPNT   ACW       REGBUF          POINTER INTO REG SAVE AREA   @@@
         BOUND     1F                                           @@@
REGBUF   REZ       1F                                           @@@
         LIST      OFF
         REZ       400F                                         @@@
         LIST      ON
BOTTOM   ACW       $                                            @@@
         PAGE
**************************************************************  @@@
*                                                            *  @@@
*        IOQSAV SUBROUTINE                                   *  @@@
*        SUBROUTINE TO SAVE IOQ ENTRIES STRING FORWARD       *  @@@
*        ADDRESSES, ALONG WITH OTHER IOQ INFORMATION,        *  @@@
*        B.GFLG, AND 'LOCAL' INFORMATION                     *  @@@
*                                                            *  @@@
**************************************************************  @@@
*        ENTERED VIA BL FROM VARIOUS LOCATIONS IN THE DISC   *  @@@
*        HANDLER                                             *  @@@
*            R0 = RETURN ADDRESS                             *  @@@
*            R4 = # OF IOQ ENTRIES LINKED TO THE CDT         *  @@@
**************************************************************  @@@
*        EXIT                                                *  @@@
*            R0 = RETURN ADDRESS                             *  @@@
*            R1-R7 = REGISTERS THAT WERE SAVED               *  @@@
**************************************************************  @@@
         BOUND     1W                                           @@@
*                                                               @@@
*                                                               @@@
*        TEMPORARY DEBUG LOOK AREA                              @@@
IOQSAV   EQU       $                                            @@@
*        TBM       MGP,B.GFLG      MHD GHOSTING IN PROGRESS?    @@@
*        BNS       IOQS4           NO...BRANCH                  @@@
         STF       R0,IOQREG       SAVE REGISTERS               @@@
         STW       R0,*IOQPNT      SAVE SEPARATOR               @@@
         BL        IOQINC          INCREMENT POINTER            @@@
         STW       R2,*IOQPNT      SAVE CURRENT IOQ ENTRY       @@@
         BL        IOQINC          INCREMENT POINTER            @@@
         LW        R2,LOCAL        GET CURRENT I/O ACTIVITY SCAN@@@
         STW       R2,*IOQPNT      AND SAVE IT                  @@@
         BL        IOQINC          INCREMENT POINTER            @@@
         LW        R2,B.GFLG       GET AND SAVE GHOST FLAG      @@@
         STW       R2,*IOQPNT      (B.GFLG)                     @@@
         BL        IOQINC          INCREMENT POINTER            @@@
         ZR        R2                                           @@@
         LI        R6,-40          MAX STRING CUTTOFF           @@@
         LW        R1,B.PCDTA      GET PRIME CDT ADDR           @@@
IOQS1    EQU       $                                            @@@
         LW        R7,0W,X1        GET STRING FORWARD ADDR      @@@
         STW       R7,*IOQPNT      INSERT IN LOOK ARRAY         @@@
         BL        IOQINC          INCREMENT POINTER            @@@
         CAMW      R7,B.PCDTA      END OF STRING DETECTED?      @@@
         BEQ       IOQS2           YES...BRANCH                 @@@
         ABR       R2,31           COUNT # OF IOQ ENTRIES       @@@
         LW        R1,0W,X1        GET NEW STRING FORWARD ADDR  @@@
         BIB       R6,IOQS1        MAX CUTOFF REACHED?          @@@
         LW        R6,=X'FFFFFFFF'  YES...INSERT DELIMITER      @@@
         STW       R6,*IOQPNT      INTO LOOK ARRAY              @@@
         BL        IOQINC          INCREMENT POINTER            @@@
IOQS2    EQU       $                                            @@@
         CAR       R2,R4           COUNTED ENTRIES = CDT.IOCT?  @@@
         BEQ       IOQS3           YES...BRANCH                 @@@
         NOP                                                    @@@
         NOP                                                    @@@
*        BL        *C.DEBUG                                     @@@
IOQS3    EQU       $                                            @@@
         LF        R0,IOQREG       RESTORE ALL REGISTERS        @@@
IOQS4    EQU       $                                            @@@
         TRSW      R0                                           @@@
*                                                               @@@
IOQINC   EQU       $                                            @@@
         LI        R5,1W                                        @@@
         ADMW      R5,IOQPNT                                    @@@
         STW       R5,IOQPNT                                    @@@
         CAMW      R5,IOQSVE       CHECK FOR POINTER OVERFLOW   @@@
         BLT       IOQI1           BRANCH IF POINTER OK         @@@
         LA        R5,IOQBUF       RESET POINTER IF OVERFLOW    @@@
         STW       R5,IOQPNT                                    @@@
IOQI1    EQU       $                                            @@@
         TRSW      R0                                           @@@
IOQREG   REZ       1F              REGISTER SAVE AREA           @@@
IOQPNT   ACW       IOQBUF          POINTER INTO STRING SAVE AREA@@@
IOQBUF   REZ       1W                                           @@@
         LIST      OFF
         REZ       300W                                         @@@
         LIST      ON
IOQSVE   ACW       $                                            @@@
         PAGE
DBEND    ANOP                                                   @@@
         PAGE
*                                                                 @
         TITLE     H.DCXIO         SYSGEN INITIALIZATION PROCESSOR
************************************************************************
*                                                                      *
*                  SG. - SYSGEN INITIALIZATION PROCESSOR               *
*                                                                      *
************************************************************************
*                                                                      *
*   THIS ENTRY POINT IS CALLED BY SYSGEN FOR THE PURPOSE OF INITIALIZ- *
*   ING CERTAIN HANDLER PARAMETERS, INITIALIZING DEVICE CONTEXT AREAS  *
*   (DCA'S) AND INITIALIZING CERTAIN DATA STRUCTURE ELEMENTS DURING    *
*   THE CONSTRUCTION OF AN MPX-32 IMAGE.                               *
*                                                                      *
*   DCA'S FOR THIS HANDLER ARE CREATED VIA THE REPEATED ASSEMBLY OF    *
*   THE MACRO, "DCA.DATA". A MAXIMUM NUMBER OF DCA'S IS                *
*   CREATED DURING HANDLER ASSEMBLY. DURING THE EXECUTION OF THIS      *
*   ENTRY POINT, ONE DCA IS INITIALIZED FOR EACH UDT ENTRY CONTAINING  *
*   THE NAME OF THIS HANDLER. ANY REMAINING DCA'S AND THE REMAINDER OF *
*   THE CODE IN THIS ENTRY WILL BE OVERLAID BY SYSGEN. THEREFORE THIS  *
*   MUST PHYSICALLY BE THE LAST ENTRY POINT OF THE HANDLER.            *
*                                                                      *
************************************************************************
*                                                                      *
*        CALLER:                   SYSGEN DURING IMAGE CONSTRUCTION    *
*                                                                      *
*        CALLERS PRIORITY:         N/A                                 *
*                                                                      *
*        INTERRUPTS:               N/A                                 *
*                                                                      *
*        CALLING SEQUENCE:         BL   LAST PHYSICAL ENTRY POINT      *
*                                                                      *
*        REGISTERS IN:             R3 = CHT ADDRESS                    *
*                                                                      *
*        RETURN SEQUENCE:          TRSW  R0 (VIA M.XIR)                *
*                                                                      *
*        REGISTERS OUT:            NONE REQ'D                          *
*                                                                      *
************************************************************************
         SPACE     3
         LPOOL                     LITERALS HERE TO AVOID OVERLAYING
DCASTART EQU       $               START OF DCA'S FOR THIS DEVICE
         REPT      64              REPEAT COUNT FOR DCA CREATION
         DCA.DATA  14,50,2,2,36,36,2,0,;                        C073-33
30,2,30,2,12,2,2,2,20,2                                             2102
         ENDR
         REPT      16              REPEAT COUNT FOR INC DATA
         REZ       6W
         ENDR
         BOUND     1W
         LIST      MAC
         SPACE     4
BDP2.8   EQU       $
         SPACE
         M.EIR
         SPACE
*
*   THE FOLLOWING IS TO SAVE THE HAT ADDRESS OF THE INTERRUPT
*   FIELDER IN THE CDT AS THE FOLLOWING MACRO OVERLAYS
*   THE ADDRESS WITH THE HAT ADDRESS OF THE HANDLER
*
         LW        R1,B.PCDTA      PRIMARY CDT ADDRESS
         LW        R6,CDT.SIHA,X1  INTERRUPT FIELDER ADDRESS
         STW       R6,PSIHA        SAVE IN LOCAL AREA
*
         LW        R1,B.GCDTA      GHOST CDT ADDRESS
         LW        R6,CDT.SIHA,X1  INTERRUPT FIELDER ADDRESS
         STW       R6,GSIHA        SAVE IN LOCAL FOR NOW
*
         DCA.INI1  H.BDP2,,IOQCDT
         SPACE     2
*
** PROCEDURE TO INITIALIZE DEVICE DEPENDENT DATA
**       REG IN : R1 = UDTA
**                R2 = DCAA
*
         LB        R6,UDT.DTC,X1   DEVICE TYPE CODE               @
         CI        R6,U0.DTC       IS THIS THE GHOST CONTROLLER   @
         BEQ       STOR1           YES...SAVE GHOST CONTEXT BLK AD@
         LW        R6,PSIHA        RESTORE PRIM FIELDER ADDRESS   @
         LW        R3,DCA.CHTA,X2  TO THE CDT
         LW        R3,CHT.CDTA,X3  CDT ADDRESS FROM CHT           @
         STW       R6,CDT.SIHA,X3  RESTORE FIELDER HAT ADDRESS    @
         LW        R6,B.PCBBA      PRIME CNTXT ADR ALREADY ENTERED@
         BNZ       STORECBA        YES...BRANCH                   @
         STW       R2,B.PCBBA      NO...SAVE PRIME CNTXT BLK BASE @
         BU        STORECBA                                       @
STOR1    EQU       $                                              @
         LW        R6,GSIHA        RESTORE GHST FIELDER ADDRESS   @
         LW        R3,DCA.CHTA,X2  TO THE CDT
         LW        R3,CHT.CDTA,X3  CDT ADDRESS FROM CHT           @
         STW       R6,CDT.SIHA,X3  RESTORE FIELDER HAT ADDRESS    @
         LW        R6,B.GCBBA      GHOST CNTXT ADR ALREADY ENTERED@ EHW
         BNZ       STORECBA        YES...BRANCH                   @ EHW
         STW       R2,B.GCBBA      SAVE GHOST CNTXT BLK BASE ADDR @
STORECBA EQU       $
         TBM       MCG,B.GFLG      MULTIPLE CHANNEL GHOSTING?     @
         BS        ZER1            YES...BRANCH                   @
         LB        R6,UDT.DTC,X1   GET UDT DEVICE TYPE CODE       @
         CI        R6,U0.DTC       GHOST SUBCHAN?                 @
         BNE       ZER1            NO...BRANCH                    @
         LW        R6,B.GCBBA      GHOST BASE ADR ALREADY ENTERED?@
         BNZ       ZER1            YES...BRANCH                   @
         STW       R2,B.GCBBA      SAVE GHOST CNTXT BLK BASE ADDR @
ZER1     EQU       $                                              @
         LD        R6,REZERO       GET THE REZERO IOCD
         STW       R6,DCA.REZO,X2  INIT REZERO COMMAND IN DCA
         STW       R7,DCA.REZO+1W,X2
         LD        R6,TICCMD       GET THE STANDARD TIC COMMAND
         STW       R6,DCA.TIC,X2   INIT TIC CMMD IN DCA
         STW       R7,DCA.TIC+1W,X2
         LD        R6,NOPCMD       GET NOP IOCD                REV20017
         STW       R6,DCA.NOP,X2   STORE INTO                  REV20017
         STW       R7,DCA.NOP+1W,X2  THE DCA                   REV20017
         LD        R6,TICCMD       GET TIC IOCD                REV20017
         STW       R6,DCA.NOPT,X2    AND STORE INTO            REV20017
         STW       R7,DCA.NOPT+1W,X2 THE DCA ALSO.             REV20017
*** INITIALIZE SECTORS/CYLINDERS IN DCA
         ZR        R4              CLEAR WORK REG
         LB        R5,UDT.SPT,X1   GET SECTORS/TRACK FROM UDT
         MPMH      R4,UDT.NHDS,X1  TIMES # OF HEADS
         STW       R5,DCA.SCYL,X2  SAVE SEC/CYL IN DCA
         SPACE     2
*
** PROCEDURE TO DO SPECIAL INITIALIZATION FOR FLOPPY DISC
*
         SPACE
         LB        R5,UDT.DTC,X1   GET DEV TYPE CODE
         CI        R5,DFCODE       IS THIS DEV A HARD DISC ?
         BNE       SG.1.00         BR IF THIS DEV IS A HARD DISC
         SBM       5,UDT.STA2,X1   SET FLOPPY DISC BIT IN UDT
         SBM       3,UDT.STA2,X1   SET OPERATOR INTERVENTION FOR FLOPPY
         LW        R6,NOPCMD       GET NOP IOCD1
         STW       R6,DCA.RECC,X2  NOP READ ECC COMMAND
         LD        R6,FL.LMODE     GET FLOPPY LOAD MODE IOCD
         STW       R6,DCA.LMOD,X2  STORE IN DCA
         STW       R7,DCA.LMOD+1W,X2   STORE IOCD 2 IN DCA
         LI        R7,FLSLGTH          GET SENS BUFFER LENGTH FOR FLOPPY
         STW       R7,DCA.SENI+1W,X2   SET SENS BUFF LNGTH FOR FLOPPY
         ZR        R6              ZERO R6                          2102
         LNW       R7,DCA.TIMO+2W,X2    GET READ TIME OUT           2102
         MPI       R6,15           MULTIPLY BY 15                   2102
         TRN       R7,R7           NEGATE THE RESULT                2102
         STW       R7,DCA.TIMO+2W,X2    STORE INTO DCA              2102
         STW       R7,DCA.TIMO+3W,X2    STORE INTO DCA              2102
         LNW       R7,DCA.TIMO+10W,X2   GET UPSPACE TIMEOUT         2102
         MPI       R6,15           MULTIPLY BY 15                   2102
         TRN       R7,R7           NEGATE THE RESULT                2102
         STW       R7,DCA.TIMO+10W,X2   STORE INTO DCA              2102
         BU        SG.3.00         GOTO GET NEXT UDT
         SPACE     2
*
** PROCEDURE TO DO SPECIAL INIT FOR IOP DISC
*
         SPACE
SG.1.00  EQU       $
         LD        R6,DP.LMODE     GET LOAD MODE IOCD FOR HARD DISC
         STW       R6,DCA.LMOD,X2  STORE IN DCA
         STW       R7,DCA.LMOD+1W,X2   STORE IOCD WRD 2 IN DCA
         LA        R6,DCA.ECC,X2       GET      ADDRESS OF ECC DATA AREA
         ORMW      R6,RDECC        OR IN READ ECC CMD
         LW        R7,RDECC+1W     GET WRD 2 OF READ ECC IOCD
         STW       R6,DCA.RECC,X2  STORE WRD 1 OF READ ECC IN DCA
         STW       R7,DCA.RECC+1W,X2   STORE WRD 2 OF READ ECC IN DCA
         TBM       1,UDT.STA2,X1   IS THIS A IOP DISC
         BNS       SG.2.00         BR IF NOT IOP DISC
         LW        R3,DCA.CDTA,X2  GET CDT ADDRESS
         ZBM       0,CDT.IOST,X3   SET IOQ LINKED TO CDT
         ZBM       0,UDT.STA2,X1   SET IOQ LINKED TO CDT
         LW        R5,CDT.UDTA,X3  GET FIRST UDT ON THIS CDT
         LW        R4,=X'000FFFFF' GET ADDRESS MASK
         CMR       R5,R1           COMPARE ADDRESSES TO SEE IF 1ST UDT
         BNE       SG.3.00         BR IF NOT FIRST UDT
*                                  INIT NEEDS TO BE PERFORMED
         STW       R3,DCA.INCA,X2  SAVE CDT ADDR TO USE TO BUILD INC
*                                  DATA FOR THIS CDT
         BU        SG.3.00         GO GET NEXT UDT TO PROCESS
         SPACE     2
*
** PROCEDURE TO INIT DUAL PORTED DISC
*
         SPACE
SG.2.00  EQU       $
         ZMW       LASTINCA        ZERO INCA ADDRESS SAVE WORD      3200
*        NO SPECIAL DUAL PORT LOGIC FOR MPX2.0                      2102
*        CONTINUE WITH NEXT INSTRUCTION                             2102
         SPACE     2
*
** END SPECIAL LOGIC
*
         SPACE
SG.3.00  EQU       $
         DCA.INI2
         SPACE     2
*
** PROCEDURE TO SET UP CNTRLR INIT DATA
*
         SPACE
SG.4.00  EQU       $
         LA        R2,DCASTART     GET STARTING ADDR OF DCA
         SPACE     2
*
** PROCEDURE TO SETUP THE CNTRLR INIT DATA AREAS
*
         SPACE
SG.4.05  EQU       $
         TRR       R2,R6           SAVE DCA ADDR IN R6
         LW        R3,DCA.INCA,X2  DOES A INC BUFFER NEED TO BE SETUP
         BNZ       SG.4.06         BR IF INC BUFFER NEEDED          3200
         LW        R4,LASTINCA     GET THE INCA ADDRESS             3200
         STW       R4,DCA.INCA,R2  PUT IN ALL IOP DCA'S FOR USE BY  3200
         BU        SG.5.00         AUTODISK TO LOCATE DATR'S        3200
*** INCR OVERLAY ADDRESS AND CLEAR INC BUFFER
SG.4.06  LW        R4,=X'FFFFF'    GET 20 BIT ADDR MASK             3200
         LMW       R1,XEP8      GET FIRST ADDRESS TO BE OVERLAYED
         STW       R1,DCA.INCA,X2  BUILD INC BUFFER THERE & SET IN DCA
         STW       R1,LASTINCA     SAVE FOR LATER USE               3200
         TRR       R1,R5           MOVE INC IOCD ADDR INTO R5
         ADI       R5,2W           INCR R5 TO POINT TO CONFIG. DATA
         ORMW      R5,INCCMD       OR CONFIG DATA ADDR W/ INC CMD
         STW       R5,0W,X1        STORE IN 1ST WORD OF XTRA SPACE
         LW        R5,INCCMD+1W    GET 2ND WORD OF INC IOCD
         STW       R5,1W,X1        STORE IN 2ND WORD OF SPACE
         ADI       R1,2W           INCR R1 TO POINT TO DRIVE CONFIG
*                                  DATA SPACE
         LW        R5,NONPRES      GET NONPRES CONFIG DATA
         STW       R5,0W,X1        MARK ALL DRIVE NONPRES TO START
         STW       R5,1W,X1
         STW       R5,2W,X1
         STW       R5,3W,X1
         TRR       R1,R0           SAVE DRIVE CONFIG DATA ADDRESS
         ADI       R1,4W           INCR ADDR TO POINT TO NEXT DATA
*                                  AREA
         STW       R1,XEP8      STORE NEXT AREA ADDR TO START
*                                  OVERLAYING
         SPACE     2
*
** PROCEDURE TO BUILD DRIVE CONFIG. DATA FOR INC BUFFER
*
         SPACE
         LNB       R7,CDT.NUOC,X3  GET NUM OF UDT ON THIS CDT
         BZ        SG.5.00         IF NO DEVICES GET NEXT DCA
         LA        R2,CDT.UT0-1W,X3   GET GET ADDR OF ADDR OF 1ST UDT
*** LOOP THRU THIS CODE TO BUILD DRIVE CONFIG DATA
SG.4.10  EQU       $
         TRR       R0,R1           RESTORE INC BUFFER ADDRESS
         ABR       R2,29           INCR UDT POINTER BY 1W
         LW        R4,=X'FFFFF'    GET 20 BIT ADDR MASK
         LMW       R3,0W,X2        GET UDT ADDRESS TO PROCESS
         BZ        SG.4.10         BR IF NO UDT ADDRESS
         LI        R4,X'F'         GET SUBADDRESS MASK
         LMB       R4,UDT.SUBA,X3  GET DEV SUBADDR
         TBR       R4,31           IS IT A ODD SUBCHANNEL
         BS        SG.4.35         BR IF ODD SUBCHANNEL
*                                  ODD SUBCHANNEL FOR SECTION 2 OF
*                                  DUAL SECTION DISC. FIXED PORTION OF
*                                  CARTRIDGE MODULE DRIVE.
         SLL       R4,1            MAKE WORD OFFSET
         ADR       R4,R1           GET DRIVE CONFIG WORD ADDR FOR THIS
*                                  SUBCHANNEL
         ZMW       0W,X1           CLEAR DRIVE CONFIG LOC
         TBM       1,UDT.STAT,X3   IS THIS DISC DUAL PORTED ?
         BNS       SG.4.15         BR IF NOT DUAL PORTED
         SBM       5,0W,X1         SET DUAL PORT BIT IN CONFIG DATA
SG.4.15  EQU       $
         LB        R4,UDT.SPT,X3   GET SECTORS/TRACK
         STB       R4,1B,X1        PLACE IN DRIVE CONFIG WORD
         LH        R4,UDT.NHDS,X3  GET NUMBER OF HEADS
         LB        R5,UDT.DTC,X3   GET DEV TYPE CODE
         CI        R5,FHDCODE      IS IT A FIXED-HEAD DISC
         BNE       SG.4.20         BR IF NOT FIXED-HEAD DISC
*** SET UP FOR FHD
         SBM       0,0W,X1         SET FHD IN DRIVE CONFIG WORD
         STB       R4,3B,X1        PLACE # OF HEADS IN DRIVE CONFIG WRD
         BU        SG.4.40         GOTO END OF LOOP
         SPACE     2
*
** PROCEDURE TO SETUP CARTRIDGE MODULE DRIVE DATA
*
         SPACE
SG.4.20  EQU       $
         TBM       6,UDT.STA2,X3   IS THIS A CMD ?
         BNS       SG.4.25         BR IF NOT CMD
         SBM       2,0W,X1         SET CMD IN DRIVE CONFIG WORD
         STB       R4,2B,X1        STORE # OF HEAD FOR CMD IN CONFIG WRD
         BU        SG.4.40         GOTO END OF LOOP
         SPACE     2
*
** PROCEDURE TO SETUP MOVING-HEAD DISC W/ FIXED-HEAD OPTION (600 MB)
*
         SPACE
SG.4.25  EQU       $
         TBM       7,UDT.STA2,X3   IS THIS A MHD W/ FHO
         BNS       SG.4.30         BR IF NOT MHD W/ FHO
         SBM       0,0W,X1         SET FHD BIT IN DRIVE CONFIG WRD
         SBM       1,0W,X1         SET MHD BIT IN DRIVE CONFIG WRD
         STB       R4,2B,X1        SET # OF HEAD FOR MHD PART
         BU        SG.4.40         GOTO END OF LOOP
         SPACE     2
*
** PROCEDURE TO SETUP MHD CONFIG WORD
*
         SPACE
SG.4.30  EQU       $
         SBM       1,0W,X1         SET MHD BIT IN DRIVE CONFIG WRD
         STB       R4,2B,X1        SET # OF HEAD FOR MHD PART
         BU        SG.4.40         GOTO END OF LOOP
         SPACE     2
*
** PROCEDURE TO SETUP SECOND PORTION OF CARTRIDGE MODULE DRIVE OR
** FIXED HEAD PORTION OF MHD W/ FHO. THIS WILL BE ON UDT WITH A
** ODD SUBCHANNEL.
*
         SPACE
SG.4.35  EQU       $
         SUI       R4,1            DECR SUBCHANNEL ADDR BY 1 TO GIVE
*                                  CORRESPONDING EVEN SUBCHANNEL ADDR
         SLL       R4,1            MAKE WORD OFFSET
         ADR       R4,R1           GET ADDR OF DRIVE CONFIG WORD
         LH        R4,UDT.NHDS,X3  GET NUM OF HEAD FOR THIS PART
         STB       R4,3B,X1        STORE IN DRIVE CONFIG DATA
         SPACE     2
*
** END OF LOOP
*
         SPACE
SG.4.40  EQU       $
         BIB       R7,SG.4.10      REPEAT LOOP IF MORE UDT'S NEED
*                                  PROCESSING
         SPACE     2
*
** PROCEDURE TO SEARCH NEXT DCA FOR NEW CDT
*
         SPACE
SG.5.00  EQU       $
         TRR       R6,R2           RESTORE DCA ADDRESS
         ADMW      R2,DCA.SIZE,X2  GET NEXT DCA ADDRESS
         LW        R7,NUMDCAS      GET NUM OF DCA'S LEFT TO SEARCH
         SUI       R7,1            DECR DCA'S LEFT TO SEARCH
         STW       R7,NUMDCAS      SAVE # OF DCA'S LEFT TO SEARCH
         BGT       SG.4.05         REPT MAIN LOOP
         SPACE
*
** END SG. ENTRY POINT
*
         SPACE
         BU        SG.XI
         DATAB     C'(C) COPYRIGHT 1983 GOULD INC.,'
         DATAB     C' COMPUTER SYSTEMS DIVISION'
         DATAB     C' ALL RIGHTS RESERVED'
SG.XI    EQU       $
*                                                                 @
*        UPDATE PRIME/GHOST CONTEXT BLKS WITH TWIN & GIOQADR ADDRS@
         LW        R1,B.PCBBA      GET PRIME CONTEXT BLK BASE ADDR@
         LW        R2,B.GCBBA      GET GHOST CONTEXT BLK BASE ADDR@
         BZ        UP2             SKIP UPDATE IF NO GHOST CNTXT  @
         LW        R4,B.GIBA       GET GHOST GIOQ ARRAY BASE ADDR @
UP1      EQU       $                                              @
         STW       R2,TWIN,X1      GHOST CBA TO PRIME COUNTERPART @
         STW       R1,TWIN,X2      PRIME CBA TO GHOST COUNTERPART @
         STW       R4,GIOQADR,X1   GIOQ ADDR TO PRIME CONTEXT BLK @
         STW       R4,GIOQADR,X2   GIOQ ADDR TO GHOST CONTEXT BLK @
         SBM       GCB,DCA.FLAG,X2 INDICATE THIS GHOST CONTEXT BLK@
         ADMW      R1,DCA.SIZE,X1  INC TO NEXT PRIME CONTEXT BLK  @
         ADMW      R2,DCA.SIZE,X2  INC TO NEXT GHOST CONTEXT BLK  @
         ADI       R4,GIOQSIZ      INC TO NEXT GHOST GIOQ ARRAY   @
         CAMW      R1,B.GCBBA      ANY MORE PRIME CONTEXT BLKS?   @
         BLT       UP1             YES...BRANCH                   @
UP2      EQU       $                                              @
         M.XIR     HAT
         SPACE     4
*
**  SG. DATA AREA
*
         SPACE
         BOUND     1D
RDECC    DATAW     X'B2000000'     READ ECC COMMAND IOCD WRD 1
         DATAW     X'00000004'     SET TO XFER 1 WORD OF INFO.
REZERO   DATAW     X'37000000'     REZERO COMMAND FOR DIS
         DATAW     X'40000000'     CC SET IN FLGS
TICCMD   DATAW     X'08000000'     TIC COMMAND
         DATAW     X'40000000'     CC SET IN FLAGS
FL.LMODE DATAW     X'5F000000'     FLOPPY LOAD MODE IOCD FOR DUAL
*                                  DENSITY, 256 BYTE SECTORS
         DATAW     X'40000000'     LOAD MODE IOCD 2
DP.LMODE DATAW     X'1F000000'     LOAD MODE IOCD FOR IOP & DISC
*                                  PROCESSOR DISCS
         DATAW     X'40000001'     BYTE COUNT OF 1
INCCMD   DATAW     X'FF000000'     INC IOCD COMMAND
         DATAW     X'00000010'     WITH BYTE COUNT OF 16
NOPCMD   DATAW     X'03000000'     NOP COMMAND
         DATAW     X'40000000'     NOP CC FLAGS FOR RETRY      REV20017
NONPRES  DATAW     X'08000000'     NON-PRESENT DRIVE CONFIG DATA
*
LASTINCA DATAW     0               SAVE AREA FOR DCA.INCA           3200
*
PSIHA    DATAW     0               SAVE AREA FOR PRIM INT. FIELDER ADDR
GSIHA    DATAW     0               SAVE AREA FOR GHST INT. FIELDER ADDR
*
DFCODE   EQU       3               HIGHEST HARD DISC DTC
FHDCODE  EQU       3               FHD DTC
*
U0.DTC   EQU       X'11'           GHOST DEVICE TYPE CODE 'U0'    @
         TITLE     H.DCXIO         SYMBOL TABLE CROSS REFERENCE
         END
