   00001                                ************************************************************************
   00002                                *MI03                      MANAGEMENT INFORMATION                      *
   00003                                *    DEVICE ID: HH-65A                 HID:       XX.XX-01             *
   00004                                *    FILENAME:  FT_.A61                LANGUAGE:  ASSEMBLY             *
   00005                                *    LOAD MODUL:                       SYSTEM:    SM                   *
   00006                                *    COMPILER:                         ASSEMBLER: ASM V2.1A            *
   00007                                *    TRNR CPU:                         CPU TYPE:  SEL 32/77            *
   00008                                *    ITRTN RATE:                       MODE:                           *
   00009                                *    LINK EDITR:                                                       *
   00010                                *                                                                      *
   00011                                ************************************************************************
   00012                                *PU02                             PURPOSE                              *
   00013                                *                                                                      *
   00014                                ************************************************************************
   00015                                *TI02                      TECHNICAL INFORMATION                       *
   00016                                *    *KEYWORD* ENTP FT.                                                *
   00017                                *    *KEYWORD* ENTP FT.IR                                              *
   00018                                *    *KEYWORD* ENTP FT.NRML                                            *
   00019                                *                                                                      *
   00020                                ************************************************************************
   00021                                *PA02                        PROGRAM ATTRIBUTES                        *
   00022                                *    LOGICAL RECORDS:            245   GENERAL COMMENTS:            50 *
   00023                                *    FORTRAN LINES:                0   NON-FORTRAN LINES:          245 *
   00024                                *    EXECUTABLE FTN STMTS:         0   NON-EXEC FORTRAN STMTS:       0 *
   00025                                *                                                                      *
   00026                                ************************************************************************
   00027                                *CH02                          CHANGE HISTORY                          *
   00028                                *    REV   DATE        SOFTWARE ANALYST               EMPLOYER         *
   00029                                *                               DESCRIPTION OF CHANGE                  *
   00030                                *    01  18JUL95   JOHN RUCKSTUHL             NAWCTSD CODE 493         *
   00031                                *              INITIAL HEADER INSTALLATION                             *
   00032                                *                                                                      *
   00033                                ************************************************************************
   00035                                         PROGRAM   FT.
   00036                                ************************************************************************
   00037                                *
   00038                                * REV01 05/05/85 LTA DR N/A   FIX ONLINE/OFFLINE INTERMITTENTS
   00039                                *
   00040                                ************************************************************************
   00041                                *
   00042                                *
   00043                                *  EXTERNAL DEFINITIONS -
   00044                                *
   00045                                         DEF       FT.             FCNT  I/O HANDLER INITIALIZATION
   00046                                         DEF       FT.NRML         FCNT  I/O HANDLER NORMAL PROC.
   00047                                         DEF       FT.IR           ERROR INTERRUPT HANDLER
   00048                                *
   00049                                *
   00050                                *  EXTERNAL REFERENCES -
   00051                                *
   00052                                DATAPOOL COMMON    IFCBUF          FCNT  SYSTEM BUFFER ADDRESS
   00053                                *                                  49 WORDS RESERVED
   00054                                DATAPOOL COMMON    FVIOFF          FCNT  INOPERATIVE
   00055                                DATAPOOL COMMON    FSCEXEC         SC ERROR OUTPUT FLAG
   00056                                DATAPOOL COMMON    FCINIT         FCNT  INITALIZATION FLAG
   00057                                *
   00058                                *
   00059                                ************************************************************************
   00061                                ************************************************************************
   00062                                *
   00063                                *
   00064   P00000                                M.REQS                    REGISTER EQUATES
                                        !0001        ANOP
                                                 ENDM
   00065                                *
   00066                                *
   00067    0001B                       VSPL     EQU       X'1B'           FCNT  I/O PRIORITY LEVEL
   00068    0011C                       VSTCW    EQU       X'11C'          FCNT  I/O TCW (OR TAW)
   00069    0015C                       VSSI     EQU       X'15C'          INTERRUPT VECTOR ADDRESS
   00070    00030                       VSDA     EQU       X'30'           FCNT  I/O DEVICE ADDRESS
   00071                                *
   00072    08000                       STARTIO  EQU       X'8000'         HSD OPERATION CODE, START I/O
   00073    01000                       HALTIO   EQU       X'1000'         HSD OPERATION CODE, HALT I/O
   00074    08000                       TD8000   EQU       X'8000'         8000 LVL DEVICE TEST
   00075    02000                       TD2000   EQU       X'2000'         HSD DEVICE STATUS TEST
   00076                                *
   00077    00001                       NRMBIT   EQU       1               NORMAL PROCESS FLAG
   00078    00002                       TRMBIT   EQU       2               TERMINATION FLAG
   00079                                *
   00080                                ************************************************************************
   00082                                ************************************************************************
   00083                                *
   00084                                *  SUBROUTINE VS.INIT - FCNT  I/O HANDLER INITIALIZATION
   00085                                *
   00086                                *  INPUTS:
   00087                                *    R0 - RETURN ADDRESS
   00088                                *
   00089                                *  OUTPUTS:
   00090                                *    I/O TERMINATION OCCURS. (TO CLEAR HSD)
   00091                                *
   00092                                *    (R7 DESTROYED)
   00093                                *
   00094                                *  ITERATION RATE:
   00095                                *    1 TIME ONLY
   00096                                *
   00097                                *  DATAPOOL VARIABLES AFFECTED ON EXIT:
   00098                                *    (FSCEXEC)
   00099                                *
   00100                                *  LATEST UPDATE     : 9/14/83 CONVERT ERROR ON TD  IN VS.INIT TO SC
   00101                                *                              CONTROL IE. SET BIT 5 IN FSCEXEC ON ERROR
   00102                                *
   00103                                ************************************************************************
   00104                                *
   00105   P00000                       FT.      EQU       $               SUBROUTINE ENTRY
   00106                                *
   00107                                *
   00108                                ********  SELECT INITIALIZATION OR NORMAL *******
   00109                                *
   00110   P00000  AE080000   A00000             LB        R4,FCINIT      FCNT  INIT FLAG
   00111   P00004  EE000071   P00070             BZ        VS.X            RETURN IF FCNT  NOT INITALIZED
   00112                                *
   00113   P00008                                TC$PATH   FT.NRML,VS.X,VSMODE
           P00008  A48800C8   P000C8             TBM       NRMBIT,VSMODE
           P0000C  EC800059   P00058             BS        FT.NRML
           P00010  A50800C8   P000C8             TBM       TRMBIT,VSMODE
           P00014  EC800071   P00070             BS        VS.X
           P00018  988800C8   P000C8             SBM       NRMBIT,VSMODE
                                                 ENDM
   00114                                *
   00115   P0001C  82000074   P00074             LEAR      R4,FT.IR        INTERRUPT TO SET CPIX
   00116   P00020  D600015C    0015C             STW       R4,VSSI         SERVICE INTERRUPT VECTOR LOCATION
   00117                                *
   00118                                *        ZMB       FVIOFF          FCNT  IS OPERATIVE
   00119   P00024  820000B8   P000B8             LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
   00120   P00028  D600011C    0011C             STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
   00121                                *
   00122   P0002C  83800030   A00030             LEAR      R7,IFCBUF+12W   SET R7 = REAL ADDRESS OF FCNT  TBL
   00123   P00030  D78000BC   P000BC             STW       R7,IOCB+1W      . STORE AS MEMORY ADDRESS
   00124                                *
   00125   P00034  FCD90000                      DI        VSPL            DISABLE INTERRUPTS (I/O RUNS DISABLED
   00126                                *
   00127   P00038  FD861000                      CD        VSDA,HALTIO     ** TERMINATE FCNT  HSD ACTIVITY **
   00128                                *
   00129   P0003C  FD858000                      TD        VSDA,TD8000     TEST HSD CONTROLLER STATUS
   00130   P00040  F0000049   P00048             BFT       $+2W            BRANCH IF O.K.
   00131   P00044  9A880000   A00000             SBM       5,FSCEXEC       SET FOR SC ERROR OUTPUT
   00132                                *
   00133                                **********  SAVE INIT. INTERRUPT ADDRESS IN VECTOR  ************
   00134                                *
   00135   P00048  FCD80000                      EI        VSPL
   00136   P0004C  FCDA0000                      RI        VSPL            REQUEST INIT. INTERRUPT
   00137   P00050  0002                          NOP
   00138   P00052      0002                      NOP
   00139                                *
   00140                                *
   00141   P00054  2800                          TRSW      R0              RETURN TO CALLER
   00142   P00056      0002                      NOP
   00143                                *
   00144                                *
   00145                                ************************************************************************
   00147                                *
   00148                                *  THIS PAGE INTENTIONALLY LEFT BLANK -
   00149                                *
   00151                                ************************************************************************
   00152                                *
   00153                                *  SUBROUTINE FT.NRML - FCNT  I/O HANDLER, NORMAL PROCESSING
   00154                                *
   00155                                *  INPUTS:
   00156                                *    R0 - RETURN ADDRESS
   00157                                *    AVSCP - ADDRESS OF CURRENT PROCESSING
   00158                                *    IFCBUF - FCNT  OUTPUT TABLE
   00159                                *    STATUS WORD OF IOCB (PREVIOUS TRANSFER STATUS)
   00160                                *
   00161                                *  OUTPUTS:
   00162                                *    "HALT I/O" ISSUED TO THE FCNT , FOLLOWED BY FCNT  DATA OUTPUT
   00163                                *
   00164                                *    (R4 DESTROYED)
   00165                                *
   00166                                *  ITERATION RATE:
   00167                                *    30 HERTZ
   00168                                *
   00169                                ************************************************************************
   00170                                *
   00171   P00058                       FT.NRML  EQU       $               SUBROUTINE ENTRY
   00172   P00058  FCD90000                      DI        VSPL            DISABLE HSD INTERRUPT (TO CLEAR)
   00173                                *
   00174                                *  START FCNT  I/O -
   00175                                *
   00176                                *        LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
   00177                                *        STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
   00178                                *        CD        VSDA,HALTIO     ** TERMINATE HSD ACTIVITY **
   00179                                *
   00180                                *        ZMB       FVIOFF          FCNT  IS OPERATIVE
   00181   P0005C  820000B8   P000B8             LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
   00182   P00060  D600011C    0011C             STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
   00183   P00064  FCDB0000                      AI        VSPL
   00184   P00068  FD868000                      CD        VSDA,STARTIO    ** INITIATE HSD I/O TRANSFER **
   00185   P0006C  FCDC0000                      DAI       VSPL
   00186                                *
   00187                                *        LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
   00188                                *        STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
   00189                                *        CD        VSDA,HALTIO     ** TERMINATE HSD ACTIVITY **
   00190                                *
   00191   P00070  2800                 VS.X     TRSW      R0              RETURN TO CALLER
   00192                                *
   00193                                ************************************************************
   00195                                ************************************************************
   00196                                ******** SERVICE INTERRUPT SECTION        ********
   00197                                ******** INTERRUPT REQUESTED BY THIS      ********
   00198                                ******** ROUTINE IS BECAUSE OF AN ERROR   ********
   00199                                ******** THE INTERRUPT CONTROL IS ONLY    ********
   00200                                ******** SO THE COMPUTER WON'T HALT       ********
   00201                                *
   00202   P00074                                BOUND     1W
   00203   P00074                       FT.IR    EQU       $               INTERRUPT ICB BLOCK
   00204   P00074  00000000                      REZ       2W              SAVE OLD PSD HERE
           P00078  00000000
   00205   P0007C  8080008C   P0008C             GEN       12/X'808',20/W(VS.IP)   EXECUTE POINT
   00206   P00080  C0010000                      DATAW     X'C0010000'     BIT 47 RETAIN OLD MAP
   00207   P00084  00000000                      REZ       2W
           P00088  00000000
   00208                                *
   00209                                ********  SELECT INITIALIZATION OR NORMAL *******
   00210                                *
   00211   P0008C                       VS.IP    TC$PATH   VS.INRML,VS.IX,VSIMODE
           P0008C  A48800CC   P000CC             TBM       NRMBIT,VSIMODE
           P00090  EC8000AD   P000AC             BS        VS.INRML
           P00094  A50800CC   P000CC             TBM       TRMBIT,VSIMODE
           P00098  EC8000B5   P000B4             BS        VS.IX
           P0009C  988800CC   P000CC             SBM       NRMBIT,VSIMODE
                                                 ENDM
   00212                                *
   00213                                *        INITIALIZE INTERRUPT HANDLING
   00214                                *
   00215   P000A0  AE000078   P00078             LW        R4,FT.IR+1W     OBTAIN OWN TASK 2ND. PSD WORD
   00216   P000A4  1FC1                          ZBR       R4,15           CLEAR OLD RETAIN BIT
   00217                                *        ZBR       R4,16
   00218   P000A6      18C2                      SBR       R4,17           SET AUTOMATIC BLOCKED INTERRUPTS
   00219   P000A8  D6000080   P00080             STW       R4,FT.IR+3W     SAVE CPIX ETC. FOR NEW PSD
   00220                                *
   00221   P000AC                       VS.INRML EQU       $               NORMAL INTERRUPT PROCESSING
   00222   P000AC  F80000C4   P000C4             ZMW       IOCB+3W         CLEAR IOCB ERROR STATUS
   00223                                *
   00224   P000B0  FCDC0000                      DAI       VSPL
   00225   P000B4  FA800074   P00074    VS.IX    LPSDCM    FT.IR           RELEASE   "SET UP" INTERRUPT
   00226                                *
   00227                                *
   00228                                ************************************************************************
   00230                                ************************************************************************
   00231                                *
   00232                                *
   00233                                *  IOCB FOR HSD TRANSFER -
   00234                                *
   00235   P000B8                                BOUND     1W
   00236   P000B8  8000000B             IOCB     GEN       8/128,8/0,16/11   . OPCODE/DEVCODE/TRANSFER COUNT
   00237   P000BC  00000000                      DATAW     0               . MEMORY BUFFER ADDRESS
   00238   P000C0  00000000                      DATAW     0               . UNUSED
   00239   P000C4  00000000                      DATAW     0               . ERROR STATUS
   00240   P000C8  00000000             VSMODE   DATAW     0               STATUS FOR INT PROCESSING
   00241   P000CC  00000000             VSIMODE  DATAW     0               STATUS FOR INT PROCESSING
   00242   P000D0  56483031             ERRCODE  DATAW     C'VH01'         FCNT  I/O ERROR CODE
   00243                                *
   00244                                ************************************************************************
   00245   P000D4                                END
*  0000  ERRORS IN FT.
  
  A40000    FCINIT    *00056   00110
  A40000    FSCEXEC   *00055   00131
  P00000    FT.       *00105   00045
  P00074    FT.IR     *00203   00047   00115   00215   00219   00225
  P00058    FT.NRML   *00171   00046   00113
   01000    HALTIO    *00073   00127
  A40000    IFCBUF    *00052   00122
  P000B8    IOCB      *00236   00119   00123   00181   00222
   00001    NRMBIT    *00077   00113   00113   00211   00211
   00000    R0        *00064   00141   00191
   00004    R4        *00064   00110   00115   00116   00119   00120   00181   00182   00215   00216   00218
                       00219
   00007    R7        *00064   00122   00123
   08000    STARTIO   *00072   00184
   08000    TD8000    *00074   00129
   00002    TRMBIT    *00078   00113   00211
  P000AC    VS.INRML  *00221   00211
  P0008C    VS.IP     *00211   00205
  P000B4    VS.IX     *00225   00211
  P00070    VS.X      *00191   00111   00113
   00030    VSDA      *00070   00127   00129   00184
  P000CC    VSIMODE   *00241   00211   00211   00211
  P000C8    VSMODE    *00240   00113   00113   00113
   0001B    VSPL      *00067   00125   00135   00136   00172   00183   00185   00224
   0015C    VSSI      *00069   00116
   0011C    VSTCW     *00068   00120   00182
  B61EB0    M.REQS    *00064
