************************************************************************
*MI03                      MANAGEMENT INFORMATION                      *
*    DEVICE ID: HH-65A                 HID:       XX.XX-01             *
*    FILENAME:  CM_.A61                LANGUAGE:  ASSEMBLY             *
*    LOAD MODUL:                       SYSTEM:    RN                   *
*    COMPILER:                         ASSEMBLER: ASM V2.1A            *
*    TRNR CPU:                         CPU TYPE:  SEL 32/77            *
*    ITRTN RATE:                       MODE:                           *
*    LINK EDITR:                                                       *
*                                                                      *
************************************************************************
*PU02                             PURPOSE                              *
*                                                                      *
************************************************************************
*TI02                      TECHNICAL INFORMATION                       *
*    *KEYWORD* ENTP CM.                                                *
*                                                                      *
************************************************************************
*PA02                        PROGRAM ATTRIBUTES                        *
*    LOGICAL RECORDS:            489   GENERAL COMMENTS:            74 *
*    FORTRAN LINES:                0   NON-FORTRAN LINES:          489 *
*    EXECUTABLE FTN STMTS:         0   NON-EXEC FORTRAN STMTS:       0 *
*                                                                      *
************************************************************************
*SU01                         SUBPROGRAM USAGE                         *
*      NAME       NAME       NAME         NAME       NAME       NAME   *
*    TCM        TCMX       TI.          TI.SEC     TI.STRT             *
*                                                                      *
************************************************************************
*CH02                          CHANGE HISTORY                          *
*    REV   DATE        SOFTWARE ANALYST               EMPLOYER         *
*                               DESCRIPTION OF CHANGE                  *
*    01  18JUL95   JOHN RUCKSTUHL             NAWCTSD CODE 493         *
*              INITIAL HEADER INSTALLATION                             *
*                                                                      *
************************************************************************
*
      PROGRAM   CM.
*
********* REV 1 - 11/01/84 - BC - ADD CYCLE TIME LOGIC
********* REV 2 - 11/10/84 - LA - ADD INTER-CPU COMMUNICATIONS
**********************************************************************
*                                                                    *
*     CM IS THE CMS SYSTEM MODULE SCHEDULER; IT RUNS UNDER           *
*     CONTROL OF CPU TASK SC/,CM IS BIASED FOR IPU OPERATION.        *
*                                                                    *
*    SMCD1KEY          CDU #1 SCRATCHPAD SERVICE        5HZ          *
*    SMCD2KEY          CDU #2 SCRATCHPAD SERVICE        5HZ          *
*    SMCD1DSP          CDU #1 DISPLAY SERVICE           5HZ          *
*    SMCD2DSP          CDU #2 DISPLAY SERVICE           5HZ          *
*    SMRNC1PG          CDU #1 PAGE DECODER              5HZ          *
*    SMRNC2PG          CDU #2 PAGE DECODER              5HZ          *
*                                                                    *
*     IT SOULD BE NOTED THAT:
*         THE MODULE TIMER USES THE SAME VARIABLES AS THE
*         SM MODULE TIMER.  THEY CANNOT BE RUN AT THE SAME TIME!!!!!!!
*
*
**********************************************************************
*
*
*     EQUATE SECTION
*
         M.EQUS
         M.DQE.
ABBIT    EQU       31
MASK     EQU       4W              CALL TBLE. ENTRY MASK OFFSET
NAME     EQU       0               START   POSITION OF CALL BLOCK
STATUS   EQU       5W              STATUS OFFSET INTO CALL TABLE ENTRY
SHOW     EQU       6W              SHOW ITS RUNNING COUNTER
NRMBIT   EQU       1               NORMAL PROCESS BIT
TRMBIT   EQU       2               TERMINATION PROCESS BIT
DRDBIT   EQU       3               DRED MODE BIT
TIMER    EQU       X'77'           INTERVAL TIMER DEVICE CODE
READTMR  EQU       X'41'           READ FUNCTION VALUE
*
***************************************************************
*
*     EXTERNAL REFERENCE SECTION
*
         DEF       CM.
*
         EXT       TCM             MODULE TABLE START ADDRESS
         EXT       TCMX            MODULE TABLE END ADDRESS
         EXT       TI.             TIMER ROUTINE
         EXT       TI.STRT         TIMER START
         EXT       TI.SEC          CYCLE TIMER
*
****************************************************************
*
*        DATAPOOL REFERENCE SECTION
*
DATAPOOL COMMON    FRMASK          FRAME SEQUENCE BIT WORD
DATAPOOL COMMON    FSCEXEC         EXECUTIVE FLAGS
DATAPOOL COMMON    IRNNAME         ABORTED ROUTINE NAME
DATAPOOL COMMON    IRNABCDE        ABORT CODE
DATAPOOL COMMON    FSPCM4          TASK ACTIVE COUNTER
DATAPOOL COMMON    FSMACTIV        SM ACTIVE FLAG
DATAPOOL COMMON    ISMMODNM        MODULE NAME ON TIMING PAGE
DATAPOOL COMMON    ISMTIM          MODULE TIMER FRAME STORAGE
DATAPOOL COMMON    ISC30HZ         FRAME COUNTER
DATAPOOL COMMON    ITIMINDX        TIMER INDEX
DATAPOOL COMMON    FRMIPU          CYCLE TIMER
DATAPOOL COMMON    ITIMVNTS        CYCLE TIMER
DATAPOOL COMMON    IPUBOVRN        CYCLE TIMER
*
DATAPOOL COMMON    TSFID           INTER-CPU FLAGS
*
****************************************************************
*     PATH CONTROL
*****************************************************************
*
         LIST NOMAC NOLREP NODATA
*
         DATAW     C'CMID'         SM/ DUMP LOCATOR
*
CM.      EQU       $               TASK ENTRY POINT
*
*
         TC$PATH   CM.NRML,CM.TERM,ISCMFLG
*
CM.INIT  EQU       $
*
*
         BL        M.FBUFF         RESET BUFFER
         LD        R4,BLANK        INIT. FIELD BUFFER
         STD       R4,FLD1         FUNCTION FIELD
         STD       R4,FLD2         NAME FIELD
         STD       R4,FLD3         DATA FIELD
*
*
         M.SUAR    CM.ABRT         SET UP ABORT RECEIVER
*
         M.RCVR    M.COLL          SET UP MESSAGE RECEIVER
*
         BL        M.FBUFF         RESET BUFFER
*
*
         BU        CM.SUSP         SUSPEND TASK
*
*************************************************************
*     NORMAL PROCESSING POINT
*************************************************************
*
CM.NRML  EQU       $
*
********** FIRST SEE IF OPERATOR INTERACTION *****************
*
         SBM       12,IPUBOVRN     SET OVERRUN INDICATOR
*
         LI        R4,X'FF'        SM ACTIVE FLAG
         STB       R4,FSMACTIV     SAVE
*
         LW        R0,ITIMINDX     GET TIMER INDEX
         CI        R0,17           17=START OF CM/ TO END OF CM/
         BNE       $+2W            SKIP IF NOT 17
         BL        TI.STRT         START TIMER
*
         LD        R4,MESSAGE      LOOK FOR INPUT CHARACTERS
         CAMD      R4,BLANK        BLANKS MEAN
         BEQ       CM.CTP          NO MESSAGE,PROCESS AS IS
         BL        CM.MODM         INTERRPRET OPERATOR INPUT
*
*     **CALL MODULES FROM CALL PROCESS TABLE
*     ****TCM = CALL TABLE START
*     ****TCMX = CALL TABLE END
*     ****CM.CUR = CURRENT MODULE ADDRESS
*
CM.CTP   EQU       $
         CT$PROCT  TCM,TCMX,CM.CUR,MODSTTIM
         BU        CM.SUSP         SUSPEND TASK
*
*************************************************************:
*       COLLECT OPERATOR MESSAGE
**************************************************************
*
*
CM.MODM  EQU       $               COLLECT MESSAGE AND INTERPRET
*
         STF       R0,SMRSVE       SAVE SYSTEM REGISTERS
*
         ZR        R1              INIT. FIELD COUNT
         ZR        R5               "    CHARACTER COUNT
         LA        R3,MESSAGE      INDEX MESSAGE BUFFER
         LA        R2,FLD1         INDEX FIELD STOR GAGE
         TRR       R2,R6           SAVE FIELD
CM.CHAR  EQU       $
         LB        R4,0,X3         INPUT DATA CHARACTER
         CI        R4,G' '         BLANK ?
         BNE       CM.NCHAR        NO GET NEXT CHAR.
         ADI       R1,1            ITS A BLANK INCR. FIELD COUNT
         CI        R1,2            MORE THAN THREE?
         BGT       CM.A            YES,MESSAGE COMPLETE
         ADI       R3,1            NO INCFREMENT MESSAGE INDEX
         TRR       R6,R2           RESTORE FIELD BASE ADDRESS TO INDEX
         ADI       R2,2W           NEXT FIELD
         TRR       R2,R6           SAVE FIELD BASE FOR NEXT PASS
         ZR        R5              CLEAR CHAR./FIELD COUNT
         BU        CM.CHAR         GET FIRST CHAR. NEXT FIELD
CM.NCHAR EQU       $
         ADI       R5,1            INCR. CHAR.S PER FIELD
         CI        R5,8            CHAR.CNT.LIMIT IS 8(0-7)
         BGT       SMT.ERR         PROCESS INPUT ERROR
         STB       R4,0,X2         STORE CHARACTER
         ADI       R3,1            INCR. MESSAGE INDEX
         ADI       R2,1            INCR. STORE INDEX
         BU        CM.CHAR         GET NEXT CHARACTER
*
*         ANALIZE MESSAGE
*
CM.A     EQU       $
         LW        R4,FLD1         CONTENTS FIELD ONE
         LA        R1,FTABLE       INDEX FUNCTION TABLE ADDRESS
         LA        R5,FTABLEX      FUNCTION TABLE END ADDRESS
         ZMB       PRINDEX         ZERO PROCESS INDEX
CM.A1    LW        R6,0,X1         LOAD FUNCTION FROM TABLE
         EOR       R4,R6           COMPARE INPUT TO FUNCTION TABLE
         BZ        CM.MTCH         FOUND IT,FUNCTION MATCHED
         ADI       R1,1W           UPDATE TABLE INDEX
         CAR       R1,R5           COMPARE TO TABLE END
         BLT       SMT.ERR         DONE,BCAUSE WRONG INPUT
         ABM       7,PRINDEX       INCR. PROCESS INDEX
         BU        CM.A1           GET NEXT
*
*******  FUNCTION MATCHED, NOW COMPARE ROUTINE NAMES
*
CM.MTCH  EQU       $
*
*        LW        R4,FLD1         ETIM DOESN'T NEED
*        EOMW      R4,ETIM         THE MODULE NAME
*        BZ        CM.MTCH1        TO FUNCTION !
*
         LA        R1,TCM          TABLE START
         LA        R5,TCMX         TABLE END
CM.A2    EQU       $
         LD        R6,0,X1         LOAD NAME
         EOMD      R6,FLD2         COMPARE INPUT NAME TO TABLE
         BZ        CM.MTCH1        THEY MATCHED
         ADI       R1,8W           INDEX NEXT ENTRY
         CAR       R1,R5           COMPARE TO TABLE END
         BLT       SMT.ERR         NOT CORRECT ROUTINE NAME
         BU        CM.A2           GET NEXT FUNCTION
*
*     BOTH FUNCTION AND NAME ARE GOOD
*
*     THE JUMP TABLE ORDER MUST MATCH THE ORDER OF THE FUNCTION
*     TABLE (FTABLE), FOR INDEXING TO THE CORRECT ROUTINE.
*
*
CM.MTCH1 EQU       $
         LB        R2,PRINDEX      GET PROCESS INDEX
         SLL       R2,2            MAKE WORD ADDRESS
         BU        $+1W,X2         BRANCH TO PERTINENT PROCESS POINT
*
         BU        CM.STAR         START A MODULE
*
         BU        CM.STOP         STOP A MODULE
*
         BU        CM.STIM         START TIMING A MODULE
*
         BU        CM.ETIM         END A MODULE TIMING
*
         BU        CM.MASK         INSERT NEW MASK
*
CM.STAR  EQU       $
         ZBM       31,STATUS,X1    CLEAR THE "STOP" BIT
         BU        CM.CLFLD        NORMAL PROCESSING
*
CM.STOP  EQU       $
         SBM       31,STATUS,X1    SET THE STOP BIT
         BU        CM.CLFLD
*
CM.STIM  EQU       $
         SBM       05,FSCEXEC      SET GENERAL TIMING FLAG
         BS        SMT.ERR         IF NOT SET
         SBM       30,STATUS,X1    SET THE MODULE TIMING FLAG
         LD        R6,NAME,X1      SEND NAME TO GRAPHICS
         STD       R6,ISMMODNM     THROUGH DATAPOOL
         BU        CM.CLFLD        CLEAR MESSAGE FIELD
*
CM.ETIM  EQU       $
         TBM       30,STATUS,X1    RESET MODULE TIMING
         BNS       SMT.ERR         UNLESS NOT SET
         ZBM       30,STATUS,X1    IF SET CLEAR MODULE
         ZBM       05,FSCEXEC      AND GENERAL TIMING BITS
         ZBM       29,STATUS,X1    CLEAR PAGE NAME FLAG
*        CLEAR SCREEN              *
         LI        R1,-30W         NUMBER OF FRAMES
         ZR        R5              CLEAR WITH ZEROS
CM.CLRSC EQU       $
         STW       R5,ISMTIM+30W,X1                            CLEAR
         BIW       R1,CM.CLRSC     GET NEXT OF 30
*        REMOVE MODULE NAME FROM SCREEN                        *
         LD        R4,BLANK        BLANK THE NAME
         STD       R4,ISMMODNM
*
         BU        CM.CLFLD        CLEAR MESSAGE FIELD
*
CM.MASK  EQU       $
         LD        R4,FLD3         INPUT MASK VALUE
         STD       R4,MASK,X1      SAVE IT IN MODULE TBLE. ENTRY
*
CM.CLFLD EQU       $
         LD        R2,BLANK        RESET MESSAGE FIELD TO BLANKS
         STD       R2,FLD1         FUNCTION FIELD
         STD       R2,FLD2         ROUTINE NAME FIELD
         STD       R2,FLD3         DATA FIELD
*
         BL        M.FBUFF         BLANK OVER BUFFER
*
         LF        R0,SMRSVE       RESTORE REGISTERS
         TRSW      R0              RETUCM TO MAIN CM.
*
         BOUND     1W              FORCE WORD BOUNDARY AFTER TRSW
*
SMT.ERR  EQU       $
         BL        M.FBUFF         RESET INPUT BUFFER
         SBM       07,FSCEXEC      SET OPERATOR INPUT ERROR
         BU        CM.SUSP         SUSPEND AFTER ERROR
*
***************************************************************
*
*      MESSAGE RECEIVER INTERRUPT AND EXIT POINT              *
*
***************************************************************
*
         LIST      NONG
         BOUND     1W              FORCE WORD BOUNDARY
M.COLL   EQU       $
*
         M.GMSGP   RECBLK          MESSAGE INTERRUPT POINT
*
*
         M.XMSGR   MEXIT           MESSAGE INT. EXIT SERVICE
*
         BU        CM.SUSP         SUSPEND
*
*
************************************************************
*     CM ABORT PROCESSOR
************************************************************
*
*       ABORT HANDLER SET UP BY MPX,M.SUAR SERVICE AND
*   REACHED WHEN SYSTEM ABORT OCCURS.
*
CM.ABRT  EQU       $
*
*        LW        R2,C.CURR       CURRENT DQE ADDRESS
*        LW        R5,DQE.ABC,X2   COLLECT ABORT CODE FOR OUTPUT
*        STW       R5,IRNABCDE     OUTPUT BUFFER CODE WORDS
*        LW        R5,DQE.ABC+1W,X2
*        STW       R5,IRNABCDE+1W
*        LW        R5,DQE.ABC+2W,X2
*        STW       R5,IRNABCDE+2W
*
*
         LW        R3,CM.CUR       CURRENT SM/ CALL PROCESS ADDRESS
*
         LD        R4,0W,X3        NAME,OFFENDING ROUTINE
         STD       R4,IRNNAME      TO OUTPUT BUFFER
*
         SBM       ABBIT,STATUS,X3 SET ABORT BIT FOR THIS ROUTINE
*
         SBM       06,FSCEXEC      SIGNAL ABORT MESSAGE
*
         BU        CM.             SUSPEND SM/
*
*************************************************************
*     TERMINATION POINT
*************************************************************
*
CM.TERM  EQU       $
*
         ZBM       NRMBIT,ISCMFLG  SO SM/ WILL REINITIALIZE
         M.EXIT
*
**************************************************************
**********  TASK SUSPENSION   ********************************
*
CM.SUSP  EQU       $
*
         LW        R0,ITIMINDX     GET TIMER INDEX
         CI        R0,102          CYCLE TIMER?
         BEQ       CM.CT           YES
         CI        R0,16           16=TOP TO END OF CM/
         BEQ       $+3W            TIME IF = 16
         CI        R0,17           17=JUST CM/
         BNE       $+2W            SKIP IF NOT 17 EITHER
         BL        TI.              CALCULATE & STORE FRAME TIMER
         BU        CM.NCT          SKIP CYCLE TIMING
*
CM.CT    EQU       $               CYCLE TIMER
*
         BL        TI.SEC          CALL CYCLE TIMER
         STW       R1,FRMIPU       STORE TIME CONTRIB.
         ABM       31,ITIMVNTS     BUMP EVENTS COUNTER
         ZBM       12,IPUBOVRN     RESET OVERRUN INDICATOR
*
CM.NCT   EQU       $
*
         ZMB       FSMACTIV        CLEAR SM ACTIVE FLAG
*
         M.SUSP    CMTASK,CMTASK
*
         TBM       TRMBIT,TSFID    TERMINATION BIT?
         BS        CM.TERM         YES, EXIT
*
         TBM       DRDBIT,TSFID    DRED MODE BIT?
         BS        CM.TERM         YES, EXIT
*
         BU        CM.             RETURN WHEN RESUMED
*
*************************************************************
********** RESET BUFFER SUBROUTINE **************************
*
M.FBUFF  EQU       $
         LA        R1,MESSAGE      BUFFER START ADDRESS
         LI        R2,-72          BYTE COUNT
         LB        R4,=C' '        BLANK
M.BLANK  STB       R4,0B,X1        STORE BLANK
         ADI       R1,1            BUMP INDEX
         BIB       R2,M.BLANK      KEEP ON BLANKING
         TRSW      R0              RETUCM
*
**************************************************************
*     LOCAL DATA SECTION
**************************************************************
*
ISCMFLG  REZ       1B              CM PATH SELECTION FLAG
PRINDEX  REZ       1B              PRINT INDEX
*
         BOUND     1W
ABRECADR ACW       CM.ABRT         ABORT SECTION ADDRESS
*
         BOUND     1D
CMTASK   DATAD     0               SUSPND OWN TASK
CM.ERRM  DATAD     C'INERR'        INPUT ERROR MESSAGE
INFADDR  DATAD     C'IN/FLT'
COUNT    DATAW     0
CM.CUR   REZ       1D              CURRENT EXECUTING MODULE ADDRESS
DPLNAME  DATAD     C'DATAPOOL'
GLBNAME  DATAD     C'GLOBAL01'
         BOUND     1D
         RES       1W
TSKENTRY EQU       $
TSKNUM   RES       1W
TASK     DATAD     C'IN/FLT'
OWNER    DATAD     0
         RES       2W
*
********* MESSAGE BUFFER *******************************
MESSAGE  REZ       72B             MESSAGE RECEIVE BUFFER
*
*
         BOUND     1W              FORCE WORD BOUNDARY
RECBLK   EQU       $
         GEN       8/0,24/W(MESSAGE)
         GEN       16/72,16/0      MESS. MAX./ACTUALL
         DATAW     0
         DATAW     0
         DATAW     0
*
MEXIT    EQU       $
         REZ       2W              EXIT BUFFER
*
         BOUND     1D              FORCE DOUBLE WORD BOUNDARY
*
FLD1     REZ       2W              MESSAGE FIELD 1   FUNCTION
FLD2     REZ       2W                "       "   2   ROUTINE NAME
FLD3     REZ       2W                "       "   3   DATA
*
*           FUNCTION TABLE
*
FTABLE   EQU       $
         DATAW     C'STAR'         START FUNCTION
         DATAW     C'STOP'         OBVIOUS
         DATAW     C'STIM'         START A MODULE TIMING
ETIM     DATAW     C'ETIM'         END A MODULE TIMING
         DATAW     C'MASK'         CHANGE MASK VALUE FUNCTION
FTABLEX  EQU       $-1W
*
BLANK    DATAD     C' '
*
*
SMRSVE   REZ       1F              STORE REGISTERS
*
MODSTTIM DATAW     0               START TIME FOR MODULE TIMING
*
         END       CM.
