#~!Makefile for make
# Name:  Makefile Part No.: _______-____r
#
# Copyright 1994 - J B Systems, Morrison, CO
#
# The recipient of this product specifically agrees not to distribute,
# disclose, or disseminate in any way, to any one, nor use for its own
# benefit, or the benefit of others, any information contained  herein
# without the expressed written consent of J B Systems.
#
#                     RESTRICTED RIGHTS LEGEND
#
# Use, duplication, or disclosure by the Government is  subject  to
# restriction  as  set forth in paragraph (b) (3) (B) of the Rights
# in Technical Data and Computer Software  Clause  in  DAR  7-104.9
# (a).
#

#ident	"$Id: makefile,v 1.4 1995/03/04 00:56:21 jbev Exp $"

# Make parameters when running on MPX

ROOT = /system/system
TARGET = /system/system
SOURCE = .
PREFIX = nb
INCLUDE = /system/$(PREFIX)include
SINCLUDE = $(INCLUDE)
SBIN = /system/system
BIN = /system/bin
UBIN = /system/bin
LIB = /system/bin
YBIN = /system/bin
CPP = $(LIB)/$(PREFIX)cpp
CPFLAGS = -M
CC = $(UBIN)/$(PREFIX)cc
CFLAGS = -DMPX #-N 
LD = $(UBIN)/$(PREFIX)nbcat
LDFLAGS = -Ymakemap
YACC = $(YBIN)/$(PREFIX)yacc
YFLAGS =
MAKEFILE = makefile.mo

# Fill in with correct information

OBJECTS = main.o doname.o files.o rules.o dosys.o gram.o dyndep.o misc.o docd.o

HDRS = ar.h defs.h

SRCS = main.c doname.c files.c rules.c dosys.c gram.y dyndep.c misc.c docd.c

MAIN = make

ALL:	all

all:	$(MAIN)
	$(BIN)/echo $(MAIN) is up to date.

$(MAIN):	$(MAKEFILE) $(OBJECTS)
	$(CC) $(LDFLAGS) $(OBJECTS) -K/system/bin/mo -Rmodirs -o $(MAIN)
	$(BIN)/chmod 775 $(MAIN)
	$(BIN)/chgrp system $(MAIN)
	$(BIN)/chown system $(MAIN)

CLEAN:  clean

clean:
	$(BIN)/rm -f $(OBJECTS)

CLOBBER: clobber

clobber: clean
	$(BIN)/rm -f $(MAIN)

DEPEND: depend

depend: $(SRCS) $(HDRS) $(MAKEFILE)
	$(BIN)/mkdep $(MAKEFILE) >dep.out
	@for i in $(SRCS); do \
	$(BIN)/echo "# Source file '$$i'" >> dep.out; \
	$(CPP) $(CPFLAGS) $$i >> dep.out; \
	done;
	$(BIN)/echo "# End of dependencies" >> dep.out;
	$(BIN)/mv dep.out $(MAKEFILE)

INSTALL: install

install: all
	$(BIN)/cp $(MAIN) $(BIN)/$(MAIN)
	$(BIN)/cp $(MAIN) $(ROOT)/$(MAIN)

# DO NOT DELETE THIS LINE -- the dependencies begin here
