/* allo.c */

# include "mfile2.h"
NODE resc[3];
int busy[REGSZ];
int maxa, mina, maxb, minb;
allo0(){ /* free everything */
 register i;
 maxa = maxb = -1;
 mina = minb = 0;
 REGLOOP(i){
  busy[i] = 0;
  if( rstatus[i] & STAREG ){
   if( mina<0 ) mina = i;
   maxa = i;
  }
  if( rstatus[i] & STBREG ){
   if( minb<0 ) minb = i;
   maxb = i;
  }
 }
 if (xdebug) fprintf(of, "mina = %d, maxa = %d, minb = %d, maxb = %d\n",
 mina,maxa,minb,maxb);
}
# define TBUSY 01000
allo( p, q ) NODE *p;
struct optab *q;
{
char *opstri();
 register n, i, j ,k;
 n = q->needs;
 i = 0;
 if( n & NRMASK ) { /* need certain specific registers */
  if( n & NREG0) {
   resc[i].in.op = REG;
   resc[i].tn.rval = freereg(p, n & (NREG0|NRSL|NRSR));
   resc[i].tn.lval = 0;
   MVNAME(resc[i].in.name, "");
   ++i;
  }
  if( n & NREG1) {
   resc[i].in.op = REG;
   resc[i].tn.rval = freereg(p, n & (NREG1|NRSL|NRSR));
   resc[i].tn.lval = 0;
   MVNAME(resc[i].in.name, "");
   ++i;
  }
 }
 while( n & NACOUNT ){ /* need one or more A registers */
  resc[i].in.op = REG;
  resc[i].tn.rval = freereg( p, n&NAMASK );
  resc[i].tn.lval = 0;
  MVNAME(resc[i].in.name, "");
  n -= NAREG;
  ++i;
 }
 while( n & NBCOUNT ){ /* need one or more B registers */
  resc[i].in.op = REG;
  resc[i].tn.rval = freereg( p, n&NBMASK );
  resc[i].tn.lval = 0;
  MVNAME(resc[i].in.name, "");
  n -= NBREG;
  ++i;
 }
 if( n & NTMASK ){ /* need temp space on stack */
  resc[i].in.op = OREG;
  resc[i].tn.rval = TMPREG;
  if( p->in.op == STCALL || p->in.op == STARG ){
   resc[i].tn.lval = freetemp( (SZCHAR*p->stn.stsize + (SZINT-1))
       );
  }
  else {
   resc[i].tn.lval = freetemp( (n&NTMASK)/NTEMP );
  }
  MVNAME(resc[i].in.name, "");
  resc[i].tn.lval = BITOOR(resc[i].tn.lval);
  ++i;
 }
 /* turn off "temporarily busy" bit */
 REGLOOP(j){
  busy[j] &= ~TBUSY;
 }
  if(xdebug) {
   fprintf(of, "resc pseudo-trees\n");
   for (k=0; k<3; k++)  
   fprintf(of,"tree %d: op= %s: rval= %s\n",
    k,opstri(resc[k].in.op),rnames[resc[k].tn.rval]);
  }
 for( j=0; j<i; ++j ) if( resc[j].tn.rval < 0 ) return(0);
 return(1);
}
freetemp( k ){ /* allocate k integers worth of temp space */
 /* we also make the convention that, if the number of words
       is more than 1,
  /* it must be aligned for storing doubles... */
 int t;
 if( k>1 ){
  SETOFF( tmpoff, ALDOUBLE );
 }
 t = tmpoff;
 tmpoff += k*SZINT;
 if( tmpoff > maxoff ) maxoff = tmpoff;
 if( tmpoff-baseoff > maxtemp ) maxtemp = tmpoff-baseoff;
 return(t);
}
freereg( p, n ) NODE *p;
{
 /* allocate a register of type n */
 /* p gives the type, if floating */
 register j;
 register bank;
 if( n&NAMASK ){
  /* not general; means that only one register (the result) OK for call*/
  switch( p->in.op ){
  case CALL:
  case UNARY CALL:
  case FORTCALL:
  case UNARY FORTCALL:
   j = callreg(p);
   if( usable( p, n, j ) ) return( j );
   cerror( "call-register busy" );
  }
 }
 if( n & NRMASK) {
  switch(n&(NREG0|NREG1)) {
  case NREG0:
   j = R0;
   break;
  case NREG1:
   j = R1;
   break;
  default:
   return(-1);
  }
  if( usable(p, n, j) )  return(j);
  else return(-1);
 }
 j = p->in.rall & ~MUSTDO;
 if( j!=NOPREF && usable(p,n,j) ){ /* needed and not allocated */
  return( j );
 }
 if( n&NAMASK ){
  /* If we need an A reg, don't waste a B */
  bank = -1;
  for( j=mina; j<=maxa; ++j ) if( rstatus[j]&STAREG ){
   if( usable(p,n,j) ){
    bank = j;
    if(rstatus[j]&STBREG)
     continue;
    return( j );
   }
  }
  return( bank );
 }
 else if( n &NBMASK ){
  if( p->in.op == CALL || p->in.op == UNARY CALL ){
   j = callreg(p);
   if( usable( p, n, j ) ) return(j);
   cerror( "call-register busy" );
  }
  for( j=minb; j<=maxb; ++j ) if( rstatus[j]&STBREG ){
   if( usable(p,n,j) ){
    return(j);
   }
  }
 }
 return( -1 );
}
usable( p, n, r ) NODE *p;
{
 /* decide if register r is usable in tree p to satisfy need n */
 /* checks, for the moment */
 if( !istreg(r) ) cerror( "usable asked about nontemp register" );
 if( busy[r] > 1 ) return(0);
 if ((n & NAMASK) && !isareg(r)) return(0);
 if ((n & NBMASK) && !isbreg(r)) return(0);
 if( (n&NAMASK) && (szty(p->in.type) == 2) ){ /* only do the pairing for
    real regs */
  if( r&01 ) return(0);
  if( !istreg(r+1) ) return( 0 );
  if( busy[r+1] > 1 ) return( 0 );
  if( busy[r] == 0 && busy[r+1] == 0  ||
      busy[r+1] == 0 && shareit( p, r, n ) ||
      busy[r] == 0 && shareit( p, r+1, n ) ){
   busy[r] |= TBUSY;
   busy[r+1] |= TBUSY;
   return(1);
  }
  else return(0);
 }
 if( busy[r] == 0 ) {
  busy[r] |= TBUSY;
  return(1);
 }
 /* busy[r] is 1: is there chance for sharing */
 return( shareit( p, r, n ) );
}
shareit( p, r, n ) NODE *p;
{
 /* can we make register r available by sharing from p
     given that the need is n */
 if( (n&(NASL|NBSL|NRSL)) && ushare( p, 'L', r ) ) return(1);
 if( (n&(NASR|NBSR|NRSR)) && ushare( p, 'R', r ) ) return(1);
 return(0);
}
ushare( p, f, r ) NODE *p;
{
 /* can we find a register r to share on the left or right
   (as f=='L' or 'R', respectively) of p */
 p = getlr( p, f );
 if( p->in.op == UNARY MUL ) p = p->in.left;
 if( p->in.op == OREG ) return( r==p->tn.rval );
 if( p->in.op == REG ){
  return( r == p->tn.rval || ( szty(p->in.type) == 2 && r==p->tn.rval
     +1) );
 }
 return(0);
}
recl2( p ) NODE *p;
{
 if( p->in.op == REG ) rfree( p->tn.rval, p->in.type );
 else if( p->in.op == OREG ) rfree( p->tn.rval, PTR+INT );
}
rfree( r, t ){
 /* mark register r free, if it is legal to do so */
 /* t is the type */
 if( rdebug ){
  fprintf(of,  "rfree( %s ), size %d\n", rnames[r], szty(t) );
 }
 if( istreg(r) ){
  if( --busy[r] < 0 ) cerror( "register overfreed");
  if( szty(t) == 2 ){
   if( (r&01) || !istreg(r+1) ) cerror( "illegal free" );
   if( --busy[r+1] < 0 ) cerror( "register overfreed" );
  }
 }
}
rbusy(r,t) {
 /* mark register r busy */
 /* t is the type */
 if( rdebug ){
  fprintf(of,  "rbusy( %s ), size %d\n", rnames[r], szty(t) );
 }
 if( istreg(r) ) ++busy[r];
 if( szty(t) == 2 ){
  if( (r&01) || !istreg(r+1) ) cerror( "illegal register pair freed" );
  ++busy[r+1];
 }
}
rwprint( rw ){ /* print rewriting rule */
 register i, flag;
 static char * rwnames[] =  {
  "RLEFT",
  "RRIGHT",
  "RESC1",
  "RESC2",
  "RESC3",
  0,
 };
 if( rw == RNULL ){
  fprintf(of,  "RNULL" );
  return;
 }
 if( rw == RNOP ){
  fprintf(of,  "RNOP" );
  return;
 }
 flag = 0;
 for( i=0; rwnames[i]; ++i ){
  if( rw & (1<<i) ){
   if( flag ) fprintf(of,  "|" );
   ++flag;
   fprintf(of,  rwnames[i] );
  }
 }
}
reclaim( p, rw, cookie ) NODE *p;
{
 register NODE **qq;
 register NODE *q;
 register i;
 NODE *recres[5];
 struct respref *r;
 /* get back stuff */
 if( rdebug ){
#ifdef NBC
  fprintf(of,  "reclaim( %o, ", p );
#else
  fprintf(of,  "reclaim( %x, ", p );
#endif
  rwprint( rw );
  fprintf(of,  ", " );
  prcook( cookie );
  fprintf(of,  " )\n" );
 }
 if( rw == RNOP || ( p->in.op==FREE && rw==RNULL ) ) return;
        /* do nothing */
 walkf( p, recl2 );
 if( rw == RNULL || (cookie&FOREFF) ){ /* totally clobber,
           leaving nothing */
  tfree(p);
  return;
 }
 /* handle condition codes specially */
 if( (cookie & FORCC) && (rw&RESCC)) {
#ifndef NBC
  if (rdebug) {
    fprintf (of, "CC'S BEGIN reclaim( %x, ", p);
    rwprint (rw);
    fprintf (of, ", ");
    prcook (cookie);
    fprintf (of, " )\n");
  }
#endif
  /* result is CC register */
  tfree(p);
  p->in.op = CCODES;
  p->tn.lval = 0;
  p->tn.rval = 0;
#ifndef NBC
  if (rdebug) {
    fprintf (of, "CC'S END reclaim( %x, ", p);
    rwprint (rw);
    fprintf (of, ", ");
    prcook (cookie);
    fprintf (of, " )\n");
  }
#endif
  return;
 }
 /* locate results */
 qq = recres;
 if( rw&RLEFT) *qq++ = p->in.left;
 if( rw&RRIGHT ) *qq++ = p->in.right;
 if( rw&RESC1 ) *qq++ = &resc[0];
 if( rw&RESC2 ) *qq++ = &resc[1];
 if( rw&RESC3 ) *qq++ = &resc[2];
 if( qq == recres ){
  cerror( "illegal reclaim");
 }
 *qq = NIL;
 /* now, select the best result, based on the cookie */
 for( r=respref; r->cform; ++r ){
  if( cookie & r->cform ){
   for( qq=recres; (q= *qq) != NIL; ++qq ){
    if( tshape( q, r->mform ) ) goto gotit;
   }
  }
 }
 /* we can't do it; die */
 cerror( "cannot reclaim");
gotit:
 if( p->in.op == STARG ) p = p->in.left;  /* STARGs are still STARGS */
 q->in.type = p->in.type;  /* to make multi-register allocations work */
 /* maybe there is a better way! */
 q = tcopy(q);
 tfree(p);
 p->in.op = q->in.op;
 p->tn.lval = q->tn.lval;
 p->tn.rval = q->tn.rval;
 MVNAME(p->in.name, q->in.name);
#ifdef ONEPASS
 p->stn.stalign = q->stn.stalign;
#endif
 q->in.op = FREE;
 /* if the thing is in a register, adjust the type */
 switch( p->in.op ){
 case REG:
  if(xdebug) {
   for (i = 0; i < 8; i++) fprintf(of, "%d ",busy[i]);
   fprintf(of, "\n");
  }
  /*
    else if( p->in.type == FLOAT ) p->in.type = DOUBLE;
  */
  if( ! (p->in.rall & MUSTDO ) ) return;  /* unless necessary, ignore it */
  i = p->in.rall & ~MUSTDO;
  if( i & NOPREF ) return;
  if( i != p->tn.rval ){
   rmove( i, p->tn.rval, p->in.type );
   if( busy[i] || ( szty(p->in.type)==2 && busy[i+1] ) ){
    cerror( "faulty register move" );
   }
   rbusy( i, p->in.type );
   rfree( p->tn.rval, p->in.type );
   p->tn.rval = i;
  }
 case OREG:
  if( (busy[p->tn.rval]>1) && istreg(p->tn.rval) )
          cerror( "potential register overwrite");
 }
}
ncopy( q, p ) NODE *p, *q;
{
 /* copy the contents of p into q, without any feeling for
     the contents */
 /* this code assume that copying rval and lval does the job;
     in general, it might be necessary to specail case the
     operator types */
 register i;
 q->in.op = p->in.op;
 q->in.rall = p->in.rall;
 q->in.type = p->in.type;
 q->tn.lval = p->tn.lval;
 q->tn.rval = p->tn.rval;
 MVNAME(q->in.name, p->in.name);
#ifndef ONEPASS
 q->in.stn.stalign = p->in.stn.stalign;
#endif
}
NODE *
tcopy( p ) NODE *p;
{
 /* make a fresh copy of p */
 NODE *q;
 ncopy( q=talloc(), p );
 if( p->in.op == REG ) rbusy( p->tn.rval, p->in.type );
 else if( p->in.op == OREG ) rbusy( p->tn.rval, PTR+INT );
 switch( optype(q->in.op) ){
 case BITYPE:
  q->in.right = tcopy(p->in.right);
 case UTYPE:
  q->in.left = tcopy(p->in.left);
 }
 return(q);
}
allchk(){
 /* check to ensure that all register are free */
 register i;
 REGLOOP(i){
  if( istreg(i) && busy[i] ){
   cerror( "register allocation error");
  }
 }
}
