/* gram.y */
%{
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

#ifndef lint
/*NOBASE*/
static char *rcsid = "@(#) (Gould) $Header: gram.y,v 5.5 89/05/12 12:35:46 pcc Rel-3_0 $";
#endif

%}

%{
/*
 *	grammar for instruction operands
 */

#include "struct.h"
#include "operand.h"

OPND result;
OPND        opzero =
{
    MEMORY, CONST, 0, 0, 0, 0
};
#define SOMEREGS(a) if(a.haveseen & (AREG|BREG))
#define TWOREGS(a) if((a.haveseen&(AREG|BREG))==(AREG|BREG))
%}
%union {
    int opchar;
    OPND o;
}

%token <o> IDENT NUMBER 
%left <o> '|' '&' '^'
%left <o> '<' '>'
%left <o> '+' '-'
%left <o> '*' '/' '%'
%left <o> UMINUS '~'
%type <o> m
%type <o> e

%%
operand	: m
	{
	    result=$1;
	    result.type=OPERROR;
	    SOMEREGS(result) {
		if( result.haveseen&~(AREG|BREG) ){
		    goto noregshere;
		}
		else {
		    TWOREGS(result){
			error("Cant have REG op BREG here");
		    } else {
			if( result.haveseen&AREG ){
			    result.type=REGISTER;
			    result.constval= result.regval;
			} else {
			    result.type=BASE;
			    result.constval= result.baseval;
			    
			}
		    }
		}
	    } else {
		result.type = MEMORY;
	    }
	}
	| '#' m
	{
	    result=$2;
	    SOMEREGS(result){
		goto noregshere;
	    }
	    if( result.haveseen == CONST ){
		result.type=IMMEDIATE;
	    } else
		result.type = CONSTANT;
	}
	| '#' '#' m
	{
	    result=$3;
	    result.type=IMMEDIATE;
	    SOMEREGS(result){
		goto noregshere;
	    }
	}
	| '[' e ']' 
	{
	    result=$2;
	    result.type=INDEXED;
	    if( $2.haveseen & ~(AREG|BREG) ){
		error("illegal expression inside []");
		result.type=OPERROR;
	    }
	}
	| m '[' e ']'
	{
	    result= $1;
	    result.regval = $3.regval;
	    result.baseval = $3.baseval;
	    result.haveseen |= $3.haveseen;
	    result.type = INDEXED;

	    if( $3.haveseen & ~(AREG|BREG) ){
		error("illegal expression inside []");
		result.type=OPERROR;
	    }
	    if (($3.haveseen & AREG) && ($3.regval == 0))
	    {
		if (pass == 1)
		{
		warning("indexed r0 (except if class F I/O instruction)");
		}
	    }
	    SOMEREGS($1){
	    noregshere:
		error("must have registers inside [] or standalone");
		result.type=OPERROR;
	    }
	}
	;


m:	e
	    {
		$$ = $1;
#ifdef NEW_LIL
		$$.ishalf = 0;
#else /* NOT NEW_LIL */
		$$.lowhalf = 0;
#endif /* NEW_LIL */
	    }
	| '`' '`' e
	    {
		$$ = $3;
#ifdef NEW_LIL
		$$.ishalf = 2;
#else /* NOT NEW_LIL */
		$$.lowhalf = 0;
		error("highhalf operator (``) not allowed");
#endif /* NEW_LIL */
	    }
	| '`' e
	    {
		$$ = $2;
#ifdef NEW_LIL
		$$.ishalf = 1;
#else /* NOT NEW_LIL */
		$$.lowhalf = 1;
#endif /* NEW_LIL */
	    }
	;

e:	IDENT
	    
	| NUMBER
	    
	| '(' e ')'
	    { $$ = $2; }
	| e '+' e
	    {add_sub:
	     $$=addsub(&$1,$<opchar>2,&$3); }
	| e '-' e
	    { goto add_sub; }
	| e '*' e
	    {mul_div:
	     $$=muldiv(&$1,$<opchar>2,&$3); }
	| e '/' e
	    {goto mul_div;}
	| e '%' e
	    {goto mul_div;}
	| e '<' e
	    {goto add_sub;}
	| e '>' e
	    {goto add_sub;}
	| e '|' e
	    {goto add_sub;}
	| e '&' e
	    {goto add_sub;}
	| e '^' e
	    {goto add_sub;}
	| '-' e %prec UMINUS
	    { $$=addsub(&opzero,'-',&$2); }
	| '~' e
	    { $$=$2;
		if( $2.haveseen != CONST ){
		    error("can only ~ consts");
		}
		$$.constval = ~$$.constval;
	    }
	;

%%
#include "gramops.h"

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
