/* pass.c */
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

#ifndef lint
/*NOBASE*/
static char *rcsid = "@(#) (Gould) $Header: pass.c,v 5.5 89/05/12 12:36:54 pcc Rel-3_0 $";
#endif

#include "parse.h"
#include "struct.h"
#include <stdio.h>

Tuchar    *curfile;
Tuchar	filename[MAX_STR];
extern Tuchar    *infile;
extern int op1();
extern int deflab();
extern int procno;

Tuchar	inbuf[MAX_STR];
Tuchar	token[MAX_STR];






/*
NAME: pass_handler
PURPOSE: manages the actions of each pass
PRECONDITIONS:
parameter label_handler is a pointer to the function which is used to
process labels (deflab in pass 1, checklab in pass 2).
ALGORITHM:
read the input line into inbuf and set up yylinept (for yyparse), check
for comments, get the first token on the line with get_token (should be
either a label or an opcode), call either the label handler or routine
op1 as appropriate, check for the semicolon statement separator, and set
the new line number.
HISTORY:
part of initial coding RJM
*/






pass_handler (label_handler)
int (*label_handler)();
{

    fseek(stdin, 0, 0);

    lineno = 1;
    curfile = infile;
    procno = 0;

    while (fgets (inbuf, sizeof(inbuf), stdin) != NULL)
    {
	yylinept = inbuf;

#ifdef DEBUG
	if (dbflag || lineflag)
	{
	    printf ("pass: line number %d - dot %x+%x, input source\n%s", 
		    lineno, dot->sspace, dot->svalue, inbuf);
	    fflush (stdout);
	}
#endif
	if (inbuf[0] == '#')
	{				/* this is preprocessor input */
	    cpp_line ();		/* go scan input file and line */
	    continue;
	}

	scan_cmt (inbuf);		/* scan for comments */

	while (*yylinept != '\0')
	{
	    if (isspace (*yylinept))
	    {				/* skip while space */
		++yylinept;
		continue;
	    }
	    
	    if (*yylinept == ';' || *yylinept == '\n')
	    {				/* skip null stmt */
		++yylinept;
		continue;
	    }

	    get_token ();		/* want a label or an opcode */
#ifdef DEBUG
	    if (dbflag)
	    {
		printf ("pass: get_token returns %s\n", token);
		fflush (stdout);
	    }
#endif
	    SKIPSPACE (yylinept);
	    if (*yylinept == ':')		/* have a label */
	    {
#ifdef DEBUG
		if (dbflag)
		{
		    printf ("pass: label handler called\n");
		    fflush (stdout);
		}
#endif
		(*label_handler) (token);
		yylinept++;
		SKIPSPACE (yylinept);
		continue;
	    }
	    else			/* must be an opcode */
	    {
#ifdef DEBUG
		if (dbflag)
		{
		    printf ("pass: op1 called - %s\n", yylinept);
		    fflush (stdout);
		}
#endif
		op1 (token);
	    }

#ifdef DEBUG
		if (dbflag)
		{
		    printf ("pass: return from op1 - %s\n", yylinept);
		    fflush (stdout);
		}
#endif

	    SKIPSPACE (yylinept);

	    if (*yylinept == ';')
	    {
#ifdef DEBUG
		if (dbflag)
		{
		    printf ("pass: semicolon found - %s\n", yylinept);
		    fflush (stdout);
		}
#endif
		yylinept++;
		SKIPSPACE (yylinept);
	    }
#ifdef DEBUG
	    if (dbflag)
	    {
		printf ("pass: end yylinept loop - %s\n", yylinept);
		fflush (stdout);
	    }
#endif
	}
	lineno++;
    }
#ifdef DEBUG
    if (dbflag)
    {
	printf ("pass: read loop exit\n");
	fflush (stdout);
    }
#endif
}






/*
NAME: get_token
PURPOSE: break out a "word" from the input buffer
PRECONDITIONS:
yylinept must be pointing at the beginning of something useful.
a word is assumed to start with a letter and is followed by 0 or more
alphanumeric characters.
a symbol beginning with a '$' should mark a NOBASE symbol.
note that yyinit in yylex.c will force '.' and '_' to be considered as
letters by isalpha and isalnum.
POSTCONDITIONS:
yylinept is left pointing at the character after the last alphanumeric
character it scans. the global variable token contains the word that has
been found.
HISTORY:
part of initial coding RJM
character variables changed to unsigned character for speed DAW
*/






get_token ()
{
register Tuchar *tp;
#ifdef DEBUG
    if (dbflag)
    {
	printf ("get_token: entry yylinept %s\n", yylinept);
	fflush (stdout);
    }
#endif

    tp = token;

    if (!(isalpha (*yylinept)))
    {
/* error message will print remainder of line, so may have a \n in it */
	error ("get_token: identifier %s does not start with alpha", yylinept);
    }

    do
    {
	*tp++ = *yylinept++;
    } while (isalnum (*yylinept));

    *tp = '\0';
}






/*
NAME: cpp_line
PURPOSE: do the appropriate thing with C preprocessor comment lines.
ALGORITHM:
the cpp comment that is of interest is the one that tells what
linenumber and file name is being assembled. the format of said line is:
#   expression  "string"
where the '#' is in the first column, the separators are some number of
tabs or spaces, and the string is enclosed in double quotes as noted.
all other formats are ignored by this routine.
HISTORY:
Tue Aug 16 16:09:22 EDT 1983 RJM
*/






cpp_line ()
{
    int num = 0;
    Tuchar *temp = &filename[0];

    /* skip the blanks between the '#' and the line number */
    yylinept++;
    SKIPSPACE (yylinept);

    /* but it must be a number */
    if (!isdigit (*yylinept))
    {
	return;
    }
    /* build the line number */
    while (isdigit (*yylinept))
    {
	num = 10 * num + (*yylinept++ - '0');
    }

    /* if not a space then not the proper format for this */
    if (!isspace (*yylinept++))
    {
	return;
    }

    /* find the string, which must be between quotes */
    SKIPSPACE (yylinept);

    if (*yylinept != '\"')
    {
	return;
    }

    /* move it to a more permanent place than inbuf */
    for (++yylinept; (*yylinept != '\0') && (*yylinept != '\"'); )
    {
	*temp++ = *yylinept++;
    }
    *temp++ = '\0';

    curfile = filename;
    lineno = num;
}






/*
NAME: scan_cmt
PURPOSE: search and destroy comments.
PRECONDITIONS:
parameter bp is a pointer to whatever section of the input line is to be
checked. it is called from pass_handler with bp set to inbuf.
ALGORITHM:
the occurrence of the string "--" (two minus signs) flags a comment to
the end of line. this routine writes a newline ('\n') and a string
terminator ('\0') over the minuses, assuring that the parser does not see
the rest of the line.
caution is required with escaped double quote characters (as in \" ), as
they are NOT string delimitors.
HISTORY:
part of initial coding DAW
*/






scan_cmt (bp)
register Tuchar *bp;
{
    
    /*
     * note - C-style comments are not yet recognized
     */
    while (*bp)
    {
	/* is it escaped double quote? */
	if (*bp == '\\' && *(bp+1) == '"')
	{
	    bp += 2;	/* if yes, skip over it */
	    continue;
	}

	if (*bp == '"')
	{				/* but no comment in string */
	    ++bp;
	    while (*bp)
	    {
		/* yet another check on escaped double quote */
		/* if just a quote, then end of string so break */
		if (*bp == '"' && *(bp-1) != '\\')
		{
		    ++bp;
		    break;
		}
		++bp;
	    }
	    continue;
	}

	if (*bp == '-' && *(bp+1) == '-')
	{				/* we found an end-of-line comment */
	    *bp++ = '\n';
	    *bp = '\0';
	    break;
	}
	++bp;
    }
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
