/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/23/84                                                  */
/*  Source File :           source/decl.22110.c                              */
/*  Revisions :             05/21/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that structures may be assigned using     */
/*                          the assignment operator (=) if both operands     */
/*                          are of the same structure type.                  */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
#define TRUE 1
int fail;
 
struct phonebook {
          int phone;
          char *name;
          char *street;
          char *city;
          int zip;
}book = { 1230000,"Davis Harry","1020 Oakland Pk Blvd",
          "Ft. Lauderdale",33313 };
 
struct phonebook pages;
 
main()
{
FILE *fp;
int a;
fp=fopen("decl_res bloc=y","a");
 
/*  Assign values to members of the structure pages. */
 
        pages = book;
 
 
/*  Verify that the members of the structure pages is equivalent
    to the members of structure book.                                 */
 
            if ( pages.phone != book.phone )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.10-1 class 2 fail exit return code : %d\n", pages.phone );
                 printf("  ** declaration, structures 2.2.1.10-1 class 2 fail exit return code : %d\n", pages.phone );
               }
 
            if ( compare( pages.name, book.name ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.10-2 class 2 fail exit return code : %s\n", pages.name );
                 printf("  ** declaration, structures 2.2.1.10-2 class 2 fail exit return code : %s\n", pages.name );
               }
 
            if ( compare( pages.street, book.street ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.10-3 class 2 fail exit return code : %s\n", pages.street );
                 printf("  ** declaration, structures 2.2.1.10-3 class 2 fail exit return code : %s\n", pages.street );
               }
 
            if ( compare( pages.city, book.city ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.10-4 class 2 fail exit return code : %s\n", pages.city );
                 printf("  ** declaration, structures 2.2.1.10-4 class 2 fail exit return code : %s\n", pages.city );
               }
 
            if ( pages.zip != book.zip )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.10-5 class 2 fail exit return code : %d\n", pages.zip );
                 printf("  ** declaration, structures 2.2.1.10-5 class 2 fail exit return code : %d\n", pages.zip );
               }
 
 
    if ( !fail )
       fprintf(fp,"  .. declaration, structures 2.2.1.10 class 2 pass\n");
       printf("  .. declaration, structures 2.2.1.10 class 2 pass\n");
       fclose(fp);
}
 
/*      COMPARE:  function - compare two given strings
                  inputs   - two strings, s1 and s2
                  outputs  - == 0, if s1 is equal to s2
                              > 0, if s1 is greater than s2
                              < 0, if s1 is less than s2
*/
 
compare( s1, s2 )
 
char *s1, *s2;
{
        for( ; *s1 == *s2 ; s1++, s2++ )
           if ( *s1 == '\0' )
              return 0;
        return( *s1 - *s2 );
}
