/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.2                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2212.c                               */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          05/14/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added types short int, long int, unsigned     */
/*                             int, unsigned short, unsigned long, unsigned  */
/*                             char, long float.                             */
/*                                                                           */
/*  Description :           Verify that the basic types of int, unsigned,    */
/*                          short int, long int, char, float, and double     */
/*                          can be initialized in external, static struct-   */
/*                          ure definitions and referenced.                  */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
 
#include <stdio.h>
 
/* Test 1
        verify the syntax    struct { type-specifier declarator;
                                    }
                             struct { type-specifier declarator : const expr;
                                      type-specifier : const expr;
                                    }
*/
 
typedef  char  *typedef_name;
typedef  int   def_bit;
 struct key {
             char *keyword ;
             int   key1;
             short key2 ;
             long  key3 ;
             unsigned key4 ;
             float key5 ;
             double key6 ;
             short int key7 ;
             long int key8 ;
             unsigned int key9 ;
             unsigned short key10 ;
             unsigned long key11 ;
             long float key12 ;
             unsigned char *key13 ;
             typedef_name keyline ;
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[] = { "keyword",1,2,3,4,5.0,6.0,7,8,9,10,11,12.0,"key13",
                         "keyline",0  };
 
main()
{
        FILE *fp;
        int result ;
        fp=fopen("decl_res bloc=y","a");
 
        /* verify they can be referenced */
 
        if (  table->key1 != 1 || table->key2 != 2 || table->key3 != 3  ||
              table->key4 != 4 || table->key5 != 5.0 || table->key6 != 6.0 ||
              table->key7 != 7 || table->key8 != 8 || table->key9 != 9 ||
              table->key10 != 10 || table->key11 != 11 || table->key12 != 12.0 )
           {
           fprintf(fp,"  ** declaration, structures 2.2.1.2-1 class 1 fail exit return code : %d\n",table->key1);
           printf("  ** declaration, structures 2.2.1.2-1 class 1 fail exit return code : %d\n",table->key1);
           }
        else
        {  result = compare (table->keyword,"keyword");
           if (result)
           {
              fprintf(fp,"  ** declaration, structures 2.2.1.2-2 class 1 fail exit return code : %d\n",result);
              printf("  ** declaration, structures 2.2.1.2-2 class 1 fail exit return code : %d\n",result);
              }
           else
           {  result = compare (table->keyline,"keyline");
              if (result){
                 fprintf(fp,"  ** declaration, structures 2.2.1.2-3 class 1 fail exit return code : %d\n",result);
                 printf("  ** declaration, structures 2.2.1.2-3 class 1 fail exit return code : %d\n",result);
                 }
              else
              {  result = compare (table->keyline,"keyword");
                 if (result == 0) {
                   fprintf(fp,"  ** declaration, structures 2.2.1.2-4 class 1 fail exit return code : %d\n",result);
                   printf("  ** declaration, structures 2.2.1.2-4 class 1 fail exit return code : %d\n",result);
                   }
                 else
                 { result = compare (table->key13,"key13");
                  if (result){
                    fprintf(fp,"  ** declaration, structures 2.2.1.2-5 class 1 fail exit return code : %d\n",result);
                    printf("  ** declaration, structures 2.2.1.2-5 class 1 fail exit return code : %d\n",result);
                    }
                  else
                  {
                  fprintf(fp,"  .. declaration, structures 2.2.1.2 class 1 pass\n");
                  printf("  .. declaration, structures 2.2.1.2 class 1 pass\n");
                  }
                 }
              }
           }
        }
        fclose(fp);
}
 
/*     Compare two strings and return a zero
       if they are equal to eachother.
*/
 
compare(s1,s2)
char *s1,*s2;
{       for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
