/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.5                                */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/decl.22152.c                              */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          05/14/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Added types short int, long int, unsigned    */
/*                              int, unsigned short, unsigned long, unsigned */
/*                              char, and long float.                        */
/*                                                                           */
/*  Description :           For structure members that are arrays of the     */
/*                          basic types : Verify that arrays can be          */
/*                          initialized for static and external structures.  */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
                   syntax    struct { type-specifier declarator;
                                    }
                             struct { type-specifier declarator : const expr;
                                      type-specifier : const expr;
                                    }
*/
 
#include <stdio.h>
#define LINE 1
#define TRUE 1
 
int fail=0;
typedef  char  *typedef_name;
typedef  int   def_bit;
 
 char buf[256];
 static struct key {
             char *keyword[LINE];
             int   key1[1][2];
             short key2[2] ;
             long  key3[3] ;
             unsigned key4[4] ;
             float key5[1][5] ;
             double key6[1][6] ;
             typedef_name keyline[LINE] ;
             short int key7[1][7] ;
             long int key8[1][8] ;
             unsigned int key9[9] ;
             unsigned short key10[10] ;
             unsigned long key11[1][1] ;
             unsigned char *key12[LINE] ;
             long float key13[2][2] ;
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[] = { "keyword",1,1,2,2,3,3,3,4,4,4,4,5,5,5,5,5,
                         6,6,6,6,6,6,"keyline",7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
                         9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,11,
                         "key12",13,13,13,13 }   ;
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
    if ( table->key1[0][1] != 1 || table->key2[0] != 2 ||
                table->key2[1] != 2 || table->key3[2] != 3 ||
                table->key4[3] != 4 || table->key5[0][4] != 5 ||
                table->key6[0][5] != 6 || table->key7[0][6] != 7 ||
                table->key8[0][7] != 8 || table->key9[8] != 9 ||
                table->key10[9] != 10  || table->key11[0][0] != 11 ||
                table->key13[1][1] != 13 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.2-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
          printf("  ** declaration, structures 2.2.1.5.2-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
        }
     if ( compare(table->keyword[0],"keyword") )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.2-2 class 2 fail exit return code : %s\n",table->keyword[0]);
          printf("  ** declaration, structures 2.2.1.5.2-2 class 2 fail exit return code : %s\n",table->keyword[0]);
        }
     if ( compare(table->keyline[0],"keyline"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.2-3 class 2 fail exit return code : %s\n",table->keyline[1]);
          printf("  ** declaration, structures 2.2.1.5.2-3 class 2 fail exit return code : %s\n",table->keyline[1]);
        }
     if ( compare(table->key12[0],"key12"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.2-4 class 2 fail exit return code : %s\n",table->key12[0]);
          printf("  ** declaration, structures 2.2.1.5.2-4 class 2 fail exit return code : %s\n",table->key12[0]);
        }
 
if (!fail)
        fprintf(fp,"  .. declaration, structures 2.2.1.5.2 class 2 pass\n");
        printf("  .. declaration, structures 2.2.1.5.2 class 2 pass\n");
        fclose(fp);
 
}
 
compare(s1,s2)                  /* compare two strings, and return a zero
                                   if they are equal to each other
                                */
char *s1,*s2;
{       for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
