/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.5                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/decl.22154.c                              */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          04/09/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added test for UTX 1.0, spr0006.              */
/*                          05/15/85    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added types short int, long int, unsigned     */
/*                             int, unsigned short, unsigned long, unsigned  */
/*                             char and long float.                          */
/*                                                                           */
/*  Description :           For structure members that are arrays of the     */
/*                          basic types : Verify that elements of the arrays */
/*                          can be referenced.                               */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
          syntax    struct { type-specifier declarator; }
                    struct { type-specifier declarator : const expr;
                             type-specifier : const expr;
                           }
*/
 
#include <stdio.h>
#define LINE 2
#define TRUE 1
 
int fail=0;
typedef  char  *typedef_name;
typedef  int   def_bit;
 
 char buf[256];
 static struct key {
             char *keyword[LINE];
             int   key1[1][2];
             short key2[2] ;
             long  key3[3] ;
             unsigned key4[4] ;
             float key5[1][5] ;
             double key6[1][6] ;
             typedef_name keyline[3] ;
             short int key7[7];
             long int key8[1][8];
             unsigned int key9[2][3];
             unsigned short key10[4][2];
             unsigned long key11[5][1];
             unsigned char *key12[2];
             long float key13[5];
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[] = { "keyword","keyword1",
                         1,1,2,2,3,3,3,4,4,4,4,5,5,5,5,5, 6,6,6,6,6,6,
                        "keyline","keyline1","keyline2",7,7,7,7,7,7,7,
                         8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,
                         11,11,11,11,11,"key12-0","key12-1",13.0,12.5,12.0,
                         11.5,11.0 } ;
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
    if ( table->key1[0][1] != 1 || table->key2[0] != 2 ||
                table->key2[1] != 2 || table->key3[2] != 3 ||
                table->key4[3] != 4 || table->key5[0][4] != 5 ||
                table->key6[0][5] != 6 || table->key7[6] != 7 ||
                table->key8[0][7] != 8 || table->key9[1][2] != 9 ||
                table->key10[3][0] != 10 || table->key11[2][0] != 11 ||
                table->key13[3] != 11.5 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
          printf("  ** declaration, structures 2.2.1.5.4-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
        }
     if ( compare(table->keyword[0],"keyword") )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-2 class 2 fail exit return code : %s\n",table->keyword[0]);
          printf("  ** declaration, structures 2.2.1.5.4-2 class 2 fail exit return code : %s\n",table->keyword[0]);
        }
 
     if ( compare(table->keyword[1],"keyword1") )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-3 class 2 fail exit return code : %s\n",table->keyword[1]);
          printf("  ** declaration, structures 2.2.1.5.4-3 class 2 fail exit return code : %s\n",table->keyword[1]);
        }
     if ( compare(table->keyline[0],"keyline"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-4 class 2 fail exit return code : %s\n",table->keyline[0]);
          printf("  ** declaration, structures 2.2.1.5.4-4 class 2 fail exit return code : %s\n",table->keyline[0]);
        }
 
     if ( compare(table->keyline[1],"keyline1"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-5 class 2 fail exit return code : %s\n",table->keyline[1]);
          printf("  ** declaration, structures 2.2.1.5.4-5 class 2 fail exit return code : %s\n",table->keyline[1]);
        }
 
     if ( compare(table->keyline[2],"keyline2"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-6 class 2 fail exit return code : %s\n",table->keyline[2]);
          printf("  ** declaration, structures 2.2.1.5.4-6 class 2 fail exit return code : %s\n",table->keyline[2]);
        }
 
     if ( compare(table->key12[0],"key12-0"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-7 class 2 fail exit return code : %s\n",table->key12[0]);
          printf("  ** declaration, structures 2.2.1.5.4-7 class 2 fail exit return code : %s\n",table->key12[0]);
        }
 
     if ( compare(table->key12[1],"key12-1"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.4-8 class 2 fail exit return code : %s\n",table->key12[1]);
          printf("  ** declaration, structures 2.2.1.5.4-8 class 2 fail exit return code : %s\n",table->key12[1]);
        }
 
/*  This test was originally spr0006 written against UTX Release 1.0.
    Problem description:  If a structure has been declared, and a pointer
            to such a structure is declared as "register struct t *p, a
            compiler error occurs when the structure is referenced.  If
            pointer is not declared as storage class register, the test
            case works.
*/
 
{
struct date {
        int day;
        int month;
        int year;
        int yearday;
};
        struct date t;
        register struct date *tptr;
 
        tptr = &t;
        tptr->day = 23;
        tptr->month = 8;
        tptr->year = 84;
        tptr->yearday = 236;
 
        if ( tptr->day != 23  || tptr->month != 8 ||
             tptr->year != 84 || tptr->yearday != 236 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.5.4-9 class 2 fail exit return code : %d%d%d%d\n", tptr->day, tptr->month,tptr->year, tptr->yearday );
             printf("  ** declaration, structures 2.2.1.5.4-9 class 2 fail exit return code : %d%d%d%d\n", tptr->day, tptr->month,tptr->year, tptr->yearday );
           }
}
 
if (!fail) {
        fprintf(fp,"  .. declaration, structures 2.2.1.5.4 class 2 pass\n");
        printf("  .. declaration, structures 2.2.1.5.4 class 2 pass\n");
        }
        fclose(fp);
 
}
 
compare(s1,s2)                  /* compare two strings, and return a zero
                                   if they are equal to each other
                                */
char *s1,*s2;
{       for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
