/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.6                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  2/27/84                                          */
/*  Source File :           source/decl.22161.c                              */
/*  Revisions :             02/23/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           For a structure that has a structure as a        */
/*                          member, verify that space is allocated           */
/*                          correctly.                                       */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
     syntax     struct { type-specifier declarator;
                       struct { type-specifier declarator;
                              struct { type-specifier declarator;
                                     }
                              struct { type-specifier declarator;
                                     }
                              }
                       }
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
int start;
 
        struct one {
                   int a1;
                   struct two {
                              int a2;
                              struct three {
                                           int b3;
                                           long a3;
                                           } three3;
                              long b2;
                              struct four {
                                          int a4;
                                          char b4[4];
                                          };
                              int c2;
                              } two2;
                   int b1;
                   } one1;
 
int fin;
main ()
{
 FILE *fp;
 
/*  Test 1
          Verify that space is allocated correctly for struct three3.
*/
 
        int a, b, c;
 
        a = ( (int) &one1.two2.b2 - (int) &one1.two2.a2 );
        fp=fopen("decl_res bloc=y","a");
 
        if ( a != ( b = 3 * sizeof (c) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.1-1 class 2 fail exit return code : %10d\n",a);
             printf("  ** declaration, structures 2.2.1.6.1-1 class 2 fail exit return code : %10d\n",a);
           }
 
/*  Test 2
           Verify that no space is allocated for struct four.
  */ 
 
        a = ( (int) &one1.two2.c2 - (int) &one1.two2.b2 );
 
        if ( a != ( b = sizeof (c) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.1-2 class 2 fail exit return code : %10d\n",a);
             printf("  ** declaration, structures 2.2.1.6.1-2 class 2 fail exit return code : %10d\n",a);
           }
 
/*  Test 3
          Verify that space is allocated for struct two.
*/
        a = ( (int) &one1.b1 - (int) &one1.a1 );
 
        if ( a != ( b = 6 * sizeof (c) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.1-3 class 2 fail exit return code : %10d\n",a);
             printf("  ** declaration, structures 2.2.1.6.1-3 class 2 fail exit return code : %10d\n",a);
           }
 
/*  Test 4
          Verify that space is allocated for struct one.
*/
 
        a = ( (int) &fin - (int) &start );
 
        if ( a != ( b = 9 * sizeof (c) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.1-4 class 2 fail exit return code : %10d\n",a);
             printf("  ** declaration, structures 2.2.1.6.1-4 class 2 fail exit return code : %10d\n",a);
             fprintf(fp,"b= %10d\n",b);
           }
 
        if (!fail)
            { 
            fprintf(fp,"  .. declaration, structures 2.2.1.6.1 class 2 pass\n");
            printf("  .. declaration, structures 2.2.1.6.1 class 2 pass\n");
            } 
            fclose(fp);
}
