/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.7                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/18/84                                                  */
/*  Source File :           source/decl.22171.c                              */
/*  Revisions :             05/17/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           For an array of structures, verify that space    */
/*                          is allocated correctly.                          */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*
     syntax     struct { type-specifier declarator;
                       struct { type-specifier declarator;
                              struct { type-specifier declarator;
                                     }
                              struct { type-specifier declarator;
                                     }
                              }
                       }
    Test Method:
                 Verify that space is correctly allocated for the structures
                 by subtracting the addresses of the variables surrounding the
                 structures.  The size of variable c which is used as a scale,
                 it multiplied by a constant representing the expected number
                 of size c variables allocating the space.
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail = 0;
 
int start;
        struct one1 {
                    int a1;
                    struct two2 {
                                int a2;
                                struct three3 {
                                              int b3;
                                              long a3;
                                } three[3];
                                long b2;
                                struct four4 {
                                             int a4;
                                             char b4[4];
                                };
                                int c2;
                   } two[2];
                   int b1;
       } one[5];
int fin;
 
main ()
{
        FILE *fp;
        int a, b, c;
fp=fopen("decl_res bloc=y","a");
 
/*  Test 1
          Verify that space is allocated correctly for struct three.
*/
        a = ( (int) &one[0].two[0].b2 - (int) &one[0].two[0].a2 );
 
        if ( a != ( b = sizeof (c) * 7 ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.7.1-1 class 2 fail  exit return code : %d %d\n",a,b);
             printf("  ** declaration, structures 2.2.1.7.1-1 class 2 fail  exit return code : %d %d\n",a,b);
           }
 
/*  Test 2
           Verify that no space is allocated for struct four.
*/
 
        a = ( (int) &one[0].two[0].c2 - (int) &one[0].two[0].b2 );
 
        if ( a != ( b = sizeof (c) ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.7.1-2 class 2 fail exit return code : %d %d\n",a,b);
             printf("  ** declaration, structures 2.2.1.7.1-2 class 2 fail exit return code : %d %d\n",a,b);
           }
 
/*  Test 3
          Verify that space is allocated for struct two.
*/
        a = ( (int) &one[0].b1 - (int) &one[0].a1 );
 
        if ( a != ( b = sizeof (c) * 19 ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.7.1-3 class 2 fail exit return code : %d %d\n",a,b);
             printf("  ** declaration, structures 2.2.1.7.1-3 class 2 fail exit return code : %d %d\n",a,b);
           }
 
/*  Test 4
          Verify that space is allocated for struct one.
*/
 
        a = ( (int) &fin - (int) &start );
 
        if ( a != ( b = sizeof (c) * 102 ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.7.1-4 class 2 fail  exit return code : %d %d\n",a,b);
             printf("  ** declaration, structures 2.2.1.7.1-4 class 2 fail  exit return code : %d %d\n",a,b);
           }
 
        if (!fail){
            fprintf(fp,"  .. declaration, structures 2.2.1.7.1 class 2 pass\n");
            printf("  .. declaration, structures 2.2.1.7.1 class 2 pass\n");
            }
            fclose(fp);
}
